/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.VectorStoreConnection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.FinalCommitable;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipePayloadBaseParams;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EmbeddingRecipeRunnerBase
implements InitializableAbortableRecipeRunner,
RecipeRunner,
FlowRunnable,
RecipeRunnerWithPayload,
FinalCommitable {
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected ConnectionsDAO connectionsDAO;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected APITicketService ticketService;
    protected JobActivity activity;
    protected FlowRecipe recipe;
    protected RetrievableKnowledge rk;
    protected AuthCtx authCtx;
    protected InitializableAbortableRecipeRunner abortableRunner = null;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.rag_embedding_base");

    @Override
    public void init() throws Exception {
        this.authCtx = this.authCtxService.getAuthCtx();
    }

    public abstract EmbeddingRecipePayloadBaseParams getRecipeBaseDesc();

    public abstract EmbeddingRecipePayloadBaseParams parseRecipePayload(String var1);

    protected abstract List<String> getIgnoredVersionFiles();

    protected void checkKnowledgeBanksAllowed(RetrievableKnowledge retrievableKnowledge) throws IOException, DKUSecurityException {
        if (retrievableKnowledge.vectorStoreType.hasConnection) {
            DSSConnection connection = this.connectionsDAO.getMandatoryConnection(null, retrievableKnowledge.connection);
            boolean allowed = false;
            if (connection instanceof VectorStoreConnection) {
                allowed = connection.allowKnowledgeBanks;
            }
            if (!allowed) {
                throw new DKUSecurityException("This connection cannot be used with knowledge banks.");
            }
        }
    }

    protected void updateKBVersionOnDisk(RetrievableKnowledge rk, File rkFolder, String newVersion) throws IOException {
        RetrievableKnowledge.RetrievableKnowledgeVersionInfo versionInfo = new RetrievableKnowledge.RetrievableKnowledgeVersionInfo();
        versionInfo.buildAt = System.currentTimeMillis();
        FileUtils.writeStringToFile((File)DKUApp.getFile((File)rkFolder, (String[])new String[]{"version_info.json"}), (String)JSON.json((Object)versionInfo), (Charset)StandardCharsets.UTF_8);
        RetrievableKnowledge.RetrievableKnowledgeVersions retrievableKnowledgeVersions = new RetrievableKnowledge.RetrievableKnowledgeVersions();
        retrievableKnowledgeVersions.currentVersion = newVersion;
        File dataFolder = RetrievableKnowledgeUtils.getDataFolder(rk.projectKey, rk.id);
        File versionsFile = DKUApp.getFile((File)dataFolder, (String[])new String[]{"versions.json"});
        JSON.prettyToFile((Object)retrievableKnowledgeVersions, (File)versionsFile);
    }

    protected boolean shouldClearKnowledgeBank(RetrievableKnowledge rk) throws IOException {
        File previousVersionFolder;
        EmbeddingRecipePayloadBaseParams currentDesc = this.getRecipeBaseDesc();
        try {
            String previousVersion = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(rk);
            previousVersionFolder = RetrievableKnowledgeUtils.getVersionFolder(rk, previousVersion);
        }
        catch (IOException e) {
            logger.info((Object)"Could not read previous KB folder", (Throwable)e);
            return this.shouldClearKnownledgeBankIfPreviousVersionNotComplete(currentDesc.getVectorStoreUpdateMethod());
        }
        File previousKbFile = DKUApp.getFile((File)previousVersionFolder, (String[])new String[]{"kb.json"});
        File previousRecipeSettingsFile = DKUApp.getFile((File)previousVersionFolder, (String[])new String[]{"recipe_settings.json"});
        if (!previousKbFile.exists() || !previousRecipeSettingsFile.exists()) {
            logger.warn((Object)String.format("Previous KB folder exists, but does not contain kb.json and recipe_settings.json files: %s", previousVersionFolder.getAbsolutePath()));
            return this.shouldClearKnownledgeBankIfPreviousVersionNotComplete(currentDesc.getVectorStoreUpdateMethod());
        }
        String previousKbContent = DKUFileUtils.readFileToStringUTF8((File)previousKbFile);
        String previousRecipeSettingsContent = DKUFileUtils.readFileToStringUTF8((File)previousRecipeSettingsFile);
        if (StringUtils.isEmpty((String)previousKbContent) || StringUtils.isEmpty((String)previousRecipeSettingsContent)) {
            logger.warn((Object)String.format("Previous KB files have not been written correctly: %s", previousVersionFolder.getAbsolutePath()));
            return this.shouldClearKnownledgeBankIfPreviousVersionNotComplete(currentDesc.getVectorStoreUpdateMethod());
        }
        RetrievableKnowledge previousRk = (RetrievableKnowledge)JSON.parse((String)previousKbContent, RetrievableKnowledge.class);
        EmbeddingRecipePayloadBaseParams previousDesc = this.parseRecipePayload(previousRecipeSettingsContent);
        return this.shouldClearKnowledgeBankAfterSettingsChange(rk, previousRk, currentDesc, previousDesc, previousVersionFolder);
    }

    protected abstract boolean shouldClearKnownledgeBankIfPreviousVersionNotComplete(EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod var1);

    protected abstract boolean shouldClearKnowledgeBankAfterSettingsChange(RetrievableKnowledge var1, RetrievableKnowledge var2, EmbeddingRecipePayloadBaseParams var3, EmbeddingRecipePayloadBaseParams var4, File var5);

    protected void copyPreviousVersionFolder(RetrievableKnowledge rk, File rkFolder) throws IOException {
        File previousVersionFolder;
        try {
            String previousVersion = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(rk);
            previousVersionFolder = RetrievableKnowledgeUtils.getVersionFolder(rk, previousVersion);
        }
        catch (IOException e) {
            logger.info((Object)"Could not read previous KB folder, so can't copy it", (Throwable)e);
            return;
        }
        if (previousVersionFolder.equals(rkFolder)) {
            throw new IllegalArgumentException(String.format("Cannot copy files to the same folder %s", rkFolder.getAbsolutePath()));
        }
        logger.info((Object)String.format("Copying previous knowledge bank version folder: %s to new version folder: %s", previousVersionFolder, rkFolder));
        DKUFileUtils.copyDirectory((File)previousVersionFolder, (File)rkFolder, EnumSet.noneOf(DKUFileUtils.CopyDirectoryFlags.class), (FileFilter[])new FileFilter[]{file -> !this.getIgnoredVersionFiles().contains(file.getName())});
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.abortableRunner != null) {
            this.abortableRunner.notifyBeforeAborting();
        }
    }

    protected void updateMetadataColsSchema(RetrievableKnowledge rk) throws IOException {
        String secret = this.ticketService.getSingleTicket().getSecret();
        try (TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);){
            logger.info((Object)("Updating metadata columns schema on knowledge bank " + rk.getFullId()));
            tClient.postFormToJSON("/dip/api/tintercom/knowledge-bank/set-metadata-columns-schema", Void.class, new Object[]{"knowledgeBankFullId", rk.getFullId(), "metadataColumnsSchema", JSON.json(rk.metadataColumnsSchema)});
            this.retrievableKnowledgeDAO.save(rk);
        }
    }

    @Override
    public void finalCommit() throws Exception {
    }
}

