/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRule;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class EmbedDocumentsRecipeParams
extends RecipeParams {
    public static final String DSS_NO_VLM_SELECTION = "DSS_NO_SELECTION";
    public ExtractionMode extractionMode = ExtractionMode.CUSTOM_RULES;
    private String defaultVlmId;
    private ArrayList<EmbedDocumentsRule> rules = new ArrayList();
    private EmbedDocumentsRule allOtherRule;

    public static EmbedDocumentsRule getDefaultAllOtherRule(@Nullable EnrichedLLMStructuredRef embeddingModelRef, @Nullable String defaultVlmId) {
        EmbedDocumentsRule otherRule = EmbedDocumentsRecipeParams.getDefaultRulesFrom(ExtractionMode.MANAGED_TEXT_ONLY, embeddingModelRef, defaultVlmId).get(0);
        otherRule.filter = null;
        otherRule.actionToPerform = EmbedDocumentsRule.ActionToPerform.DONOTEXTRACT;
        return otherRule;
    }

    public static ArrayList<EmbedDocumentsRule> getDefaultRulesFrom(ExtractionMode extractionMode, @Nullable EnrichedLLMStructuredRef embeddingModelRef, @Nullable String defaultVlmId) {
        String[] structuredDocExtensions = new String[]{"txt", "md", "pdf", "pptx", "docx", "html"};
        String[] vlmDocExtensions = new String[]{"docx", "jpg", "pdf", "png", "pptx"};
        if (extractionMode == ExtractionMode.MANAGED_TEXT_ONLY) {
            ArrayList<EmbedDocumentsRule> textExtractionRules = new ArrayList<EmbedDocumentsRule>();
            EmbedDocumentsRule structuredRule = new EmbedDocumentsRule(EmbedDocumentsRule.ActionToPerform.STRUCTURED, structuredDocExtensions, embeddingModelRef);
            structuredRule.structuredSettings = new EmbedDocumentsRule.UIStructuredExtractorSettings();
            structuredRule.storeInMultimodalColumn = EmbedDocumentsRule.MultimodalContentType.FULL_CONTENT;
            textExtractionRules.add(structuredRule);
            return textExtractionRules;
        }
        if (extractionMode == ExtractionMode.MANAGED_VISUAL_ONLY) {
            defaultVlmId = defaultVlmId == null || defaultVlmId.equals(DSS_NO_VLM_SELECTION) ? null : defaultVlmId;
            ArrayList<EmbedDocumentsRule> visualExtractionRules = new ArrayList<EmbedDocumentsRule>();
            EmbedDocumentsRule vlmRule = new EmbedDocumentsRule(EmbedDocumentsRule.ActionToPerform.VLM, vlmDocExtensions, embeddingModelRef);
            vlmRule.vlmSettings = new EmbedDocumentsRule.UiVLMExtractorSettings(defaultVlmId);
            vlmRule.storeInMultimodalColumn = EmbedDocumentsRule.MultimodalContentType.IMAGES;
            visualExtractionRules.add(vlmRule);
            EmbedDocumentsRule structuredRule = new EmbedDocumentsRule(EmbedDocumentsRule.ActionToPerform.STRUCTURED, structuredDocExtensions, embeddingModelRef);
            structuredRule.structuredSettings = new EmbedDocumentsRule.UIStructuredExtractorSettings();
            structuredRule.storeInMultimodalColumn = EmbedDocumentsRule.MultimodalContentType.FULL_CONTENT;
            visualExtractionRules.add(structuredRule);
            return visualExtractionRules;
        }
        if (extractionMode == ExtractionMode.CUSTOM_RULES) {
            return new ArrayList<EmbedDocumentsRule>();
        }
        throw new IllegalArgumentException("Unknown extraction mode " + String.valueOf((Object)extractionMode));
    }

    public void initializeWithDefaultRules(EnrichedLLMStructuredRef embeddingModelRef, String creationVLMId) {
        GeneralSettingsDAO.EmbedDocumentsRecipeSettings embedDocumentsRecipeSettings;
        this.defaultVlmId = creationVLMId != null ? creationVLMId : ((embedDocumentsRecipeSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings) != null ? embedDocumentsRecipeSettings.defaultVLMId : null);
        this.extractionMode = ExtractionMode.MANAGED_TEXT_ONLY;
        if (this.defaultVlmId != null && !this.defaultVlmId.equals(DSS_NO_VLM_SELECTION)) {
            this.extractionMode = ExtractionMode.MANAGED_VISUAL_ONLY;
        }
        this.rules = new ArrayList();
        this.allOtherRule = EmbedDocumentsRecipeParams.getDefaultAllOtherRule(embeddingModelRef, this.defaultVlmId);
    }

    public String getDefaultVLMSelection() {
        return this.defaultVlmId;
    }

    public void setDefaultVLMSelection(String defaultVlmId) {
        this.defaultVlmId = defaultVlmId;
    }

    public ArrayList<EmbedDocumentsRule> getRules(EnrichedLLMStructuredRef embeddingModelRef) {
        return this.extractionMode.equals((Object)ExtractionMode.CUSTOM_RULES) ? this.rules : EmbedDocumentsRecipeParams.getDefaultRulesFrom(this.extractionMode, embeddingModelRef, this.defaultVlmId);
    }

    public ArrayList<EmbedDocumentsRule> getAllRules() {
        ArrayList allRules = (ArrayList)this.rules.clone();
        allRules.add(this.allOtherRule);
        return allRules;
    }

    public EmbedDocumentsRule getAllOtherFilesRule() {
        return this.allOtherRule;
    }

    public static enum ExtractionMode {
        MANAGED_TEXT_ONLY,
        MANAGED_VISUAL_ONLY,
        CUSTOM_RULES;

    }
}

