/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyColumnFactory;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyRowObservation;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.ScreenshotterService;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.docextraction.VLMExtractor;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.TextChunk;
import com.dataiku.dip.docextraction.common.TextExtractionResponseOrError;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.llm.online.utils.BlockingQueryProcessor;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.recipes.nlp.embed_documents.DocumentPageRange;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsIndexer;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRule;
import com.dataiku.dip.recipes.nlp.embed_documents.ExtractedData;
import com.dataiku.dip.recipes.nlp.embed_documents.ExtractedDataWriter;
import com.dataiku.dip.recipes.nlp.embed_documents.ExtractedMetadata;
import com.dataiku.dip.recipes.nlp.embed_documents.IndexerComputationResult;
import com.dataiku.dip.recipes.nlp.embed_documents.MultimodalImagePart;
import com.dataiku.dip.recipes.nlp.embed_documents.MultimodalPart;
import com.dataiku.dip.recipes.nlp.embed_documents.MultimodalTextPart;
import com.dataiku.dip.recipes.nlp.embed_documents.SingleExtractedChunk;
import com.dataiku.dip.recipes.nlp.embed_documents.SourceFile;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.shaker.processors.expr.RecursiveCharacterTextSplitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.scoring.util.RawObservation;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbedDocumentsRuleApplier {
    private static final Logger log = LoggerFactory.getLogger(EmbedDocumentsRuleApplier.class);
    ArrayList<EmbedDocumentsRule> rules;
    EmbedDocumentsRule allOtherFilesRule;
    ManagedFolder imageFolder;
    AuthCtx authCtx;
    String projectKey;
    APITicketService ticketService;
    JobActivity activity;
    ScreenshotterService screenshotterService;
    ExecutorService extractionExecutorService;
    ExecutorService postExtractionExecutorService;
    int DEFAULT_PAGINATION_SIZE = ApplicationConfigurator.getParams().getIntParam("dku.llm.embedDocuments.screenshotPaginationSize", Integer.valueOf(100));
    int MAX_PARALLELISM = ApplicationConfigurator.getParams().getIntParam("dku.llm.embedDocuments.maxParallelism", Integer.valueOf(4));
    int MAX_POST_EXTRACTION_PARALLELISM = ApplicationConfigurator.getParams().getIntParam("dku.llm.embedDocuments.maxPostExtractionParallelism", Integer.valueOf(4));
    Set<String> unmatchedDocuments = Sets.newConcurrentHashSet();
    Set<String> processingFailedDocuments = Sets.newConcurrentHashSet();
    List<CompletableFuture<Void>> documentsExtractionTaskList = new ArrayList<CompletableFuture<Void>>();
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.embed_documents_applier");

    public EmbedDocumentsRuleApplier(ArrayList<EmbedDocumentsRule> rules, EmbedDocumentsRule allOtherFilesRule, @Nullable ManagedFolder outfolder, AuthCtx authCtx, String projectKey, APITicketService ticketService, JobActivity activity, ScreenshotterService screenshotterService) {
        this.rules = rules;
        this.allOtherFilesRule = allOtherFilesRule;
        this.imageFolder = outfolder;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.ticketService = ticketService;
        this.activity = activity;
        this.screenshotterService = screenshotterService;
        this.extractionExecutorService = new ThreadPoolExecutor(this.MAX_PARALLELISM, this.MAX_PARALLELISM, 0L, TimeUnit.MILLISECONDS, new BlockingQueryProcessor.OfferBlockingLinkedBlockingQueue<Runnable>(this.MAX_PARALLELISM * 2), new ThreadFactoryBuilder().setNameFormat("embed-documents-rule-applier-extraction-%d").build());
        this.postExtractionExecutorService = Executors.newFixedThreadPool(this.MAX_POST_EXTRACTION_PARALLELISM, new ThreadFactoryBuilder().setNameFormat("embed-documents-rule-applier-post-extraction-%d").build());
    }

    void handleLoadedDocument(InputRefs.ManagedFolderDocumentRefWithMetadata document, @Nullable HashMap<String, String> additionalDocumentProperties, EmbedDocumentsIndexer indexer, IndexerComputationResult indexerResult, ExtractedDataWriter extractedDataWriter) {
        EmbedDocumentsRule matchedRule = this.findFirstMatchingRule(document, additionalDocumentProperties);
        EmbedDocumentsIndexer.SingleDocumentIndexerResult singleDocumentIndexerResult = indexer.indexDocument(document, matchedRule, indexerResult);
        if (singleDocumentIndexerResult.equals((Object)EmbedDocumentsIndexer.SingleDocumentIndexerResult.IS_NEW) || singleDocumentIndexerResult.equals((Object)EmbedDocumentsIndexer.SingleDocumentIndexerResult.IS_KNOWN_TO_REPROCESS)) {
            this.documentsExtractionTaskList.add(this.runRule(document, matchedRule, extractedDataWriter));
        } else {
            logger.info((Object)this.buildMessageLogForDocument(document.documentRef, "Not extracting document (Document already extracted, not modified nor matching a forced-extraction rule)"));
        }
    }

    void onExtractionEnd(EmbedDocumentsIndexer indexer, IndexerComputationResult indexerResult) {
        CompletableFuture.allOf(this.documentsExtractionTaskList.toArray(new CompletableFuture[0])).join();
        logger.info((Object)("'all other documents' rule will be applied to these " + this.unmatchedDocuments.size() + "documents: " + String.valueOf(this.unmatchedDocuments)));
        if (!this.processingFailedDocuments.isEmpty()) {
            logger.warn((Object)(this.processingFailedDocuments.size() + " documents failed to be processed and have been skipped: " + String.valueOf(this.processingFailedDocuments)));
        } else {
            logger.info((Object)"No document failed to be processed.");
        }
        indexer.stopIndexing(indexerResult);
        this.extractionExecutorService.shutdown();
        this.postExtractionExecutorService.shutdown();
    }

    public CompletableFuture<Void> runRule(InputRefs.ManagedFolderDocumentRefWithMetadata document, EmbedDocumentsRule ruleToApply, ExtractedDataWriter extractedDataWriter) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return this.applyRule(ruleToApply, document.documentRef);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.extractionExecutorService).thenAcceptAsync(extractedData -> {
            if (extractedData != null) {
                try {
                    extractedDataWriter.append(document, (ExtractedData)extractedData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Executor)this.postExtractionExecutorService)).exceptionallyAsync(e -> {
            this.processingFailedDocuments.add(document.documentRef.filePath);
            logger.error((Object)this.buildMessageLogForDocument(document.documentRef, "Document failed to be processed and was skipped"), e);
            this.activity.warnContext.addWarning(WarningsContext.WarningType.DOCUMENT_PROCESSING_FAILED, "Document " + document.documentRef.filePath + " failed to be processed and was skipped", e, logger);
            return null;
        }, (Executor)this.postExtractionExecutorService);
    }

    public EmbedDocumentsRule findFirstMatchingRule(InputRefs.ManagedFolderDocumentRefWithMetadata document, @Nullable HashMap<String, String> additionalDocumentProperties) {
        String fileName = (String)PathUtils.splitBasename((String)document.documentRef.filePath).second;
        logger.info((Object)this.buildMessageLogForDocument(document, "Searching a matching rule"));
        RawObservation rawObservation = new RawObservation(new HashMap<String, String>(Map.of("file extension", FilenameUtils.getExtension((String)fileName), "file name", fileName, "file path", document.documentRef.filePath)));
        if (additionalDocumentProperties != null) {
            additionalDocumentProperties.forEach((arg_0, arg_1) -> ((RawObservation)rawObservation).put(arg_0, arg_1));
        }
        ReadOnlyRowObservation observation = new ReadOnlyRowObservation(rawObservation);
        String[] filtersColumns = rawObservation.keys().toArray(new String[0]);
        for (EmbedDocumentsRule rule : this.rules) {
            Expression expression;
            try {
                expression = new Expression(FilterDescUtils.getGrelExpression(rule.filter));
                expression.setColumnFactory((ColumnFactory)new ReadOnlyColumnFactory(filtersColumns));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!expression.isTrueish(observation)) continue;
            logger.info((Object)this.buildMessageLogForDocument(document, "Found a matching rule : " + String.valueOf((Object)rule.actionToPerform)));
            return rule;
        }
        logger.info((Object)this.buildMessageLogForDocument(document, "No rule matched, applying the 'all other documents' rule"));
        this.unmatchedDocuments.add(document.documentRef.filePath);
        return this.allOtherFilesRule;
    }

    private ExtractedData applyRule(EmbedDocumentsRule ruleToApply, InputRefs.ManagedFolderDocumentRef document) throws Exception {
        ExtractedData extractedData = new ExtractedData();
        switch (ruleToApply.actionToPerform) {
            case VLM: {
                this.applyVLMRule(ruleToApply, document, extractedData);
                break;
            }
            case STRUCTURED: {
                this.applyStructuredRule(ruleToApply, document, extractedData);
                break;
            }
            case DONOTEXTRACT: {
                logger.info((Object)this.buildMessageLogForDocument(document, "Not extracting document (matching an 'ignore' rule)"));
                return new ExtractedData();
            }
            default: {
                throw new RuntimeException("Unknown extractor");
            }
        }
        boolean usePostChunkingValuesForMultimodalCol = ruleToApply.storeInMultimodalColumn.equals((Object)EmbedDocumentsRule.MultimodalContentType.FULL_CONTENT) || ruleToApply.storeInMultimodalColumn.equals((Object)EmbedDocumentsRule.MultimodalContentType.CHUNKED_PROMPT_OUTPUT);
        logger.info((Object)this.buildMessageLogForDocument(document, "Performing splitting on embedded chunks (using " + (usePostChunkingValuesForMultimodalCol ? "chunked" : "un-chunked") + " values for content stored for retrieval)"));
        ExtractedData splittedExtractedData = this.splitExtractedData(extractedData, ruleToApply.splittingSettings, usePostChunkingValuesForMultimodalCol);
        logger.info((Object)this.buildMessageLogForDocument(document, "Splitting expanded the " + extractedData.chunks.size() + " document's extracted chunks to " + splittedExtractedData.chunks.size() + " records to embed"));
        return splittedExtractedData;
    }

    private void applyStructuredRule(EmbedDocumentsRule ruleToApply, InputRefs.ManagedFolderDocumentRef document, ExtractedData extractedData) throws Exception {
        StructuredExtractor.StructuredExtractorSettings structuredSettings = ruleToApply.structuredSettings.toStructuredExtractorSettings();
        long structuredStartTime = System.currentTimeMillis();
        TextExtractionResponseOrError structuredResp = this.runStructuredInBackend(this.authCtx, this.projectKey, structuredSettings, document);
        long structuredProcessingTime = System.currentTimeMillis() - structuredStartTime;
        if (!structuredResp.ok) {
            logger.error((Object)this.buildMessageLogForDocument(document, "Got structured extraction result: failed - " + structuredResp.errorMessage + " (processing time: " + structuredProcessingTime + "ms)"));
            throw new Exception(structuredResp.errorMessage);
        }
        logger.info((Object)this.buildMessageLogForDocument(document, "Got structured extraction result: success (processing time: " + structuredProcessingTime + "ms)"));
        List<TextChunk> prependedContentWithOutlineChunks = this.prependOutlineToFullContent(structuredResp.chunks);
        List<MultimodalPart> multiPartsContent = this.buildMultipartList(prependedContentWithOutlineChunks, null, -1, -1, ruleToApply.storeInMultimodalColumn);
        List<String> embedValues = prependedContentWithOutlineChunks.stream().map(chunk -> chunk.fullContent).collect(Collectors.toList());
        List<ExtractedMetadata> metadataContent = this.buildStructuredExtractionMetadata(document, prependedContentWithOutlineChunks);
        extractedData.createChunks(embedValues, multiPartsContent, metadataContent);
    }

    private void applyVLMRule(EmbedDocumentsRule ruleToApply, InputRefs.ManagedFolderDocumentRef document, ExtractedData extractedData) throws Exception {
        Screenshotter.ScreenshotterResponseOrError screenshotterResponse;
        Screenshotter.ScreenshotterSettings screenshotterSettings = new Screenshotter.ScreenshotterSettings();
        screenshotterSettings.paginationSize = this.DEFAULT_PAGINATION_SIZE;
        screenshotterSettings.paginationOffset = 0;
        VLMExtractor.VLMExtractorSettings vlmSettings = ruleToApply.vlmSettings.toVLMExtractorSettings();
        if (ruleToApply.storeInMultimodalColumn.equals((Object)EmbedDocumentsRule.MultimodalContentType.IMAGES)) {
            if (this.imageFolder == null) {
                throw new Exception("Missing an output managed folder to store page-images that are required to at least one rule output");
            }
            screenshotterSettings.outputManagedFolderId = this.imageFolder.getFullId();
        }
        do {
            long screenshotterStartTime = System.currentTimeMillis();
            screenshotterResponse = this.screenshotterService.extractScreenshotsFromManagedFolderDocumentRef(this.authCtx, this.projectKey, document, screenshotterSettings);
            long screenshotterProcessingTime = System.currentTimeMillis() - screenshotterStartTime;
            if (!screenshotterResponse.ok) {
                logger.error((Object)this.buildMessageLogForDocument(document, "Got screenshotter result: failed - " + screenshotterResponse.errorMessage + " (processing time: " + screenshotterProcessingTime + "ms)"));
                throw new Exception(screenshotterResponse.errorMessage);
            }
            logger.info((Object)this.buildMessageLogForDocument(document, "Got screenshotter result: success (processing time: " + screenshotterProcessingTime + "ms)"));
            int firstPageNumber = screenshotterSettings.paginationOffset + 1;
            int lastPageNumber = screenshotterResponse.lastResultIndex + 1;
            if (screenshotterResponse.hasMoreResults.booleanValue()) {
                screenshotterSettings.paginationOffset = screenshotterResponse.lastResultIndex + 1;
            }
            if (ruleToApply.storeInMultimodalColumn.equals((Object)EmbedDocumentsRule.MultimodalContentType.IMAGES)) {
                if (!(screenshotterResponse.imagesRefs instanceof InputRefs.ManagedFolderImagesRef)) {
                    throw new Exception("Screenshotter returned an image ref that is not a managed folder");
                }
                extractedData.associatedStoragePath = ((InputRefs.ManagedFolderImagesRef)screenshotterResponse.imagesRefs).commonPrefixPath;
            }
            long vlmExtractionStartTime = System.currentTimeMillis();
            TextExtractionResponseOrError vlmExtractionResp = this.runVLMInBackend(this.authCtx, this.projectKey, new VLMExtractor.VLMExtractorRequest(screenshotterResponse.imagesRefs, vlmSettings), document);
            long vlmExtractionProcessingTime = System.currentTimeMillis() - vlmExtractionStartTime;
            if (!vlmExtractionResp.ok) {
                logger.error((Object)this.buildMessageLogForDocument(document, "Got VLM extraction result: failed - " + vlmExtractionResp.errorMessage + " (processing time: " + vlmExtractionProcessingTime + "ms)"));
                throw new Exception(vlmExtractionResp.errorMessage);
            }
            logger.info((Object)this.buildMessageLogForDocument(document, "Got VLM extraction result: success (processing time: " + vlmExtractionProcessingTime + "ms)"));
            logger.info((Object)(document.filePath + ": " + (screenshotterResponse.lastResultIndex + 1) + " processed pages over " + screenshotterResponse.totalResults + " total pages."));
            List<MultimodalPart> multiPartsContent = this.buildMultipartList(vlmExtractionResp.chunks, screenshotterResponse.imagesRefs, vlmSettings.windowSize, vlmSettings.windowOverlap, ruleToApply.storeInMultimodalColumn);
            List<ExtractedMetadata> metadata = this.buildVLMExtractionMetadata(document, firstPageNumber, lastPageNumber, vlmSettings.windowSize, vlmSettings.windowOverlap);
            List<String> embedValues = vlmExtractionResp.chunks.stream().map(chunk -> chunk.promptOutput).collect(Collectors.toList());
            extractedData.createChunks(embedValues, multiPartsContent, metadata);
        } while (screenshotterResponse.hasMoreResults.booleanValue());
    }

    private List<ExtractedMetadata> buildVLMExtractionMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument, int firstPageNumber, int lastPageNumber, int windowSize, int windowOverlap) {
        ArrayList<ExtractedMetadata> metadata = new ArrayList<ExtractedMetadata>();
        if (windowSize <= 0) {
            ExtractedMetadata chunkMetadata = new ExtractedMetadata();
            chunkMetadata.sourceFile = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
            chunkMetadata.pageRange = new DocumentPageRange(firstPageNumber, lastPageNumber);
            metadata.add(chunkMetadata);
        } else {
            for (int i = firstPageNumber; i <= lastPageNumber; i += windowSize - windowOverlap) {
                int currentWindowEnd = Math.min(i - 1 + windowSize, lastPageNumber);
                ExtractedMetadata chunkMetadata = new ExtractedMetadata();
                chunkMetadata.sourceFile = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
                chunkMetadata.pageRange = new DocumentPageRange(i, currentWindowEnd);
                metadata.add(chunkMetadata);
                if (currentWindowEnd == lastPageNumber) break;
            }
        }
        return metadata;
    }

    private List<ExtractedMetadata> buildStructuredExtractionMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument, List<TextChunk> extractedTextChunks) {
        ArrayList<ExtractedMetadata> metadata = new ArrayList<ExtractedMetadata>();
        SourceFile sourceFileMetadata = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
        for (TextChunk extractedText : extractedTextChunks) {
            ExtractedMetadata chunkMetadata = new ExtractedMetadata();
            chunkMetadata.sourceFile = sourceFileMetadata;
            ArrayList<String> sectionOutline = new ArrayList<String>();
            if (extractedText.outline != null) {
                for (int i = 0; i < extractedText.outline.size(); ++i) {
                    String text = extractedText.outline.get(i);
                    String cleanedHeader = StringUtils.stripEnd((String)StringUtils.stripEnd((String)StringUtils.strip((String)text, (String)"#"), (String)"="), (String)"-");
                    sectionOutline.add(cleanedHeader);
                }
                chunkMetadata.sectionOutline = sectionOutline;
            }
            metadata.add(chunkMetadata);
        }
        return metadata;
    }

    private ExtractedData splitExtractedData(ExtractedData extractedData, EmbedDocumentsRule.SplittingSettings splittingSettings, boolean usePostChunkingValuesForMultimodalCol) {
        RecursiveCharacterTextSplitter.Parameter param = new RecursiveCharacterTextSplitter.Parameter();
        param.chunkSize = splittingSettings.chunkSizeCharacters;
        param.chunkOverlap = splittingSettings.chunkOverlapCharacters;
        param.validate();
        RecursiveCharacterTextSplitter splitter = new RecursiveCharacterTextSplitter(param);
        ExtractedData splitExtractedData = new ExtractedData();
        if (extractedData != null) {
            splitExtractedData.associatedStoragePath = extractedData.associatedStoragePath;
        }
        for (SingleExtractedChunk chunk : extractedData.chunks) {
            List<String> embedValues = splitter.splitText(chunk.embedValue);
            if (usePostChunkingValuesForMultimodalCol) {
                splitExtractedData.createChunks(embedValues, embedValues.stream().map(MultimodalTextPart::new).collect(Collectors.toList()), Collections.nCopies(embedValues.size(), chunk.extractedMetadata));
                continue;
            }
            splitExtractedData.createChunks(embedValues, Collections.nCopies(embedValues.size(), chunk.multimodalPart), Collections.nCopies(embedValues.size(), chunk.extractedMetadata));
        }
        return splitExtractedData;
    }

    private List<TextChunk> prependOutlineToFullContent(List<TextChunk> chunks) {
        ArrayList<TextChunk> res = new ArrayList<TextChunk>();
        chunks.stream().filter(textChunk -> StringUtils.isNotBlank((String)textChunk.fullContent)).forEach(chunk -> {
            if (chunk.outline != null && !chunk.outline.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                chunk.outline.forEach(level -> builder.append((String)level).append("\n"));
                String fullContentWithOutline = builder.append(StringUtils.isNotBlank((String)chunk.fullContent) ? chunk.fullContent : "").toString();
                res.add(TextChunk.build(chunk.promptOutput, fullContentWithOutline, chunk.outline));
            } else {
                res.add(TextChunk.build(chunk.promptOutput, chunk.fullContent, chunk.outline));
            }
        });
        return res;
    }

    private List<MultimodalPart> buildMultipartList(List<TextChunk> extractedTextChunks, InputRefs.ImagesRef imgsRefs, int windowSize, int windowOverlap, EmbedDocumentsRule.MultimodalContentType storeInMultimodal) {
        ArrayList<MultimodalPart> multimodalParts = new ArrayList<MultimodalPart>();
        if (storeInMultimodal.equals((Object)EmbedDocumentsRule.MultimodalContentType.IMAGES)) {
            assert (imgsRefs instanceof InputRefs.ManagedFolderImagesRef);
            InputRefs.ManagedFolderImagesRef imgsMF = (InputRefs.ManagedFolderImagesRef)imgsRefs;
            if (windowSize <= 0 || windowSize >= imgsMF.imagesPaths.size()) {
                multimodalParts.add(new MultimodalImagePart(imgsMF.imagesPaths));
            } else {
                for (int i = 0; i < imgsMF.imagesPaths.size(); i += windowSize - windowOverlap) {
                    int currentWindowEnd = Math.min(i + windowSize, imgsMF.imagesPaths.size());
                    multimodalParts.add(new MultimodalImagePart(imgsMF.imagesPaths.subList(i, currentWindowEnd)));
                    if (currentWindowEnd != imgsMF.imagesPaths.size()) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (TextChunk extractedText : extractedTextChunks) {
                if (storeInMultimodal.equals((Object)EmbedDocumentsRule.MultimodalContentType.FULL_CONTENT)) {
                    multimodalParts.add(new MultimodalTextPart(extractedText.fullContent));
                    continue;
                }
                if (!storeInMultimodal.equals((Object)EmbedDocumentsRule.MultimodalContentType.PROMPT_OUTPUT) && !storeInMultimodal.equals((Object)EmbedDocumentsRule.MultimodalContentType.CHUNKED_PROMPT_OUTPUT)) continue;
                multimodalParts.add(new MultimodalTextPart(extractedText.promptOutput));
            }
        }
        return multimodalParts;
    }

    private TextExtractionResponseOrError runVLMInBackend(AuthCtx authCtx, String projectKey, VLMExtractor.VLMExtractorRequest vlmRequest, InputRefs.ManagedFolderDocumentRef document) {
        TextExtractionResponseOrError textExtractionResponseOrError;
        block8: {
            String secret = this.ticketService.getSingleTicket().getSecret();
            TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);
            try {
                String areImgInlined = vlmRequest.inputs.imagesRef instanceof InputRefs.InlineImagesRef ? "inlined" : "stored";
                logger.info((Object)this.buildMessageLogForDocument(document, "Calling VLM extractor on " + areImgInlined + " screenshots with settings: " + vlmRequest.settings.toString()));
                textExtractionResponseOrError = (TextExtractionResponseOrError)tClient.postFormToJSON("/dip/api/tintercom/docextraction/vlm", TextExtractionResponseOrError.class, new Object[]{"authCtx", JSON.json((Object)authCtx), "projectKey", projectKey, "vlmRequest", JSON.json((Object)vlmRequest)});
                if (tClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tClient != null) {
                        try {
                            tClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            tClient.close();
        }
        return textExtractionResponseOrError;
    }

    private TextExtractionResponseOrError runStructuredInBackend(AuthCtx authCtx, String projectKey, StructuredExtractor.StructuredExtractorSettings settings, InputRefs.ManagedFolderDocumentRef documentRef) {
        TextExtractionResponseOrError textExtractionResponseOrError;
        block8: {
            String secret = this.ticketService.getSingleTicket().getSecret();
            TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);
            try {
                logger.info((Object)this.buildMessageLogForDocument(documentRef, "Calling Structured extractor with settings: " + settings.toString()));
                textExtractionResponseOrError = (TextExtractionResponseOrError)tClient.postFormToJSON("/dip/api/tintercom/docextraction/structured-flatten", TextExtractionResponseOrError.class, new Object[]{"authCtx", JSON.json((Object)authCtx), "projectKey", projectKey, "settings", JSON.json((Object)settings), "documentRef", JSON.json((Object)documentRef)});
                if (tClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tClient != null) {
                        try {
                            tClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            tClient.close();
        }
        return textExtractionResponseOrError;
    }

    public String buildMessageLogForDocument(InputRefs.ManagedFolderDocumentRef documentRef, String message) {
        return String.format("[%s] - %s", documentRef.filePath, message);
    }

    public String buildMessageLogForDocument(InputRefs.ManagedFolderDocumentRefWithMetadata document, String message) {
        return this.buildMessageLogForDocument(document.documentRef, message);
    }
}

