/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.recipes.nlp.embed_documents.ExtractedMetadata;
import com.dataiku.dip.recipes.nlp.embed_documents.MultimodalPart;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.UUID;

class SingleExtractedChunk {
    static final String KNOWLEDGE_PROPERTY_NAME = "DKU_GENERATED_EMBEDDING";
    static final String SECURITY_TOKEN_NAME = "DKU_SECURITY_TOKENS";
    static final String MULTIMODAL_PROPERTY_NAME = "DKU_MULTIMODAL_CONTENT";
    static final String METADATA_PROPERTY_NAME = "DKU_DOCUMENT_INFO";
    String uuid;
    String embedValue;
    MultimodalPart multimodalPart;
    ExtractedMetadata extractedMetadata;

    SingleExtractedChunk() {
    }

    SingleExtractedChunk(String embedValue, MultimodalPart multimodalPart, ExtractedMetadata extractedMetadata) {
        this.uuid = UUID.randomUUID().toString();
        this.embedValue = embedValue;
        this.multimodalPart = multimodalPart;
        this.extractedMetadata = extractedMetadata;
    }

    JsonObject jsonify(String securityToken, HashMap<String, String> userMetadata) {
        JsonObject jsonifiedChunk = new JsonObject();
        jsonifiedChunk.addProperty(KNOWLEDGE_PROPERTY_NAME, this.embedValue);
        jsonifiedChunk.addProperty(MULTIMODAL_PROPERTY_NAME, JSON.json((Object)this.multimodalPart));
        userMetadata.forEach((arg_0, arg_1) -> ((JsonObject)jsonifiedChunk).addProperty(arg_0, arg_1));
        jsonifiedChunk.addProperty(METADATA_PROPERTY_NAME, JSON.json((Object)this.extractedMetadata));
        if (this.extractedMetadata.sourceFile != null) {
            jsonifiedChunk.addProperty("dku_file_path", this.extractedMetadata.sourceFile.path);
        }
        if (securityToken != null) {
            jsonifiedChunk.addProperty(SECURITY_TOKEN_NAME, securityToken);
        }
        return jsonifiedChunk;
    }
}

