/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class KsqlRecipeCreator
extends GenericRecipeCreator {
    public KsqlRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws Exception {
        String prefill;
        String firstInputRef = recipe.getInputsForRole((String)"main").get((int)0).ref;
        StreamingEndpoint inputSE = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(recipe.projectKey, firstInputRef));
        KafkaStreamingEndpointParams inputParams = inputSE.getParamsAs(KafkaStreamingEndpointParams.class);
        String firstOutputRef = recipe.getOutputsForRole((String)"main").get((int)0).ref;
        StreamingEndpoint outputSE = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(recipe.projectKey, firstOutputRef));
        KafkaStreamingEndpointParams outputParams = outputSE.getParamsAs(KafkaStreamingEndpointParams.class);
        String string = prefill = data.has("script") ? data.get("script").getAsString() : null;
        if (StringUtils.isNotBlank((String)prefill)) {
            return prefill;
        }
        StringBuilder sb = new StringBuilder();
        if (outputParams.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.STREAM) {
            sb.append("SELECT * \n");
            sb.append("FROM `");
            sb.append(inputSE.id);
            sb.append("`\n");
            sb.append("EMIT CHANGES\n");
        } else if (outputParams.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.TABLE) {
            sb.append("SELECT * \n");
            sb.append("FROM `");
            sb.append(inputSE.id);
            sb.append("`\n");
            List columns = inputSE.schema.getColumns();
            if (columns.isEmpty()) {
                sb.append(" GROUP BY ROWKEY\n");
            } else {
                SchemaColumn firstCol = (SchemaColumn)columns.get(0);
                sb.append(" GROUP BY `" + firstCol.getName() + "`\n");
            }
            sb.append("EMIT CHANGES\n");
        }
        return sb.toString();
    }
}

