/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.activity.GlobalUsageSummaryBuilder;
import com.dataiku.dip.activity.ProjectUsageSummaryBuilder;
import com.dataiku.dip.activity.WorkspaceUsageSummaryBuilder;
import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UsageSummaryReportsBuilder {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private WorkspacesService workspacesService;
    private static final Logger logger = Logger.getLogger((String)"dku.server.datasets");

    public UsageSummaryReportsBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public List<ReportsManagementService.ReadyReport> getReports() throws IOException {
        Transaction ignored;
        List<String> workspaceKeys;
        List<String> projectKeys;
        ArrayList<ReportsManagementService.ReadyReport> ret = new ArrayList<ReportsManagementService.ReadyReport>();
        GlobalUsageSummaryBuilder gusb = new GlobalUsageSummaryBuilder();
        logger.info((Object)"Building global report");
        try {
            ret.add(new ReportsManagementService.ReadyReport("global-usage-summary", JSON.toJsonObject((Object)gusb.buildGlobalSummary(false))));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to build global report", (Throwable)e);
        }
        try (Transaction t = this.transactionService.beginRead();){
            projectKeys = this.projectsService.listKeys();
            workspaceKeys = this.workspacesService.listWorkspaceKeys();
        }
        for (String projectKey : projectKeys) {
            try {
                ignored = this.transactionService.beginRead();
                try {
                    ret.add(UsageSummaryReportsBuilder.buildReadyReport("project", projectKey, JSON.toJsonObject((Object)new ProjectUsageSummaryBuilder().makeDetailedProjectReport(projectKey, gusb.getApplicationInstanceInfoByAppId(), gusb.getCodeStudioTemplateInfoById()))));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to build project report " + projectKey), (Throwable)e);
            }
        }
        for (String workspaceKey : workspaceKeys) {
            try {
                ignored = this.transactionService.beginRead();
                try {
                    ret.add(UsageSummaryReportsBuilder.buildReadyReport("workspace", workspaceKey, JSON.toJsonObject((Object)new WorkspaceUsageSummaryBuilder().makeDetailedWorkspaceReport(workspaceKey))));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to build workspace report " + workspaceKey), (Throwable)e);
            }
        }
        return ret;
    }

    private static ReportsManagementService.ReadyReport buildReadyReport(String type, String key, JsonObject reportData) {
        logger.info((Object)("Building " + type + " report for " + key));
        return new ReportsManagementService.ReadyReport(type + "-usage-summary", type + "-usage-summary-" + key, type + "-usage-summary-" + DKUtils.md5Base64((String)key), reportData);
    }
}

