/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.code.AutomationNodeCodeEnvsAccessService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.ParameterSetSettings;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.ConfigurablePublicAPIKey;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService
implements IPermissionsService {
    public static final String ALL_USERS_GROUP = "$$ALL_USERS$$";
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private AutomationNodeCodeEnvsAccessService automationNodeCodeEnvsService;
    @Autowired
    private DesignNodeCodeEnvsAccessService designNodeCodeEnvsService;
    @Autowired
    private ClustersService clusterService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private PluginParameterSetsService pluginParameterSetsService;
    @Autowired
    private IWorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private RecipeSaveService recipeSaveService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.permissions");

    @Override
    public boolean hasDatasetPrivilege(AuthCtx u, DatasetLocUtils.DatasetLoc loc, Privileges.DatasetLevelPrivilegeType privilegeType) throws DKUSecurityException {
        DSSAuthCtx du = (DSSAuthCtx)u;
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = du.getAsConfigurableAPIKey();
                if (cpa.hasEffectiveDatasetPrivilege(privilegeType, loc)) {
                    if (cpa.isGlobalAdmin()) {
                        return true;
                    }
                    SerializedProject sp = this.projectsService.getMandatoryUnsafe_RethrowException(loc.getProjectKey());
                    return this.hasCustomHookAccess(u, sp, privilegeType.requiredProjectPrivilege);
                }
                return false;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                String login = u.getAssociatedDSSUser();
                assert (login != null);
                return this.hasProjectPrivilege(u, loc.getProjectKey(), privilegeType.requiredProjectPrivilege);
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkDatasetPrivileges(AuthCtx u, DatasetLocUtils.DatasetLoc loc, Privileges.DatasetLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.DatasetLevelPrivilegeType p : privileges) {
            if (this.hasDatasetPrivilege(u, loc, p)) continue;
            throw new UnauthorizedException("Action on dataset forbidden", "dataset-action-denied");
        }
    }

    public static void makeEffective(SerializedProject.PermissionItem item) {
        if (item.admin) {
            item.editPermissions = true;
            item.readProjectContent = true;
            item.writeProjectContent = true;
            item.exportDatasetsData = true;
            item.publishToDataCollections = true;
            item.shareToWorkspaces = true;
            item.readDashboards = true;
            item.writeDashboards = true;
            item.moderateDashboards = true;
            item.runScenarios = true;
            item.manageDashboardAuthorizations = true;
            item.manageExposedElements = true;
            item.manageAdditionalDashboardUsers = true;
            item.executeApp = true;
        }
        if (item.editPermissions) {
            item.readDashboards = true;
        }
        if (item.writeProjectContent) {
            item.readProjectContent = true;
            item.readDashboards = true;
            item.writeDashboards = true;
            item.moderateDashboards = true;
            item.runScenarios = true;
            item.executeApp = true;
        }
        if (item.shareToWorkspaces || item.publishToDataCollections) {
            item.readProjectContent = true;
            item.readDashboards = true;
            item.manageDashboardAuthorizations = true;
            item.executeApp = true;
        }
        if (item.moderateDashboards) {
            item.readDashboards = true;
            item.writeDashboards = true;
        }
        if (item.readProjectContent) {
            item.readDashboards = true;
            item.executeApp = true;
        }
        if (item.writeDashboards) {
            item.readDashboards = true;
        }
    }

    public static boolean permissionItemIncludes(SerializedProject.PermissionItem item, Privileges.ProjectLevelPrivilegeType privilege) {
        if (item == null) {
            return false;
        }
        switch (privilege) {
            case ADMIN: {
                return item.admin;
            }
            case EDIT_PERMISSIONS: {
                return item.admin || item.editPermissions;
            }
            case MANAGE_DASHBOARD_AUTHORIZATIONS: {
                return item.admin || item.manageDashboardAuthorizations || item.shareToWorkspaces || item.publishToDataCollections;
            }
            case MANAGE_EXPOSED_ELEMENTS: {
                return item.admin || item.manageExposedElements;
            }
            case MANAGE_ADDITIONAL_DASHBOARD_USERS: {
                return item.admin || item.manageAdditionalDashboardUsers;
            }
            case MODERATE_DASHBOARDS: {
                return item.admin || item.writeProjectContent || item.moderateDashboards;
            }
            case READ_CONF: {
                return item.admin || item.writeProjectContent || item.readProjectContent || item.shareToWorkspaces || item.publishToDataCollections;
            }
            case PUBLISH_TO_DATA_COLLECTIONS: {
                return item.admin || item.publishToDataCollections;
            }
            case SHARE_TO_WORKSPACES: {
                return item.admin || item.shareToWorkspaces;
            }
            case READ_DASHBOARDS: {
                return item.admin || item.editPermissions || item.writeProjectContent || item.readProjectContent || item.moderateDashboards || item.writeDashboards || item.readDashboards || item.shareToWorkspaces || item.publishToDataCollections;
            }
            case RUN_SCENARIOS: {
                return item.admin || item.writeProjectContent || item.runScenarios;
            }
            case WRITE_CONF: {
                return item.admin || item.writeProjectContent;
            }
            case WRITE_DASHBOARDS: {
                return item.admin || item.writeProjectContent || item.moderateDashboards || item.writeDashboards;
            }
            case EXPORT_DATASETS_DATA: {
                return item.admin || item.exportDatasetsData;
            }
            case EXECUTE_APP: {
                return item.admin || item.writeProjectContent || item.executeApp || item.readProjectContent || item.publishToDataCollections || item.shareToWorkspaces;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(CodeEnvModel.PermissionItem item, Privileges.CodeEnvLevelPrivilegeType privilege) {
        switch (privilege) {
            case MANAGE_USERS: {
                return item.manageUsers;
            }
            case UPDATE: {
                return item.update || item.manageUsers;
            }
            case USE: {
                return item.use || item.update || item.manageUsers;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(Cluster.PermissionItem item, Privileges.ClusterLevelPrivilegeType privilege) {
        switch (privilege) {
            case MANAGE_USERS: {
                return item.manageUsers;
            }
            case UPDATE: {
                return item.update || item.manageUsers;
            }
            case USE: {
                return item.use || item.update || item.manageUsers;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(CodeStudioTemplate.PermissionItem item, Privileges.CodeStudioTemplatePrivilegeType privilege) {
        switch (privilege) {
            case UPDATE: {
                return item.update;
            }
            case USE: {
                return item.use || item.update;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(ProjectFolder.PermissionItem item, Privileges.ProjectFolderLevelPrivilegeType privilege) {
        switch (privilege) {
            case ADMIN: {
                return item.admin;
            }
            case WRITE_CONTENTS: {
                return item.admin || item.writeContents;
            }
            case READ: {
                return item.admin || item.writeContents || item.read;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(PluginSettings.PermissionItem item, Privileges.PluginLevelPrivilegeType privilege) {
        switch (privilege) {
            case ADMIN: {
                return item.admin;
            }
            case COMPONENTS_VIEWER: {
                return item.admin || item.canViewComponents;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(PluginPreset.PermissionItem item, Privileges.PluginPresetLevelPrivilegeType privilege) {
        switch (privilege) {
            case USE: {
                return item.use;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionItemIncludes(ParameterSetSettings.PermissionItem item, Privileges.PluginParameterSetLevelPrivilegeType privilege) {
        switch (privilege) {
            case OVERRIDE: {
                return item.definableAtProjectLevel;
            }
            case INLINE: {
                return item.definableInline;
            }
        }
        throw new Error("forbidden");
    }

    private static boolean permissionItemIncludes(LabelingTask.LabelingPermissionItem item, Privileges.LabelingLevelPrivilegeType privilege) {
        switch (privilege) {
            case WRITE_CONF: 
            case READ_CONF: {
                return false;
            }
            case REVIEW: {
                return item.review;
            }
            case ANNOTATE: 
            case READ: {
                return item.review || item.annotate;
            }
        }
        throw new Error("forbidden");
    }

    public static boolean permissionChangeAddsGrant(PermissionsWatcher.ProjectPermissionChange change) {
        return change.before == null && change.after != null;
    }

    public static boolean permissionChangeAddsGrant(PermissionsWatcher.ProjectPermissionChange change, Privileges.ProjectLevelPrivilegeType privilege) {
        return !PermissionsService.permissionItemIncludes(change.before, privilege) && PermissionsService.permissionItemIncludes(change.after, privilege);
    }

    public static boolean permissionChangeRemovesGrant(PermissionsWatcher.ProjectPermissionChange change) {
        return change.before != null && change.after == null;
    }

    public static boolean permissionChangeRemovesGrant(PermissionsWatcher.ProjectPermissionChange change, Privileges.ProjectLevelPrivilegeType privilege) {
        return PermissionsService.permissionItemIncludes(change.before, privilege) && !PermissionsService.permissionItemIncludes(change.after, privilege);
    }

    public static void convertPendingPermissionItem(SerializedProject.PermissionItem item, String user) {
        assert (item.pendingUserEmail != null);
        item.user = user;
        item.pendingUserEmail = null;
        item.invitationEmailStatus = null;
    }

    @Override
    public boolean hasAnyProjectAccess(AuthCtx u, String projectKey) throws DKUSecurityException {
        return this.hasProjectPrivilege(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) || this.hasProjectPrivilege(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
    }

    @Override
    public boolean hasAnyProjectAccess(AuthCtx u, SerializedProject serializedProject) throws DKUSecurityException {
        return this.hasProjectPrivilege(u, serializedProject, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) || this.hasProjectPrivilege(u, serializedProject, Privileges.ProjectLevelPrivilegeType.READ_CONF);
    }

    @Override
    public boolean hasCustomProjectAccess(AuthCtx u, String projectKey, Privileges.ProjectLevelPrivilegeType privilege) throws DKUSecurityException {
        return this.hasCustomHookAccess(u, this.projectsService.getMandatoryUnsafe_RethrowException(projectKey), privilege);
    }

    @Override
    public boolean hasProjectPrivilege(AuthCtx u, String projectKey, Privileges.ProjectLevelPrivilegeType privilege) throws DKUSecurityException {
        assert (u != null);
        return this.hasProjectPrivilege(u, this.projectsService.getMandatoryUnsafe_RethrowException(projectKey), privilege);
    }

    @Override
    public boolean hasProjectPrivilege(AuthCtx u, SerializedProject sp, Privileges.ProjectLevelPrivilegeType privilege) throws DKUSecurityException {
        assert (u != null);
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                if (cpa.hasProjectPrivilege(privilege, sp.projectKey)) {
                    if (cpa.isGlobalAdmin()) {
                        return true;
                    }
                    return this.hasCustomHookAccess(u, sp, privilege);
                }
                return false;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (this.isAdmin(u)) {
                    return true;
                }
                String login = u.getAssociatedDSSUser();
                assert (login != null);
                String dssUser = u.getAssociatedDSSUserMand();
                if (dssUser.equals(sp.owner)) {
                    return this.hasCustomHookAccess(u, sp, privilege);
                }
                for (SerializedProject.PermissionItem pi : sp.permissions) {
                    if (pi == null || !dssUser.equals(pi.user) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                    return this.hasCustomHookAccess(u, sp, privilege);
                }
                for (String gid : u.getGroups()) {
                    for (SerializedProject.PermissionItem pi : sp.permissions) {
                        if (pi == null || !gid.equals(pi.group) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return this.hasCustomHookAccess(u, sp, privilege);
                    }
                }
                if (privilege == Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) {
                    for (SerializedProject.AdditionalDashboardUser adu : sp.additionalDashboardUsers.users) {
                        if (!dssUser.equals(adu.login)) continue;
                        return this.hasCustomHookAccess(u, sp, privilege);
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    private boolean hasCustomHookAccess(AuthCtx u, SerializedProject sp, Privileges.ProjectLevelPrivilegeType projectLevelPrivilegeType) {
        try {
            return this.customPolicyHooksRegistry.hasProjectPermissions(u, sp, projectLevelPrivilegeType);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read custom project permissions", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasAnyCodeEnvAccess(AuthCtx u, CodeEnvModel.EnvLang envLang, String envName) throws DKUSecurityException {
        return this.hasCodeEnvPrivilege(u, envLang, envName, Privileges.CodeEnvLevelPrivilegeType.USE);
    }

    @Override
    public boolean hasCodeEnvPrivilege(AuthCtx u, CodeEnvModel.EnvLang envLang, String envName, Privileges.CodeEnvLevelPrivilegeType privilege) throws DKUSecurityException {
        assert (u != null);
        if (((DSSAuthCtx)u).getPermissions().mayManageCodeEnvs()) {
            return true;
        }
        CodeEnvModel.PermissionAndContainerConfBearingDesc desc = this.getCodeEnvForPermissionCheck(envLang, envName);
        if (privilege == Privileges.CodeEnvLevelPrivilegeType.USE && desc.usableByAll) {
            return true;
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.mayManageCodeEnvs() || cpa.hasCodeEnvPrivilege(privilege, envLang, envName);
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (u.getAssociatedDSSUserMand().equals(desc.owner)) {
                    return true;
                }
                for (String gid : u.getGroups()) {
                    for (CodeEnvModel.PermissionItem pi : desc.permissions) {
                        if (!pi.group.equals(gid) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    private CodeEnvModel.PermissionAndContainerConfBearingDesc getCodeEnvForPermissionCheck(CodeEnvModel.EnvLang envLang, String envName) throws DKUSecurityException {
        CodeEnvModel.PermissionAndContainerConfBearingDesc desc;
        try {
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    desc = this.automationNodeCodeEnvsService.getEnvRootDef(envLang, envName);
                    break;
                }
                case DESIGN: {
                    desc = this.designNodeCodeEnvsService.getEnvDesc(envLang, envName);
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
            if (desc == null) {
                throw new Exception("Code env not found : " + envName);
            }
        }
        catch (Exception e) {
            throw new UnauthorizedException("Failed to read code env permissions", "check-failed", (Throwable)e);
        }
        return desc;
    }

    @Override
    public boolean hasAnyClusterAccess(AuthCtx u, String clusterId) throws DKUSecurityException {
        return this.hasClusterPrivilege(u, clusterId, Privileges.ClusterLevelPrivilegeType.USE);
    }

    @Override
    public boolean hasClusterPrivilege(AuthCtx u, String clusterId, Privileges.ClusterLevelPrivilegeType privilege) throws DKUSecurityException {
        Cluster cluster;
        assert (u != null);
        try {
            cluster = this.clusterService.getMandatoryUnsafe(clusterId);
        }
        catch (Exception e) {
            throw new UnauthorizedException("Failed to read cluster permissions", "check-failed", (Throwable)e);
        }
        if (((DSSAuthCtx)u).getPermissions().mayManageClusters()) {
            return true;
        }
        if (privilege == Privileges.ClusterLevelPrivilegeType.USE && cluster.usableByAll) {
            return true;
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.mayManageClusters() || cpa.hasClusterPrivilege(privilege, clusterId);
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (u.getAssociatedDSSUserMand().equals(cluster.owner)) {
                    return true;
                }
                for (String gid : u.getGroups()) {
                    for (Cluster.PermissionItem pi : cluster.permissions) {
                        if (!pi.group.equals(gid) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public boolean hasAnyCodeStudioTemplateAccess(AuthCtx u, String codeStudioTemplateId) throws DKUSecurityException {
        return this.hasCodeStudioTemplatePrivilege(u, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.USE);
    }

    @Override
    public boolean hasCodeStudioTemplatePrivilege(AuthCtx u, String codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType privilege) throws DKUSecurityException {
        CodeStudioTemplate codeStudioTemplate;
        try {
            if (((DSSAuthCtx)u).getPermissions().mayManageCodeStudioTemplates()) {
                return true;
            }
            codeStudioTemplate = this.codeStudioTemplatesDAO.getMandatoryUnsafe(codeStudioTemplateId);
        }
        catch (Exception e) {
            throw new UnauthorizedException("Failed to read Code Studio template permissions", "check-failed", (Throwable)e);
        }
        return this.hasCodeStudioTemplatePrivilege(u, codeStudioTemplate, privilege);
    }

    @Override
    public boolean hasCodeStudioTemplatePrivilege(AuthCtx u, CodeStudioTemplate codeStudioTemplate, Privileges.CodeStudioTemplatePrivilegeType privilege) throws DKUSecurityException {
        assert (u != null);
        if (((DSSAuthCtx)u).getPermissions().mayManageCodeStudioTemplates()) {
            return true;
        }
        if (PermissionsService.permissionItemIncludes(codeStudioTemplate.defaultPermission, privilege)) {
            return true;
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.mayManageCodeStudioTemplates() || cpa.hasCodeStudioTemplatePrivilege(privilege, codeStudioTemplate.id);
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (u.getAssociatedDSSUserMand().equals(codeStudioTemplate.owner)) {
                    return true;
                }
                for (String gid : u.getGroups()) {
                    for (CodeStudioTemplate.PermissionItem pi : codeStudioTemplate.permissions) {
                        if (!pi.group.equals(gid) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public boolean hasAnyPluginPresetAccess(AuthCtx u, String pluginId, String projectKey, String presetName, String parameterSetId) throws DKUSecurityException {
        return this.hasPluginPresetPrivilege(u, pluginId, projectKey, presetName, parameterSetId, Privileges.PluginPresetLevelPrivilegeType.USE);
    }

    @Override
    public boolean hasPluginPresetPrivilege(AuthCtx u, String pluginId, String projectKey, String presetName, String parameterSetId, Privileges.PluginPresetLevelPrivilegeType privilege) throws DKUSecurityException {
        boolean isDev;
        DSSAuthCtx du = (DSSAuthCtx)u;
        assert (u != null);
        PluginPreset preset = null;
        boolean isProjectLevel = false;
        try {
            isDev = this.pluginsRegistryService.isPluginInstalledAsDev(pluginId);
            if (StringUtils.isNotBlank((String)projectKey)) {
                PluginSettings pluginProjectSettings = this.pluginsRegistryService.getProjectSettings(pluginId, projectKey);
                preset = this.pluginParameterSetsService.findPresetInListOfPresets(presetName, parameterSetId, pluginProjectSettings.presets);
                if (preset != null) {
                    isProjectLevel = true;
                }
            }
            if (preset == null) {
                PluginSettings pluginSettings = this.pluginsRegistryService.getSettings(pluginId);
                preset = this.pluginParameterSetsService.findPresetInListOfPresets(presetName, parameterSetId, pluginSettings.presets);
            }
            if (preset == null) {
                throw new NotFoundException("Preset " + presetName + " not found in plugin " + pluginId);
            }
            LoadedParameterSet parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(preset.type);
            if (parameterSetDesc == null) {
                throw new NotFoundException("Preset " + presetName + " is of unknown type " + preset.type);
            }
            if (this.hasPluginPrivilege(u, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new UnauthorizedException("Failed to read preset permissions", "check-failed", (Throwable)e);
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                if (PermissionsService.permissionItemIncludes(preset.defaultPermission, privilege)) {
                    return true;
                }
                ConfigurablePublicAPIKey cpa = du.getAsConfigurableAPIKey();
                return cpa.hasPluginPresetPrivilege(privilege, isDev, preset.type);
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (this.isAdmin(u)) {
                    return true;
                }
                if (isDev && du.getPermissions().mayDevelopPlugins()) {
                    return true;
                }
                if (isProjectLevel && this.hasProjectPrivilege(u, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
                    return true;
                }
                if (PermissionsService.permissionItemIncludes(preset.defaultPermission, privilege)) {
                    return true;
                }
                String login = u.getAssociatedDSSUser();
                assert (login != null);
                if (u.getAssociatedDSSUserMand().equals(preset.owner)) {
                    return true;
                }
                for (String gid : u.getGroups()) {
                    for (PluginPreset.PermissionItem pi : preset.permissions) {
                        if (!pi.group.equals(gid) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkPluginPrivileges(AuthCtx u, String pluginId, Privileges.PluginLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.PluginLevelPrivilegeType p : privileges) {
            if (this.hasPluginPrivilege(u, pluginId, p)) continue;
            throw new UnauthorizedException("Action on plugin forbidden", "plugin-action-denied");
        }
    }

    @Override
    public boolean hasPluginPrivilege(AuthCtx u, String pluginId, Privileges.PluginLevelPrivilegeType privilege) throws DKUSecurityException {
        PluginSettings pluginSettings;
        boolean isDev;
        DSSAuthCtx du = (DSSAuthCtx)u;
        assert (u != null);
        try {
            isDev = this.pluginsRegistryService.isPluginInstalledAsDev(pluginId);
            pluginSettings = this.pluginsRegistryService.getSettings(pluginId);
        }
        catch (Exception e) {
            throw new UnauthorizedException("Failed to read plugin permissions", "check-failed", (Throwable)e);
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = du.getAsConfigurableAPIKey();
                return cpa.hasPluginPrivilege(privilege, isDev, pluginId);
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (this.isAdmin(u)) {
                    return true;
                }
                if (isDev && du.getPermissions().mayDevelopPlugins()) {
                    return true;
                }
                if (PermissionsService.permissionItemIncludes(pluginSettings.defaultPermission, privilege)) {
                    return true;
                }
                for (String gid : u.getGroups()) {
                    for (PluginSettings.PermissionItem pi : pluginSettings.permissions) {
                        if (!pi.group.equals(gid) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkPluginParameterSetPrivileges(AuthCtx u, String pluginId, String parameterSetName, Privileges.PluginParameterSetLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.PluginParameterSetLevelPrivilegeType p : privileges) {
            if (this.hasPluginParameterSetPrivilege(u, pluginId, parameterSetName, p)) continue;
            throw new UnauthorizedException("Action on plugin forbidden", "plugin-action-denied");
        }
    }

    @Override
    public boolean hasPluginParameterSetPrivilege(AuthCtx u, String pluginId, String parameterSetName, Privileges.PluginParameterSetLevelPrivilegeType privilege) throws DKUSecurityException {
        boolean isDev;
        assert (u != null);
        ParameterSetSettings parameterSetSettings = null;
        try {
            isDev = this.pluginsRegistryService.isPluginInstalledAsDev(pluginId);
            PluginSettings pluginSettings = this.pluginsRegistryService.getSettings(pluginId);
            for (ParameterSetSettings p : pluginSettings.parameterSets) {
                if (!StringUtils.equals((String)parameterSetName, (String)p.name)) continue;
                parameterSetSettings = p;
            }
            if (parameterSetSettings == null) {
                parameterSetSettings = new ParameterSetSettings();
            }
        }
        catch (Exception e) {
            throw new UnauthorizedException("Failed to read preset permissions", "check-failed", (Throwable)e);
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.hasPluginParameterSetPrivilege(privilege, isDev, this.pluginParameterSetsService.makeType(pluginId, parameterSetName));
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (PermissionsService.permissionItemIncludes(parameterSetSettings.defaultPermission, privilege)) {
                    return true;
                }
                for (String gid : u.getGroups()) {
                    for (ParameterSetSettings.PermissionItem pi : parameterSetSettings.permissions) {
                        if (!pi.group.equals(gid) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkProjectPrivileges(AuthCtx authContext, String projectKey, Privileges.ProjectLevelPrivilegeType ... privileges) throws DKUSecurityException {
        this.checkProjectPrivileges(authContext, projectKey, true, privileges);
    }

    @Override
    public void checkProjectPrivileges(AuthCtx authContext, String projectKey, boolean withLicensingCheck, Privileges.ProjectLevelPrivilegeType ... privileges) throws DKUSecurityException {
        SerializedProject serializedProject = this.projectsService.getMandatoryUnsafe_RethrowException(projectKey);
        boolean isRegularProject = !SerializedProject.ProjectAppType.APP_INSTANCE.equals((Object)serializedProject.projectAppType);
        for (Privileges.ProjectLevelPrivilegeType p : privileges) {
            if (withLicensingCheck) {
                if (p == Privileges.ProjectLevelPrivilegeType.WRITE_CONF) {
                    if (isRegularProject) {
                        this.licenseEnforcementService.checkWriteProjectContentAllowed(authContext);
                    }
                } else if (p == Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS || p == Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS) {
                    this.licenseEnforcementService.checkWriteDashboardsAllowed(authContext);
                }
            }
            if (this.hasProjectPrivilege(authContext, serializedProject, p)) continue;
            throw new UnauthorizedException("Action forbidden", "project-authorization-failure").with("requiredPrivileges", StringUtils.join((Object[])privileges));
        }
    }

    @Override
    public void checkCodeEnvPrivileges(AuthCtx authContext, CodeEnvModel.EnvLang envLang, String envName, Privileges.CodeEnvLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.CodeEnvLevelPrivilegeType p : privileges) {
            if (this.hasCodeEnvPrivilege(authContext, envLang, envName, p)) continue;
            throw new UnauthorizedException("Action forbidden", "codeenv-authorization-failure").with("requiredPrivileges", StringUtils.join((Object[])privileges));
        }
    }

    @Override
    public void checkClusterPrivileges(AuthCtx authContext, String clusterId, Privileges.ClusterLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.ClusterLevelPrivilegeType p : privileges) {
            if (this.hasClusterPrivilege(authContext, clusterId, p)) continue;
            throw new UnauthorizedException("Action forbidden on cluster '" + clusterId + "' : " + p.toString(), "cluster-authorization-failure").with("requiredPrivileges", StringUtils.join((Object[])privileges));
        }
    }

    @Override
    public boolean isAdmin(AuthCtx authCtx) {
        return authCtx.isAdmin();
    }

    @Override
    public void checkAdmin(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not admin", "not-admin");
        }
    }

    @Override
    public void checkAdmin(AuthCtx authCtx, String reason) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not admin: " + reason, "not-admin");
        }
    }

    @Override
    public boolean hasAdditionalCloudDataikerAdminPermission(AuthCtx authCtx) {
        if (!this.isAdmin(authCtx)) {
            return false;
        }
        if (!DKUApp.isDataikuCloud()) {
            return true;
        }
        DSSAuthCtx dAuthCtx = (DSSAuthCtx)authCtx;
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                throw new AssertionError((Object)"impossible");
            }
            case CONFIGURABLE_API_KEY_GLOBAL: {
                GlobalScopePublicAPIKey cpa = (GlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
                return cpa.managedKey;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
                return gp.dataikerAdmin != null && gp.dataikerAdmin != false;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @Override
    public void checkAdditionalCloudDataikerAdminPermission(AuthCtx authCtx) throws UnauthorizedException {
        this.checkAdmin(authCtx);
        if (!DKUApp.isDataikuCloud()) {
            return;
        }
        DSSAuthCtx dAuthCtx = (DSSAuthCtx)authCtx;
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                throw new AssertionError((Object)"impossible");
            }
            case CONFIGURABLE_API_KEY_GLOBAL: {
                GlobalScopePublicAPIKey cpa = (GlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
                if (!cpa.managedKey.booleanValue()) {
                    throw new UnauthorizedException("Action forbidden", "not-super-admin");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
                if (gp.dataikerAdmin == null || !gp.dataikerAdmin.booleanValue()) {
                    throw new UnauthorizedException("Action forbidden", "not-dataiker-admin");
                }
                return;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @Override
    public boolean isCloudDataikerAdmin(AuthCtx authCtx) {
        return DKUApp.isDataikuCloud() && this.hasAdditionalCloudDataikerAdminPermission(authCtx);
    }

    @Override
    public void checkSQLikePrivilege(AuthCtx authCtx, DSSConnection connection) throws DKUSecurityException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (cpa.isGlobalAdmin()) {
                    return;
                }
                if (!cpa.hasSQLikePrivilege()) {
                    throw new UnauthorizedException("Action forbidden", "sql-action-denied");
                }
                if (connection.usableBy != DSSConnection.ConnectionUsableBy.ALL) {
                    throw new UnauthorizedException("Connection " + connection.name + " is in restricted mode, use an admin or personal API key", "connection-access-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                this.connectionsService.checkUserForConnection(authCtx, connection.name);
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkCreateCodeEnvPrivilege(AuthCtx authCtx) throws UnauthorizedException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (!cpa.mayManageCodeEnvs() && !cpa.mayCreateCodeEnvs()) {
                    throw new UnauthorizedException("Action forbidden", "create-code-env-action-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!((DSSAuthCtx)authCtx).getPermissions().mayManageCodeEnvs() && !((DSSAuthCtx)authCtx).getPermissions().mayCreateCodeEnvs()) {
                    throw new UnauthorizedException("Action forbidden", "create-code-env-action-denied");
                }
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkCreateClusterPrivilege(AuthCtx authCtx) throws UnauthorizedException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (!cpa.mayManageClusters() && !cpa.mayCreateClusters()) {
                    throw new UnauthorizedException("Action forbidden", "create-cluster-action-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!((DSSAuthCtx)authCtx).getPermissions().mayManageClusters() && !((DSSAuthCtx)authCtx).getPermissions().mayCreateClusters()) {
                    throw new UnauthorizedException("Action forbidden", "create-cluster-action-denied");
                }
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkCreateCodeStudioTemplatePrivilege(AuthCtx authCtx) throws UnauthorizedException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (!cpa.mayManageCodeStudioTemplates() && !cpa.mayCreateCodeStudioTemplates()) {
                    throw new UnauthorizedException("Action forbidden", "create-code-studio-template-action-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!((DSSAuthCtx)authCtx).getPermissions().mayManageCodeStudioTemplates() && !((DSSAuthCtx)authCtx).getPermissions().mayCreateCodeStudioTemplates()) {
                    throw new UnauthorizedException("Action forbidden", "create-code-studio-template-action-denied");
                }
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkManageFeatureStorePrivilege(AuthCtx authCtx) throws UnauthorizedException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (!cpa.mayManageFeatureStore()) {
                    throw new UnauthorizedException("Action forbidden", "manage-feature-store-action-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!((DSSAuthCtx)authCtx).getPermissions().mayManageFeatureStore()) {
                    throw new UnauthorizedException("Action forbidden", "manage-feature-store-action-denied");
                }
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkCanExportAndManageBundles(AuthCtx authCtx, String projectKey) throws DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        if (gs.security.requireProjectAdminPermissionToExportAndBundleProjects) {
            this.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        } else {
            this.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
    }

    @Override
    public void checkDevelopPluginPrivilege(AuthCtx authCtx) throws UnauthorizedException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (!cpa.mayDevelopPlugins()) {
                    throw new UnauthorizedException("Action forbidden", "plugin-dev-action-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!((DSSAuthCtx)authCtx).getPermissions().mayDevelopPlugins()) {
                    throw new UnauthorizedException("Action forbidden", "plugin-dev-action-denied");
                }
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkEditLibFoldersPrivilege(AuthCtx authCtx) throws UnauthorizedException {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                if (!cpa.mayEditLibFolders()) {
                    throw new UnauthorizedException("Action forbidden", "lib-edit-action-denied");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!((DSSAuthCtx)authCtx).getPermissions().mayEditLibFolders()) {
                    throw new UnauthorizedException("Action forbidden", "lib-edit-action-denied");
                }
                return;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkCanCreateActiveWebContent(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.canCreateActiveWebContent(authCtx)) {
            throw new UnauthorizedException("Action forbidden", "web-content-create-action-denied");
        }
    }

    @Override
    public boolean canCreateActiveWebContent(AuthCtx authCtx) {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)authCtx).getAsConfigurableAPIKey();
                return cpa.mayCreateActiveWebContent();
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                return ((DSSAuthCtx)authCtx).getPermissions().mayCreateActiveWebContent();
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkProjectFolderPrivilege(AuthCtx authContext, String projectFolderId, Privileges.ProjectFolderLevelPrivilegeType ... privileges) throws DKUSecurityException {
        for (Privileges.ProjectFolderLevelPrivilegeType p : privileges) {
            if (this.hasProjectFolderPrivilege(authContext, projectFolderId, p)) continue;
            throw new UnauthorizedException("Action forbidden", "projectfolder-authorization-failure").with("requiredPrivileges", StringUtils.join((Object[])privileges));
        }
    }

    @Override
    public boolean hasProjectFolderPrivilege(AuthCtx u, String projectFolderId, Privileges.ProjectFolderLevelPrivilegeType privilege) throws DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        assert (u != null);
        ProjectFolder projectFolder = null;
        try {
            projectFolder = this.projectFoldersService.getMandatoryUnsafe_Uncheck(projectFolderId);
            if (this.projectFoldersService.isProjectFolderRoot(projectFolder.id)) {
                return privilege == Privileges.ProjectFolderLevelPrivilegeType.READ || ((DSSAuthCtx)u).getPermissions().mayWriteInRootProjectFolder();
            }
            if (this.projectFoldersService.isProjectFolderAppInstance(projectFolder.id) && Arrays.asList(Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS, Privileges.ProjectFolderLevelPrivilegeType.READ).contains((Object)privilege)) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read project folder", (Throwable)e);
            throw new UnauthorizedException("Failed to read project folder permissions", "check-failed", (Throwable)e);
        }
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                ConfigurablePublicAPIKey cpa = ((DSSAuthCtx)u).getAsConfigurableAPIKey();
                return cpa.hasProjectFolderPrivilege(privilege, projectFolderId);
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (this.isAdmin(u)) {
                    return true;
                }
                String login = u.getAssociatedDSSUser();
                assert (login != null);
                if (u.getAssociatedDSSUserMand().equals(projectFolder.owner)) {
                    return true;
                }
                if (PermissionsService.userHasPrivilegeDirectlyOnFolder(u, privilege, projectFolder)) {
                    return true;
                }
                if (privilege == Privileges.ProjectFolderLevelPrivilegeType.READ) {
                    LinkedList<String> projectFoldersList = new LinkedList<String>();
                    projectFoldersList.add(projectFolder.id);
                    try {
                        String pfId;
                        while ((pfId = (String)projectFoldersList.poll()) != null) {
                            ProjectFolder pf = this.projectFoldersService.getMandatoryUnsafe_Uncheck(pfId);
                            if (u.getAssociatedDSSUserMand().equals(pf.owner)) {
                                return true;
                            }
                            if (PermissionsService.userHasPrivilegeDirectlyOnFolder(u, Privileges.ProjectFolderLevelPrivilegeType.READ, pf)) {
                                return true;
                            }
                            for (String pkey : pf.projectKeys) {
                                SerializedProject sp = this.projectsService.getMandatoryUnsafe_RethrowException(pkey);
                                if (!this.hasAnyProjectAccess(u, sp) && !this.projectsService.isVisible(sp, gs)) continue;
                                return true;
                            }
                            projectFoldersList.addAll(pf.childrenIds);
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to read project folder", (Throwable)e);
                    }
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    private static boolean userHasPrivilegeDirectlyOnFolder(AuthCtx u, Privileges.ProjectFolderLevelPrivilegeType privilege, ProjectFolder projectFolder) throws DKUSecurityException {
        HashSet<String> usersGroups = new HashSet<String>(u.getGroups());
        usersGroups.add(ALL_USERS_GROUP);
        return projectFolder.permissions.stream().anyMatch(pi -> PermissionsService.permissionItemIncludes(pi, privilege) && usersGroups.contains(pi.group));
    }

    @Override
    public boolean hasLabelingTaskPrivilege(AuthCtx u, String projectKey, String labelingTaskId, Privileges.LabelingLevelPrivilegeType privilege) throws DKUSecurityException {
        LabelingTask labelingTask;
        try {
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read labeling task permissions", (Throwable)e);
            throw new UnauthorizedException("Failed to read project permissions", "check-failed", (Throwable)e);
        }
        return this.hasLabelingTaskPrivilege(u, labelingTask, privilege);
    }

    @Override
    public boolean hasLabelingTaskPrivilege(AuthCtx u, LabelingTask task, Privileges.LabelingLevelPrivilegeType privilege) throws DKUSecurityException {
        Privileges.ProjectLevelPrivilegeType sufficientProjectPrivilege = Privileges.ProjectLevelPrivilegeType.WRITE_CONF;
        if (privilege == Privileges.LabelingLevelPrivilegeType.READ || privilege == Privileges.LabelingLevelPrivilegeType.READ_CONF) {
            sufficientProjectPrivilege = Privileges.ProjectLevelPrivilegeType.READ_CONF;
        }
        assert (u != null);
        SerializedProject sp = this.projectsService.getMandatoryUnsafe_RethrowException(task.projectKey);
        if (this.hasProjectPrivilege(u, sp, sufficientProjectPrivilege)) {
            return true;
        }
        String dssUser = u.getAssociatedDSSUserMand();
        if (dssUser.equals(task.owner)) {
            return this.hasCustomHookAccess(u, sp, sufficientProjectPrivilege);
        }
        Set groups = u.getGroups();
        for (LabelingTask.LabelingPermissionItem pi : task.permissions) {
            if (dssUser.equals(pi.user) && PermissionsService.permissionItemIncludes(pi, privilege)) {
                return this.hasCustomHookAccess(u, sp, sufficientProjectPrivilege);
            }
            if (!groups.contains(pi.group) || !PermissionsService.permissionItemIncludes(pi, privilege)) continue;
            return this.hasCustomHookAccess(u, sp, sufficientProjectPrivilege);
        }
        return false;
    }

    @Override
    public void checkAnyProjectAccess(AuthCtx u, String projectKey) throws DKUSecurityException {
        if (!this.hasAnyProjectAccess(u, projectKey)) {
            throw new UnauthorizedException("Action forbidden", "project-authorization-failure");
        }
    }

    @Override
    public boolean canObtainAPITicketFromCookies(AuthCtx u, AuthCtx as) throws DKUSecurityException {
        assert (u != null);
        assert (as != null);
        logger.info((Object)("Check if " + String.valueOf(u) + " can impersonate " + String.valueOf(as)));
        switch (u.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                return false;
            }
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (!u.isAdmin()) break;
                return true;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        switch (as.getAuthSource()) {
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case CONFIGURABLE_API_KEY_PROJECT: {
                return false;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                if (StringUtils.equals((String)u.getAssociatedDSSUser(), (String)as.getAssociatedDSSUser())) {
                    return true;
                }
                Set groups = as.getGroups();
                String canObtainAPITicketFromCookiesForGroupRegex = ((DSSAuthCtx)u).getPermissions().canObtainAPITicketFromCookiesForGroupsRegex();
                logger.info((Object)("Check if " + canObtainAPITicketFromCookiesForGroupRegex + " matches one of " + JSON.json((Object)groups)));
                Pattern canObtainPattern = Pattern.compile(String.format("^%s$", StringUtils.defaultIfBlank((String)canObtainAPITicketFromCookiesForGroupRegex, (String)"")));
                for (String group : groups) {
                    if (!canObtainPattern.matcher(group).matches()) continue;
                    return true;
                }
                return false;
            }
            case NONE: {
                throw new Error("cannot check permissions on a NONE context");
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public void checkCanCreateProjectFromMacro(AuthCtx authCtx) throws UnauthorizedException {
        if (!((DSSAuthCtx)authCtx).getPermissions().mayCreateProjectsFromMacros()) {
            throw new UnauthorizedException("You may not create a project this way", "project-creation-denied");
        }
    }

    @Override
    public void checkReadDashboardPermission(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, @Nullable String objectId) throws DKUSecurityException {
        if (!this.hasReadDashboardPermission(authCtx, projectKey, objectType, objectId)) {
            throw new UnauthorizedException("Action forbidden", "read-dashboard-failure");
        }
    }

    @Override
    public boolean hasReadDashboardPermission(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, @Nullable String objectId) throws DKUSecurityException {
        if (ITaggingService.TaggableType.WORKSPACE.equals((Object)objectType)) {
            return this.workspacePermissionsService.hasWorkspacePrivileges(authCtx, objectId, Privileges.WorkspaceLevelPrivilegeType.READ);
        }
        return this.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) || this.workspacePermissionsService.isObjectReadableViaSomeWorkspace(authCtx, projectKey, objectType, objectId);
    }

    @Override
    public void checkUserDefinedCustomSqlFilters(AuthCtx authCtx, Dataset dataset, DatasetSelection selection) throws IOException, DKUSecurityException, SQLException {
        if (this.hasProjectPrivilege(authCtx, dataset.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
            logger.debug((Object)"The user can already write to the dataset project, skipping permission checks");
            return;
        }
        if (!FilterDescUtils.willFilter(selection.filter)) {
            logger.debug((Object)"The filter won't filter anything, skipping permission checks");
            return;
        }
        if (selection.filter.getExpressionLanguage() != FilterDesc.ExpressionLanguage.SQL) {
            logger.debug((Object)"The filter does not contain raw SQL expression, skipping permission checks");
            return;
        }
        if (!DatasetInspector.isSQL(dataset)) {
            logger.debug((Object)"The explored dataset is not SQL related, skipping permission checks");
            return;
        }
        AbstractSQLConnection connection = DatasetInspector.getDSSConnectionForPureSQL(authCtx, dataset.getModel());
        if (connection.isFreelyUsableBy(authCtx)) {
            logger.debugV("User is allowed to freely use connection '%s'", new Object[]{connection.name});
            return;
        }
        boolean alwaysAllowSql = ApplicationConfigurator.getParams().getBoolParam("dku.selection.filter.alwaysAllowSQL", false);
        if (alwaysAllowSql) {
            logger.infoV("User is not allowed to freely use connection '%s', but checks are disabled by properties", new Object[]{connection.name});
            return;
        }
        throw new DKUSecurityException("You don't have the permission to execute SQL expression filters");
    }

    @Override
    public void checkUnsafeCodePermission(AuthCtx authCtx, Transaction t, GitModel.MultiCommitDiff diff) throws DKUSecurityException, IOException {
        for (GitModel.DKUDiffEntry diffEntry : diff.diffEntries) {
            JsonElement jsonElement;
            String fileContent;
            File file;
            RelFile relFile;
            String path;
            String string = path = com.dataiku.dip.utils.StringUtils.nullIfBlank((String)diffEntry.newPath) != null ? diffEntry.newPath : diffEntry.oldPath;
            if (path.endsWith(".shaker")) {
                relFile = new RelFile(path.split("/"));
                file = t.resolve(relFile);
                fileContent = DKUFileUtils.readFileToStringUTF8((File)file);
                SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)fileContent, SerializedShakerScript.class);
                try {
                    ShakerUtils.checkScriptCodePermission(authCtx, ss);
                    continue;
                }
                catch (UnauthorizedException e2) {
                    throw new UnauthorizedException("Merging modification on file '" + file.getName() + "' not authorized. " + e2.getMessage(), e2.getType(), (Throwable)e2);
                }
            }
            if (!path.endsWith(".json")) continue;
            relFile = new RelFile(path.split("/"));
            file = t.resolve(relFile);
            fileContent = DKUFileUtils.readFileToStringUTF8((File)file);
            if ((fileContent.contains("script") || fileContent.contains("Script")) && (jsonElement = JsonParser.parseReader((Reader)new FileReader(file))).isJsonObject()) {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                for (Map.Entry entry : jsonObj.entrySet()) {
                    if (!((String)entry.getKey()).toLowerCase().endsWith("script") || !((JsonElement)entry.getValue()).isJsonObject() || !((JsonElement)entry.getValue()).getAsJsonObject().entrySet().stream().anyMatch(e -> ((String)e.getKey()).equals("steps"))) continue;
                    try {
                        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)JSON.json(entry.getValue()), SerializedShakerScript.class);
                        ShakerUtils.checkScriptCodePermission(authCtx, ss);
                    }
                    catch (UnauthorizedException e3) {
                        throw new UnauthorizedException("Merging modification on file '" + file.getName() + "' not authorized. " + e3.getMessage(), e3.getType(), (Throwable)e3);
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (!path.contains("recipes/")) continue;
            try {
                SerializedRecipe recipe = (SerializedRecipe)JSON.parse((String)fileContent, SerializedRecipe.class);
                this.recipeSaveService.failIfNotAllowed(recipe, authCtx, null);
            }
            catch (DKUSecurityException e4) {
                throw new DKUSecurityException("Merging modification on file '" + file.getName() + "' not authorized. " + e4.getMessage(), (Throwable)e4);
            }
            catch (SecurityException e5) {
                throw new SecurityException("Merging modification on file '" + file.getName() + "' not authorized. " + e5.getMessage(), e5);
            }
            catch (Exception exception) {
            }
        }
    }
}

