/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.process;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.processes.AbstractCGroupHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.AbstractIsolableProcess;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RegularProcess
extends AbstractIsolableProcess {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType;
    private static Logger logger = Logger.getLogger((String)"dku.process");

    public RegularProcess(ProcessBuilder def, File runDir, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, AuthCtx authCtx, String projectKey) {
        super(def, runDir);
        this.cgrouppableProcessType = cgrouppableProcessType;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
    }

    public RegularProcess(ProcessBuilder def, File runDir) {
        this(def, runDir, null, null, null);
    }

    public void preStartHook(int pid) throws IOException {
        if (this.cgrouppableProcessType != null) {
            if (!(ApplicationConfigurator.isDevLambdaServer() || this.authCtx != null && this.authCtx.getAuthSource() != AuthCtx.AuthSource.NONE && this.projectKey != null && DKUApp.getProcessType() != MainLoggingConfigurator.ProcessType.UNKNOWN)) {
                logger.warn((Object)("Cannot apply cgroup type " + String.valueOf((Object)this.cgrouppableProcessType) + " in this context"));
            } else {
                AbstractCGroupHelper cGroupHelper = AbstractCGroupHelper.getCGroupHelper(this.authCtx, this.projectKey, this.cgrouppableProcessType);
                if (cGroupHelper.isEnabled()) {
                    cGroupHelper.applyCGroupsConfigToProcess(pid);
                }
            }
        }
    }
}

