/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.process;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.processes.AbstractCGroupHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.UserImpersonationUtils;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class WrapperIsolatedProcess
implements IsolableProcess {
    private String command;
    private File intercomDir;
    private File workDir;
    private ProcessBuilder def;
    private String runAsUser;
    private Map<String, String> pipes;
    private Process wrapperProcess;
    private int pid;
    private int childPid;
    private FileOutputStream childStdin;
    private FileInputStream childStdout;
    private FileInputStream childStderr;
    private final MUSExecutionHandlingMode mode;
    private final File execWrapper;
    private final GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType;
    private final AuthCtx authCtx;
    private final String contextProjectKey;
    Thread wrapperErr;
    private static Logger logger = Logger.getLogger((String)"dku.security.process");

    private byte[] readUntil0(InputStream is) throws IOException {
        byte[] buf = new byte[8192];
        int read = 0;
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            read = bis.read(buf);
            if (read < 0) {
                throw new EOFException();
            }
        }
        for (int i = 0; i < read; ++i) {
            if (buf[read] != 0) continue;
            return Arrays.copyOfRange(buf, 0, read - 1);
        }
        throw new EOFException("No 0 seen");
    }

    public WrapperIsolatedProcess(String command, ProcessBuilder def, String runAsUser, File intercomDir, File workDir, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, AuthCtx authCtx, String contextProjectKey) {
        this.command = command;
        this.def = def;
        this.runAsUser = runAsUser;
        this.intercomDir = intercomDir;
        this.workDir = workDir;
        this.mode = MUSExecutionHandlingMode.valueOf(ApplicationConfigurator.getIniValue((String)"mus", (String)"execution_handling_mode", (String)"EXECWRAPPER"));
        String location = ApplicationConfigurator.getIniValue((String)"mus", (String)"exec_wrapper_location");
        this.execWrapper = location != null ? new File(location) : new File(ApplicationConfigurator.getFile((String)"security"), "execwrapper.sh");
        this.cgrouppableProcessType = cgrouppableProcessType;
        this.authCtx = authCtx;
        this.contextProjectKey = contextProjectKey;
    }

    public void start() throws IOException {
        AbstractCGroupHelper cgroupsHelper;
        if (DKUApp.getParams().getBoolParam("dku.security.preventLocalProcessImpersonation", false)) {
            throw new IOException("Execution of this command (" + this.command + ") has been forbidden by your administrator");
        }
        WrapperConfigFile wcf = new WrapperConfigFile();
        wcf.path = this.command;
        wcf.args = this.def.command();
        wcf.chan = Lists.newArrayList((Object[])new String[]{"stdin", "stdout", "stderr"});
        wcf.user = this.runAsUser;
        wcf.dss_user = UserImpersonationUtils.getDSSUser();
        wcf.intercom_dir = this.intercomDir.getAbsolutePath();
        wcf.dir = wcf.work_dir = this.workDir.getAbsolutePath();
        wcf.env = this.def.environment();
        if (this.cgrouppableProcessType != null && (cgroupsHelper = AbstractCGroupHelper.getCGroupHelper(this.authCtx, this.contextProjectKey, this.cgrouppableProcessType)).isEnabled()) {
            wcf.cgroupsHierarchiesRoot = cgroupsHelper.getHierarchiesMountPoint();
            wcf.cgroupPaths = cgroupsHelper.getTargetCGroups();
            cgroupsHelper.createCGroups(wcf.cgroupPaths);
            cgroupsHelper.applyRulesToUsedCGroups(wcf.cgroupPaths);
        }
        File wcfFile = new File(this.intercomDir, "config.json");
        String wcfFileData = JSON.pretty((Object)wcf);
        String wcfFileSha256 = DigestUtils.sha256Hex((byte[])wcfFileData.getBytes(StandardCharsets.UTF_8));
        DKUFileUtils.writeFileUTF8((File)wcfFile, (String)wcfFileData);
        logger.info((Object)("Written config to " + String.valueOf(wcfFile) + " expected SHA256: " + wcfFileSha256));
        ProcessBuilder wrapper = switch (this.mode) {
            case MUSExecutionHandlingMode.EXECWRAPPER -> {
                List args = null;
                String customSudo = ApplicationConfigurator.getIniValue((String)"mus", (String)"custom_root_sudo");
                args = customSudo != null ? (List)JSON.parse((String)customSudo, JSON.StringList.class) : Lists.newArrayList((Object[])new String[]{"sudo", "-n"});
                args.addAll(Lists.newArrayList((Object[])new String[]{this.execWrapper.getAbsolutePath(), "execute", "-s", wcfFileSha256, wcfFile.getAbsolutePath()}));
                yield new ProcessBuilder(args);
            }
            case MUSExecutionHandlingMode.DIRECT_SUDO -> {
                List args = null;
                String customSudo = ApplicationConfigurator.getIniValue((String)"mus", (String)"exec_custom_direct_sudo");
                if (customSudo != null) {
                    args = (List)JSON.parse((String)customSudo, JSON.StringList.class);
                    for (int i = 0; i < args.size(); ++i) {
                        args.set(i, ((String)args.get(i)).replace("%{USER}", this.runAsUser));
                    }
                } else {
                    args = Lists.newArrayList((Object[])new String[]{"sudo", "-u", this.runAsUser, "-n"});
                }
                args.addAll(Lists.newArrayList((Object[])new String[]{this.execWrapper.getAbsolutePath(), "execute", wcfFile.getAbsolutePath()}));
                yield new ProcessBuilder(args);
            }
            default -> throw new Error("unreachable");
        };
        logger.info((Object)("Starting wrapper: " + JSON.json(wrapper.command())));
        this.wrapperProcess = wrapper.start();
        this.wrapperErr = new DKUtils.LoggingStreamEater(this.wrapperProcess.getErrorStream(), Level.INFO, "wrapper-stderr");
        this.wrapperErr.start();
        DKUtils.unsafeSleep((long)100L);
        logger.info((Object)"Reading pids and pipes from wrapper");
        byte[] data = this.readUntil0(this.wrapperProcess.getInputStream());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Pipes read as bytes: " + data.length));
            logger.trace((Object)("Pipes read as bytes: " + new String(data, "utf8")));
        }
        PidAndPipes pip = (PidAndPipes)JSON.parse((InputStream)new ByteArrayInputStream(data), PidAndPipes.class);
        this.pid = pip.pid;
        this.pipes = pip.pipes;
        this.childPid = pip.childPid;
        logger.info((Object)("Data read from wrapper: " + JSON.json((Object)pip)));
        if (this.pipes.containsKey("stdin")) {
            this.childStdin = new FileOutputStream(new File(this.pipes.get("stdin")));
        }
        if (this.pipes.containsKey("stdout")) {
            this.childStdout = new FileInputStream(new File(this.pipes.get("stdout")));
        }
        if (this.pipes.containsKey("stderr")) {
            this.childStderr = new FileInputStream(new File(this.pipes.get("stderr")));
        }
    }

    private void sendCommandToWrappedProcess(byte[] b) throws IOException {
        this.wrapperProcess.getOutputStream().write(b);
        this.wrapperProcess.getOutputStream().flush();
    }

    public void niceKill() throws IOException {
        this.sendCommandToWrappedProcess(new byte[]{2});
    }

    public void evilKill() throws IOException {
        this.sendCommandToWrappedProcess(new byte[]{9});
    }

    public void evilKillTree() throws IOException {
        throw new NotImplementedException("Kill process tree not implemented on isolated processes");
    }

    public void niceThenEvilKill() throws IOException {
        this.sendCommandToWrappedProcess(new byte[]{11});
    }

    public int getWorkingPid() {
        return this.pid;
    }

    public int getPidIfAvailable() {
        return this.childPid;
    }

    public int waitFor() throws InterruptedException {
        int ret = this.wrapperProcess.waitFor();
        this.wrapperErr.join();
        return ret;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.childStdin;
    }

    public InputStream getInputStream() throws IOException {
        return this.childStdout;
    }

    public InputStream getErrorStream() throws IOException {
        return this.childStderr;
    }

    public static enum MUSExecutionHandlingMode {
        EXECWRAPPER,
        DIRECT_SUDO;

    }

    static class WrapperConfigFile {
        public String path;
        public List<String> args = new ArrayList<String>();
        public List<String> chan = new ArrayList<String>();
        public String user;
        public String dss_user;
        public String intercom_dir;
        public String work_dir;
        @Deprecated
        public String dir;
        public Map<String, String> env = new HashMap<String, String>();
        public String cgroupsHierarchiesRoot;
        public Set<String> cgroupPaths = new HashSet<String>();

        WrapperConfigFile() {
        }
    }

    static class PidAndPipes {
        public int pid;
        public Map<String, String> pipes;
        public int childPid;

        PidAndPipes() {
        }
    }
}

