/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server;

import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TagFilterUtils {
    static Logger logger = Logger.getLogger((String)"dku.tags");

    public static boolean matches(TagFilter filter, Collection<String> elementTags) {
        if (filter == null) {
            return true;
        }
        if (filter.orRequiredSet.size() == 0 && filter.orForbiddenSte.size() == 0) {
            return true;
        }
        boolean matchesOneOfRequired = false;
        if (elementTags != null) {
            for (String tag : elementTags) {
                if (filter.orForbiddenSte.contains(tag)) {
                    return false;
                }
                if (!filter.orRequiredSet.contains(tag)) continue;
                matchesOneOfRequired = true;
            }
        }
        if (matchesOneOfRequired) {
            return true;
        }
        return filter.orRequiredSet.size() == 0;
    }

    public static boolean matches(TagFilter filter, TaggableObjectsService.TaggableObject object) {
        return TagFilterUtils.matches(filter, object.tags);
    }

    public static class TagFilter {
        public List<String> orRequired = new ArrayList<String>();
        public List<String> orForbidden = new ArrayList<String>();
        transient Set<String> orRequiredSet = new HashSet<String>();
        transient Set<String> orForbiddenSte = new HashSet<String>();

        static {
            JSON.registerAdapter(TagFilter.class, (Object)new Deserializer());
        }

        private static class Deserializer
        implements JsonDeserializer<TagFilter> {
            private Deserializer() {
            }

            public TagFilter deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                TagFilter ret = new TagFilter();
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (jsonObj.has("orRequired")) {
                    ret.orRequired = (List)ctx.deserialize(jsonObj.get("orRequired"), List.class);
                }
                if (jsonObj.has("orForbidden")) {
                    ret.orForbidden = (List)ctx.deserialize(jsonObj.get("orForbidden"), List.class);
                }
                for (String e : ret.orForbidden) {
                    ret.orForbiddenSte.add(e);
                }
                for (String e : ret.orRequired) {
                    ret.orRequiredSet.add(e);
                }
                return ret;
            }
        }
    }
}

