/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.codahale.metrics.Timer;
import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.common.server.CountingHttpServletResponseWrapper;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.CallTracingAspectBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.MDC;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=1)
public class CallTracingAspect
extends CallTracingAspectBase {
    private static final String VERSION_ID_HEADER = "version-id";
    private static final String VERSION_MISMATCH_HEADER = "version-mismatch-refresh-prompt";
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    private String productVersion;
    private boolean hideVersionWhenNotLogged;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.tracing");

    @PostConstruct
    public void init() {
        this.productVersion = DKUApp.getDSSVersion().product_version;
        this.hideVersionWhenNotLogged = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.hideVersionStringsWhenNotLogged;
    }

    @Around(value="traceRequestMapping()")
    public Object doCall(ProceedingJoinPoint joinpoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinpoint.getSignature();
        Method method = signature.getMethod();
        String mapping = CallTracingAspect.getMapping((Method)method);
        this.setAuditContext(mapping);
        Timer timer = DSSMetrics.registry().timer("dku.api.internal.calltime" + mapping.replace('/', '.').replace('*', '_'));
        Timer.Context timerCtx = timer.time();
        long startTime = System.currentTimeMillis();
        AuthCtx authCtx = null;
        AuthCtxUsage authCtxUsage = null;
        String displayedUserStr = null;
        HttpServletRequest request = null;
        try (Transaction t = this.transactionService.beginRead(IsolationLevel.YOLO, "[CallTracingAspect: " + method.toGenericString() + "]");){
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            AuditContextBase.setIPInfo((HttpServletRequest)request);
            authCtxUsage = this.authService.getWithContextFromAnyOrNullNoXSRF(request);
            AuthCtx authCtx2 = authCtx = authCtxUsage == null ? null : authCtxUsage.getAuthCtx();
            if (authCtx != null) {
                AuditContextBase.setAuthContext((AuthCtx)authCtx);
                displayedUserStr = authCtx.getIdentifier();
            }
        }
        catch (DKUSecurityException | SecurityException e) {
            logger.info((Object)("Failed to trace call info: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        catch (Exception e) {
            logger.info((Object)"Failed to trace call info: ", (Throwable)e);
        }
        if (displayedUserStr != null) {
            MDC.put((String)"user", displayedUserStr);
        }
        MDC.put((String)"apiCall", (Object)mapping);
        MDC.put((String)"_apiCallStartTime", (Object)startTime);
        CallTracingAspectBase.AllCallsLoggingContext aclc = this.buildAllCallsLoggingContext(joinpoint, signature);
        aclc.logStart(mapping, displayedUserStr, authCtx, request);
        try {
            HttpServletResponse response;
            if (!(request == null || authCtx == null && this.hideVersionWhenNotLogged || (response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse()) == null)) {
                CallTracingAspect.addVersionToResponse(request, response, this.productVersion);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to set product version into HTTP response", (Throwable)e);
        }
        Throwable thrown = null;
        try {
            Object object = joinpoint.proceed();
            return object;
        }
        catch (Throwable t) {
            thrown = t;
            throw t;
        }
        finally {
            HttpServletResponse response;
            long endTime = System.currentTimeMillis();
            long executeTime = endTime - startTime;
            try {
                response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                if (response != null) {
                    response.setHeader("DKU-Call-BackendTime", Long.toString(executeTime));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Backend time header could not be set", (Throwable)e);
            }
            timerCtx.stop();
            try {
                response = (CountingHttpServletResponseWrapper)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                if (response != null) {
                    long size = response.getByteCount();
                    DSSMetrics.registry().histogram("dku.api.internal.response.size" + mapping.replace('/', '.').replace('*', '_')).update(size);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Impossible to compute the response size", (Throwable)e);
            }
            aclc.logDone(mapping, displayedUserStr, authCtx, executeTime, thrown, request);
            aclc.emitAudit(executeTime);
            this.reportPossibleAuthenticationFailure(thrown, null);
            if (authCtxUsage != null) {
                authCtxUsage.close();
            }
            MDC.clear();
            AuditContextBase.reset();
            CurrentComputeResourceUsageContext.clear();
        }
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void traceRequestMapping() {
    }

    private static void addVersionToResponse(HttpServletRequest request, HttpServletResponse response, String currentVersionId) {
        if (!StringUtils.isBlank((String)currentVersionId) && !currentVersionId.equals("Unknown")) {
            response.addHeader(VERSION_ID_HEADER, currentVersionId);
            String requestVersionId = request.getHeader(VERSION_ID_HEADER);
            if (!StringUtils.isBlank((String)requestVersionId) && !currentVersionId.equals(requestVersionId)) {
                response.addHeader(VERSION_MISMATCH_HEADER, "true");
            }
        }
    }
}

