/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomJavaExporterDesc;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExporterDesc;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.ExportOption;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.LoadedExporter;
import com.dataiku.dip.export.LoadedJavaExporter;
import com.dataiku.dip.export.LoadedPythonExporter;
import com.dataiku.dip.export.input.BindableExportInput;
import com.dataiku.dip.export.input.ExportUIDataInput;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.AvroFormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatDesc;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedFormat;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.formats.excel.ExcelFormatExtractor;
import com.dataiku.dip.formats.geo.GeoJSONFormatExtractor;
import com.dataiku.dip.formats.geo.ShapefileFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ExportController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private CustomPythonExportersService customPythonExportersService;
    @Autowired
    private CustomJavaExportersService customJavaExportersService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static final Logger logger = Logger.getLogger((String)"dssplugin.qvx.output");

    @AuditedCall(value={"msgType", "exports-list"})
    @RequestMapping(value={"/api/exports/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String userFilter;
        try (Transaction t = this.transactionService.beginRead();){
            userFilter = this.authService.getMandatoryUser(req).getIdentifier();
        }
        ExportController.writeJSON((HttpServletResponse)resp, this.exportService.listExports(userFilter));
    }

    @AuditedCall(value={"msgType", "exports-clear"})
    @RequestMapping(value={"/api/exports/clear"})
    public void clear(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="CURRENT_USER", required=false) String user) throws Exception {
        String userFilter = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            userFilter = this.authService.getMandatoryUser(req).getIdentifier();
            if ("CURRENT_USER".equals(user)) {
            } else if ("ALL_USERS".equals(user)) {
                this.authService.failIfNotAdmin(req);
                userFilter = null;
            } else {
                userFilter = user;
            }
        }
        for (ExportStatus s : this.exportService.listExports(userFilter)) {
            if (s.state != JobState.FAILED && s.state != JobState.DONE && s.state != JobState.ABORTED) continue;
            this.exportService.removeExport(s.exportId);
        }
    }

    @AuditedCall(value={"msgType", "export-remove", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/exports/remove"})
    public void remove(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportId) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
        }
        this.exportService.removeExport(exportId);
    }

    @AuditInline
    @RequestMapping(value={"/api/exports/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="Unbound") String name, @RequestParam String params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            BindableExportInput input = new BindableExportInput(name, 30000L);
            ExportStatus ret = this.exportService.handleExportRequest(this.authService.getUser(req), input, exportParams);
            ExportController.writeJSON((HttpServletResponse)resp, (Object)ret);
            this.auditTrailService.generic("export-create").with("inputName", input.describe().name).with("inputProjectKey", input.describe().projectKey).with("exportId", ret.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("export-create", (Throwable)e).with("name", name).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/exports/download"})
    public void download(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            ExportStatus status = this.exportService.getExport(exportId);
            if (!StringUtils.equals((String)user.getIdentifier(), (String)status.userId) && !user.isAdmin()) {
                throw ErrorContext.iae((String)"You're not allowed to download this export, sorry");
            }
            t.close();
            long downloadSize = this.exportService.handleDownloadRequest(exportId, resp, user);
            this.auditTrailService.generic("export-download").with("exportId", exportId).with("downloadSize", (Number)downloadSize).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("export-download", (Throwable)e).with("exportId", exportId).emit();
            throw e;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/exports/get-export-options"})
    public void gerFormats(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ExportOption newEO;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        ExportOptions ret = new ExportOptions();
        CSVFormatConfig csvFormatConfig = CSVFormatConfig.getStandardTabExcelFormat();
        csvFormatConfig.parseHeaderRow = true;
        csvFormatConfig.setSeparatorStr(",");
        CSVFormatConfig csvFormatConfigGzip = CSVFormatConfig.getStandardTabExcelFormat();
        csvFormatConfig.parseHeaderRow = true;
        csvFormatConfigGzip.setSeparatorStr(",");
        csvFormatConfigGzip.compress = "gz";
        ret.options.add(ExportOption.builtin("tsv-excel-header", "CSV (*.csv)", true, CSVFormatExtractor.META.getType(), csvFormatConfig));
        if (BuiltinsLoader.apachePoiAvailable()) {
            ret.options.add(ExportOption.builtin("excel", "Excel (*.xlsx)", false, ExcelFormatExtractor.META.getType(), new ExcelFormatExtractor.Config()));
        }
        ret.options.add(ExportOption.builtin("tsv-excel-header-gz", "Compressed CSV (*.csv.gz)", true, CSVFormatExtractor.META.getType(), csvFormatConfigGzip));
        ret.options.add(ExportOption.builtin("avro", "AVRO (*.avro)", true, AvroFormatMeta.META.getType(), new AvroFormatConfig()));
        ret.options.add(ExportOption.builtin("geojson", "GeoJSON (*.geojson)", true, GeoJSONFormatExtractor.META.getType(), new GeoJSONFormatExtractor.Config()));
        ret.options.add(ExportOption.builtin("shapefile", "Shapefile (*.shp)", false, ShapefileFormatExtractor.META.getType(), new ShapefileFormatExtractor.Config()));
        for (LoadedFormat customFormat : this.customPythonFormatsService.list()) {
            if (!((CustomPythonFormatDesc)((LoadedPythonFormat)customFormat).desc).canWrite || ((CustomPythonFormatDesc)((LoadedPythonFormat)customFormat).desc).exportOptions == null) continue;
            for (ExportOption exportOption : ((CustomPythonFormatDesc)((LoadedPythonFormat)customFormat).desc).exportOptions) {
                newEO = (ExportOption)JSON.deepCopy((Object)exportOption);
                newEO.id = ((LoadedPythonFormat)customFormat).id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)newEO));
                newEO.formatType = customFormat.getType();
                newEO.optionType = ExportOptionType.CUSTOM_FORMAT;
                ret.options.add(newEO);
            }
        }
        for (LoadedFormat customFormat : this.customJavaFormatsService.list()) {
            logger.error((Object)("HAS A JAVA FORMAT: " + ((CustomJavaFormatDesc)((LoadedJavaFormat)customFormat).desc).id + " : " + ((CustomJavaFormatDesc)((LoadedJavaFormat)customFormat).desc).canWrite + "&&" + (((CustomJavaFormatDesc)((LoadedJavaFormat)customFormat).desc).exportOptions != null)));
            if (!((CustomJavaFormatDesc)((LoadedJavaFormat)customFormat).desc).canWrite || ((CustomJavaFormatDesc)((LoadedJavaFormat)customFormat).desc).exportOptions == null) continue;
            for (ExportOption exportOption : ((CustomJavaFormatDesc)((LoadedJavaFormat)customFormat).desc).exportOptions) {
                newEO = (ExportOption)JSON.deepCopy((Object)exportOption);
                newEO.id = ((LoadedJavaFormat)customFormat).id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)newEO));
                newEO.formatType = ((LoadedJavaFormat)customFormat).getType();
                newEO.optionType = ExportOptionType.CUSTOM_FORMAT;
                ret.options.add(newEO);
            }
        }
        for (LoadedExporter customExporter : this.customPythonExportersService.list()) {
            if (((CustomPythonExporterDesc)((LoadedPythonExporter)customExporter).desc).exportBehavior == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE && ((CustomPythonExporterDesc)((LoadedPythonExporter)customExporter).desc).exportOptions != null) {
                for (ExportOption exportOption : ((CustomPythonExporterDesc)((LoadedPythonExporter)customExporter).desc).exportOptions) {
                    newEO = (ExportOption)JSON.deepCopy((Object)exportOption);
                    newEO.id = ((LoadedPythonExporter)customExporter).id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)newEO));
                    newEO.exporterType = customExporter.getType();
                    newEO.optionType = ExportOptionType.CUSTOM_TO_FILE;
                    ret.options.add(newEO);
                }
            }
            if (((CustomPythonExporterDesc)((LoadedPythonExporter)customExporter).desc).exportBehavior != CustomExporterDesc.ExportBehavior.MANAGES_OUTPUT || ((CustomPythonExporterDesc)((LoadedPythonExporter)customExporter).desc).exportOptions == null) continue;
            for (ExportOption exportOption : ((CustomPythonExporterDesc)((LoadedPythonExporter)customExporter).desc).exportOptions) {
                newEO = (ExportOption)JSON.deepCopy((Object)exportOption);
                newEO.id = ((LoadedPythonExporter)customExporter).id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)newEO));
                newEO.exporterType = customExporter.getType();
                newEO.optionType = ExportOptionType.CUSTOM_MANAGED;
                ret.options.add(newEO);
            }
        }
        for (LoadedExporter customExporter : this.customJavaExportersService.list()) {
            if (((CustomJavaExporterDesc)((LoadedJavaExporter)customExporter).desc).exportBehavior == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE && ((CustomJavaExporterDesc)((LoadedJavaExporter)customExporter).desc).exportOptions != null) {
                for (ExportOption exportOption : ((CustomJavaExporterDesc)((LoadedJavaExporter)customExporter).desc).exportOptions) {
                    newEO = (ExportOption)JSON.deepCopy((Object)exportOption);
                    newEO.id = ((LoadedJavaExporter)customExporter).id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)newEO));
                    newEO.exporterType = customExporter.getType();
                    newEO.optionType = ExportOptionType.CUSTOM_TO_FILE;
                    ret.options.add(newEO);
                }
            }
            if (((CustomJavaExporterDesc)((LoadedJavaExporter)customExporter).desc).exportBehavior != CustomExporterDesc.ExportBehavior.MANAGES_OUTPUT || ((CustomJavaExporterDesc)((LoadedJavaExporter)customExporter).desc).exportOptions == null) continue;
            for (ExportOption exportOption : ((CustomJavaExporterDesc)((LoadedJavaExporter)customExporter).desc).exportOptions) {
                newEO = (ExportOption)JSON.deepCopy((Object)exportOption);
                newEO.id = ((LoadedJavaExporter)customExporter).id + "-" + DigestUtils.md5Hex((String)JSON.json((Object)newEO));
                newEO.exporterType = customExporter.getType();
                newEO.optionType = ExportOptionType.CUSTOM_MANAGED;
                ret.options.add(newEO);
            }
        }
        ExportController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/exports/export-ui-data"})
    public void exportUIData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ExportUIDataInput.ExportableUIData euid = (ExportUIDataInput.ExportableUIData)JSON.parse((String)data, ExportUIDataInput.ExportableUIData.class);
            ExportUIDataInput input = new ExportUIDataInput(euid);
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            exportParams.filenameBase = euid.name;
            ExportStatus ret = this.exportService.handleExportRequest(this.authService.getUser(req), input, exportParams);
            ExportController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    public static class ExportOptions {
        List<ExportOption> options = Lists.newArrayList();
    }

    public static enum ExportOptionType {
        BUILTIN_FORMAT,
        CUSTOM_FORMAT,
        CUSTOM_TO_FILE,
        CUSTOM_MANAGED;

    }
}

