/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/projects"})
public class ExposedObjectsController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private FlowGraphService graphService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.controller");

    @AuditedCall(value={"msgType", "project-get-exposed-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-exposed-objects"})
    public void getExposedObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
            ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)sp.exposedObjects);
        }
    }

    @AuditedCall(value={"msgType", "project-get-object-authorizations", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}"})
    @RequestMapping(value={"/get-object-authorizations"})
    public void getObjectAuthorizations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectId, @RequestParam ITaggingService.TaggableType objectType) throws Exception {
        ExposedObjectsService.ObjectAuthorizations objectAuthorizations;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(projectKey, objectId, objectType, authCtx);
        }
        ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)objectAuthorizations);
    }

    @AuditedCall(value={"msgType", "project-get-exposed-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-enriched-exposed-objects"})
    public void getEnrichedExposedObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
            EnrichedExposedObjects result = new EnrichedExposedObjects();
            result.objects = this.exposedObjectsService.getEnrichedExposedObjects((String)projectKey).objects;
            result.sharingRequestsEnabled = sp.settings.sharingRequestsEnabled;
            ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)result);
        }
    }

    @AuditedCall(value={"msgType", "project-save-exposed-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/save-exposed-objects"})
    public void saveExposedObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exposedObjects) throws Exception {
        EnrichedExposedObjects config = (EnrichedExposedObjects)JSON.parse((String)exposedObjects, EnrichedExposedObjects.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(t.getUser(), projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            sp.exposedObjects = new SerializedProject.ProjectExposedObjects();
            sp.exposedObjects.objects = config.objects;
            if (config.sharingRequestsEnabled != null) {
                sp.settings.sharingRequestsEnabled = config.sharingRequestsEnabled;
            }
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
            t.commit("Updated exposed objects (project:" + projectKey + ")");
        }
    }

    @AuditedCall(value={"msgType", "project-add-exposed-object", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/add-exposed-object"})
    public void addExposedObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam ITaggingService.TaggableType type, @RequestParam String objectId, @RequestParam String targetProjectKey, @RequestParam @Nullable String targetZoneId) throws Exception {
        if (projectKey.equals(targetProjectKey)) {
            ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)InfoMessage.fatal((String)"Target project must be different.", null));
        } else {
            InfoMessage result;
            try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                AuthCtx authCtx = t.getUser();
                result = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS) || this.canQuickShare(authCtx, projectKey, type, objectId, targetProjectKey) ? this.exposedObjectsService.addExposedObject(projectKey, type, objectId, targetProjectKey) : new InfoMessage(InfoMessage.Severity.ERROR, "Insufficient privileges to share object with project " + projectKey, null);
                if (result.severity == InfoMessage.Severity.SUCCESS) {
                    this.moveObjectToZone(projectKey, type, objectId, targetProjectKey, targetZoneId);
                    t.commit("Updated exposed objects (project:" + projectKey + ")");
                }
            }
            ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)result);
        }
    }

    @AuditedCall(value={"msgType", "project-get-exposed-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-object-exposition"})
    public void getObjectExposition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectId, @RequestParam ITaggingService.TaggableType objectType) throws Exception {
        ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)this.getObjectExposition(req, projectKey, objectId, objectType));
    }

    private ExposedObjectsService.ObjectExposition getObjectExposition(HttpServletRequest req, String projectKey, String objectId, ITaggingService.TaggableType objectType) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ExposedObjectsService.ObjectExposition objectExposition = this.getObjectExposition(authCtx, projectKey, objectType, objectId);
            return objectExposition;
        }
    }

    private ExposedObjectsService.ObjectExposition getObjectExposition(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException, DKUSecurityException {
        ExposedObjectsService.ObjectExposition objectExposition = new ExposedObjectsService.ObjectExposition();
        boolean hasManagedExposedElementsPermission = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
        objectExposition.quickSharingEnabled = this.exposedObjectsService.isQuickSharingEnabled(projectKey, objectType, objectId);
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        for (ExposedObject exposedObject : sp.exposedObjects.objects) {
            if (exposedObject == null || !exposedObject.localName.equals(objectId) || !exposedObject.type.equals((Object)objectType)) continue;
            for (ExposedObject.Rule rule : exposedObject.rules) {
                String targetProjectDisplayName;
                SerializedProject targetProject = this.projectsService.getOrNullUnsafe(rule.targetProject);
                String string = targetProjectDisplayName = targetProject != null ? targetProject.getDisplayName() + " (" + rule.targetProject + ")" : rule.targetProject + " (deleted)";
                if (!hasManagedExposedElementsPermission && (targetProject == null || !this.permissionsService.hasProjectPrivilege(authCtx, targetProject.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF))) continue;
                objectExposition.rules.add(ExposedObject.Rule.RuleWithName.fromRule(rule, targetProjectDisplayName, false));
            }
        }
        for (SerializedProject.ReaderAuthorization dashboardAuthorization : sp.dashboardAuthorizations.authorizations) {
            if (dashboardAuthorization.objectRef.isForeign() || !dashboardAuthorization.objectRef.objectId.equals(objectId) || !dashboardAuthorization.objectRef.objectType.equals((Object)objectType)) continue;
            objectExposition.dashboardAuthorizedModes = dashboardAuthorization.modes;
            break;
        }
        objectExposition.dashboardAllAuthorized = sp.dashboardAuthorizations.allAuthorized;
        return objectExposition;
    }

    @AuditedCall(value={"msgType", "project-get-exposed-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/get-objects-expositions"})
    public void getObjectsExpositions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items) throws Exception {
        ExposedObjectsService.ObjectsExpositions objectsExpositions;
        Set parsedItems = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef item : parsedItems) {
                this.checkNotNull((Object)item.type, "Invalid item type", new Object[0]);
                this.projectsService.checkPerm(authCtx, item.projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            }
            objectsExpositions = this.exposedObjectsService.getObjectsExpositions(parsedItems);
        }
        ExposedObjectsController.writeJSON((HttpServletResponse)resp, (Object)objectsExpositions);
    }

    @AuditedCall(value={"msgType", "project-save-exposed-objects", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/save-object-exposition"})
    public void saveObjectExposition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectId, @RequestParam ITaggingService.TaggableType objectType, @RequestParam String objectExposition) throws Exception {
        block9: {
            ExposedObjectsService.ObjectExposition exposition = (ExposedObjectsService.ObjectExposition)JSON.parse((String)objectExposition, ExposedObjectsService.ObjectExposition.class);
            Preconditions.checkArgument((exposition != null ? 1 : 0) != 0, (Object)"Empty exposed objects settings");
            try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                AuthCtx authCtx = this.authService.getMandatoryUser(req);
                ExposedObjectsService.ObjectAuthorizations objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(projectKey, objectId, objectType, authCtx);
                if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS)) {
                    this.exposedObjectsService.saveObjectExposition(projectKey, objectType, objectId, exposition, authCtx);
                    t.commit("Updated managed shares for " + projectKey + "." + String.valueOf((Object)objectType) + "." + objectId);
                    break block9;
                }
                if (objectAuthorizations.isQuicklyShareable) {
                    ExposedObjectsService.ObjectExposition existingExpositions = this.getObjectExposition(authCtx, projectKey, objectType, objectId);
                    Set existingProjects = existingExpositions.rules.stream().map(r -> r.targetProject).collect(Collectors.toSet());
                    Set requestedProjects = exposition.rules.stream().map(r -> r.targetProject).collect(Collectors.toSet());
                    Sets.SetView addedProjects = Sets.difference(requestedProjects, existingProjects);
                    Sets.SetView removedProjects = Sets.difference(existingProjects, requestedProjects);
                    for (String addedOrRemoveProjectKey : Sets.union((Set)addedProjects, (Set)removedProjects)) {
                        this.projectsService.checkPerm(authCtx, addedOrRemoveProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                        if (objectAuthorizations.canReadObject) continue;
                        throw new UnauthorizedException("Action forbidden", "object-read-for-quick-sharing-failure");
                    }
                    this.exposedObjectsService.updateObjectExpositions(projectKey, objectType, objectId, (Collection<String>)addedProjects, (Collection<String>)removedProjects);
                    t.commit("Updated quick shares for " + projectKey + "." + String.valueOf((Object)objectType) + "." + objectId);
                    break block9;
                }
                throw new UnauthorizedException("Action forbidden", "project-authorization-failure");
            }
        }
    }

    @AuditedCall(value={"msgType", "append-object-expositions", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}"})
    @RequestMapping(value={"/append-object-expositions"}, method={RequestMethod.POST})
    public void appendObjectExposition(HttpServletRequest req, HttpServletResponse resp, @RequestParam ITaggingService.TaggableType objectType, @RequestParam String projectKey, @RequestParam String objectId, @Nullable @RequestParam Boolean quickShareEnabled, @RequestParam List<String> newProjectsSharedTo) throws Exception {
        Preconditions.checkNotNull((Object)((Object)objectType), (Object)"objectType must be defined");
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey must be defined");
        Preconditions.checkNotNull((Object)objectId, (Object)"objectId must be defined");
        Preconditions.checkNotNull(newProjectsSharedTo, (Object)"newProjectsSharedTo must be defined");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            boolean hasChangeToSave = false;
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (!newProjectsSharedTo.isEmpty()) {
                ExposedObjectsService.ObjectAuthorizations objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(projectKey, objectId, objectType, authCtx);
                if (!objectAuthorizations.isQuicklyShareable || !objectAuthorizations.canReadObject) {
                    this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
                }
                for (String newProjectSharedTo : newProjectsSharedTo) {
                    this.permissionsService.checkProjectPrivileges(authCtx, newProjectSharedTo, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                }
                hasChangeToSave |= sp.exposedObjects.addTargetProjects(objectType, objectId, newProjectsSharedTo);
            }
            if (quickShareEnabled != null) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
                hasChangeToSave |= sp.exposedObjects.setQuickSharing(objectType, objectId, quickShareEnabled);
            }
            if (hasChangeToSave) {
                this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
                t.commit("Updated shares for " + projectKey + "." + String.valueOf((Object)objectType) + "." + objectId);
            }
        }
    }

    @AuditedCall(value={"msgType", "project-enable-quick-sharing", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectId", "${objectId}"})
    @RequestMapping(value={"/enable-quick-sharing"})
    public void enableQuickSharing(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam ITaggingService.TaggableType objectType, @RequestParam String objectId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            this.exposedObjectsService.enableQuickSharing(projectKey, objectType, objectId);
            t.commit("Enabled quick sharing for " + projectKey + "." + String.valueOf((Object)objectType) + "." + objectId);
        }
    }

    @AuditedCall(value={"msgType", "project-add-exposed-objects", "projectKey", "${projectKey}", "items", "${items}", "settings", "${settings}"})
    @RequestMapping(value={"/add-objects-expositions"})
    public void addObjectsExpositions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam String settings) throws Exception {
        Set parsedItems = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        ExposedObjectsService.MultiObjectsExposeSettings expositionSettings = (ExposedObjectsService.MultiObjectsExposeSettings)JSON.parse((String)settings, ExposedObjectsService.MultiObjectsExposeSettings.class);
        HashSet<String> destinationProjects = new HashSet<String>(expositionSettings.projects.size());
        for (Map.Entry<String, ExposedObjectsService.MultiObjectsExposeProjectRule> e : expositionSettings.projects.entrySet()) {
            if (!e.getValue().exposeAll) continue;
            destinationProjects.add(e.getKey());
        }
        HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>> toExposeByProject = new HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>>();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef item : parsedItems) {
                AnyLoc loc = item.getLoc().resolved();
                if (toExposeByProject.get(loc.getProjectKey()) == null) {
                    if (!destinationProjects.isEmpty()) {
                        this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
                    }
                    if (expositionSettings.dashboard) {
                        this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS);
                    }
                    toExposeByProject.put(loc.getProjectKey(), new HashSet());
                }
                ((Set)toExposeByProject.get(loc.getProjectKey())).add(item);
            }
            this.exposedObjectsService.addObjectsExpositions(toExposeByProject, destinationProjects, expositionSettings);
            t.commit("Updated exposed objects");
        }
    }

    @AuditedCall(value={"msgType", "project-unshare", "items", "${items}"})
    @RequestMapping(value={"/unshare"})
    public void stopExposeObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam String targetProjectKey) throws Exception {
        Set parsedItems = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        HashSet<TaggableObjectsService.TaggableObjectRef> itemsToStopSharing = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef item : parsedItems) {
                AnyLoc loc = item.getLoc().resolved();
                if (this.permissionsService.hasProjectPrivilege(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS)) {
                    itemsToStopSharing.add(item);
                    continue;
                }
                if (this.canQuickShare(authCtx, item.projectKey, item.type, item.id, targetProjectKey)) {
                    itemsToStopSharing.add(item);
                    continue;
                }
                logger.info((Object)("Not enough privilege to stop sharing object " + String.valueOf(loc) + " from project " + targetProjectKey));
            }
            if (!itemsToStopSharing.isEmpty()) {
                this.exposedObjectsService.unshare(itemsToStopSharing, targetProjectKey);
            }
            t.commit("Updated exposed objects");
        }
    }

    private boolean canQuickShare(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, String objectId, String targetProjectKey) throws IOException, DKUSecurityException {
        ExposedObjectsService.ObjectAuthorizations objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(projectKey, objectId, objectType, authCtx);
        return this.exposedObjectsService.isQuickSharingEnabled(projectKey, objectType, objectId) && this.permissionsService.hasProjectPrivilege(authCtx, targetProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF) && objectAuthorizations.canReadObject;
    }

    private void moveObjectToZone(String projectKey, ITaggingService.TaggableType type, String objectId, String targetProjectKey, String targetZoneId) throws IOException {
        if (StringUtils.isNotBlank((String)targetZoneId)) {
            SmartObjectRef smartObjectRef = SmartObjectRef.fromResolved(type, projectKey, objectId, targetProjectKey);
            this.flowZonesService.attachObjectToZone(targetZoneId, targetProjectKey, smartObjectRef, false);
            this.graphService.invalidateCache();
        }
    }

    public static class EnrichedExposedObjects {
        public List<ExposedObject> objects = new ArrayList<ExposedObject>();
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue sharingRequestsEnabled;
    }
}

