/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.ReverseJobUnprunedTreeComputer;
import com.dataiku.dip.dataflow.export.FlowExportService;
import com.dataiku.dip.dataflow.export.model.FlowExport;
import com.dataiku.dip.dataflow.export.model.FlowExportFormat;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.DataLineageSerializer;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializer;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.dataflow.graph.utils.ProjectGraphSerializer;
import com.dataiku.dip.dataflow.graph.utils.ProjectsGraphSerializer;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.docgen.flow.FlowDocumentUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.graphicsexport.FlowDocumentGenerationService;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.UsabilityComputer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class FlowGraphController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private BuildState buildState;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private FlowExportService flowExportService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private FlowDocumentGenerationService flowDocumentGenerationService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private PermissionsService permissionsService;
    private final GraphSerializerCommon.GraphCache graphCache = new GraphSerializerCommon.GraphCache();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.crud");

    @AuditedCall(value={"msgType", "get-data-lineage", "contextProjectKey", "${contextProjectKey}", "smartName", "${smartName}", "column", "${column}", "useHardMax", "${useHardMax}"})
    @RequestMapping(value={"/api/flow/get-data-lineage"})
    @ResponseBody
    public DataLineageSerializer.SerializedGraph getDataLineage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String smartName, @RequestParam String column, @RequestParam boolean useHardMax) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(contextProjectKey, smartName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDatasetReadUseAccess(authCtx, datasetLoc, contextProjectKey);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
        }
        DataLineageSerializer dataLineageSerializer = new DataLineageSerializer(contextProjectKey, datasetLoc, column, useHardMax, authCtx);
        dataLineageSerializer.setCache(this.graphCache);
        Callable<DataLineageSerializer.SerializedGraph> graphCallable = dataLineageSerializer.serialize_NT();
        return graphCallable.call();
    }

    @AuditedCall(value={"msgType", "flow-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/recipes/get-graph-serialized"})
    @ResponseBody
    public LoadFlowResponse getGraphSerialized(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(defaultValue="true") boolean withSvg, @RequestParam(defaultValue="true") boolean drawZones, @RequestParam(defaultValue="") String zoneId, @RequestParam(required=false) Set<String> collapsedZones) throws Exception {
        Callable<GraphSerializer.SerializedGraph> graphCallable;
        collapsedZones = collapsedZones == null ? Collections.emptySet() : collapsedZones;
        ZonesManualPositioning zonesManualPositioning = new ZonesManualPositioning();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            graphCallable = this.getSerializedGraphCallable(projectKey, withSvg, drawZones, zoneId, collapsedZones, authCtx);
            zonesManualPositioning = this.getZonesManualPositioning(projectKey, authCtx);
        }
        return new LoadFlowResponse(new SerializedFilteredGraphResponse(graphCallable.call()), zonesManualPositioning);
    }

    private Callable<GraphSerializer.SerializedGraph> getSerializedGraphCallable(String projectKey, boolean withSvg, boolean drawZones, String zoneId, Set<String> collapsedZones, AuthCtx authCtx) throws Exception {
        ProjectFlowGraph projectGraph = this.graphService.getProjectGraphUnsafe(projectKey, drawZones);
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        ProjectGraphSerializer projectGraphSerializer = new ProjectGraphSerializer(projectGraph, projectKey, drawZones, zoneId, collapsedZones, authCtx);
        projectGraphSerializer.setBuildState(this.buildState);
        projectGraphSerializer.setContinuousActivitiesCurrentState(this.continuousActivitiesManager.listProjectStates_autoTxn(projectKey));
        projectGraphSerializer.setDisplaySettings(sp.settings.flowAnchorSourcesAndSinks, sp.settings.flowDisplaySettings);
        projectGraphSerializer.setSvg(withSvg);
        projectGraphSerializer.setCache(this.graphCache);
        return projectGraphSerializer.serialize();
    }

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/flow/projects/get-graph-serialized"})
    public void getProjectsGraph(HttpServletRequest req, HttpServletResponse resp, String layoutEngine, @RequestParam(required=false) String projectFolderId, @RequestParam(defaultValue="false") boolean recursive) throws Exception {
        Callable<ProjectsGraphSerializer.ProjectsSerializedGraph> graphCallable;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            ProjectsGraphSerializer gs = new ProjectsGraphSerializer();
            gs.setCache(this.graphCache);
            graphCallable = gs.serialize(layoutEngine, projectFolderId, recursive, u);
        }
        FlowGraphController.writeJSON((HttpServletResponse)resp, (Object)graphCallable.call());
    }

    @AuditedCall(value={"msgType", "flow-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/list-usable-computable"})
    public void listUsableComputables(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String filter) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            if (projectKey != null) {
                this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            UsabilityComputer.ListSettings ls = new UsabilityComputer.ListSettings();
            if (!StringUtils.isBlank((String)filter)) {
                ls = (UsabilityComputer.ListSettings)JSON.parse((String)filter, UsabilityComputer.ListSettings.class);
            }
            ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(projectKey);
            String lang = this.userSettingsService.getLangForUser(u.getIdentifier());
            UsabilityComputer uc = new UsabilityComputer(u, graph, ls, false, projectKey);
            FlowGraphController.writeJSON((HttpServletResponse)resp, uc.compute(lang));
        }
    }

    @AuditedCall(value={"msgType", "flow-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/list-downstream-computable"})
    public void getDownstreamComputables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String computable, @RequestParam(required=false) String runnable, @RequestParam(required=false) String zoneId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            if (projectKey != null) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            Collection<FlowComputable> downstreamComputables = StringUtils.isNotBlank((String)computable) ? this.graphService.getDownstreamFromComputable(projectKey, computable) : (StringUtils.isNotBlank((String)runnable) ? this.graphService.getDownstreamFromRunnable(projectKey, runnable) : (StringUtils.isNotBlank((String)zoneId) ? this.graphService.getFinalComputablesOfFlow(projectKey, zoneId) : this.graphService.getDownstream(projectKey)));
            ArrayList<DownstreamComputable> results = new ArrayList<DownstreamComputable>(downstreamComputables.size());
            for (FlowComputable flowComputable : downstreamComputables) {
                DownstreamComputable downstreamComputable = new DownstreamComputable();
                downstreamComputable.type = flowComputable.getType();
                String[] parts = flowComputable.getFullId().split("\\.", 2);
                downstreamComputable.projectKey = parts[0];
                downstreamComputable.id = parts[1];
                switch (flowComputable.getType()) {
                    case DATASET: {
                        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(((FlowDataset)flowComputable).getFullName());
                        downstreamComputable.serializedDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc);
                        downstreamComputable.name = downstreamComputable.serializedDataset != null ? downstreamComputable.serializedDataset.name : "";
                        break;
                    }
                    case SAVED_MODEL: {
                        downstreamComputable.name = ((FlowSavedModel)flowComputable).getSavedModel().name;
                        downstreamComputable.model = ((FlowSavedModel)flowComputable).getSavedModel();
                        break;
                    }
                    case MANAGED_FOLDER: {
                        downstreamComputable.name = ((FlowManagedFolder)flowComputable).getManagedFolder().name;
                        downstreamComputable.box = ((FlowManagedFolder)flowComputable).getManagedFolder();
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        downstreamComputable.name = ((FlowModelEvaluationStore)flowComputable).getModelEvaluationStore().name;
                        downstreamComputable.evaluationStore = ((FlowModelEvaluationStore)flowComputable).getModelEvaluationStore();
                        break;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        downstreamComputable.name = ((FlowRetrievableKnowledge)flowComputable).getRetrievableKnowledge().name;
                        downstreamComputable.retrievableKnowledge = ((FlowRetrievableKnowledge)flowComputable).getRetrievableKnowledge();
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        downstreamComputable.name = ((FlowStreamingEndpoint)flowComputable).getStreamingEndpoint().id;
                        downstreamComputable.streamingEndpoint = ((FlowStreamingEndpoint)flowComputable).getStreamingEndpoint();
                    }
                }
                results.add(downstreamComputable);
            }
            FlowGraphController.writeJSON((HttpServletResponse)resp, results);
        }
    }

    @AuditedCall(value={"msgType", "check-downstream-buildable"})
    @RequestMapping(value={"/api/flow/check-downstream-buildable"})
    @ResponseBody
    public ReverseJobUnprunedTreeComputer.Buildable checkDownstreamBuildable(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) String computable, @RequestParam(required=false) String runnable) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ReverseJobUnprunedTreeComputer.Buildable buildable;
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ProjectFlowGraph graph = this.graphService.getProjectGraph(projectKey, true);
            JobDef jobDef = new JobDef();
            jobDef.initiationTimestamp = System.currentTimeMillis();
            jobDef.projectKey = projectKey;
            jobDef.type = JobDef.JobType.REVERSE_FORCED_BUILD;
            if (StringUtils.isNotBlank((String)computable)) {
                loc = AnyLoc.resolveSmart(projectKey, computable);
                JobDef.ReverseJobStartingPoint r = new JobDef.ReverseJobStartingPoint();
                r.graphNodeSupertype = JobDef.GraphNodeSupertype.COMPUTABLE;
                r.projectKey = loc.getProjectKey();
                r.id = loc.getId();
                jobDef.reverseStartingPoints.add(r);
            } else if (StringUtils.isNotBlank((String)runnable)) {
                loc = AnyLoc.resolveSmart(projectKey, runnable);
                FlowRunnable flowRunnable = graph.getRunnable(loc.getFullName());
                for (GraphNode graphNode : flowRunnable.getSuccessors()) {
                    if (!(graphNode instanceof FlowDataset) && !(graphNode instanceof FlowManagedFolder)) continue;
                    AnyLoc computableLoc = DatasetLocUtils.DatasetLoc.resolveFull(((FlowComputable)graphNode).getFullId());
                    JobDef.ReverseJobStartingPoint r = new JobDef.ReverseJobStartingPoint();
                    r.graphNodeSupertype = JobDef.GraphNodeSupertype.COMPUTABLE;
                    r.projectKey = computableLoc.getProjectKey();
                    r.id = computableLoc.getId();
                    jobDef.reverseStartingPoints.add(r);
                }
            } else {
                throw new IllegalArgumentException("No location to start downstream-buildability check from");
            }
            if (jobDef.reverseStartingPoints.isEmpty()) {
                buildable = ReverseJobUnprunedTreeComputer.Buildable.yes();
                return buildable;
            }
            buildable = new ReverseJobUnprunedTreeComputer(graph).checkBuildability(jobDef);
            return buildable;
        }
    }

    @AuditedCall(value={"msgType", "flow-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/get-computables"})
    public void getComputables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items) throws Exception {
        Set parsedItems = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        ArrayList<DownstreamComputable> results = new ArrayList<DownstreamComputable>(parsedItems.size());
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef item : parsedItems) {
                String projectKey = item.getLoc().resolved().getProjectKey();
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                FlowComputable flowComputable = this.computableFromRefService.get(item);
                DownstreamComputable computable = new DownstreamComputable();
                computable.type = flowComputable.getType();
                String[] parts = flowComputable.getFullId().split("\\.", 2);
                computable.projectKey = parts[0];
                computable.id = parts[1];
                switch (flowComputable.getType()) {
                    case DATASET: {
                        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(((FlowDataset)flowComputable).getFullName());
                        computable.serializedDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc);
                        computable.name = computable.serializedDataset != null ? computable.serializedDataset.name : "";
                        break;
                    }
                    case SAVED_MODEL: {
                        computable.name = ((FlowSavedModel)flowComputable).getSavedModel().name;
                        computable.model = ((FlowSavedModel)flowComputable).getSavedModel();
                        break;
                    }
                    case MANAGED_FOLDER: {
                        computable.name = ((FlowManagedFolder)flowComputable).getManagedFolder().name;
                        computable.box = ((FlowManagedFolder)flowComputable).getManagedFolder();
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        computable.name = ((FlowModelEvaluationStore)flowComputable).getModelEvaluationStore().name;
                        computable.evaluationStore = ((FlowModelEvaluationStore)flowComputable).getModelEvaluationStore();
                        break;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        computable.name = ((FlowRetrievableKnowledge)flowComputable).getRetrievableKnowledge().name;
                        computable.retrievableKnowledge = ((FlowRetrievableKnowledge)flowComputable).getRetrievableKnowledge();
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        computable.name = ((FlowStreamingEndpoint)flowComputable).getStreamingEndpoint().id;
                        computable.streamingEndpoint = ((FlowStreamingEndpoint)flowComputable).getStreamingEndpoint();
                    }
                }
                results.add(computable);
            }
        }
        FlowGraphController.writeJSON((HttpServletResponse)resp, results);
    }

    @AuditedCall(value={"msgType", "flow-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/get-object-context"})
    @ResponseBody
    public NavigatorService.ObjectContext getObjectContext(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String objectType, @RequestParam String objectId) throws Exception {
        NavigatorService.ObjectContext objectContext;
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.valueOf(objectType), objectId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            objectContext = this.navigatorService.getObjectContext(obj);
        }
        if (objectContext != null) {
            ArrayList notebooks = Lists.newArrayList();
            for (Object o : objectContext.nodes.values()) {
                if (o instanceof NavigatorService.NotebookFullInfo && ((NavigatorService.NotebookFullInfo)o).notebook instanceof JupyterService.JupyterNotebookListEntry) {
                    notebooks.add((JupyterService.JupyterNotebookListEntry)((NavigatorService.NotebookFullInfo)o).notebook);
                }
                if (!(o instanceof NavigatorService.SavedModelFullInfo)) continue;
                NavigatorService.SavedModelFullInfo smInfo = (NavigatorService.SavedModelFullInfo)o;
                this.navigatorService.addSavedModelStatus_NT(smInfo);
            }
            this.jupyterService.addKernelSpecInfo(authCtx, notebooks);
        }
        return objectContext;
    }

    @AuditedCall(value={"msgType", "flow-export", "projectKey", "${projectKey}", "exportFormat", "${exportFormat}"})
    @RequestMapping(value={"/api/flow/export"}, method={RequestMethod.POST})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam FlowExportFormat exportFormat) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        FlowExport export = new FlowExport(projectKey, exportFormat);
        FutureResponse<ExportResult> futureResponse = this.flowExportService.export(user, export);
        FlowGraphController.writeJSON((HttpServletResponse)resp, futureResponse);
    }

    @AuditedCall(value={"msgType", "flow-download-export", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/flow/download-export"}, method={RequestMethod.GET})
    public void downloadExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportId) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            file = this.flowExportService.getExportFile(user, projectKey, exportId);
        }
        this.auditTrailService.generic("flow-export-download").with("ProjectKey", projectKey).with("ExportId", exportId).emit();
        String mimeType = DKUtils.probeContentTypeWithFallback((File)file);
        this.writeFileForDownload(resp, file, mimeType, file.getName());
        this.flowExportService.clean(projectKey, exportId);
    }

    @AuditedCall(value={"msgType", "flow-zone-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/create-zone"})
    @ResponseBody
    public Zone createZone(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam String color) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            Zone zone = new Zone(null, name, color, projectKey);
            this.flowZonesService.create(projectKey, zone, user);
            this.graphService.invalidateCache();
            t.commitV("Created a new zone:%s", new Object[]{name});
            Zone zone2 = zone;
            return zone2;
        }
    }

    private List<SmartObjectRef> doMoveToZone(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String zoneId, @RequestParam List<TaggableObjectsService.TaggableObjectRef> movingItems) throws Exception {
        AuthCtx user = this.authService.getMandatoryUser(req);
        this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        this.licenseEnforcementService.checkReadProjectContentAllowed(user);
        List<SmartObjectRef> smartObjectRefs = this.toSmartObjectRefs(projectKey, movingItems);
        for (SmartObjectRef movingItem : smartObjectRefs) {
            this.failIfNoReadAccess(projectKey, user, movingItem);
            this.flowZonesService.detachObjectFromZone(projectKey, movingItem);
            this.flowZonesService.attachObjectToZone(zoneId, projectKey, movingItem, false);
        }
        this.graphService.invalidateCache();
        return smartObjectRefs;
    }

    @AuditedCall(value={"msgType", "flow-zone-items-move-to", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/move-to-zone"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void moveToZone(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String zoneId, @RequestParam List<TaggableObjectsService.TaggableObjectRef> movingItems) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            List<SmartObjectRef> smartObjectRefs = this.doMoveToZone(req, projectKey, zoneId, movingItems);
            t.commitV("Moved %d items to zone: %s", new Object[]{smartObjectRefs.size(), zoneId});
        }
    }

    @AuditedCall(value={"msgType", "flow-zone-items-move-to-item-zone", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/move-to-item-zone"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void moveToItemZone(HttpServletRequest req, @RequestParam String projectKey, @RequestParam TaggableObjectsService.TaggableObjectRef item, @RequestParam List<TaggableObjectsService.TaggableObjectRef> movingItems) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            String zoneId = this.flowZonesService.retrieveZone(projectKey, item);
            List<SmartObjectRef> smartObjectRefs = this.doMoveToZone(req, projectKey, zoneId, movingItems);
            t.commitV("Moved %d items to zone: %s", new Object[]{smartObjectRefs.size(), zoneId});
        }
    }

    private void failIfNoReadAccess(String projectKey, AuthCtx user, SmartObjectRef movingItem) throws IOException, DKUSecurityException {
        TaggableObjectsService.TaggableObjectRef taggableObjectRef = movingItem.toTaggableObjectRef(projectKey);
        this.projectsService.failIfNoReadAccess(user, taggableObjectRef, projectKey);
    }

    @AuditedCall(value={"msgType", "flow-zone-items-share-to", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/share-to-zone"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void shareToZone(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String zoneId, @RequestParam List<TaggableObjectsService.TaggableObjectRef> sharingItems) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            List<SmartObjectRef> smartObjectRefs = this.toSmartObjectRefs(projectKey, sharingItems);
            for (SmartObjectRef sharingItem : smartObjectRefs) {
                this.failIfNoReadAccess(projectKey, user, sharingItem);
                this.flowZonesService.shareObjectToZone(zoneId, projectKey, sharingItem);
            }
            this.graphService.invalidateCache();
            t.commitV("Shared %s items to zone:%s", new Object[]{smartObjectRefs.size(), zoneId});
        }
    }

    @AuditedCall(value={"msgType", "flow-zone-items-unshare-from", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/unshare-to-zone"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void unshareToZone(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> zoneIds, @RequestParam List<TaggableObjectsService.TaggableObjectRef> sharingItems) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            List<SmartObjectRef> smartObjectRefs = this.toSmartObjectRefs(projectKey, sharingItems);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < smartObjectRefs.size(); ++i) {
                String zoneId = zoneIds.get(i);
                Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
                SmartObjectRef sharingItem = smartObjectRefs.get(i);
                zone.removeZoneShared(sharingItem);
                Integer number = (Integer)map.get(zoneId);
                if (number == null) {
                    number = 0;
                    map.put(zoneId, number);
                }
                number = number + 1;
                map.put(zoneId, number);
                this.zonesDAO.save(projectKey, zone);
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                builder.append(String.format("Unshared %d items from zone:%s%n", entry.getValue(), entry.getKey()));
            }
            this.graphService.invalidateCache();
            t.commit(builder.toString());
        }
    }

    @AuditedCall(value={"msgType", "flow-zone-edit", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/edit-zone"})
    @ResponseBody
    public Zone editZone(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String zoneId, @RequestParam String newName, @RequestParam String newColor) throws Exception {
        Zone zone;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            zone.setName(newName);
            zone.setColor(newColor);
            this.flowZonesService.edit(projectKey, zone, user);
            t.commitV("Edited zone:%s", new Object[]{zoneId});
        }
        this.graphService.invalidateCache();
        return zone;
    }

    @AuditedCall(value={"msgType", "flow-zones-manual-positioning", "projectKey", "${projectKey}", "zonesManualPositioning", "${zonesManualPositioning}"})
    @RequestMapping(value={"/api/flow/set-zones-manual-positioning"})
    @ResponseBody
    public void setZonesManualPositioning(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam boolean zonesManualPositioning) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.settings.flowDisplaySettings.zonesManualPositioning == zonesManualPositioning) {
                return;
            }
            sp.settings.flowDisplaySettings.zonesManualPositioning = zonesManualPositioning;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            t.commit("Set zones manual positioning: " + zonesManualPositioning + " for project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "flow-save-zone-position", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/api/flow/save-zone-position"})
    @ResponseBody
    public Zone saveZonePosition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String zoneId, @RequestParam double x, @RequestParam double y) throws Exception {
        Zone zone;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            ZonesManualPositioning zonesManualPositioning = this.getZonesManualPositioning(projectKey, user);
            if (!zonesManualPositioning.projectSettingsValue) {
                throw new IllegalArgumentException("Cannot save flow zone positions if manual zone positioning is disabled.");
            }
            if (!zonesManualPositioning.canMove) {
                throw new DKUSecurityException("Saving flow zones positions is not allowed.");
            }
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            zone.setCoordinates(x, y);
            this.zonesDAO.save(projectKey, zone);
            t.commitV("Saved zone position: %s | (%f, %f)", new Object[]{zoneId, x, y});
        }
        this.graphService.invalidateCache(projectKey);
        return zone;
    }

    @AuditedCall(value={"msgType", "flow-reset-zone-positions", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/reset-zone-positions"})
    @ResponseBody
    public void resetZonePositions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            ZonesManualPositioning zonesManualPositioning = this.getZonesManualPositioning(projectKey, user);
            if (!zonesManualPositioning.canMove) {
                throw new DKUSecurityException("Saving flow zones positions is not allowed.");
            }
            for (Zone zone : this.zonesDAO.list(projectKey)) {
                zone.clearPosition();
                this.zonesDAO.save(projectKey, zone);
            }
            t.commitV("Reset zone positions for project: %s", new Object[]{projectKey});
        }
        this.graphService.invalidateCache(projectKey);
    }

    @AuditedCall(value={"msgType", "flow-zones-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/zones"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Zone> listZones(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            List<Zone> list = this.zonesDAO.listUnsafe(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "flow-zone-delete", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/api/flow/zones/{zoneId}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(HttpServletRequest req, @RequestParam String projectKey, @PathVariable String zoneId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.flowZonesService.delete(projectKey, zoneId, user);
            t.commitV("Zone:%s has been deleted", new Object[]{zoneId});
        }
        this.graphService.invalidateCache();
    }

    @AuditedCall(value={"msgType", "flow-zone-retrieve-zone-item", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/retrieve-zone-item"})
    @ResponseBody
    public Zone retrieveZoneOfItem(HttpServletRequest req, @RequestParam String projectKey, @RequestParam TaggableObjectsService.TaggableObjectRef item) throws Exception {
        String zoneId;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(user);
            List<SmartObjectRef> smartObjectRefs = this.toSmartObjectRefs(projectKey, Collections.singletonList(item));
            if (smartObjectRefs.isEmpty()) {
                Zone zone = null;
                return zone;
            }
            zoneId = this.flowZonesService.retrieveZone(projectKey, smartObjectRefs.get(0));
        }
        if (StringUtils.isNotBlank((String)zoneId)) {
            Zone zone = new Zone();
            zone.setId(zoneId);
            return zone;
        }
        return null;
    }

    @AuditedCall(value={"msgType", "flow-document-generator-default", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/generate-default-document"})
    public void generateDefaultDocument(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        File f = this.flowDocumentGenerationService.getDefaultTemplate();
        FutureResponse<DocumentGenerationResponse> future = this.flowDocumentGenerationService.generateDocument(authCtx, projectKey, Files.newInputStream(f.toPath(), new OpenOption[0]));
        FlowGraphController.writeJSON((HttpServletResponse)resp, future);
    }

    @AuditedCall(value={"msgType", "flow-document-generator-custom", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/generate-custom-document"})
    public void generateCustomDocument(HttpServletRequest req, HttpServletResponse resp, @RequestParam MultipartFile file, @RequestParam String projectKey) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        FutureResponse<DocumentGenerationResponse> future = this.flowDocumentGenerationService.generateDocument(authCtx, projectKey, file.getInputStream());
        FlowGraphController.writeJSON((HttpServletResponse)resp, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "flow-documentation-export", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/flow/export-flow-document"}, method={RequestMethod.GET})
    public void downloadPreparedExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        File parentFolder = DKUApp.getFile((String[])new String[]{"tmp", "docgen/" + exportId});
        File outputFile = FlowDocumentUtils.getRenderedTemplateFile(parentFolder);
        try {
            if (outputFile != null) {
                MDGFileUtil.sendDocxDownload(outputFile, resp);
            } else {
                FlowGraphController.send404((String)"Generated file not found", (HttpServletResponse)resp);
            }
        }
        finally {
            if (outputFile != null) {
                DKUFileUtils.forceDelete((File)outputFile);
            }
            DKUFileUtils.forceDelete((File)parentFolder);
        }
    }

    private List<SmartObjectRef> toSmartObjectRefs(String projectKey, List<TaggableObjectsService.TaggableObjectRef> movingItems) {
        ArrayList<SmartObjectRef> refs = new ArrayList<SmartObjectRef>(movingItems.size());
        for (TaggableObjectsService.TaggableObjectRef movingItem : movingItems) {
            refs.add(SmartObjectRef.fromResolved(movingItem.type, movingItem.projectKey, movingItem.id, projectKey));
        }
        return refs;
    }

    private ZonesManualPositioning getZonesManualPositioning(String projectKey, AuthCtx authCtx) throws IOException, DKUSecurityException {
        ZonesManualPositioning zonesManualPositioning = new ZonesManualPositioning();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        zonesManualPositioning.projectSettingsValue = sp.settings.flowDisplaySettings.zonesManualPositioning;
        zonesManualPositioning.canMove = this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        return zonesManualPositioning;
    }

    public static class ZonesManualPositioning {
        public boolean projectSettingsValue = false;
        public boolean canMove = false;
    }

    public static class LoadFlowResponse {
        public SerializedFilteredGraphResponse serializedFilteredGraph = new SerializedFilteredGraphResponse();
        public ZonesManualPositioning zonesManualPositioning = new ZonesManualPositioning();

        public LoadFlowResponse() {
        }

        public LoadFlowResponse(SerializedFilteredGraphResponse serializedFilteredGraph, ZonesManualPositioning zonesManualPositioning) {
            this.serializedFilteredGraph = serializedFilteredGraph;
            this.zonesManualPositioning = zonesManualPositioning;
        }
    }

    public static class SerializedFilteredGraphResponse {
        public GraphSerializer.SerializedGraph serializedGraph = null;

        public SerializedFilteredGraphResponse(GraphSerializer.SerializedGraph serializedGraph) {
            this.serializedGraph = serializedGraph;
        }

        public SerializedFilteredGraphResponse() {
        }
    }

    class DownstreamComputable {
        public FlowComputable.FCType type;
        public String id;
        public String projectKey;
        public String name;
        public SerializedDataset serializedDataset;
        public ManagedFolder box;
        public SavedModel model;
        public StreamingEndpoint streamingEndpoint;
        public ModelEvaluationStore evaluationStore;
        public RetrievableKnowledge retrievableKnowledge;

        DownstreamComputable() {
        }
    }
}

