/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.aiexplanations.dataset.AIDatasetExplanationService;
import com.dataiku.dip.aiexplanations.flow.AIFlowExplanationService;
import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.AISQLQueryGenerationService;
import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializer;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.dataflow.graphtools.AutoSchemaPropagation;
import com.dataiku.dip.dataflow.graphtools.ConsistencyTool;
import com.dataiku.dip.dataflow.graphtools.PropagateSchemaTool;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.FlowToolsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class FlowToolsController
extends DIPInternalControllerBase {
    @Autowired
    private FlowToolsService flowToolsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AIFlowExplanationService aiFlowExplanationService;
    @Autowired
    private AIDatasetExplanationService aiDatasetExplanationService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private AIRecipeGenerationService aiRecipeGenerationService;
    @Autowired
    private AISQLQueryGenerationService aiSqlQueryGenerationService;
    @Autowired
    private LicenseStatusService licenseStatusService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/start"})
    public void getRecipesGraph(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String type, @RequestParam String data) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        JsonObject obj = StringUtils.isBlank((String)data) ? null : (JsonObject)JSON.parse((String)data, JsonObject.class);
        AbstractFlowTool.UserSessionsInProject ret = this.flowToolsService.startTool(u, projectKey, type, obj);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/stop"})
    public void stopTool(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String toolId) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AbstractFlowTool.UserSessionsInProject ret = this.flowToolsService.stopTool(u, projectKey, toolId);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/get-sessions"})
    public void getSessions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AbstractFlowTool.UserSessionsInProject ret = this.flowToolsService.getUserSessions(u, projectKey);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/get-state"})
    public void getState(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String options) throws Exception {
        AuthCtx u;
        JsonObject parsedOptions = (JsonObject)JSON.parse((String)options, JsonObject.class);
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AbstractFlowTool th = this.flowToolsService.getActiveHandler(u, projectKey);
        AbstractFlowTool.FlowState state = th.getFlowState(parsedOptions);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)state);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/get-state-no-session"})
    public void getStateNoSession(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String tool, @RequestParam(required=false) String data, @RequestParam(required=false) String options) throws Exception {
        AuthCtx u;
        JsonObject parsedData = !StringUtils.isBlank((String)data) ? (JsonObject)JSON.parse((String)data, JsonObject.class) : null;
        JsonObject parsedOptions = !StringUtils.isBlank((String)options) ? (JsonObject)JSON.parse((String)options, JsonObject.class) : null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ToolStateFutureThread tsft = new ToolStateFutureThread(u, projectKey, tool, parsedData, parsedOptions);
        FlowToolsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(tsft, 0L, new TypeToken<FutureResponse<AbstractFlowTool.FlowState>>(){}));
    }

    @AuditedCall(value={"msgType", "flow-consistency-check-update", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/tools/start-update"})
    public void startUpdate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String tool, @RequestParam String updateOptions) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
        }
        JsonObject options = (JsonObject)JSON.parse((String)updateOptions, JsonObject.class);
        AbstractFlowTool.FlowTool th = this.checkAndGetToolHandlerAs(req, projectKey, AbstractFlowTool.FlowTool.class, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        FlowToolsController.writeJSON((HttpServletResponse)resp, th.getUpdateFuture(u, options));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/set-active"})
    public void setActiveTool(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String toolId) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AbstractFlowTool.UserSessionsInProject ret = this.flowToolsService.switchTo(u, projectKey, toolId);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/set-default-active"})
    public void setDefaultActive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AbstractFlowTool.UserSessionsInProject ret = this.flowToolsService.setDefaultActive(u, projectKey);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/set-focused"})
    public void tagsSetFocused(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String focused, @RequestParam(required=false) String mode) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AbstractFlowTool.FlowView view = (AbstractFlowTool.FlowView)this.flowToolsService.getActiveHandler(authCtx, projectKey);
        Set focusedItems = (Set)JSON.parse((String)focused, (TypeToken)new TypeToken<HashSet<String>>(){});
        view.setFocus(focusedItems, mode);
        FlowToolsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "start-project-explanation", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/ai-tools/start-project-explanation"})
    @ResponseBody
    public FutureResponse<ExplainStuffFrontendResponse> startProjectExplanation(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String explanationOptions) throws Exception {
        DSSAuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.aiFlowExplanationService.startExplainingProject(user, projectKey, explanationOptions);
    }

    @AuditedCall(value={"msgType", "log-rating", "isSuccess", "${isSuccess}", "feedback", "${feedback}", "featureRated", "${featureRated}", "requestId", "${requestId}"})
    @RequestMapping(value={"/api/flow/ai-tools/log-rating"}, method={RequestMethod.POST})
    public void sendRating(HttpServletRequest req, HttpServletResponse resp, @RequestParam Boolean isSuccess, @RequestParam String feedback, @RequestParam String featureRated, @RequestParam String requestId) throws IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        if (Set.of("text2recipe", "text2sql", "generateSteps").contains(featureRated)) {
            LicenseStatusService.LicensingStatus licensingStatus = this.licenseStatusService.getLicensingStatus();
            boolean bl = AIFeaturesUtil.sendRating(isSuccess, feedback, requestId, featureRated, licensingStatus);
        }
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)new JsonObject());
    }

    @AuditedCall(value={"msgType", "start-recipe-generation", "projectKey", "${projectKey}", "datasetNames", "${datasetNames}"})
    @RequestMapping(value={"/api/flow/ai-tools/start-recipe-generation"})
    @ResponseBody
    public FutureResponse<AIRecipeGenerationService.AIRecipeGenerationFrontendResponse> startRecipeGeneration(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<GraphSerializer.SerializedNode> datasetNodes, @RequestParam String query) throws Exception {
        AuthCtx user;
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            for (GraphSerializer.SerializedNode datasetNode : datasetNodes) {
                DatasetLocUtils.DatasetLoc datasetLoc = new DatasetLocUtils.DatasetLoc(datasetNode.projectKey, datasetNode.name);
                this.projectsService.failIfNoDatasetReadUseAccess(user, datasetLoc, projectKey);
                Dataset d = this.datasetAccessService.getMandatory(datasetNode.projectKey, datasetNode.name);
                if (d == null) {
                    throw new IllegalArgumentException("Failed to retrieve the dataset: " + datasetNode.name);
                }
                datasets.add(d);
            }
        }
        return this.aiRecipeGenerationService.startGeneration(user, projectKey, datasets, query);
    }

    @AuditedCall(value={"msgType", "create-recipe", "recipeCreationSettings", "${recipeCreationSettings}"})
    @RequestMapping(value={"/api/flow/ai-tools/create-recipe"})
    @ResponseBody
    public AIRecipeGenerationService.RecipeCreationResponse createRecipe(HttpServletRequest req, @RequestParam AIRecipeGenerationService.RecipeCreationSettings recipeCreationSettings) throws Exception {
        DSSAuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, recipeCreationSettings.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        return this.aiRecipeGenerationService.createRecipe(user, recipeCreationSettings);
    }

    @AuditedCall(value={"msgType", "start-flow-zone-explanation", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/api/flow/ai-tools/start-flow-zone-explanation"})
    @ResponseBody
    public FutureResponse<ExplainStuffFrontendResponse> startFlowExplanation(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String zoneId, @RequestParam String explanationOptions) throws Exception {
        DSSAuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.aiFlowExplanationService.startExplainingFlowZone(user, projectKey, zoneId, explanationOptions);
    }

    @AuditedCall(value={"msgType", "start-dataset-explanation", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/flow/ai-tools/start-dataset-explanation"})
    @ResponseBody
    public FutureResponse<AIDatasetExplanationService.ExplainDatasetFrontendResponse> startDatasetExplanation(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String explanationOptions) throws Exception {
        Dataset dataset;
        DSSAuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.hasAnyReadPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        return this.aiDatasetExplanationService.startExplainingDataset(user, dataset, explanationOptions);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/propagate-schema/mark-recipe-as-ok-forced"})
    public void propagateSchemaMarkREcipeAsOK(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        AbstractFlowTool th = this.flowToolsService.getActiveHandler(u, projectKey);
        PropagateSchemaTool tth = (PropagateSchemaTool)th;
        tth.forceMarkRecipeOK(recipeName, false);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)tth.getFlowState(null));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/propagate-schema/mark-recipe-as-ok-after-update"})
    public void propagateSchemaMarkRecipeAsOKAfterUpdate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        AbstractFlowTool th = this.flowToolsService.getActiveHandler(u, projectKey);
        PropagateSchemaTool tth = (PropagateSchemaTool)th;
        tth.markRecipeAsOKAfterUpdate(recipeName);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)tth.getFlowState(null));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/propagate-schema/mark-dataset-as-being-rebuilt"})
    public void propagateSchemaMarkDatasetAsRebuilt(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        AbstractFlowTool th = this.flowToolsService.getActiveHandler(u, projectKey);
        PropagateSchemaTool tth = (PropagateSchemaTool)th;
        tth.markDatasetAsBeingRebuilt(datasetName);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)tth.getFlowState(null));
    }

    @AuditedCall(value={"msgType", "flow-consistency-check-node", "projectKey", "${projectKey}", "nodeId", "${nodeId}"})
    @RequestMapping(value={"/api/flow/tools/propagate-schema/run-automatically"})
    public void propagateAutomatically(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam boolean rebuild, @RequestParam(value="recipeUpdateOptions") String recipeUpdateOptionsStr, @RequestParam(value="partitionByDim") String partitionByDimStr, @RequestParam(value="partitionByComputable") String partitionByComputableStr, @RequestParam(value="excludedRecipes") String excludedRecipesStr, @RequestParam(value="markAsOkRecipes") String markAsOkRecipesStr) throws Exception {
        JsonObject recipeUpdateOptions = (JsonObject)JSON.parse((String)recipeUpdateOptionsStr, JsonObject.class);
        List partitionByDim = (List)JSON.parse((String)partitionByDimStr, (TypeToken)new TypeToken<List<AppHomepageTile.PartitionDef>>(){});
        List partitionByComputable = (List)JSON.parse((String)partitionByComputableStr, (TypeToken)new TypeToken<List<AppHomepageTile.PartitionDef>>(){});
        Set excludedRecipes = (Set)JSON.parse((String)excludedRecipesStr, (TypeToken)new TypeToken<Set<String>>(){});
        Set markAsOkRecipes = (Set)JSON.parse((String)markAsOkRecipesStr, (TypeToken)new TypeToken<Set<String>>(){});
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        AutoSchemaPropagation propagation = new AutoSchemaPropagation(u, projectKey, (List<AnyLoc>)Lists.newArrayList((Object[])new AnyLoc[]{new AnyLoc(projectKey, datasetName)}), recipeUpdateOptions, (Set<String>)excludedRecipes, partitionByDim, partitionByComputable, (Set<String>)markAsOkRecipes);
        FlowToolsController.writeJSON((HttpServletResponse)resp, propagation.propagateAsync(rebuild));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/tools/check-consistency/mark-as-ok"})
    public void checkConsistencyMarkAsOK(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String nodeIds) throws Exception {
        ConsistencyTool tth = this.checkAndGetToolHandlerAs(req, projectKey, ConsistencyTool.class, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        Set ids = (Set)JSON.parse((String)nodeIds, (TypeToken)new TypeToken<HashSet<String>>(){});
        tth.forceMarkOK(ids);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)tth.getFlowState(null));
    }

    @AuditedCall(value={"msgType", "flow-consistency-check-node", "projectKey", "${projectKey}", "nodeId", "${nodeId}"})
    @RequestMapping(value={"/api/flow/tools/check-consistency/recheck"})
    public void checkConsistencyRecheckNode(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String nodeIds) throws Exception {
        ConsistencyTool tth = this.checkAndGetToolHandlerAs(req, projectKey, ConsistencyTool.class, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        Set ids = (Set)JSON.parse((String)nodeIds, (TypeToken)new TypeToken<HashSet<String>>(){});
        tth.recheck(ids);
        FlowToolsController.writeJSON((HttpServletResponse)resp, (Object)tth.getFlowState(null));
    }

    private <T extends AbstractFlowTool> T checkAndGetToolHandlerAs(HttpServletRequest req, String projectKey, Class<T> clazz, Privileges.ProjectLevelPrivilegeType perm) throws Exception {
        AuthCtx u = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, perm);
        }
        return (T)((AbstractFlowTool)clazz.cast(this.flowToolsService.getActiveHandler(u, projectKey)));
    }

    private class ToolStateFutureThread
    extends SimpleFutureThread<AbstractFlowTool.FlowState> {
        private String projectKey;
        private String tool;
        @Nullable
        private JsonObject parsedData;
        private JsonObject parsedOptions;

        public ToolStateFutureThread(AuthCtx user, String projectKey, String tool, JsonObject parsedData, JsonObject parsedOptions) {
            super(user);
            this.projectKey = projectKey;
            this.tool = tool;
            this.parsedData = parsedData;
            this.parsedOptions = parsedOptions;
        }

        @Override
        protected AbstractFlowTool.FlowState compute() throws Exception {
            try {
                AbstractFlowTool th = FlowToolsController.this.flowToolsService.getTool(this.owner, this.projectKey, this.tool, this.parsedData);
                AbstractFlowTool.FlowState state = th.getFlowState(this.parsedOptions);
                if (this.isInterrupted()) {
                    DIPInternalControllerBase.logger.warn((Object)"Flow State computation has been interrupted");
                    return null;
                }
                return state;
            }
            catch (Exception e) {
                DIPInternalControllerBase.logger.warn((Object)("Unexpected exception occurred while computing state of tool " + this.tool));
                throw e;
            }
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "flow_tool_compute_state";
            fp.displayName = "Compute flow tool state";
            return fp;
        }
    }
}

