/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.code.CodeConversionService;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.JupyterExportStream;
import com.dataiku.dip.notebooks.NotebookTemplateDesc;
import com.dataiku.dip.notebooks.NotebooksTemplatesService;
import com.dataiku.dip.notebooks.exports.JupyterExport;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.JupyterExportService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class JupyterController
extends DIPInternalControllerBase {
    @Autowired
    private IJupyterService service;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private NotebooksTemplatesService templatesService;
    @Autowired
    private JupyterExportService jupyterExportService;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private AchievementsService achievementsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private CodeConversionService codeConvService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    static Logger logger = Logger.getLogger((String)"dku.jupyter");

    @AuditNotNeeded
    @RequestMapping(value={"/api/notebooks/list-templates"})
    public void listTemplates(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String language) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        JupyterController.writeJSON((HttpServletResponse)resp, this.templatesService.listOfType(NotebookTemplateDesc.NotebookTemplateType.valueOf(type), language));
    }

    @AuditedCall(value={"msgType", "notebooks-list"})
    @RequestMapping(value={"/api/jupyter/map-notebook-exports"})
    public void mapNotebooksToExports(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<AccessibleObjectsService.AccessibleObject> list;
        AuthCtx user;
        HashMap<String, AccessibleObjectsService.AccessibleObject> notebookMap = new HashMap<String, AccessibleObjectsService.AccessibleObject>();
        HashMap<String, List<JupyterExport>> notebookToExportsMap = new HashMap<String, List<JupyterExport>>();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            list = this.accessibleObjectsService.listAccessibleObjectsUnsafe(user, projectKey, ITaggingService.TaggableType.JUPYTER_NOTEBOOK, SerializedProject.ReaderAuthorization.Mode.READ);
        }
        for (AccessibleObjectsService.AccessibleObject object : list) {
            notebookMap.put(object.smartId, object);
            notebookToExportsMap.put(object.smartId, this.jupyterExportService.list_NT(object.projectKey, object.id, true));
        }
        this.accessibleObjectsService.addKernelSpecInfo_NT(user, list);
        Pair pair = new Pair(notebookMap, notebookToExportsMap);
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)pair);
    }

    @AuditedCall(value={"msgType", "get-notebook", "projectKey", "${projectKey}", "notebookName", "${name}"})
    @RequestMapping(value={"/api/jupyter/get-notebook"})
    public void getNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam(required=false) String kernelName) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        JupyterService.JupyterNotebookListEntry notebook = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            boolean withGitInformation = this.projectsService.hasPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            notebook = this.service.getMandatoryUnsafe(projectKey, name, withGitInformation);
        }
        if (kernelName != null) {
            JupyterService.KernelSpec kernelSpec = this.service.getKernelSpecs(kernelName);
            notebook.displayKernelSpec = JupyterService.KernelSpec.toKernelSpec(kernelName, kernelSpec);
        } else {
            this.service.addKernelSpecInfo(authCtx, Lists.newArrayList((Object[])new JupyterService.JupyterNotebookListEntry[]{notebook}));
        }
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)notebook);
    }

    @AuditedCall(value={"msgType", "notebooks-list"})
    @RequestMapping(value={"/api/jupyter/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        List<JupyterService.JupyterNotebookListEntry> notebookEntries;
        TagFilterUtils.TagFilter tf;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
            boolean withGitInformation = this.projectsService.hasPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            notebookEntries = withGitInformation ? this.service.listUnsafeWithGitInformation(authCtx, projectKey) : this.service.listUnsafe(authCtx, projectKey);
        }
        this.service.addActiveSessions(authCtx, notebookEntries);
        this.service.addKernelSpecInfo(authCtx, notebookEntries);
        Filtered out = new Filtered();
        for (JupyterService.JupyterNotebookListEntry e : notebookEntries) {
            if (TagFilterUtils.matches(tf, e.tags)) {
                JupyterNotebookListItem nb = new JupyterNotebookListItem(e);
                this.taggableObjectsService.setEditionInfoFromTags(e, nb);
                out.items.add(nb);
                continue;
            }
            ++out.filteredOut;
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, out.items);
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)out);
    }

    @AuditedCall(value={"msgType", "notebooks-metadata"})
    @RequestMapping(value={"/api/jupyter/get-metadata"})
    public void getMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        TaggableObjectsService.TaggableObjectMetadata metaData;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            metaData = this.service.getMetadata(projectKey, name);
        }
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)metaData);
    }

    @AuditedCall(value={"msgType", "jupyter-notebook-export-prepare"})
    @RequestMapping(value={"/api/tintercom/jupyter/bind-export"}, method={RequestMethod.PUT})
    public void bindCSV(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String exportId = req.getQueryString();
        BufferedInputStream is = new BufferedInputStream((InputStream)req.getInputStream());
        JupyterExportStream source = new JupyterExportStream(is);
        this.exportService.bindInput(exportId, source);
        this.exportService.waitForExport(exportId);
    }

    @AuditedCall(value={"msgType", "notebook-clear-outputs", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/api/jupyter/clear-notebook-outputs"}, method={RequestMethod.POST})
    public void clearNotebookOutputs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookName) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            if (this.service.deleteOutputs(projectKey, notebookName, authCtx)) {
                rwt.commitV("Cleared outputs for Jupyter notebook '%s'", new Object[]{notebookName});
            }
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/jupyter/new-notebook-for-dataset"})
    public void createDatasetNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String baseName, @RequestParam String datasetSmartName, @RequestParam String templateDesc, @RequestParam String codeEnv, @RequestParam(required=false) String containerConf) throws Exception {
        JupyterService.JupyterNotebookListEntry nbk;
        AuthCtx liu;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, datasetSmartName);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(liu, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            liu.failIfNoSafeCode("create a Jupyter notebook");
            NotebookTemplateDesc td = (NotebookTemplateDesc)JSON.parse((String)templateDesc, NotebookTemplateDesc.class);
            if (td == null) {
                throw ErrorContext.iae((String)"Template not specified");
            }
            this.service.checkLicenceForLanguage(liu, td.language);
            this.projectsService.failIfNoDatasetReadUseAccess(liu, loc, projectKey);
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (JupyterService.JupyterNotebookListEntry e : this.service.listSimple(DSSAuthCtx.newNone(), projectKey)) {
                st2.addAlreadyTransmogrified(e.name);
            }
            String nbName = st2.transmogrify(baseName);
            nbk = this.service.createNotebookForDataset(liu, projectKey, nbName, templateDesc, loc, codeEnv, containerConf);
            t.commit("Created Jupyter notebook '" + nbName + "'for dataset '" + loc.getFullName() + "' from template " + td.id + " (lang=" + td.language + ")");
            this.auditTrailService.generic("notebook-create").with("projectKey", projectKey).with("notebookName", nbName).with("forDataset", loc.getFullName()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("notebook-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
        this.service.addKernelSpecInfo(liu, Lists.newArrayList((Object[])new JupyterService.JupyterNotebookListEntry[]{nbk}));
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)nbk);
    }

    @AuditInline
    @RequestMapping(value={"/api/jupyter/new-notebook-for-kb"})
    public void createDatasetNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String baseName, @RequestParam String knowledgeBankRef, @RequestParam String templateDesc) throws Exception {
        JupyterService.JupyterNotebookListEntry nbk;
        AuthCtx authCtx;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(authCtx, loc, projectKey);
            authCtx.failIfNoSafeCode("create a Jupyter notebook");
            NotebookTemplateDesc td = (NotebookTemplateDesc)JSON.parse((String)templateDesc, NotebookTemplateDesc.class);
            if (td == null) {
                throw ErrorContext.iae((String)"Template not specified");
            }
            this.service.checkLicenceForLanguage(authCtx, td.language);
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (JupyterService.JupyterNotebookListEntry e : this.service.listSimple(DSSAuthCtx.newNone(), projectKey)) {
                st2.addAlreadyTransmogrified(e.name);
            }
            String nbName = st2.transmogrify(baseName);
            nbk = this.service.createNotebookForRetrievableKnowledge(authCtx, projectKey, nbName, td, loc);
            t.commit("Created Jupyter notebook '" + nbName + "'for KB '" + loc.getFullName() + "' from template " + td.id + " (lang=" + td.language + ")");
            this.auditTrailService.generic("notebook-create").with("projectKey", projectKey).with("notebookName", nbName).with("forRetrievableKnowledge", loc.getFullName()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("notebook-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
        this.service.addKernelSpecInfo(authCtx, Lists.newArrayList((Object[])new JupyterService.JupyterNotebookListEntry[]{nbk}));
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)nbk);
    }

    @AuditInline
    @RequestMapping(value={"/api/jupyter/new-notebook-with-template"})
    public void newNotebookWithTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String baseName, @RequestParam String templateDesc, @RequestParam String codeEnv, @RequestParam(required=false) String containerConf) throws Exception {
        JupyterService.JupyterNotebookListEntry nbk;
        AuthCtx liu;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(liu, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            liu.failIfNoSafeCode("create a Jupyter notebook");
            NotebookTemplateDesc td = (NotebookTemplateDesc)JSON.parse((String)templateDesc, NotebookTemplateDesc.class);
            this.service.checkLicenceForLanguage(liu, td.language);
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (JupyterService.JupyterNotebookListEntry e : this.service.list(DSSAuthCtx.newNone(), projectKey)) {
                st2.addAlreadyTransmogrified(e.name);
            }
            String nbName = st2.transmogrify(baseName);
            nbk = this.service.createStandaloneNotebook(liu, projectKey, nbName, td, codeEnv, containerConf);
            t.commit("Created Jupyter notebook '" + nbName + "' from template " + td.id + " (lang=" + td.language + ")");
            this.auditTrailService.generic("notebook-create").with("projectKey", projectKey).with("notebookName", nbName).with("fromTemplate", td.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("notebook-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
        this.service.addKernelSpecInfo(liu, Lists.newArrayList((Object[])new JupyterService.JupyterNotebookListEntry[]{nbk}));
        JupyterController.writeJSON((HttpServletResponse)resp, (Object)nbk);
    }

    @AuditInline
    @RequestMapping(value={"/api/jupyter/new-notebook-from-file"})
    public void newNotebookWithTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String baseName, @RequestParam String language, @RequestParam(required=false) String datasetSmartName, @RequestParam(value="file") MultipartFile notebook) throws Exception {
        JupyterService.NotebookSafeForWritingNew notebookObj;
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)baseName);
        Validate.notNull((Object)language);
        Validate.notNull((Object)notebook);
        try (InputStreamReader reader = new InputStreamReader(notebook.getInputStream(), "UTF-8");){
            notebookObj = (JupyterService.NotebookSafeForWritingNew)JSON.gson().fromJson((Reader)reader, JupyterService.NotebookSafeForWritingNew.class);
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(liu, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            liu.failIfNoSafeCode("upload a Jupyter notebook");
            String fileName = notebook.getOriginalFilename();
            logger.info((Object)("Uploading new notebook from file " + fileName));
            AnyLoc loc = null;
            if (StringUtils.isNotBlank((String)datasetSmartName)) {
                loc = AnyLoc.resolveSmart(projectKey, datasetSmartName);
            }
            this.licenseEnforcementService.checkRegularCodeAllowed(liu);
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (JupyterService.JupyterNotebookListEntry e : this.service.list(DSSAuthCtx.newNone(), projectKey)) {
                st2.addAlreadyTransmogrified(e.name);
            }
            String nbName = st2.transmogrify(baseName);
            JupyterService.JupyterNotebookListEntry importedNotebook = this.service.installNotebookFromFile(liu, projectKey, nbName, loc, notebookObj);
            t.commit("Uploaded Jupyter notebook '" + nbName + "' from file " + fileName + " (lang=python)");
            this.auditTrailService.generic("notebook-upload").with("projectKey", projectKey).with("notebookName", nbName).with("fromFile", fileName).emit();
            JupyterController.writeJSON((HttpServletResponse)resp, (Object)importedNotebook);
        }
        catch (Exception e) {
            this.auditTrailService.failure("notebook-upload", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/jupyter/create-recipe-from-notebook"})
    @ResponseBody
    public JsonObject createNewRecipe(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebook, @RequestParam(value="recipe") SerializedRecipe recipe) throws Exception {
        try {
            JsonObject data;
            String script;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                recipe.projectKey = projectKey;
                JupyterService.JupyterNotebookListEntry jupyterNotebookListEntry = this.service.getOrNullUnsafe(projectKey, notebook);
                recipe.name = "recipe_from_notebook_" + jupyterNotebookListEntry.name.replaceAll("[\\W&&\\S]", "").trim().replace(" ", "_");
                if (!recipe.name.matches("^[\\w-]+$")) {
                    throw new IllegalArgumentException("New recipe's name '" + recipe.name + "' contains an illegal character");
                }
                RelFile notebookFile = this.service.getNotebookFile(projectKey, notebook);
                JsonObject notebookContent = (JsonObject)t.readObject(notebookFile, JsonObject.class);
                script = this.codeConvService.notebookToNewRecipe(recipe.type, notebookContent, recipe);
                data = new JsonObject();
                data.addProperty("script", script);
            }
            RecipeCreator recipeCreator = RecipeRegistry.getMeta(recipe.type).buildCreator(authCtx);
            assert (recipeCreator != null);
            RecipeCreator.CreationResult recipeCreationResult = recipeCreator.create_NT(recipe, data);
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx, true);){
                this.service.associateNotebookWithRecipe(authCtx, projectKey, notebook, recipe.name);
                t.commitV("Linked notebook '%s' to recipe '%s'", new Object[]{notebook, recipe.name});
            }
            this.achievementsService.win(authCtx, AchievementsService.AchievementId.WE_ARE_ALCHEMISTS);
            this.auditTrailService.generic("create-recipe-from-notebook").with("projectKey", recipe.projectKey).with("notebookName", notebook).with("recipeName", recipeCreationResult.id).with("recipeType", recipe.type).emit();
            JsonObject ret = new JsonObject();
            ret.addProperty("id", recipeCreationResult.id);
            ret.addProperty("script", script);
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("create-recipe-from-notebook", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/jupyter/save-back-to-recipe"})
    public void saveBackToRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebook) throws Exception {
        try {
            AuthCtx authCtx = null;
            try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                JupyterService.JupyterNotebookListEntry jnle = this.service.getOrNullUnsafe(projectKey, notebook);
                if (jnle == null) {
                    throw new NotFoundException("Notebook '" + notebook + "' not found");
                }
                if (jnle.associatedRecipe == null) {
                    throw ErrorContext.iae((String)("Notebook '" + notebook + "' has no associated recipe"));
                }
                RelFile nbFile = this.service.getNotebookFile(projectKey, notebook);
                JsonObject nbContent = (JsonObject)t.readObject(nbFile, JsonObject.class);
                AnyLoc loc = AnyLoc.resolveSmart(projectKey, jnle.associatedRecipe);
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
                String newPayload = this.codeConvService.notebookToRecipe(recipe.getType(), nbContent);
                SerializedRecipe savedRecipe = this.recipeSaveService.save(projectKey, recipe, newPayload);
                t.commit("Recipe " + loc.getFullName() + " saved through notebook " + notebook);
                this.auditTrailService.generic("save-back-to-recipe").with("projectKey", projectKey).with("notebookName", notebook).with("recipeName", savedRecipe.name).with("recipeType", savedRecipe.type).emit();
                JupyterController.writeJSON((HttpServletResponse)resp, (Object)new Id(savedRecipe.getId()));
            }
        }
        catch (Exception e) {
            this.auditTrailService.failure("save-back-to-recipe", (Throwable)e).emit();
            throw e;
        }
    }

    static class Filtered {
        List<JupyterNotebookListItem> items = new ArrayList<JupyterNotebookListItem>();
        int filteredOut;

        Filtered() {
        }
    }

    public static class JupyterNotebookListItem
    extends TaggableObjectsService.TaggableListItem {
        public final boolean automationLocal;
        public final String language;
        public final JupyterService.DisplayKernelSpec displayKernelSpec;
        public List<JupyterService.ActiveSession> activeSessions = new ArrayList<JupyterService.ActiveSession>();
        public String analyzedDataset;
        public String connectionDisplayName;
        public GitModel.GitReference gitReference;

        public JupyterNotebookListItem(JupyterService.JupyterNotebookListEntry nbk) {
            super(nbk);
            this.automationLocal = nbk.automationLocal;
            this.language = nbk.language;
            this.displayKernelSpec = nbk.displayKernelSpec;
            this.activeSessions = nbk.activeSessions;
            this.analyzedDataset = nbk.analyzedDataset;
            this.gitReference = nbk.gitReference;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.JUPYTER_NOTEBOOK;
        }
    }
}

