/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectExporter;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.projects.importexport.model.ProjectDuplicateOptions;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.ProjectDuplicator;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import javax.mail.internet.ContentDisposition;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ProjectImportExportController
extends DIPInternalControllerBase {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.projects.export.controller");
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsDeletionService taggableObjectsDeletionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesInternalDB timelinesDAO;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private TrustedCodeService trustedCodeService;
    @Autowired
    private IPermissionsService permissionsService;

    @AuditInline
    @RequestMapping(value={"/api/projects/import/upload"}, method={RequestMethod.POST})
    public void prepareImportProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        try {
            try (Transaction t = this.transactionService.beginRead();){
                DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                if (!liu.getPermissions().mayCreateProjects()) {
                    throw new SecurityException("You may not create new projects");
                }
            }
            String importId = SecretKeyGenerator.generate((int)16);
            logger.info((Object)("Uploading archive " + filePart.getOriginalFilename()));
            ProjectImportExportController.unzipImportUploadStream(importId, filePart.getInputStream());
            ProjectImportExportController.writeJSON((HttpServletResponse)resp, (Object)new Id(importId));
            this.auditTrailService.generic("project-import-prepare").with("importId", importId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("project-import-prepare", (Throwable)e).emit();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendExportDataAndDelete(HttpServletResponse resp, String projectKey, String exportId) throws IOException {
        File f = ProjectImportExportController.exportFile(projectKey, exportId);
        try {
            resp.setStatus(200);
            resp.setContentType("application/zip");
            ContentDisposition contentDisposition = new ContentDisposition();
            contentDisposition.setDisposition("attachment");
            contentDisposition.setParameter("filename", projectKey + ".zip");
            resp.setHeader("Content-Disposition", contentDisposition.toString());
            resp.setHeader("Content-Length", "" + f.length());
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
                IOUtils.copy((InputStream)bis, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            DKUFileUtils.forceDelete((File)f);
        }
    }

    public static void unzipImportUploadStream(String importId, InputStream inputStream) throws IOException {
        File tmpDir = ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-import", importId});
        DKUFileUtils.unzipInputStream((File)tmpDir, (InputStream)inputStream);
    }

    private ProjectExportOptions prepareExportOptions(ProjectDuplicateOptions options) {
        ProjectExportOptions exportOptions = new ProjectExportOptions();
        exportOptions.exportAnalysisModels = options.exportAnalysisModels;
        exportOptions.exportSavedModels = options.exportSavedModels;
        exportOptions.exportModelEvaluationStores = options.exportModelEvaluationStores;
        exportOptions.exportProjectResources = options.exportProjectResources;
        exportOptions.exportLabelingTasks = options.exportLabelingTasks;
        exportOptions.exportGitRepository = options.exportGitRepository != null && options.exportGitRepository != false;
        exportOptions.exportInsightsData = options.exportInsightsData;
        exportOptions.exportAllInputDatasets = options.exportAllInputDatasets;
        exportOptions.exportAllDatasets = options.exportAllDatasets;
        exportOptions.exportAllInputManagedFolders = options.exportAllInputManagedFolders;
        exportOptions.exportManagedFolders = options.exportManagedFolders;
        exportOptions.exportUploads = options.exportUploads;
        exportOptions.exportManagedFS = options.exportManagedFS;
        exportOptions.exportNotebooksWithOutputs = options.exportNotebooksWithOutputs;
        exportOptions.exportPromptStudioHistories = options.exportPromptStudioHistories;
        exportOptions.useManualPluginsInfo = false;
        exportOptions.shareAllInputDatasets = options.shareAllInputDatasets;
        exportOptions.exportForeignObjectsReferences = false;
        exportOptions.exportForNewBranch = options.createBranch;
        return exportOptions;
    }

    public void duplicationOptionsChecks(ProjectDuplicateOptions options) {
        if (StringUtils.isBlank((String)options.targetProjectKey)) {
            throw new IllegalArgumentException("Missing targetProjectKey");
        }
        if (StringUtils.isBlank((String)options.targetProjectName)) {
            throw new IllegalArgumentException("Missing targetProjectName");
        }
        switch (options.duplicationMode) {
            case NONE: {
                options.exportUploads = false;
                options.exportAllInputDatasets = false;
                options.exportAllInputManagedFolders = false;
                options.exportAllDatasets = false;
                options.exportManagedFolders = false;
                options.exportManagedFS = false;
                options.shareAllInputDatasets = false;
                break;
            }
            case UPLOADS_ONLY: {
                options.exportUploads = true;
                options.exportAllInputDatasets = false;
                options.exportAllInputManagedFolders = false;
                options.exportAllDatasets = false;
                options.exportManagedFolders = false;
                options.exportManagedFS = false;
                options.shareAllInputDatasets = false;
                break;
            }
            case FULL: {
                options.exportUploads = true;
                options.exportAllInputDatasets = true;
                options.exportAllInputManagedFolders = true;
                options.exportAllDatasets = true;
                options.exportManagedFolders = true;
                options.exportManagedFS = true;
                options.shareAllInputDatasets = false;
                break;
            }
            case SHARING: {
                options.exportUploads = false;
                options.exportAllInputDatasets = false;
                options.exportAllInputManagedFolders = false;
                options.exportAllDatasets = false;
                options.exportManagedFolders = false;
                options.exportManagedFS = false;
                options.shareAllInputDatasets = true;
                break;
            }
            default: {
                options.exportUploads = true;
                options.exportAllInputDatasets = true;
                options.exportAllInputManagedFolders = true;
                options.exportAllDatasets = false;
                options.exportManagedFolders = false;
                options.exportManagedFS = false;
                options.shareAllInputDatasets = false;
            }
        }
    }

    private static String getDayOfMonthSuffix(int n) {
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public void checkExportGitOption(AuthCtx authCtx, String projectKey) throws Exception {
        if (!this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN) && this.projectsGitService.hasRemoteWithAuth(projectKey)) {
            throw new SecurityException("You are not allowed to export this project with the git repository content");
        }
    }

    public void checkAndSetExportGitOption(AuthCtx authCtx, String projectKey, ProjectDuplicateOptions duplicateOptions) throws Exception {
        if (duplicateOptions.exportGitRepository == null) {
            duplicateOptions.exportGitRepository = !this.projectsGitService.hasRemoteWithAuth(projectKey) || this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        } else if (Boolean.TRUE.equals(duplicateOptions.exportGitRepository)) {
            this.checkExportGitOption(authCtx, projectKey);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectDuplicateResult processDuplicate(String projectKey, AuthCtx user, String duplicationId, ProjectDuplicateOptions options) throws Exception {
        ProjectDuplicateResult projectDuplicateResult = new ProjectDuplicateResult();
        try (FutureProgress.AutocloseableFutureProgressState fut = FutureProgress.pushAutoCloseableState((String)"Building export", (double)19.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            List<WebApp> copiedWebapps;
            File f = ProjectImportExportController.duplicateFile(duplicationId);
            DKUFileUtils.mkdirsParent((File)f);
            ProjectExportOptions exportOptions = this.prepareExportOptions(options);
            ProjectExportResult per = new ProjectExporter(user, exportOptions, projectKey, f).export(false);
            per.projectKey = projectKey;
            per.exportId = duplicationId;
            per.summarize();
            this.auditTrailService.generic("project-export").with("exportId", duplicationId).with("projectKey", projectKey).emit();
            logger.infoV("Duplication done: %s", new Object[]{JSON.pretty((Object)((Object)per))});
            ProjectImporter.ProjectImportSettings projectImportSettings = new ProjectImporter.ProjectImportSettings();
            projectImportSettings.targetProjectKey = options.targetProjectKey;
            projectImportSettings.importType = "DUPLICATED";
            projectImportSettings.remapping = options.remapping;
            projectImportSettings.targetProjectFolderId = options.targetProjectFolderId;
            projectImportSettings.createBranch = options.createBranch;
            logger.infoV("Starting import: %s", new Object[]{JSON.pretty((Object)projectImportSettings)});
            ProjectImporter.ProjectImportResult ret = this.processLocalImport(user, duplicationId, projectImportSettings);
            projectDuplicateResult.mergeFrom(ret);
            if (ret.anyFatal()) {
                this.projectsService.clearProjectRelatedFiles_NT(options.targetProjectKey, false);
                try (Object t = this.transactionService.beginWriteAsDSS();){
                    this.projectsService.deleteProject(user, options.targetProjectKey);
                    t.commit("delete the failed project " + options.targetProjectKey, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                }
                projectDuplicateResult.summarize();
                t = projectDuplicateResult;
                return t;
            }
            this.auditTrailService.generic("project-import").with("importId", duplicationId).with("projectKey", ret.usedProjectKey).emit();
            FutureProgress.incrementState((double)1.0);
            if (options.targetBranchName != null) {
                if (options.createBranch) {
                    this.projectsGitService.createBranch_NT(user, options.targetProjectKey, projectKey, options.targetBranchName, options.commitId);
                } else {
                    this.projectsGitService.resetToHead_NT(user, options.targetProjectKey);
                    this.projectsGitService.checkoutBranch_NT(user, options.targetProjectKey, options.targetBranchName.replaceFirst("^origin/", ""));
                }
            }
            projectDuplicateResult.projectKey = projectKey;
            projectDuplicateResult.targetProjectKey = options.targetProjectKey;
            projectDuplicateResult.targetProjectFolderId = options.targetProjectFolderId;
            ProjectDuplicator.ExposedInputDatasets exposedInputDatasets = null;
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(user);){
                if (options.targetBranchName == null) {
                    this.projectsGitService.removeGitInfo(options.targetProjectKey);
                } else {
                    this.projectsGitService.setupGitInfo(options.targetProjectKey, projectKey, options.targetBranchName);
                }
                ProjectDuplicator projectDuplicator = new ProjectDuplicator(projectKey, options.targetProjectKey);
                projectDuplicator.shareForeignObjects();
                if (options.shareAllInputDatasets) {
                    exposedInputDatasets = projectDuplicator.shareAndRemapInputObjects();
                }
                if (projectImportSettings.createBranch) {
                    t.commit("Share and remap foreign and input objects");
                } else {
                    SerializedProject sp = this.projectsService.getMandatory(options.targetProjectKey);
                    sp.name = options.targetProjectName;
                    sp.shortDesc = this.decorateShortDesc(sp.shortDesc, projectKey, options.targetProjectKey, user);
                    this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.DUPLICATION);
                    t.commit("Updated name of project " + projectKey);
                }
            }
            catch (Exception e) {
                this.auditTrailService.failure("project-duplicate", (Throwable)e).with("duplicationId", duplicationId).emit();
                this.projectsService.clearProjectRelatedFiles_NT(options.targetProjectKey, false);
                try (RWTransaction t2 = this.transactionService.beginWriteAsDSS();){
                    this.projectsService.deleteProject(user, options.targetProjectKey);
                    t2.commit("delete the failed project " + options.targetProjectKey, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                    throw e;
                }
            }
            FutureProgress.incrementState((double)1.0);
            if (options.shareAllInputDatasets) {
                assert (exposedInputDatasets != null);
                this.taggableObjectsDeletionService.delete_NT(exposedInputDatasets.deletionRequestItems, exposedInputDatasets.taggableObjectsMap, options.targetProjectKey, exposedInputDatasets.ignored, user);
            }
            FutureProgress.incrementState((double)1.0);
            this.timelinesDAO.clearForProject(projectImportSettings.targetProjectKey);
            try (Transaction t = this.transactionService.beginRead();){
                copiedWebapps = this.webAppsService.listUnsafe(options.targetProjectKey);
            }
            for (WebApp webApp : copiedWebapps) {
                this.trustedCodeService.copyTrustEntriesForWebApp_NT(projectKey, webApp.id, options.targetProjectKey, webApp.id);
            }
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectImportSettings.targetProjectKey, projectKey, user, TaggableObjectChangedEvent.ActionType.PROJECT_DUPLICATE));
        }
        catch (Exception e) {
            this.auditTrailService.failure("project-duplicate", (Throwable)e).with("duplicationId", duplicationId).emit();
            throw e;
        }
        projectDuplicateResult.summarize();
        return projectDuplicateResult;
    }

    public ProjectImporter.ProjectImportResult processImport(AuthCtx authCtx, String importId, ProjectImporter.ProjectImportSettings settings) throws Exception {
        File tmpDir = ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-import", importId});
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Importing project", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ProjectImporter pi = new ProjectImporter(authCtx, tmpDir, settings);
            ProjectImporter.ProjectImportResult result = pi.importProject(authCtx);
            if (!result.success) {
                logger.error((Object)("Project import failed: \n" + JSON.pretty((Object)((Object)result))));
            } else {
                logger.info((Object)("Project import success:\n" + JSON.pretty((Object)((Object)result))));
                this.pubSub.publish(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, result.usedProjectKey, result.usedProjectKey, authCtx, TaggableObjectChangedEvent.ActionType.PROJECT_CREATE));
                DKUFileUtils.deleteDirectory((File)tmpDir);
                this.graphService.invalidateCache();
            }
            ProjectImporter.ProjectImportResult projectImportResult = result;
            return projectImportResult;
        }
    }

    private ProjectImporter.ProjectImportResult processLocalImport(AuthCtx authCtx, String importId, ProjectImporter.ProjectImportSettings settings) throws Exception {
        File tmpZip = ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-duplicate", importId + ".zip"});
        ProjectImporter pi = new ProjectImporter(authCtx, tmpZip, settings);
        ProjectImporter.ProjectImportResult result = pi.importProject(authCtx);
        result.summarize();
        if (!result.success) {
            logger.error((Object)("Project duplication failed on re-import: \n" + JSON.pretty((Object)((Object)result))));
        } else {
            logger.info((Object)("Project duplication success:\n" + JSON.pretty((Object)((Object)result))));
            DKUFileUtils.forceDelete((File)tmpZip);
            this.graphService.invalidateCache();
        }
        return result;
    }

    @AuditedCall(value={"msgType", "project-import-prepare", "importId", "${importId}"})
    @RequestMapping(value={"/api/projects/import/prepare"}, method={RequestMethod.POST})
    public void prepareImportProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String importId, @RequestParam String importSettings) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        File tmpDir = "".equals(importId) ? null : ApplicationConfigurator.getFile((String[])new String[]{"tmp", "project-import", importId});
        ProjectImporter.ProjectImportSettings pis = "\"\"".equals(importSettings) ? new ProjectImporter.ProjectImportSettings() : (ProjectImporter.ProjectImportSettings)JSON.parse((String)importSettings, ProjectImporter.ProjectImportSettings.class);
        ProjectImportExportController.writeJSON((HttpServletResponse)resp, (Object)new ProjectImporter(liu, tmpDir, pis).prepareImport(liu));
    }

    @AuditedCall(value={"msgType", "project-export-prepare", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/export/prepare"}, method={RequestMethod.POST})
    public void prepareExportProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ExportedProject exportedProject;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(liu, projectKey);
            ProjectExportOptions projectExportOptions = new ProjectExportOptions();
            ProjectExporter projectExporter = new ProjectExporter(liu, projectExportOptions, projectKey, null);
            exportedProject = projectExporter.prepareExport();
        }
        ProjectImportExportController.writeJSON((HttpServletResponse)resp, (Object)exportedProject);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/import/start"}, method={RequestMethod.POST})
    public void startImportProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String importId, @RequestParam String importSettings) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        ProjectImporter.ProjectImportSettings pis = (ProjectImporter.ProjectImportSettings)JSON.parse((String)importSettings, ProjectImporter.ProjectImportSettings.class);
        ProjectImportFutureThread pift = new ProjectImportFutureThread(liu, importId, pis);
        ProjectImportExportController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(pift, 0L, new TypeToken<FutureResponse<ProjectImporter.ProjectImportResult>>(){}));
    }

    private static FuturePayload buildImportFuturePayload(String projectKey, String importId) {
        FuturePayload fp = new FuturePayload();
        fp.action = "import_project";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, importId, ITaggingService.TaggableType.PROJECT.name(), null));
        fp.displayName = "Import project " + importId;
        return fp;
    }

    public static File exportFile(String projectKey, String exportId) throws IOException {
        if (!Pattern.matches("^[A-Za-z0-9]*$", exportId)) {
            throw new IllegalArgumentException("Invalid export id");
        }
        return DSSTempUtils.getTempFileWithSpecificName((String)"project-export", (String)(projectKey + "-" + exportId), (String)"zip");
    }

    private static File duplicateFile(String exportId) throws IOException {
        if (!Pattern.matches("^[A-Za-z0-9]*$", exportId)) {
            throw new IllegalArgumentException("Invalid export id");
        }
        return DSSTempUtils.getTempFileWithSpecificName((String)"project-duplicate", (String)exportId, (String)"zip");
    }

    @AuditedCall(value={"msgType", "project-export-download", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/projects/download-export"}, method={RequestMethod.GET})
    public void downloadPreparedExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
        }
        ProjectImportExportController.sendExportDataAndDelete(resp, projectKey, exportId);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/start-export"}, method={RequestMethod.POST})
    public void startExportProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportOptions) throws Exception {
        AuthCtx u;
        String exportId = SecretKeyGenerator.generate((int)16);
        ProjectExportOptions options = (ProjectExportOptions)JSON.parse((String)exportOptions, ProjectExportOptions.class);
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
            if (options.exportGitRepository) {
                this.checkExportGitOption(u, projectKey);
            }
        }
        logger.infoV("Starting export of %s with options %s", new Object[]{projectKey, JSON.pretty((Object)options)});
        ProjectExportFutureThread peft = new ProjectExportFutureThread(u, projectKey, exportId, options);
        FutureResponse<ProjectExportResult> fr = this.futureService.runFuture(peft, 0L, new TypeToken<FutureResponse<ProjectExportResult>>(){});
        ProjectImportExportController.writeJSON((HttpServletResponse)resp, fr);
    }

    @AuditedCall(value={"msgType", "project-duplicate", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/duplicate"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ProjectDuplicateResult> startDuplicateProject(HttpServletRequest req, @RequestParam String projectKey, @RequestParam ProjectDuplicateOptions duplicateOptions) throws Exception {
        DSSAuthCtx u;
        String duplicateId = SecretKeyGenerator.generate((int)16);
        try (Transaction t = this.transactionService.beginRead();){
            u = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!u.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
            this.permissionsService.checkCanExportAndManageBundles(u, projectKey);
            this.checkAndSetExportGitOption(u, projectKey, duplicateOptions);
        }
        this.duplicationOptionsChecks(duplicateOptions);
        logger.infoV("Starting duplication of %s into %s with options %s", new Object[]{projectKey, duplicateOptions.targetProjectKey, JSON.pretty((Object)duplicateOptions)});
        ProjectDuplicateFutureThread pdft = new ProjectDuplicateFutureThread(u, projectKey, duplicateId, duplicateOptions);
        return this.futureService.runFuture(pdft, 0L, new TypeToken<FutureResponse<ProjectDuplicateResult>>(){});
    }

    private static FuturePayload buildExportFuturePayload(String projectKey, String exportId) {
        FuturePayload fp = new FuturePayload();
        fp.action = "export_project";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, exportId, ITaggingService.TaggableType.PROJECT.name(), null));
        fp.displayName = "Export project " + projectKey + "/" + exportId;
        return fp;
    }

    private static FuturePayload buildDuplicateFuturePayload(String projectKey, String newProjectKey) {
        FuturePayload fp = new FuturePayload();
        fp.action = "duplicate_project";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, newProjectKey, ITaggingService.TaggableType.PROJECT.name(), null));
        fp.displayName = "Duplicate project " + projectKey + "into" + newProjectKey;
        return fp;
    }

    private String decorateShortDesc(String shortDesc, String projectKey, String newProjectKey, AuthCtx user) throws IOException {
        String addendum = "The project *" + newProjectKey + "* was copied from *" + projectKey + "*" + this.getOriginalBranchDesc(projectKey) + " by " + this.usersService.getPublicUser((String)user.getAssociatedDSSUser()).displayName + " on " + ProjectImportExportController.getFormattedDateForToday();
        if (StringUtils.isBlank((String)shortDesc)) {
            return addendum;
        }
        return shortDesc + "\n" + addendum;
    }

    private static String getFormattedDateForToday() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd'" + ProjectImportExportController.getDayOfMonthSuffix(cal.get(5)) + "' yyyy");
        return sdf.format(cal.getTime());
    }

    private String getOriginalBranchDesc(String projectKey) {
        try {
            String branch = this.projectsGitService.getCurrentBranch_NT(projectKey);
            if (!"master".equals(branch)) {
                return " on *" + branch + "* branch";
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to retrieve current branch for project " + projectKey), (Throwable)e);
        }
        return "";
    }

    public static class ProjectDuplicateResult
    extends InfoMessage.InfoMessages {
        public String projectKey;
        public String targetProjectKey;
        public String targetProjectFolderId;
    }

    public static class ProjectExportResult
    extends InfoMessage.InfoMessages {
        public String projectKey;
        public String exportId;
    }

    private class ProjectImportFutureThread
    extends SimpleFutureThread<ProjectImporter.ProjectImportResult> {
        private String importId;
        private ProjectImporter.ProjectImportSettings settings;
        private final FuturePayload futurePayload;

        private ProjectImportFutureThread(AuthCtx user, String importId, ProjectImporter.ProjectImportSettings settings) {
            super(user);
            this.importId = importId;
            this.settings = settings;
            this.futurePayload = ProjectImportExportController.buildImportFuturePayload(settings.targetProjectKey, importId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ProjectImporter.ProjectImportResult compute() throws Exception {
            try {
                ProjectImporter.ProjectImportResult ret = ProjectImportExportController.this.processImport(this.owner, this.importId, this.settings);
                ProjectImportExportController.this.auditTrailService.generic("project-import").with("importId", this.importId).with("projectKey", ret.usedProjectKey).emit();
                return ret;
            }
            catch (Exception e) {
                ProjectImportExportController.this.auditTrailService.failure("project-import", (Throwable)e).with("importId", this.importId).emit();
                throw e;
            }
        }
    }

    private class ProjectExportFutureThread
    extends SimpleFutureThread<ProjectExportResult> {
        private String projectKey;
        private String exportId;
        private ProjectExportOptions options;
        private final FuturePayload futurePayload;

        private ProjectExportFutureThread(AuthCtx user, String projectKey, String exportId, ProjectExportOptions options) {
            super(user);
            this.projectKey = projectKey;
            this.exportId = exportId;
            this.options = options;
            this.futurePayload = ProjectImportExportController.buildExportFuturePayload(projectKey, exportId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ProjectExportResult compute() throws Exception {
            ProjectExportResult projectExportResult;
            block8: {
                FutureProgress.AutocloseableFutureProgressState fut = FutureProgress.pushAutoCloseableState((String)"Building export", (double)18.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                try {
                    File f = ProjectImportExportController.exportFile(this.projectKey, this.exportId);
                    DKUFileUtils.mkdirsParent((File)f);
                    ProjectExporter peo = new ProjectExporter(this.getOwner(), this.options, this.projectKey, f);
                    ProjectExportResult per = peo.export(true);
                    per.projectKey = this.projectKey;
                    per.exportId = this.exportId;
                    per.summarize();
                    ProjectImportExportController.this.auditTrailService.generic("project-export").with("exportId", this.exportId).with("projectKey", this.projectKey).emit();
                    projectExportResult = per;
                    if (fut == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (fut != null) {
                            try {
                                fut.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ProjectImportExportController.this.auditTrailService.failure("project-export", (Throwable)e).with("projectKey", this.projectKey).emit();
                        throw e;
                    }
                }
                fut.close();
            }
            return projectExportResult;
        }
    }

    private class ProjectDuplicateFutureThread
    extends SimpleFutureThread<ProjectDuplicateResult> {
        private final FuturePayload futurePayload;
        private String projectKey;
        private String duplicateId;
        private ProjectDuplicateOptions options;
        private AuthCtx user;

        private ProjectDuplicateFutureThread(AuthCtx user, String projectKey, String duplicateId, ProjectDuplicateOptions options) {
            super(user);
            this.user = user;
            this.options = options;
            this.projectKey = projectKey;
            this.duplicateId = duplicateId;
            this.futurePayload = ProjectImportExportController.buildDuplicateFuturePayload(projectKey, options.targetProjectKey);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ProjectDuplicateResult compute() throws Exception {
            try {
                ProjectDuplicateResult ret = ProjectImportExportController.this.processDuplicate(this.projectKey, this.user, this.duplicateId, this.options);
                ProjectImportExportController.this.auditTrailService.generic("project-duplicate").with("exportId", this.duplicateId).with("projectKey", this.projectKey).emit();
                return ret;
            }
            catch (Exception e) {
                ProjectImportExportController.this.auditTrailService.failure("project-duplicate", (Throwable)e).with("projectKey", this.projectKey).emit();
                throw e;
            }
        }
    }
}

