/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.metrics.DisplayedChecksSet;
import com.dataiku.dip.metrics.DisplayedMetricsSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.ExternalCheck;
import com.dataiku.dip.metrics.engines.PythonProbeEngine;
import com.dataiku.dip.metrics.probes.ExternalProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MetricsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private MetricsComputationService metricsComputationService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.datasets.metrics.controller");

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/list-available-metrics"})
    public void listOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getAvailableMetricsSet(authCtx, dataset, MetricTargetType.DATASET));
        }
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/list-available-metrics"})
    public void listOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getAvailableMetricsSet(authCtx, folder, MetricTargetType.MANAGED_FOLDER));
        }
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/list-available-metrics"})
    public void listOnProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedProject project = this.projectsDAO.getMandatory(projectKey);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getAvailableMetricsSet(authCtx, project, MetricTargetType.PROJECT));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-prepared-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getMetricHistoryOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partitionId, @RequestParam(required=false) String metricId) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
        return this.metricsService.getMetricData_NT(dataset, MetricTargetType.DATASET, partition, metricId, true);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/get-prepared-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getMetricHistoryOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam(required=false) String metricId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
        }
        Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
        return this.metricsService.getMetricData_NT(folder, MetricTargetType.MANAGED_FOLDER, partition, metricId, true);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/get-prepared-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getMetricHistoryOnModel(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam(required=false) String metricId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        return this.metricsService.getMetricData_NT(sm, MetricTargetType.SAVED_MODEL, null, metricId, true);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/modelevaluationstore/get-prepared-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getMetricHistoryOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam(required=false) String metricId) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
        }
        return this.metricsService.getMetricData_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, null, metricId, true);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-prepared-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getMetricHistoryOnProject(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) String metricId) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getMandatoryUnsafe(projectKey);
        }
        return this.metricsService.getMetricData_NT(project, MetricTargetType.PROJECT, null, metricId, true);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/get-prepared-metric-partitions"})
    public void getMetricPartitionsOnSM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
            DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getPartitionMetricData(sm, displayedState.metrics));
        }
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-prepared-metric-partitions"})
    public void getMetricPartitionsOnMES(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
            DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getPartitionMetricData(mes, displayedState.metrics));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-prepared-check-histories"})
    @ResponseBody
    public MetricsService.CheckHistoriesData getCheckHistoriesOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        DisplayedChecksSet displayedState = (DisplayedChecksSet)JSON.parse((String)data, DisplayedChecksSet.class);
        Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), displayedState.partition);
        return this.metricsService.getCheckData_NT(dataset, MetricTargetType.DATASET, partition, displayedState.checks);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-prepared-metric-partitions"})
    public void getMetricPartitionsOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getPartitionMetricData(dataset, displayedState.metrics));
        }
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/managedfolder/get-prepared-metric-partitions"})
    public void getMetricPartitionsOnFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getPartitionMetricData(folder, displayedState.metrics));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-prepared-metric-columns"})
    public void getMetricColumnsOnDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
            Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), displayedState.partition);
            ArrayList<String> columnNames = displayedState.columns != null ? displayedState.columns : new ArrayList<String>();
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getColumnMetricData(dataset, partition, displayedState.metrics, columnNames));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-prepared-metric-histories"})
    @ResponseBody
    public MetricsService.MetricHistoriesData getMetricHistoriesOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data) throws Exception {
        DisplayedMetricsSet displayedState;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
        }
        Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), displayedState.partition);
        return this.metricsService.getMetricData_NT(dataset, MetricTargetType.DATASET, partition, displayedState.metrics);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/get-prepared-metric-histories"})
    @ResponseBody
    public MetricsService.MetricHistoriesData getMetricHistoriesOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String data) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
        }
        DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
        Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), displayedState.partition);
        return this.metricsService.getMetricData_NT(folder, MetricTargetType.MANAGED_FOLDER, partition, displayedState.metrics);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/get-prepared-metric-histories"})
    @ResponseBody
    public MetricsService.MetricHistoriesData getMetricHistoriesOnModel(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String data) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
        return this.metricsService.getMetricData_NT(sm, MetricTargetType.SAVED_MODEL, null, displayedState.metrics);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-prepared-metric-histories"})
    @ResponseBody
    public MetricsService.MetricHistoriesData getMetricHistoriesOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam String data) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
        }
        DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
        return this.metricsService.getMetricData_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, null, displayedState.metrics);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-prepared-metric-histories"})
    @ResponseBody
    public MetricsService.MetricHistoriesData getMetricHistoriesOnProject(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getMandatoryUnsafe(projectKey);
        }
        DisplayedMetricsSet displayedState = (DisplayedMetricsSet)JSON.parse((String)data, DisplayedMetricsSet.class);
        return this.metricsService.getMetricData_NT(project, MetricTargetType.PROJECT, null, displayedState.metrics);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/list-computed-checks"})
    @ResponseBody
    public MetricsService.ComputedChecks listComputedChecksOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        return this.metricsService.listComputedChecks_NT(dataset, MetricTargetType.DATASET, dataset.getModel().getDataQualityRuleSet().displayedState, false);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/list-computed-metrics"})
    @ResponseBody
    public MetricsService.ComputedMetrics listComputedMetricsOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        return this.metricsService.listComputedMetrics_NT(dataset, MetricTargetType.DATASET, dataset.getModel().getMetrics() != null ? dataset.getModel().getMetrics().displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/list-computed-metrics"})
    @ResponseBody
    public MetricsService.ComputedMetrics listComputedMetricsOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
        }
        return this.metricsService.listComputedMetrics_NT(folder, MetricTargetType.MANAGED_FOLDER, folder.metrics != null ? folder.metrics.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/list-computed-metrics"})
    @ResponseBody
    public MetricsService.ComputedMetrics listComputedMetricsOnModel(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId) throws Exception {
        SavedModel model;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            model = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, modelId);
        }
        return this.metricsService.listComputedMetrics_NT(model, MetricTargetType.SAVED_MODEL, model.metrics != null ? model.metrics.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/list-computed-metrics"})
    @ResponseBody
    public MetricsService.ComputedMetrics listComputedMetricsOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(projectKey, mesId);
        }
        return this.metricsService.listComputedMetrics_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, mes.metrics != null ? mes.metrics.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/list-computed-metrics"})
    @ResponseBody
    public MetricsService.ComputedMetrics listComputedMetricsOnProject(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getMandatory(projectKey);
        }
        return this.metricsService.listComputedMetrics_NT(project, MetricTargetType.PROJECT, project.metrics != null ? project.metrics.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/list-computed-checks"})
    @ResponseBody
    public MetricsService.ComputedChecks listComputedChecksOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        return this.metricsService.listComputedChecks_NT(sm, MetricTargetType.SAVED_MODEL, sm.metricsChecks != null ? sm.metricsChecks.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/list-computed-checks"})
    @ResponseBody
    public MetricsService.ComputedChecks listComputedChecksOnSM(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
        }
        return this.metricsService.listComputedChecks_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, mes.metricsChecks != null ? mes.metricsChecks.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/get-prepared-check-histories"})
    @ResponseBody
    public MetricsService.CheckHistoriesData getCheckHistoriesOnModel(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String data) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        DisplayedChecksSet displayedState = (DisplayedChecksSet)JSON.parse((String)data, DisplayedChecksSet.class);
        return this.metricsService.getCheckData_NT(sm, MetricTargetType.SAVED_MODEL, null, displayedState.checks);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/modelevaluationstores/get-prepared-check-histories"})
    @ResponseBody
    public MetricsService.CheckHistoriesData getCheckHistoriesOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam String data) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
        }
        DisplayedChecksSet displayedState = (DisplayedChecksSet)JSON.parse((String)data, DisplayedChecksSet.class);
        return this.metricsService.getCheckData_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, null, displayedState.checks);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/list-computed-checks"})
    @ResponseBody
    public MetricsService.ComputedChecks listComputedChecksOnMF(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
        }
        return this.metricsService.listComputedChecks_NT(folder, MetricTargetType.MANAGED_FOLDER, folder.checks != null ? folder.checks.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/list-computed-checks"})
    @ResponseBody
    public MetricsService.ComputedChecks listComputedChecksOnProject(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getMandatory(projectKey);
        }
        return this.metricsService.listComputedChecks_NT(project, MetricTargetType.PROJECT, project.metricsChecks != null ? project.metricsChecks.displayedState : null, false);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/get-prepared-check-histories"})
    @ResponseBody
    public MetricsService.CheckHistoriesData getCheckHistoriesOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String data) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
        }
        DisplayedChecksSet displayedState = (DisplayedChecksSet)JSON.parse((String)data, DisplayedChecksSet.class);
        Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), displayedState.partition);
        return this.metricsService.getCheckData_NT(folder, MetricTargetType.MANAGED_FOLDER, partition, displayedState.checks);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-prepared-check-histories"})
    @ResponseBody
    public MetricsService.CheckHistoriesData getCheckHistoriesOnProject(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getMandatory(projectKey);
        }
        DisplayedChecksSet displayedState = (DisplayedChecksSet)JSON.parse((String)data, DisplayedChecksSet.class);
        return this.metricsService.getCheckData_NT(project, MetricTargetType.PROJECT, null, displayedState.checks);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getHistoryValuesOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partition, @RequestParam String metricLookup) throws Exception {
        Dataset dataset;
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        Partition p = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partition);
        Map<String, Metric> lastMetrics = this.metricsService.getLastKnownMetrics_NT(dataset, MetricTargetType.DATASET);
        Metric lookedUpMetric = MetricsService.lookupMetric(metricLookup, lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on dataset " + loc.getFullName() + ".");
        }
        return this.metricsService.getMetricData_NT(dataset, MetricTargetType.DATASET, p, lookedUpMetric.getId(), true);
    }

    /*
     * Unable to fully structure code
     */
    @AuditedCall(value={"msgType", "object-read-status", "projectKey", "${projectKey}", "objectType", "${objectType}", "objectRef", "${objectSmartName}"})
    @RequestMapping(value={"/api/metrics/get-computed-metric-with-history"})
    @ResponseBody
    public ComputedMetricWithHistory getMetricWithHistory(HttpServletRequest req, @RequestParam String projectKey, @RequestParam MetricTargetType objectType, @RequestParam(required=false) String objectSmartName, @RequestParam(required=false) String partitionId, @RequestParam(required=false) String metricId) throws Exception {
        object = null;
        partition = null;
        if (StringUtils.isNotBlank((String)objectSmartName)) {
            ref = SmartObjectRef.fromSmartName(objectType.toTaggableType(), objectSmartName);
        } else {
            if (objectType != MetricTargetType.PROJECT) {
                throw new IllegalArgumentException("A smartName is mandatory for all objects except projects");
            }
            ref = new SmartObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, null);
        }
        t = this.transactionService.beginRead();
        try {
            user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, ref, projectKey);
            switch (4.$SwitchMap$com$dataiku$dip$metrics$MetricTargetType[objectType.ordinal()]) {
                case 1: {
                    dataset = this.datasetAccessService.getMandatory(ref.getProjectKey(projectKey), ref.objectId);
                    partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
                    object = dataset;
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 2: {
                    object = this.savedModelsDAO.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
                    ** break;
lbl23:
                    // 1 sources

                    break;
                }
                case 3: {
                    folder = (ManagedFolder)this.managedFolderDAO.getMandatory(ref.getProjectKey(projectKey), ref.objectId);
                    partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
                    object = folder;
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 4: {
                    object = this.projectsDAO.getMandatoryUnsafe(ref.getProjectKey(projectKey));
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 5: {
                    object = this.modelEvaluationStoresDAO.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
                    break;
                }
                ** default:
lbl38:
                // 1 sources

                break;
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        lastMetrics = this.metricsService.getLastKnownMetrics_NT(object, objectType);
        lookedUpMetric = MetricsService.lookupMetric(metricId, lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricId + "' does not exist on " + String.valueOf((Object)objectType) + " " + projectKey + "." + objectSmartName + ".");
        }
        metricWithHistory = new ComputedMetricWithHistory();
        metricWithHistory.metric = this.metricsService.getComputedMetric_NT(new DatasetLocUtils.DatasetLoc(ref.getProjectKey(projectKey), ref.objectId), lookedUpMetric, false);
        metricWithHistory.history = this.metricsService.getMetricData_NT(object, objectType, partition, metricId, true);
        return metricWithHistory;
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "contextProjectKey", "${contextProjectKey}", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-partition-list-metric"})
    public void getDatasetPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)contextProjectKey)) {
                this.projectsService.failIfNoDatasetReadUseAccess(user, new AnyLoc(projectKey, datasetName), contextProjectKey);
            } else {
                this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName, SerializedProject.ReaderAuthorization.Mode.READ);
            }
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getLastKnownListOfPartitions(dataset, MetricTargetType.DATASET));
        }
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/get-partition-list-metric"})
    public void getFolderPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getLastKnownListOfPartitions(folder, MetricTargetType.MANAGED_FOLDER));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "contextProjectKey", "${contextProjectKey}", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-full-sample-statistics-config"})
    public void getFullSampleStatisticsConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{datasetName});
            this.projectsService.failIfNoDashboardReadPermission(authCtx, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey);
            SerializedShakerScript shakerScript = this.exploresService.get((String)projectKey, (String)datasetName).script;
            SerializedShakerScript.FullSampleStatisticsConfig config = shakerScript.fullSampleStatistics;
            if (config == null) {
                SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
                ProbesSet probes = dataset.getMetrics();
                config = new SerializedShakerScript.FullSampleStatisticsConfig();
                config.engineConfig = probes.engineConfig;
            }
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)config);
        }
    }

    @AuditedCall(value={"msgType", "project-save-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-external-metrics-values"})
    public void saveProjectExternalMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam(required=false) String typesData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedProject project = this.projectsDAO.getMandatory(projectKey);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            HashMap<String, String> types = StringUtils.isBlank((String)typesData) ? new HashMap<String, String>() : (Map)JSON.parse((String)typesData, (TypeToken)new TypeToken<Map<String, String>>(){});
            Probe externalProbe = new Probe("external").withConfiguration(new ExternalProbeType.ExternalProbeConfiguration());
            Map<Metric, String> metricsValues = PythonProbeEngine.makeMetricsValuesFromObjectMap(project, MetricTargetType.PROJECT, externalProbe, results, types);
            this.metricsComputationService.saveMetricsValues(authCtx, project, MetricTargetType.PROJECT, null, DateTime.now(), metricsValues, this.buildMetricsEnvironment());
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    @AuditedCall(value={"msgType", "project-save-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-external-checks-values"})
    public void saveProjectExternalChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedProject project = this.projectsDAO.getMandatory(projectKey);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            Map<Check, AbstractCheckContext.CheckResult> metricsValues = ExternalCheck.makeChecksValuesFromObjectMap(results);
            this.metricsComputationService.saveChecksValues(project.projectKey, null, null, DateTime.now(), metricsValues, new DataQualityRunOrigin.External());
            MetricsController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    private MetricsComputationService.MetricsComputationEnvironment buildMetricsEnvironment() throws IOException {
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        return environment;
    }

    public static class ComputedMetricWithHistory {
        public MetricsService.ComputedMetric metric;
        public MetricsService.MetricHistoryData history;
    }
}

