/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.python;

import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ImportedScenarioClassParser
implements RegexParser {
    private static final String SCENARIO_MODULE_NAME = "scenario";
    private static final String SCENARIO_CLASS_NAME = "Scenario";
    private final Set<String> classNames = new HashSet<String>();
    private final Pattern importModulePattern = Pattern.compile(String.format("^import\\s*+\\\\?\\s*+%s\\.%s(?:\\s*+\\\\?\\s*+as\\s*+\\\\?\\s*+(\\w++))?", "dataiku", "scenario"));
    private final Pattern importClassPattern = Pattern.compile(String.format("^from\\s*+\\\\?\\s*+%s\\.%s\\s*+\\\\?\\s*+import\\s*+\\\\?\\s*+(?:[\\w]++\\s*+\\\\?\\s*+as\\s*+\\\\?\\s*+[\\w]++,\\s*+\\\\?\\s*+)?%s(?:\\s*+\\\\?\\s*+as\\s*+\\\\?\\s*+(\\w++))?", "dataiku", "scenario", "Scenario"));
    private Matcher importModuleMatcher;
    private Matcher importClassMatcher;
    private boolean matchesImportModulePattern;

    public Set<String> getClassNames() {
        return this.classNames;
    }

    @Override
    public boolean matches(String input) {
        this.importModuleMatcher = this.importModulePattern.matcher(input);
        this.matchesImportModulePattern = this.importModuleMatcher.find();
        if (this.matchesImportModulePattern) {
            Object className = this.importModuleMatcher.group(1) == null ? "dataiku.scenario" : this.importModuleMatcher.group(1);
            className = (String)className + ".Scenario";
            this.classNames.add((String)className);
            return true;
        }
        this.importClassMatcher = this.importClassPattern.matcher(input);
        boolean match = this.importClassMatcher.find();
        if (match) {
            String className = this.importClassMatcher.group(1) == null ? SCENARIO_CLASS_NAME : this.importClassMatcher.group(1);
            this.classNames.add(className);
        }
        return match;
    }

    @Override
    public String getMatch() {
        if (this.matchesImportModulePattern) {
            return this.importModuleMatcher.group(0);
        }
        return this.importClassMatcher.group(0);
    }

    @Override
    public String getReplacement() {
        return this.getMatch();
    }

    @Override
    public int datasetReferences() {
        return 0;
    }
}

