/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.notebooks.JupyterSecurityService;
import com.dataiku.dip.notebooks.JupyterVirtualPathService;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class JupyterIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private JupyterSecurityService jupyterSecurityService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private JupyterVirtualPathService virtualPathService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jupyter.intercom.controller");

    @AuditedCall(value={"msgType", "jupyter-create-kernel-context", "projectKey", "${projectKey}", "notebookId", "${notebookId}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/new-kernel-context"})
    public void newKernelContext(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String user, @RequestParam String sessionId) throws Exception {
        CodeEnvModel.UsedCodeEnvRef codeEnv;
        AuthCtx authCtx;
        this.authService.failIfNoSharedSecret(req);
        logger.infoV("Creating Kernel context projectKey=%s user=%s", new Object[]{projectKey, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)notebookId);
        Validate.notNull((Object)user);
        HashSet relevantProjectKeys = Sets.newHashSet((Object[])new String[]{projectKey});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
            List<? extends DatasetLocUtils.DatasetLoc> exposedDatasets = this.projectsService.getExposedDatasets(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : exposedDatasets) {
                relevantProjectKeys.add(datasetLoc.getProjectKey());
            }
            RelFile rf = this.jupyterService.getNotebookFile(projectKey, StringUtils.removeEnd((String)notebookId, (String)".ipynb"));
            JsonObject jsonObject = (JsonObject)t.readObjectUnsafe(rf, JsonObject.class);
            JupyterCodeEnvUtils.NotebookCodeEnvInfo kernelInfo = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(jsonObject);
            logger.info((Object)("Got info for " + notebookId + " : " + JSON.json((Object)kernelInfo)));
            codeEnv = kernelInfo != null && kernelInfo.envLang != null ? new CodeEnvModel.UsedCodeEnvRef(kernelInfo.envLang, kernelInfo.envName) : null;
        }
        logger.info((Object)("Using code env : " + JSON.json(codeEnv)));
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forJupyterNotebookKernel((AuthCtx)authCtx, (String)projectKey, (String)notebookId, (String)sessionId);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.jupyterSecurityService.createContext(projectKey, notebookId, authCtx, relevantProjectKeys, null, sessionId, codeEnv));
    }

    @AuditedCall(value={"msgType", "jupyter-delete-kernel-context", "sessionId", "${sessionId}"})
    @RequestMapping(value={"/api/pintercom/jupyter/delete-kernel-context"})
    public void deleteKernelContext(HttpServletRequest req, HttpServletResponse resp, @RequestParam String sessionId) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        logger.infoV("Deleting Kernel context sessionId=%s", new Object[]{sessionId});
        this.jupyterSecurityService.destroyContext(sessionId);
    }

    @AuditedCall(value={"msgType", "jupyter-get-session-path", "projectKey", "${projectKey}", "notebookId", "${notebookId}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/get-session-virtual-path"})
    public void getSessionVirtualPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String user) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        logger.infoV("Getting session virtual path projectKey=%s notebookId=%s user=%s", new Object[]{projectKey, notebookId, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)notebookId);
        Validate.notNull((Object)user);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authCtxCreationService.create(user);
            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)new Id(this.virtualPathService.getSessionVirtualPath(projectKey, notebookId, authCtx)));
        }
    }

    @AuditedCall(value={"msgType", "jupyter-git-commit-file", "projectKey", "${projectKey}", "fileName", "${fileName}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/git-commit-notebook"})
    public void gitCommitNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fileName, @RequestParam String user, @RequestParam MultipartFile notebook, @RequestParam boolean isCopy) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        JupyterService.NotebookSafeForWritingNew notebookObj;
        logger.infoV("Commit on a notebook projectKey=%s fileName=%s user=%s", new Object[]{projectKey, fileName, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)fileName);
        Validate.notNull((Object)user);
        Validate.notNull((Object)notebook);
        try (InputStreamReader reader = new InputStreamReader(notebook.getInputStream(), StandardCharsets.UTF_8);){
            notebookObj = (JupyterService.NotebookSafeForWritingNew)JSON.gson().fromJson((Reader)reader, JupyterService.NotebookSafeForWritingNew.class);
        }
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            if (this.jupyterService.exists(projectKey, fileName)) {
                JupyterService.JupyterNotebookListEntry entry = this.jupyterService.gitCommitNotebook(authCtx, projectKey, fileName, notebookObj);
                t.commit("Saved Jupyter notebook '" + entry.getDisplayName() + "'");
                JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)entry.getId());
            } else {
                JupyterService.JupyterNotebookListEntry entry = this.jupyterService.installNotebookFromFile(authCtx, projectKey, fileName, null, notebookObj, isCopy);
                t.commit("Created Jupyter notebook '" + entry.getDisplayName() + "' from Jupiter API");
                JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)entry.getId());
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "jupyter-git-rename-file", "projectKey", "${projectKey}", "oldFileName", "${oldFileName}", "newFileName", "${newFileName}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/git-rename-notebook"})
    public void gitRenameNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String oldFileName, @RequestParam String newFileName, @RequestParam String user) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        logger.infoV("Rename a notebook projectKey=%s oldFileName=%s newFileName=%s user=%s", new Object[]{projectKey, oldFileName, newFileName, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)oldFileName);
        Validate.notNull((Object)newFileName);
        Validate.notNull((Object)user);
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            JupyterService.JupyterNotebookListEntry entry = this.jupyterService.gitRenameNotebook(authCtx, projectKey, oldFileName, newFileName);
            t.commit("Renamed Jupyter notebook from '" + oldFileName + "' to '" + entry.getDisplayName() + "'");
            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)entry.getId());
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "jupyter-git-delete-file", "projectKey", "${projectKey}", "fileName", "${fileName}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/git-delete-notebook"})
    public void gitDeleteNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fileName, @RequestParam String user) throws IOException, DKUSecurityException, CodedException {
        AuthCtx authCtx;
        logger.infoV("Deleting a notebook projectKey=%s fileName=%s user=%s", new Object[]{projectKey, fileName, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)fileName);
        Validate.notNull((Object)user);
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            this.jupyterService.delete(projectKey, fileName, authCtx);
            t.commit("Deleting Jupyter notebook '" + fileName + "'");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "jupyter-git-commit-checkpoint", "projectKey", "${projectKey}", "fileName", "${fileName}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/git-commit-checkpoint"})
    public void gitCommitCheckpoint(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fileName, @RequestParam String user) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        logger.infoV("Commit a checkpoint projectKey=%s fileName=%s user=%s", new Object[]{projectKey, fileName, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)fileName);
        Validate.notNull((Object)user);
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            String entry = this.jupyterService.gitCommitCheckpoint(authCtx, projectKey, fileName);
            t.commit("Saved Jupyter checkpoint '" + entry + "'");
            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)entry);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "jupyter-git-restore-checkpoint", "projectKey", "${projectKey}", "fileName", "${fileName}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/git-restore-checkpoint"})
    public void gitRestoreCheckpoint(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fileName, @RequestParam String user) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        logger.infoV("Restore a checkpoint projectKey=%s fileName=%s user=%s", new Object[]{projectKey, fileName, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)fileName);
        Validate.notNull((Object)user);
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            String entry = this.jupyterService.gitRestoreCheckpoint(authCtx, projectKey, fileName);
            t.commit("Restore Jupyter notebook '" + fileName + "' from checkpoint");
            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)entry);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "jupyter-git-rename-checkpoint", "projectKey", "${projectKey}", "oldFileName", "${oldFileName}", "newFileName", "${newFileName}", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/git-rename-checkpoint"})
    public void gitRenameCheckpoint(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String oldFileName, @RequestParam String newFileName, @RequestParam String user) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        logger.infoV("Rename a checkpoint projectKey=%s oldFileName=%s newFileName=%s user=%s", new Object[]{projectKey, oldFileName, newFileName, user});
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)oldFileName);
        Validate.notNull((Object)newFileName);
        Validate.notNull((Object)user);
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authCtxCreationService.create(user);
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            String entry = this.jupyterService.gitRenameCheckpoint(authCtx, projectKey, oldFileName, newFileName);
            t.commit("Renamed Jupyter checkpoint from '" + oldFileName + "-chekpoint.ipynb' to '" + entry + "'");
            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)entry);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "jupyter-get-user-authorization", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/user-auth"})
    @ResponseBody
    public JupyterService.JupyterUserAuthorization getUserAuth(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws IOException, DKUSecurityException {
        Validate.notNull((Object)user);
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            JupyterService.JupyterUserAuthorization jupyterUserAuthorization = this.jupyterService.getJupyterUserAuthorization(user);
            return jupyterUserAuthorization;
        }
    }

    @AuditedCall(value={"msgType", "jupyter-get-user-authorized-projects", "user", "${user}"})
    @RequestMapping(value={"/api/pintercom/jupyter/user-authorized-projects"})
    @ResponseBody
    public List<String> getUserAuthorizedProjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user, @RequestParam(required=false) String filterProjectIdIn) throws IOException, DKUSecurityException {
        Validate.notNull((Object)user);
        List<String> parsedFilterProjectIdIn = null;
        if (filterProjectIdIn != null) {
            parsedFilterProjectIdIn = Arrays.asList(filterProjectIdIn.split(","));
        }
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            List<String> list = this.jupyterService.listAuthorizedProjects(user, parsedFilterProjectIdIn);
            return list;
        }
    }

    @RequestMapping(value={"/api/tintercom/jupyter/allowed-port-range"})
    public void getAllowedPorts(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.ticketAuthService.failIfNoTicket(req);
        PortRangeParams portRange = ApplicationConfigurator.getPortRangeParams();
        JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)portRange);
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/jupyter/start-remote-kernel"})
    public void startRemoteKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String connectionFile, @RequestParam(required=false) String envLang, @RequestParam(required=false) String envName, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String bundleId, @RequestParam(required=false) String containerConf) throws Exception {
        ContainerExecRuntimeConfig containerExecRuntimeConfig;
        JupyterSecurityService.JupyterKernelContext kernelContext;
        AuthCtx authCtx;
        logger.infoV("Start container kernel contextProjectKey=%s connectionFile=%s envName=%s projectKey=%s bundleId=%s containerConf=%s", new Object[]{contextProjectKey, connectionFile, envName, projectKey, bundleId, containerConf});
        Validate.notNull((Object)connectionFile);
        JsonObject connectionFileJson = (JsonObject)JSON.parse((String)connectionFile, JsonObject.class);
        connectionFileJson.addProperty("relayHost", RemoteRunNetworkingUtils.getBackendHost());
        connectionFileJson.addProperty("connectTimeout", (Number)ApplicationConfigurator.getParams().getLongParam("dku.nbk.container.connect.timeout", 30000L));
        if ("__BUILTIN__".equals(envName)) {
            envName = null;
        }
        HashSet relevantProjectKeys = Sets.newHashSet((Object[])new String[]{contextProjectKey});
        try (Transaction t = this.transactionService.beginRead();
             APITicketService.TicketUsage ticketUsage = this.ticketAuthService.getAndUseMandTicket(req);){
            authCtx = ticketUsage.getAuthCtx();
            Object ticketPayload = ticketUsage.getTicket().getPayload();
            if (ticketPayload == null || !(ticketPayload instanceof JupyterSecurityService.JupyterKernelContext)) {
                throw new IllegalArgumentException("Ticket doesn't have a jupyter context payload");
            }
            kernelContext = (JupyterSecurityService.JupyterKernelContext)ticketPayload;
            List<? extends DatasetLocUtils.DatasetLoc> exposedDatasets = this.projectsService.getExposedDatasets(contextProjectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : exposedDatasets) {
                relevantProjectKeys.add(datasetLoc.getProjectKey());
            }
            ContainerExecSelection containerSelection = new ContainerExecSelection();
            containerSelection.containerMode = StringUtils.isBlank((String)containerConf) ? ContainerExecSelection.ContainerExecMode.INHERIT : ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER;
            containerSelection.containerConf = containerConf;
            containerExecRuntimeConfig = new ContainerExecConfigSelector().select_autoTXN(authCtx, contextProjectKey, containerSelection);
        }
        try {
            ContainerNotebookThread ft = new ContainerNotebookThread(authCtx, contextProjectKey, connectionFileJson, CodeEnvModel.EnvLang.valueOf(envLang.toUpperCase()), envName, containerExecRuntimeConfig, kernelContext);
            RemoteKernelInfo ret = ft.init();
            FutureResponse<ObjectState> fr = this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<ObjectState>>(){});
            if (fr.hasResult) {
                throw new Exception("Remote kernel thread finished to early, with final state : " + JSON.json((Object)fr.result));
            }
            ret.id = fr.jobId;
            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)ret);
            this.auditTrailService.generic("start-remote-kernel").with("contextProjectKey", contextProjectKey).with("user", authCtx.getAssociatedDSSUser()).emit();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start livy batch for notebook", (Throwable)e);
            this.auditTrailService.failure("start-remote-kernel", (Throwable)e).with("contextProjectKey", contextProjectKey).with("user", authCtx.getAssociatedDSSUser()).emit();
        }
    }

    private static EnvironmentStash getEnvironmentForRemoteKernel(String contextProjectKey, JupyterSecurityService.JupyterKernelContext kernelContext, String envName) {
        EnvironmentStash envStash = new EnvironmentStash();
        envStash.fillDefaultForRemote();
        envStash.fillCommunicationVars();
        envStash.apiTicket = kernelContext.ticketSecret;
        envStash.projectKey = contextProjectKey;
        if (StringUtils.isNotBlank((String)envName)) {
            envStash.env.put("DKU_CODE_ENV_NAME", envName);
        }
        return envStash;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jupyter/poll-remote-kernel"})
    public void pollRemoteKernel(HttpServletRequest req, HttpServletResponse resp, String batchId) throws Exception {
        block19: {
            try (Transaction t = this.transactionService.beginRead();
                 APITicketService.TicketUsage ticketUsage = this.ticketAuthService.getAndUseMandTicket(req);){
                try {
                    FutureResponse fr = this.futureService.getUpdate(batchId);
                    if (fr.hasResult) {
                        logger.debug((Object)("Remote kernel future has final result: " + JSON.json((Object)fr.result)));
                        if (fr.result == null) {
                            ObjectState currentState = new ObjectState();
                            currentState.state = "done";
                            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)currentState);
                        } else {
                            JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)fr.result);
                        }
                        break block19;
                    }
                    FutureThreadBase thread = this.futureService.getThread(batchId);
                    if (thread == null || !(thread instanceof ContainerNotebookThread)) {
                        throw new IllegalArgumentException("Not a remote notebook thread");
                    }
                    ContainerNotebookThread ft = (ContainerNotebookThread)thread;
                    ObjectState currentState = ft.getCurrentState();
                    if (currentState == null) {
                        currentState = new ObjectState();
                        currentState.state = "preparing";
                    }
                    JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)currentState);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to poll livy batch for notebook", (Throwable)e);
                    ObjectState currentState = new ObjectState();
                    currentState.state = "dead";
                    currentState.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
                    JupyterIntercomController.writeJSON((HttpServletResponse)resp, (Object)currentState);
                }
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/jupyter/abort-remote-kernel"})
    public void abortRemoteKernel(HttpServletRequest req, HttpServletResponse resp, String batchId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            APITicketService.TicketUsage ticketUsage = this.ticketAuthService.getAndUseMandTicket(req);
            if (ticketUsage != null) {
                ticketUsage.close();
            }
        }
        logger.info((Object)("Aborting remote kernel futureId=" + batchId));
        this.futureService.abort(batchId);
    }

    public static class ContainerNotebookThread
    extends SimpleFutureThread<ObjectState> {
        private final FuturePayload futurePayload;
        private final String contextProjectKey;
        private final JsonObject connectionFileJson;
        private final JupyterSecurityService.JupyterKernelContext kernelContext;
        private final CodeEnvModel.EnvLang envLang;
        private final String envName;
        private final ContainerExecRuntimeConfig containerExecRuntimeConfig;
        private final String executionId;
        private File kernelRunDir;
        private String state;
        private volatile RegularProcess dockerProcess;

        public ContainerNotebookThread(AuthCtx owner, String contextProjectKey, JsonObject connectionFileJson, CodeEnvModel.EnvLang envLang, String envName, ContainerExecRuntimeConfig containerExecRuntimeConfig, JupyterSecurityService.JupyterKernelContext kernelContext) {
            super(owner);
            this.contextProjectKey = contextProjectKey;
            this.connectionFileJson = connectionFileJson;
            this.envLang = envLang;
            this.envName = envName;
            this.containerExecRuntimeConfig = containerExecRuntimeConfig;
            this.kernelContext = kernelContext;
            this.executionId = KubernetesExecUtils.getNormalizedExecutionId("remote-notebook-" + SecretKeyGenerator.generate((int)8));
            this.state = null;
            this.futurePayload = FuturePayload.newSimple((String)"run_container_nbk", (String)("Containerized " + envLang.getLanguageInfo() + " notebook"));
        }

        public ObjectState getCurrentState() {
            ObjectState ret = new ObjectState();
            ret.appId = this.executionId;
            ret.state = this.state;
            return ret;
        }

        public RemoteKernelInfo init() throws IOException {
            this.state = "preparing";
            this.kernelRunDir = new File(this.kernelContext.processRunDir);
            RemoteKernelInfo remoteKernelId = new RemoteKernelInfo();
            return remoteKernelId;
        }

        @Override
        protected ObjectState compute() throws Exception {
            String notebookId = StringUtils.isBlank((String)this.kernelContext.notebookObjectId) ? "unknown-containerized-notebook" : this.kernelContext.notebookObjectId;
            ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forJupyterNotebookKernel((AuthCtx)this.owner, (String)this.contextProjectKey, (String)notebookId, (String)"unknown-containerized-notebook-session");
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
            try {
                CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(this.envLang, this.envName);
                logger.info((Object)("Connection file for remote kernel is " + JSON.json((Object)this.connectionFileJson)));
                File tmpScriptData = new File(this.kernelRunDir, "launcher.py");
                FileUtils.write((File)tmpScriptData, (CharSequence)"# nothing");
                Object imageId = this.prepareContainerExecution(this.kernelRunDir, this.kernelRunDir, this.containerExecRuntimeConfig.dockerHost, this.containerExecRuntimeConfig.baseImage, codeEnvRef, JSON.json((Object)this.connectionFileJson), FileUtils.readFileToString((File)tmpScriptData));
                if (StringUtils.isNotBlank((String)this.containerExecRuntimeConfig.repositoryURL)) {
                    imageId = PathUtils.slashes((String)this.containerExecRuntimeConfig.repositoryURL, (Boolean)false, (Boolean)true, (boolean)true, (String)"") + (String)imageId;
                }
                RemoteRunEnvDef envResource = new RemoteRunEnvDef();
                envResource.runsRemotely = false;
                envResource.cwd = this.kernelRunDir.getAbsolutePath();
                EnvironmentStash envStash = JupyterIntercomController.getEnvironmentForRemoteKernel(this.contextProjectKey, this.kernelContext, this.envName);
                envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
                envResource.jobId = this.executionId;
                RemoteRunsRegistry.get((String)this.executionId).envResource = envResource;
                switch (this.containerExecRuntimeConfig.type) {
                    case DOCKER: {
                        this.executeDockerNotebook(this.containerExecRuntimeConfig, (String)imageId, this.kernelRunDir, envStash);
                        break;
                    }
                    case KUBERNETES: {
                        this.executeKubernetesNotebook(this.containerExecRuntimeConfig, this.contextProjectKey, (String)imageId, this.kernelRunDir, envStash);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)this.containerExecRuntimeConfig.type));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to run notebook", (Throwable)e);
                ObjectState ret = new ObjectState();
                ret.state = "dead";
                ret.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
                return ret;
            }
            return this.getCurrentState();
        }

        private String prepareContainerExecution(File contextPath, File notebookTmpDir, String dockerHost, String baseImageRef, CodeEnvModel.UsedCodeEnvRef codeEnvRef, String definition, String payload) throws IOException {
            RemoteRunsRegistry.ExecutionType executionType = this.envLang == CodeEnvModel.EnvLang.PYTHON ? RemoteRunsRegistry.ExecutionType.NOTEBOOK_PYTHON : RemoteRunsRegistry.ExecutionType.NOTEBOOK_R;
            String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(codeEnvRef.envName, codeEnvRef.envLang, this.contextProjectKey);
            CodeEnvModel.EnvFullRef env = new CodeEnvModel.EnvFullRef(codeEnvRef.envLang, codeEnvRef.envName, envVersion);
            RemoteRunsRegistry.add(this.executionId, this.owner, this.contextProjectKey, contextPath.getPath(), notebookTmpDir.getPath(), executionType, definition, payload, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(env));
            return ContainerExecImagesHelper.getImageTagToUse(dockerHost, baseImageRef, ContainerExecUtils.BaseImageType.EXEC, codeEnvRef.envLang, codeEnvRef.envName, envVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeDockerNotebook(final ContainerExecRuntimeConfig containerConfig, String imageId, File notebookTmpDir, EnvironmentStash envStash) throws Exception {
            block19: {
                final String containerPodId = "dku_exec-" + this.executionId;
                logger.infoV("Executing notebook on Docker with config=%s, using image '%s', container '%s'", new Object[]{containerConfig.name, imageId, containerPodId});
                List<String> command = DockerExecUtils.getDockerRunCommand(this.owner, this.envLang == CodeEnvModel.EnvLang.PYTHON ? RemoteRunsRegistry.ExecutionType.NOTEBOOK_PYTHON : RemoteRunsRegistry.ExecutionType.NOTEBOOK_R, this.contextProjectKey, "remote-notebook", "python", containerConfig, "--name", containerPodId, "-e", "DKU_API_TICKET=" + this.kernelContext.ticketSecret);
                command.addAll(DockerExecUtils.getEnvironmentCommandFlags(containerConfig));
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.directory(notebookTmpDir);
                pb.command(command);
                pb.environment().put("DKU_API_TICKET", envStash.apiTicket);
                pb.command().add(imageId);
                pb.command().add(this.executionId);
                ContainerExecUtils.enrichDockerEnv(containerConfig, pb.environment());
                logger.info((Object)"Running docker ");
                Thread.sleep(ApplicationConfigurator.getParams().getLongParam("dku.debug.slowDockerStart", 0L));
                try {
                    int returnValue;
                    File logOutputFile = new File(notebookTmpDir, "docker_" + this.jobId + ".log");
                    try (OutputStreamWriter fwr = new OutputStreamWriter((OutputStream)new FileOutputStream(logOutputFile), StandardCharsets.UTF_8);){
                        this.dockerProcess = new RegularProcess(pb, notebookTmpDir);
                        this.dockerProcess.start();
                        this.state = "started";
                        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    logger.info((Object)"Killing docker process");
                                    RegularProcess p = dockerProcess;
                                    if (p != null) {
                                        dockerProcess.evilKill();
                                    }
                                }
                                catch (IOException e) {
                                    logger.error((Object)"Failed to kill docker process", (Throwable)e);
                                }
                                logger.warn((Object)("Abort received, will kill Docker container " + containerPodId));
                                HashMap env = Maps.newHashMap();
                                ContainerExecUtils.enrichDockerEnv(containerConfig, env);
                                ContainerExecUtils.killDockerContainer(containerPodId, true, env, logger);
                            }
                        });){
                            DKUtils.ExecOutputConsumer eoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)fwr, false)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)fwr, false));
                            eoc.start(this.dockerProcess.getInputStream(), this.dockerProcess.getErrorStream(), null);
                            returnValue = this.dockerProcess.waitFor();
                            this.state = returnValue == 0 ? "done" : "failed";
                            eoc.finish();
                        }
                    }
                    logger.info((Object)("docker process returned " + returnValue));
                    if (returnValue == 0) break block19;
                    File errorFile = new File(notebookTmpDir, "error.json");
                    if (errorFile.isFile()) {
                        logger.info((Object)("Error file found, trying to throw it: " + String.valueOf(errorFile)));
                        SerializedError err = null;
                        try {
                            err = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
                            logger.info((Object)("Error is" + JSON.json((Object)err)));
                        }
                        catch (Throwable t) {
                            logger.error((Object)"Could not parse error file", t);
                        }
                        if (err != null) {
                            throw new APIError.SerializedErrorException(err);
                        }
                        break block19;
                    }
                    throw new CodedException((InfoMessage.MessageCode)ContainerExecCodes.ERR_DOCKER_FAILED, "Docker process failed before container was running, check docker log");
                }
                finally {
                    RemoteRunsRegistry.remove(this.executionId);
                }
            }
        }

        private void executeKubernetesNotebook(final ContainerExecRuntimeConfig containerConfig, String projectKey, String imageId, File notebookTmpDir, EnvironmentStash envStash) throws Exception {
            logger.infoV("Executing notebook on Kubernetes with config=%s, using image '%s'", new Object[]{containerConfig.name, imageId});
            final File secretFile = new File(notebookTmpDir, "secret_" + this.jobId + ".yaml");
            final File podFile = new File(notebookTmpDir, "pod_" + this.jobId + ".yaml");
            ArrayList podStartFiles = Lists.newArrayList((Object[])new String[]{"-f", secretFile.getAbsolutePath(), "-f", podFile.getAbsolutePath()});
            KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.owner, this.executionId, containerConfig);
            String secretDesc = KubernetesExecUtils.getTicketSecretConf(this.executionId, this.kernelContext.ticketSecret);
            String podDesc = KubernetesExecUtils.getPodConf(this.owner, this.executionId, this.contextProjectKey, "remote-notebook", "python", laa, Collections.emptyMap(), imageId, containerConfig);
            DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
            DKUFileUtils.writeFileUTF8((File)podFile, (String)podDesc);
            boolean deleteK8sPod = true;
            logger.info((Object)"Running kubectl ");
            String k8sClusterId = new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.KUBERNETES);
            K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = containerConfig.kubernetesResources;
            ComputeResourceUsage cru = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)this.executionId, (IK8SContainerLimits)k8sContainerLimits).reportStartNoFail();
            try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    logger.warn((Object)"Abort received, will kill Kubernetes pod ");
                    try {
                        KubernetesExecUtils.deleteFromFiles(owner, contextProjectKey, containerConfig, true, Lists.newArrayList((Object[])new File[]{podFile, secretFile}));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Could not stop Kubernetes pod", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.error((Object)"Interrupted while stopping Kubernetes pod", (Throwable)e);
                    }
                }
            });){
                this.state = "starting";
                String podName = KubernetesExecUtils.getPodName(this.executionId);
                KubernetesExecUtils.createPod(this.owner, projectKey, containerConfig, podName, secretFile, podFile, notebookTmpDir);
                Exception exception = null;
                try {
                    logger.info((Object)"Waiting for kubernetes logs availability");
                    exception = KubernetesExecUtils.waitForLogStart(this.owner, this.contextProjectKey, podName, containerConfig);
                    if (exception != null) {
                        throw exception;
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Will not delete kubernetes pod for debugging");
                    deleteK8sPod = false;
                    throw e;
                }
                this.state = "started";
                File logOutputFile = new File(notebookTmpDir, "kube_" + this.jobId + ".log");
                int logReturnValue = KubernetesExecUtils.streamLogsUntilPodsAreDone(this.owner, projectKey, notebookTmpDir, podName, containerConfig, logOutputFile);
                logger.info((Object)("kubectl process returned " + logReturnValue));
                if (logReturnValue != 0) {
                    logger.error((Object)"Could not get kubernetes pod logs");
                    logger.warn((Object)"Will not delete kubernetes pod for debugging");
                    deleteK8sPod = false;
                    throw new Exception("kubectl failed to start pod : " + logReturnValue);
                }
                this.state = "done";
            }
            catch (Exception e) {
                logger.error((Object)"Kubernetes notebook failed", (Throwable)e);
                this.state = "failed";
                throw e;
            }
            finally {
                cru.reportCompleteNoFail();
                RemoteRunsRegistry.remove(this.executionId);
                if (deleteK8sPod) {
                    logger.info((Object)"Cleaning Kubernetes pod");
                    try {
                        KubernetesExecUtils.delete(this.owner, this.contextProjectKey, containerConfig, true, podStartFiles.toArray(new String[0]));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Could not stop Kubernetes pod", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.error((Object)"Interrupted while stopping Kubernetes pod", (Throwable)e);
                    }
                }
            }
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    public static class RemoteKernelInfo {
        String id;
    }

    public static class ObjectState {
        public int id;
        public String state;
        public String appId;
        public String errorMessage;
    }
}

