/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.dataflow.streaming.DataframePreparationExecutor;
import com.dataiku.dip.dataflow.streaming.DataframePreparationRequest;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.datasets.EditableDatasetService;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.DatasetStreamService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DatasetsIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private EditableDatasetService editableDatasetService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private MeaningsDAO meaningsDAO;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private DatasetStreamService datasetStreamService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.streaming");

    @PostConstruct
    void init() {
        logger.debug((Object)"Init dataset write service");
        this.datasetWritingService.configureForBackend(this.pubSub);
        logger.debug((Object)"Done init dataset write service");
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/set-schema"})
    public void setSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName, String schemaData, String dropAndCreate, @RequestParam(required=false) String origin) throws Exception {
        Schema ss = (Schema)JSON.parse((String)schemaData, Schema.class);
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        boolean dropAndRecreate = !StringUtils.isBlank((String)dropAndCreate) && Boolean.parseBoolean(dropAndCreate);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.projectsService.checkPerm(t.getUser(), ds.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (this.datasetWritingService.writeDatasetSchema(t.getUser(), ds, ss, dropAndRecreate, origin)) {
                t.commit("Updated dataset \"" + fullDatasetName + "\" schema");
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/get-schema"})
    public void getSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName) throws Exception {
        Dataset dataset;
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, ds);
            dataset = this.datasetAccessService.getMandatory(ds.getProjectKey(), ds.getName());
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)dataset.getSchema());
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/get-settings/"})
    @ResponseBody
    public SerializedDataset getDatasetSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName) throws Exception {
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();){
            SerializedDataset serializedDataset;
            block12: {
                AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
                try {
                    this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtxUsage.getAuthCtx(), ds);
                    serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(ds);
                    if (authCtxUsage == null) break block12;
                }
                catch (Throwable throwable) {
                    if (authCtxUsage != null) {
                        try {
                            authCtxUsage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                authCtxUsage.close();
            }
            return serializedDataset;
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/list-partitions"})
    public void listPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, ds);
            dataset = this.datasetAccessService.getMandatory(ds.getProjectKey(), ds.getName());
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)ds.getProjectKey(), (String)ds.getName()));
        }
        ArrayList<String> list = new ArrayList<String>();
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            for (Partition p : PartitioningUtils.sort(dh.listPartitions(), true)) {
                list.add(p.id());
            }
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/get-metadata"})
    public void getMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName) throws Exception {
        Dataset dataset;
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, ds);
            dataset = this.datasetAccessService.getMandatory(ds.getProjectKey(), ds.getName());
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)DatasetInspector.getMetadata(dataset));
    }

    @AuditedCall(value={"msgType", "dataset-save-meta", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/write-metadata"})
    public void writeMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName, @RequestParam String metadata) throws Exception {
        ObjectCompleteMetadata om = (ObjectCompleteMetadata)JSON.parse((String)metadata, ObjectCompleteMetadata.class);
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        logger.info((Object)("Writing metadata for dataset " + ds.getFullName()));
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.projectsService.checkPerm(t.getUser(), ds.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.datasetWritingService.writeDatasetMetadata(t.getUser(), ds, om);
            t.commit("Updated dataset meta for " + fullDatasetName + " from intercom API");
        }
    }

    @AuditedCall(value={"msgType", "dataset-clear-samples", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/clear-samples"})
    public void clearDatasetSamples(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName) throws Exception {
        Dataset dataset;
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.datasetAccessService.getMandatory(loc.getProjectKey(), loc.getName());
        }
        SampleBuilder.clearSamplesWithLock(dataset);
    }

    @AuditedCall(value={"msgType", "init-write-session"})
    @RequestMapping(value={"/api/tintercom/datasets/init-write-session"}, method={RequestMethod.POST})
    public void initSession(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.datasetWritingService.initSession(authCtx, req, resp);
        }
    }

    @AuditedCall(value={"msgType", "wait-write-session"})
    @RequestMapping(value={"/api/tintercom/datasets/wait-write-session"}, method={RequestMethod.GET})
    public void waitSession(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.datasetWritingService.waitSession(authCtx, req, resp);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/datasets/push-data"}, method={RequestMethod.PUT, RequestMethod.POST})
    public void pushData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, null);
            this.datasetWritingService.pushDataAtOnce(authCtx, req, resp);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/datasets/push-data-continuous"}, method={RequestMethod.PUT, RequestMethod.POST})
    public void pushDataContinuous(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, null);
            this.datasetWritingService.pushDataContinuous(authCtx, req, resp);
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-continuous-state"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/get-continuous-state"})
    public void getContinuousState(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        JsonObject ret = new JsonObject();
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            ret.addProperty("state", this.datasetWritingService.getContinuousState(authCtx, req));
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-write-continuous-state"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/checkpoint-continuous"})
    public void checkpointContinuous(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.datasetWritingService.checkpointContinuous(authCtx, req);
        }
    }

    @AuditedCall(value={"msgType", "dataset-close-continuous"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/close-continuous"})
    public void closeContinuous(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.datasetWritingService.closeContinuous(authCtx, req);
        }
    }

    @AuditedCall(value={"msgType", "init-preparation-session"})
    @RequestMapping(value={"/api/tintercom/datasets/init-preparation-session"}, method={RequestMethod.POST})
    public void initProcessSession(HttpServletRequest req, HttpServletResponse resp, @RequestParam DataframePreparationRequest request) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, request.contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        DataframePreparationExecutor preparationExecutor = new DataframePreparationExecutor();
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)preparationExecutor.initSession(authCtx, request));
    }

    @AuditedCall(value={"msgType", "dataset-read-data", "fullDatasetName", "${fullDatasetName}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/datasets/stream-prepared-dataset"})
    public void streamPreparedDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullDatasetName, @RequestParam String script, @RequestParam String requestedOutputSchema, @RequestParam(value="partitions", required=false) String partitions, @RequestParam(value="sampling", required=false) String sampling, @RequestParam(value="contextProjectKey", required=false) String contextProjectKey, @RequestParam(required=false) String readSessionId) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, ds);
            dataset = this.datasetAccessService.getMandatory(ds.getProjectKey(), ds.getName());
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)ds.getProjectKey(), (String)ds.getName()));
        }
        this.datasetStreamService.streamPreparedDataset(resp, fullDatasetName, script, requestedOutputSchema, partitions, sampling, ds, dataset, authCtx, contextProjectKey, readSessionId);
    }

    @AuditedCall(value={"msgType", "dataset-editable-save", "projectKey", "${projectKey}", "datasetName", "${datasetName"})
    @RequestMapping(value={"/api/tintercom/datasets/editable/save"})
    public void saveEditableDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataset, @RequestParam String data) throws Exception {
        EditableDatasetService.EditableDatasetSaveResult res;
        Dataset ds;
        EditableDatasetService.EditableDatasetSaveQuery query = (EditableDatasetService.EditableDatasetSaveQuery)JSON.parse((String)data, EditableDatasetService.EditableDatasetSaveQuery.class);
        logger.info((Object)("Saved editable dataset " + dataset));
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.projectsService.checkPerm(t.getUser(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ds = this.datasetAccessService.getMandatory(projectKey, dataset);
            this.editableDatasetService.checkEditable(ds);
            if (!query.force) {
                VersionTag.ConflictCheckResult ccr = this.conflictCheckService.checkConflict(ds.serialize().versionTag, query.versionTag);
                if (!ccr.canBeSaved) {
                    DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)ccr);
                    return;
                }
            }
            res = this.editableDatasetService.save(ds, query, t.getUser());
            t.commit("Saved editable dataset: " + ds.getFullName());
        }
        this.datasetDeletionService.clearCacheAndStatus_NT(ds);
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "managed-folder-get-path", "projectKey", "${projectKey}", "folderId", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/get-info"})
    @ResponseBody
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getManagedFolderPath(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam(required=false) boolean sensitiveInfo) throws Exception {
        ManagedFolder box;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        return CodeBasedRecipeDatasetInfoHelper.getManagedFolderLocationInfo_NT(authCtx, box, sensitiveInfo);
    }

    @AuditedCall(value={"msgType", "managed-folder-ensure-direct-access", "projectKey", "${projectKey}", "folderId", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/ensure-direct-access"})
    public void getManagedFolderAccess(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup) throws Exception {
        ManagedFolder box;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.kernelsManagedFolderService.access(authCtx, box));
    }

    @AuditedCall(value={"msgType", "managed-folder-get-path", "projectKey", "${projectKey}", "folderId", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/get-partition-paths"})
    @ResponseBody
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getManagedFolderPaths(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam(required=false) String partition) throws Exception {
        ManagedFolder mf;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        return this.kernelsManagedFolderService.getPartitionPaths_NT(authCtx, mf, partition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "managed-folder-read-meta", "projectKey", "${projectKey}", "folderId", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/list-partitions"})
    public void listFolderPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup) throws Exception {
        ManagedFolderHandler handler;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            ManagedFolder box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            handler = (ManagedFolderHandler)box.buildHandler(authCtx);
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Partition p : PartitioningUtils.sort(handler.listPartitions(), true)) {
                list.add(p.id());
            }
            DatasetsIntercomController.writeJSON((HttpServletResponse)resp, list);
        }
        finally {
            handler.close();
        }
    }

    @AuditedCall(value={"msgType", "managed-folder-clear", "projectKey", "${projectKey}", "folderId", "${lookup}", "partition", "${partition}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/clear-partition"})
    public void clearManagedFolderPartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam String partition) throws Exception {
        block21: {
            ManagedFolder box;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();
                 AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
                authCtx = authCtxUsage.getAuthCtx();
                box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            }
            try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(authCtx);){
                if (StringUtils.isBlank((String)partition)) {
                    handler.clear();
                    break block21;
                }
                if (box.isPartitioned()) {
                    Partition p = PartitionFactory.fromIdentifier(box.getPartitioningSchema(), partition);
                    handler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
                    break block21;
                }
                throw new IllegalArgumentException("Can not specify a partition to delete on a non-partitioned folder");
            }
        }
    }

    @AuditedCall(value={"msgType", "managed-folder-clear", "projectKey", "${projectKey}", "folderId", "${lookup}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/clear-path"})
    public void clearManagedFolderPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam String path) throws Exception {
        ManagedFolder box;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(authCtx);){
            handler.delete(path);
        }
    }

    @AuditedCall(value={"msgType", "managed-folder-get-path-details", "projectKey", "${projectKey}", "folderId", "${lookup}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/get-path-details"})
    public void getManagedFolderPathDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam String path) throws Exception {
        ManagedFolder box;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(authCtx);){
            DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)handler.browse(path));
        }
    }

    @AuditedCall(value={"msgType", "managed-folder-download", "projectKey", "${projectKey}", "folderId", "${lookup}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/download-path"})
    public void getManagedFolderDownloadPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam String path) throws Exception {
        ManagedFolder box;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(authCtx);){
            EnrichedInputStream eis = handler.getInputStream(path);
            this.kernelsManagedFolderService.sendFileAsUrl(resp, eis);
        }
    }

    @AuditedCall(value={"msgType", "managed-folder-upload", "projectKey", "${projectKey}", "folderId", "${lookup}", "path", "${path}"})
    @RequestMapping(value={"/api/tintercom/managed-folders/upload-path"})
    public void getManagedFolderUploadPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam String path) throws Exception {
        ManagedFolder box;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(authCtx);
             OutputStream os = handler.getOutputStream(path);
             ServletInputStream is = req.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/get-location-info/"})
    @ResponseBody
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getDatasetLocationInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) boolean sensitiveInfo) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, new AnyLoc(projectKey, datasetName));
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        return new CodeBasedRecipeDatasetInfoHelper().getDatasetLocationInfo_NT(authCtx, dataset, sensitiveInfo);
    }

    @AuditedCall(value={"msgType", "dataset-clear-data-partitions", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitions", "${partition}"})
    @RequestMapping(value={"/api/tintercom/datasets/clear-partition/"})
    public void clearPartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partition) throws Exception {
        Dataset dataset = null;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, dataset.getLoc(), Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forDatasetClearing((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            Partition p = PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), partition);
            dh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
        }
    }

    @AuditedCall(value={"msgType", "dataset-clear-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/clear/"})
    public void clearData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        Dataset dataset = null;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, dataset.getLoc(), Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forDatasetClearing((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            dh.clearAllDataAndStructure();
        }
    }

    @AuditedCall(value={"msgType", "prepare-sql-table-for-write", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/prepare-sql-table-for-write/"})
    public void prepareSqlTableForWrite(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="partition", required=false) String partition, @RequestParam String writeMode, @RequestParam String datasetName) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getWithContextFromAny(req);){
            authCtx = authCtxUsage.getAuthCtx();
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, dataset.getLoc(), Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
        }
        logger.info((Object)("Prepare SQL table for write " + datasetLoc.getFullName()));
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);){
            if (datasetHandler instanceof AbstractSQLTableDatasetHandler) {
                PartitioningScheme partitioningSchema = dataset.getPartitioningSchema();
                Partition targetPartition = partitioningSchema.isPartitioned() ? PartitionFactory.fromIdentifier(partitioningSchema, partition) : null;
                ((AbstractSQLTableDatasetHandler)datasetHandler).prepareSqlTableForWrite(authCtx, targetPartition, Output.WriteMode.valueOf((String)writeMode), messages);
            } else {
                logger.warnV("Dataset %s not a SQL-table based dataset", new Object[]{datasetName});
            }
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditedCall(value={"msgType", "expand-sql-query-for-partition", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitions", "${partition}"})
    @RequestMapping(value={"/api/tintercom/datasets/expand-sql-query-for-partition/"})
    public void expandSQLQueryForPartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partition) throws Exception {
        block20: {
            Dataset dataset;
            AuthCtx authCtx;
            try (Transaction ignored = this.transactionService.beginRead();
                 AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
                authCtx = authCtxUsage.getAuthCtx();
                dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
                this.permissionsService.checkDatasetPrivileges(authCtx, dataset.getLoc(), Privileges.DatasetLevelPrivilegeType.READ_DATA);
            }
            try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
                if (dh instanceof AbstractSQLQueryDatasetHandler) {
                    Partition p = PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), partition);
                    String query = ((AbstractSQLQueryDatasetHandler)dh).expandQueryForPartition(p);
                    DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)query);
                    break block20;
                }
                throw new IllegalArgumentException(String.format("Dataset %s not a SQL-query based dataset", datasetName));
            }
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/get-files-info/"})
    public void getDatasetFilesInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(value="partitions") String partitionExpression) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        List partitions = (List)JSON.parse((String)partitionExpression, (TypeToken)new TypeToken<List<String>>(){});
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, new AnyLoc(projectKey, datasetName));
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)CodeBasedRecipeDatasetInfoHelper.getDatasetFilesInfo(authCtx, dataset, partitions));
    }

    @AuditedCall(value={"msgType", "dataset-read-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/read-data"})
    public void streamData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(value="format", defaultValue="json") String format, @RequestParam(value="formatParams", defaultValue="") String formatParams, @RequestParam(value="sampling", defaultValue="") String sampling, @RequestParam(value="columns", defaultValue="") String columns, @RequestParam(value="partitions", defaultValue="") String partitions, @RequestParam(value="filter", defaultValue="") String filterExpression, @RequestParam(required=false) String readSessionId) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, new AnyLoc(projectKey, datasetName));
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        this.datasetStreamService.doStream(resp, authCtx, dataset, format, DatasetReadAPIUtils.formatParamsFromString(formatParams), DatasetReadAPIUtils.columnsListFromString(columns), partitions, filterExpression, DatasetReadAPIUtils.samplingParamFromString(sampling), readSessionId);
    }

    @AuditedCall(value={"msgType", "dataset-read-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/read-data2"})
    public void streamData2(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String settings) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, new AnyLoc(projectKey, datasetName));
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        DatasetReadAPIUtils.DatasetStreamingRequestSettings reqSettings = (DatasetReadAPIUtils.DatasetStreamingRequestSettings)JSON.parse((String)settings, DatasetReadAPIUtils.DatasetStreamingRequestSettings.class);
        logger.infoV("Streaming dataset %s using settings: %s", new Object[]{dataset.getFullName(), JSON.jsonExceptRecursive((Object)reqSettings, Collections.singleton("password"))});
        this.datasetStreamService.doStream(resp, authCtx, dataset, reqSettings.format, reqSettings.formatParams, reqSettings.columns, reqSettings.partitions, reqSettings.filterExpression, reqSettings.sampling, reqSettings.readSessionId);
    }

    @AuditedCall(value={"msgType", "dataset-verify-read", "readSessionId", "${readSessionId}"})
    @RequestMapping(value={"/api/tintercom/datasets/verify-read"})
    public void verifyDatasetStream(HttpServletRequest req, HttpServletResponse resp, @RequestParam String readSessionId) throws Exception {
        try (AuthCtxUsage ignored = this.authService.getTicketOrKeyAndContext_NT(req);){
            this.datasetStreamService.verifyRead(readSessionId);
            resp.setStatus(200);
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/datasets/read-config/"})
    public void readDatasetConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        Validate.notEmpty((String)projectKey);
        Validate.notEmpty((String)datasetName);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, new AnyLoc(projectKey, datasetName));
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, datasetName);
            if (sd == null) {
                throw new IllegalArgumentException("Dataset not found (" + projectKey + " . " + datasetName + ")");
            }
            DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)sd);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/meanings/list/"})
    public void listTables(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            MeaningsDAO.MeaningsList list = new MeaningsDAO.MeaningsList();
            list.meanings.addAll(this.meaningsDAO.listUnsafe());
            DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)list);
        }
    }

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/tintercom/projects/list-accessible"})
    public void listAccessibleProjects(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ArrayList projectKeys = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
                if (!this.permissionsService.hasAnyProjectAccess(authCtx, sp)) continue;
                projectKeys.add(sp.projectKey);
            }
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)projectKeys);
    }

    @AuditedCall(value={"msgType", "project-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/projects/get"})
    public void getProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        SerializedProject sp;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            if (!this.permissionsService.hasAnyProjectAccess(authCtx, projectKey)) {
                throw new UnauthorizedException("Action forbidden", "project-authorization-failure");
            }
            sp = this.projectsService.getMandatoryUnsafe(projectKey);
        }
        DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)sp);
    }

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/datasets/list"})
    public void listDatasets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        Validate.notEmpty((String)projectKey);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ArrayList datasetNames = Lists.newArrayList();
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                datasetNames.add(sd.name);
            }
            DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)datasetNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-detect-format", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/datasets/detect-one-format"})
    public void detectOneFormat(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam String format) throws Exception {
        FSLikeDatasetTestHandler testHandler;
        AuthCtx authCtx;
        Validate.notEmpty((String)projectKey);
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedDataset sds = (SerializedDataset)JSON.parse((String)data, SerializedDataset.class);
            if (StringUtils.isNotBlank((String)sds.getParams().getConnection())) {
                this.connectionsService.checkUserForConnection(authCtx, sds.getParams().getConnection());
            }
            String fullName = (sds.projectKey == null ? projectKey : sds.projectKey) + "." + (sds.name == null ? "fakeDataset" : sds.name);
            Dataset dataset = Dataset.fromSerialized(fullName, sds);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback(req, authCtxUsage, u -> ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)u, (String)dataset.getProjectKey(), (String)dataset.getName()));
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, FSLikeDatasetTestHandler.class);
        }
        try {
            DatasetsIntercomController.writeJSON((HttpServletResponse)resp, (Object)testHandler.detectOneFormat(authCtx, format));
        }
        finally {
            testHandler.close();
        }
    }

    public static class FullNameTransformer
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.has(new String[]{"fullDatasetName"})) {
                AnyLoc loc = AnyLoc.resolveFull(obj.get().get("fullDatasetName").getAsString());
                obj.with("projectKey", loc.getProjectKey());
                obj.with("datasetName", loc.getId());
            }
        }
    }
}

