/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.analysis.ml.hf.HuggingFaceClient;
import com.dataiku.dip.analysis.ml.hf.ModelCacheService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ModelCacheIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private ModelCacheService modelCacheService;
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private FutureService futureService;

    @AuditedCall(value={"msgType", "ml-hf-cache-model-local-path", "modelKey", "${modelKey}"})
    @RequestMapping(value={"api/tintercom/ml/hf/model/local-path"}, method={RequestMethod.GET})
    @ResponseBody
    public LocalModelInfo getModelLocalPath(HttpServletRequest req, @RequestParam String modelKey) throws Exception {
        AuthCtx authCtx;
        try (APITicketService.TicketUsage ticket = this.authService.getAndUseMandTicket(req);){
            authCtx = ticket.getAuthCtx();
        }
        LocalModelInfo resp = new LocalModelInfo(this.modelCacheService.getLocalModelPath(modelKey));
        this.modelCacheService.updateModelLastUsage(new ModelCacheService.ModelStorageDefinition(modelKey), authCtx);
        return resp;
    }

    @AuditedCall(value={"msgType", "ml-hf-cache-model-base-model-key", "modelKey", "${modelKey}"})
    @RequestMapping(value={"api/tintercom/ml/hf/model/base-model-key"}, method={RequestMethod.GET})
    @ResponseBody
    public String getBaseModelKey(HttpServletRequest req, @RequestParam String modelKey) throws Exception {
        AuthCtx authCtx;
        try (APITicketService.TicketUsage ticket = this.authService.getAndUseMandTicket(req);){
            authCtx = ticket.getAuthCtx();
        }
        String resp = this.modelCacheService.getBaseModelKey(modelKey);
        this.modelCacheService.updateModelLastUsage(new ModelCacheService.ModelStorageDefinition(modelKey), authCtx);
        return resp;
    }

    @AuditedCall(value={"msgType", "ml-hf-cache-model-download", "modelKey", "${modelKey}"})
    @RequestMapping(value={"api/tintercom/ml/hf/download-model-if-needed"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Void> downloadModel(HttpServletRequest req, final @RequestParam String modelKey, final @RequestParam(required=false) String connectionName) throws Exception {
        DSSAuthCtx authCtx;
        try (APITicketService.TicketUsage ticket = this.authService.getAndUseMandTicket(req);){
            authCtx = (DSSAuthCtx)ticket.getAuthCtx();
        }
        return this.futureService.runFuture(new SimpleFutureThread<Void>((AuthCtx)authCtx){

            @Override
            protected Void compute() throws Exception {
                ModelCacheIntercomController.this.modelCacheService.downloadModelIfNeeded_Check(modelKey, authCtx, connectionName);
                return null;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"download-hf-model", (String)("Downloading model '" + modelKey + "' from Hugging Face"));
            }
        }, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    @AuditedCall(value={"msgType", "ml-hf-cache-model-metadata", "modelKey", "${modelKey}"})
    @RequestMapping(value={"api/tintercom/ml/hf/model/metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public ModelCacheService.ModelMetadata getMetadata(HttpServletRequest req, @RequestParam String modelKey, @RequestParam(required=false) String connectionName) throws Exception {
        DSSAuthCtx authCtx;
        try (APITicketService.TicketUsage ticket = this.authService.getAndUseMandTicket(req);){
            authCtx = (DSSAuthCtx)ticket.getAuthCtx();
        }
        return this.modelCacheService.getModelMetadata_Check(modelKey, authCtx, connectionName);
    }

    @ExceptionHandler(value={ModelCacheService.BadModelKeyException.class})
    @ResponseBody
    public ResponseEntity<?> handleBadModelKeyException(ModelCacheService.BadModelKeyException e) {
        return ModelCacheIntercomController.handleException((Exception)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    public ResponseEntity<?> handleUnauthorizedException(UnauthorizedException e) {
        return ModelCacheIntercomController.handleException((Exception)((Object)e), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HuggingFaceClient.HuggingFaceResponseException.class})
    @ResponseBody
    public ResponseEntity<?> handleHuggingFaceResponseException(HuggingFaceClient.HuggingFaceResponseException e) {
        return ModelCacheIntercomController.handleException((Exception)((Object)e), e.getStatusCode());
    }

    @ExceptionHandler(value={ModelCacheService.ModelNotFoundException.class})
    @ResponseBody
    public ResponseEntity<?> handleHuggingFaceResponseException(ModelCacheService.ModelNotFoundException e) {
        return ModelCacheIntercomController.handleException((Exception)e, HttpStatus.NOT_FOUND);
    }

    private static ResponseEntity<?> handleException(Exception e, HttpStatus responseStatusCode) {
        return ModelCacheIntercomController.handleException(e, responseStatusCode.value());
    }

    private static ResponseEntity<?> handleException(Exception e, int responseStatusCode) {
        String bodyJson = e.toString();
        return ResponseEntity.status((int)responseStatusCode).contentType(MediaType.APPLICATION_JSON).body((Object)bodyJson);
    }

    public static class LocalModelInfo {
        public final String modelPath;

        LocalModelInfo(String modelPath) {
            this.modelPath = modelPath;
        }
    }
}

