/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.factory.MailSenderFactory;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.variables.VariablesService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailNotificationsSender {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private IntegrationChannelsDAO integrationChannelsDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private MailSenderFactory mailSenderFactory;
    @Nullable
    private String customChannelId;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.emails");

    public EmailNotificationsSender() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public EmailNotificationsSender(String customChannelId) {
        this();
        this.customChannelId = customChannelId;
    }

    public Future<InfoMessage.InfoMessages> sendToUser(String recipientEmailAddress, UserSettingsService.EmailNotificationsSettings params, String body) throws Exception {
        List<IntegrationChannel> channels;
        GeneralSettingsDAO.GeneralSettings settings;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            settings = this.generalSettingsDAO.read();
            channels = this.integrationChannelsDAO.list();
        }
        return this.sendToUser(recipientEmailAddress, params, settings, channels, EmailNotificationsSender.makeHtmlMultipartBody(body));
    }

    public Future<InfoMessage.InfoMessages> sendToUser(String recipientEmailAddress, UserSettingsService.EmailNotificationsSettings params, Multipart content) throws Exception {
        List<IntegrationChannel> channels;
        GeneralSettingsDAO.GeneralSettings settings;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            settings = this.generalSettingsDAO.read();
            channels = this.integrationChannelsDAO.list();
        }
        return this.sendToUser(recipientEmailAddress, params, settings, channels, content);
    }

    public Future<InfoMessage.InfoMessages> sendToUser(String recipientAddress, UserSettingsService.EmailNotificationsSettings params, GeneralSettingsDAO.GeneralSettings settings, List<IntegrationChannel> channels, Multipart content) throws Exception {
        if (!params.enabled) {
            logger.info((Object)"Emails are disabled, not sending");
            InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
            infoMessages.addMessage(InfoMessage.error((String)"Emails disabled", (String)("Mail has not been sent to \"" + recipientAddress + "\" because emails are disabled.")));
            return CompletableFuture.completedFuture(infoMessages);
        }
        if (recipientAddress == null) {
            throw new IllegalArgumentException("Unknown user email");
        }
        String channelId = StringUtils.defaultIfBlank((String)this.customChannelId, (String)settings.notifications.emailChannelId);
        IntegrationChannel channel = channels.stream().filter(chan -> channelId.equals(chan.id)).findFirst().orElse(null);
        String dssEmail = settings.studioMailAddress;
        if (channel == null) {
            throw new NotFoundException("The integration channel does not exist: " + channelId);
        }
        AbstractMailSender sender = this.mailSenderFactory.createMailSenderWithoutPermissionCheck(channel);
        String senderAddress = sender.getConfiguration().computeFromField(null, null, dssEmail);
        Session session = sender.newSession();
        Message msg = this.makeMessage(session, params, senderAddress, recipientAddress, content);
        logger.info((Object)"Message ready to be sent");
        return sender.startSending(session, msg);
    }

    private Message makeMessage(Session session, UserSettingsService.EmailNotificationsSettings params, String senderAddress, String recipientAddress, Multipart content) throws Exception {
        MimeMessage mail = new MimeMessage(session);
        mail.setFrom((Address)this.makeSenderAddress(senderAddress, recipientAddress));
        mail.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipientAddress));
        mail.setSubject(EmailNotificationsSender.makeSubject(params));
        mail.setContent(content);
        return mail;
    }

    private static Multipart makeHtmlMultipartBody(String body) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body, "utf-8", "html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        return multipart;
    }

    private static String makeSubject(UserSettingsService.EmailNotificationsSettings params) {
        return StringUtils.isNotBlank((String)params.subject) ? params.subject : "Dataiku DSS report";
    }

    private InternetAddress makeSenderAddress(String senderAddress, String recipientAddress) throws AddressException {
        String parsedSenderAddress;
        if (StringUtils.isNotBlank((String)senderAddress)) {
            VariableLookup lookup = new VariableLookup();
            lookup.setVariablesContext(this.variablesService.getGlobalContext());
            StrSubstitutor substitutor = new StrSubstitutor((StrLookup)lookup);
            parsedSenderAddress = substitutor.replace(senderAddress);
        } else {
            parsedSenderAddress = recipientAddress;
        }
        return new InternetAddress(parsedSenderAddress);
    }
}

