/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.analysis.ml.hf.HuggingFaceClient;
import com.dataiku.dip.analysis.ml.vectorstore.AzureAISearchRestClient;
import com.dataiku.dip.analysis.ml.vectorstore.PineconeRestClient;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AnthropicConnection;
import com.dataiku.dip.connections.AzureAISearchConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.AzureLLMConnection;
import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.connections.AzureOpenAIConnection;
import com.dataiku.dip.connections.BedrockConnection;
import com.dataiku.dip.connections.CassandraConnection;
import com.dataiku.dip.connections.CassandraUtil;
import com.dataiku.dip.connections.CohereConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.CustomLLMConnection;
import com.dataiku.dip.connections.DatabricksLLMConnection;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.GoogleUserAgentBuilder;
import com.dataiku.dip.connections.HuggingFaceInferenceAPIConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.connections.MistralAIConnection;
import com.dataiku.dip.connections.MongoDBConnection;
import com.dataiku.dip.connections.MosaicMLConnection;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.connections.PineconeConnection;
import com.dataiku.dip.connections.PostgreSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLDriverLoader;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.connections.SageMakerConnection;
import com.dataiku.dip.connections.SageMakerGenericLLMConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.connections.SnowflakeCortexLLMConnection;
import com.dataiku.dip.connections.TwitterConnection;
import com.dataiku.dip.connections.VertexAILLMConnection;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchHttpClient;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.datasets.fs.AzureBlobModel;
import com.dataiku.dip.datasets.fs.GCSclient;
import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModel;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClientFactory;
import com.dataiku.dip.llm.online.sagemakergeneric.GenericLLMHandling;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.streaming.endpoints.kafka.JSONKafkaFormat;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.s3.AmazonS3Client;
import com.dataiku.dss.shadelib.com.databricks.sdk.core.error.platform.NotFound;
import com.dataiku.dss.shadelib.com.databricks.sdk.service.catalog.VolumeInfo;
import com.dataiku.dss.shadelib.com.databricks.sdk.service.catalog.VolumesAPI;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.exception.AwsServiceException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

@Service
public class ConnectionsTestService {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLConnectionTestResult testSQL_NOTRANSACTION(String targetProjectKey, AbstractSQLConnection connection, AuthCtx authCtx) throws Exception {
        JsonObject testPayload;
        block24: {
            SQLConnectionProvider.SQLConnectionWrapper jdbcConn;
            SQLConnectionProvider.SQLConnectionData cd;
            StringTransmogrifier st2 = new StringTransmogrifier();
            try (Transaction t = this.transactionService.beginRead();){
                if (!StringUtils.isBlank((String)targetProjectKey)) {
                    for (SerializedDataset d : this.dao.listUnsafe(targetProjectKey)) {
                        st2.addAlreadyTransmogrified(d.name);
                    }
                }
            }
            CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)targetProjectKey, null));
            try {
                connection.checkConfiguration();
                cd = connection.getConnectionData_NT(authCtx, null);
            }
            catch (Exception e) {
                logger.error((Object)"Configuration error", (Throwable)e);
                return SQLConnectionTestResult.error(e);
            }
            String driverClass = cd.getDriver(authCtx, null);
            if (driverClass != null) {
                try {
                    SQLDriverLoader.loadDriver(driverClass, cd.getJarsDirectory(), cd.getJarsFallThroughPackages(), cd.getJarsNonFallThroughPackages());
                }
                catch (CodedSQLException e) {
                    logger.error((Object)"Driver error", (Throwable)e);
                    return SQLConnectionTestResult.error(e);
                }
                catch (Exception | NoClassDefFoundError e) {
                    logger.error((Object)"Driver error", e);
                    return SQLConnectionTestResult.errorFailedToLoadDriver(driverClass, e);
                }
            }
            try {
                jdbcConn = SQLConnectionProvider.newConnection(cd, authCtx, null);
            }
            catch (Exception e) {
                logger.error((Object)"Connection error", (Throwable)e);
                return SQLConnectionTestResult.error(e);
            }
            catch (NoClassDefFoundError e) {
                logger.error((Object)"Driver error", (Throwable)e);
                return SQLConnectionTestResult.errorFailedToLoadDriver(driverClass, e);
            }
            testPayload = null;
            try {
                if (!connection.getDkuPropertiesAsParams().getBoolParam("dku.connection.test.listTableTypes", false)) break block24;
                logger.info((Object)"Listing table types on connection");
                testPayload = new JsonObject();
                JsonArray arr = new JsonArray();
                try {
                    ResultSet rs2 = jdbcConn.getMetaData().getTableTypes();
                    while (rs2.next()) {
                        logger.info((Object)("Table type: " + rs2.getString("TABLE_TYPE")));
                        arr.add(rs2.getString("TABLE_TYPE"));
                    }
                }
                catch (SQLException e) {
                    logger.warn((Object)"Failed to list table types", (Throwable)e);
                }
                testPayload.add("tableTypes", (JsonElement)arr);
            }
            finally {
                jdbcConn.close();
            }
        }
        return SQLConnectionTestResult.ok(testPayload);
    }

    public PostgreSQLConnectionTestResult testPostgreSQL(AuthCtx authCtx, PostgreSQLConnection connection) throws Exception {
        PostgreSQLConnectionTestResult result = new PostgreSQLConnectionTestResult(this.testSQL_NOTRANSACTION(null, connection, authCtx));
        boolean shouldCheckPostGIS = connection.getDkuPropertiesAsParams().getBoolParam("dku.connection.test.postgresql.postgis.check", true);
        if (shouldCheckPostGIS && ((PostgreSQLConnection.Params)connection.getParams()).postGISenabled) {
            result.postGISversion = this.retrievePostGISversion(authCtx, connection);
            if (result.postGISversion == null) {
                logger.warnV("Couldn't find installed PostGIS for %s connection", new Object[]{connection.name});
                result.connectionWarningMsg = "PostGIS extension is not installed";
            } else {
                logger.warnV("PostGIS of version %s is installed for connection %s", new Object[]{result.postGISversion, connection.name});
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String retrievePostGISversion(AuthCtx authCtx, PostgreSQLConnection connection) throws Exception {
        String postgisVersionQuery = SimpleSelectQueryBuilder.select().columns(new SchemaColumn[][]{{new SchemaColumn("extversion", Type.STRING)}}).from(new SQLUtils.SQLTable(null, null, "pg_extension")).where(new ExpressionBuilder.ExpressionBuilderFactory().col("extname").eq("postgis")).toSQL(connection.getDialect());
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connection.getConnectionData_NT(authCtx, null), authCtx, null);){
            ResultSet rs2 = conn.createStatement().executeQuery(postgisVersionQuery);
            if (rs2.next()) {
                String string2 = rs2.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to check if PostGIS extension is installed", (Throwable)e);
            return null;
        }
    }

    public static boolean checkS3BucketExists(S3Client client, String bucket) {
        try {
            if (StringUtils.isBlank((String)bucket)) {
                logger.error((Object)"The bucket name must not be null or an empty string.");
                return false;
            }
            client.getBucketAcl(r -> r.bucket(bucket));
            logger.infoV("The specified bucket exists: %s", new Object[]{bucket});
            return true;
        }
        catch (AwsServiceException ase) {
            if (ase.statusCode() == 301 || "AccessDenied".equals(ase.awsErrorDetails().errorCode())) {
                logger.infoV("The specified bucket exists but is not accessible: %s", new Object[]{bucket});
                return true;
            }
            if (ase.statusCode() == 404) {
                logger.infoV("The specified bucket does not exist: %s", new Object[]{bucket});
                return false;
            }
            if (ase.statusCode() == 400 && "InvalidBucketName".equals(ase.awsErrorDetails().errorCode())) {
                logger.infoV("The specified bucket is not a valid name: %s", new Object[]{bucket});
                return false;
            }
            throw ase;
        }
    }

    public EC2LikeConnectionTestResult testS3BucketAccess(S3Client client, String bucket) {
        try {
            if (StringUtils.isBlank((String)bucket)) {
                String errorMessage = "The bucket name must not be null or an empty string.";
                logger.error((Object)errorMessage);
                return EC2LikeConnectionTestResult.error(errorMessage);
            }
            client.getBucketAcl(r -> r.bucket(bucket));
            return EC2LikeConnectionTestResult.ok();
        }
        catch (AwsServiceException ase) {
            Object errorMessage = "";
            if (ase.statusCode() == 301) {
                errorMessage = "Bucket does not exist in the specified region/endpoint: " + bucket;
                logger.warn(errorMessage);
            }
            if ("AccessDenied".equals(ase.awsErrorDetails().errorCode()) || ase.statusCode() == 401 || ase.statusCode() == 403) {
                errorMessage = "You do not have access to bucket: " + bucket;
                logger.warn(errorMessage);
            }
            if (ase.statusCode() == 404) {
                errorMessage = "Bucket does not exist: " + bucket;
                logger.warn(errorMessage);
            }
            if (!StringUtils.isBlank((String)errorMessage)) {
                return EC2LikeConnectionTestResult.error((Exception)((Object)new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, (String)errorMessage, (Throwable)ase)));
            }
            return EC2LikeConnectionTestResult.error((Exception)((Object)new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, (Throwable)ase)));
        }
    }

    public static EC2LikeConnectionTestResult testAwsCredentials(AuthCtx authCtx, EC2Connection connection) throws IOException, DKUSecurityException {
        EC2LikeConnectionTestResult eC2LikeConnectionTestResult;
        block9: {
            if (connection.params.regionOrEndpoint != null && connection.params.regionOrEndpoint.contains("://")) {
                logger.warn((Object)"Credentials are not checked with STS when using a custom endpoint");
                return EC2LikeConnectionTestResult.ok();
            }
            StsClient stsClient = connection.getStsClient(authCtx);
            try {
                stsClient.getCallerIdentity();
                eC2LikeConnectionTestResult = EC2LikeConnectionTestResult.ok();
                if (stsClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stsClient != null) {
                        try {
                            stsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CodedException | AwsServiceException e) {
                    logger.error((Object)"Invalid credentials provided", e);
                    return EC2LikeConnectionTestResult.error((Exception)((Object)new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid credentials provided", e)));
                }
            }
            stsClient.close();
        }
        return eC2LikeConnectionTestResult;
    }

    public EC2LikeConnectionTestResult testEC2(AuthCtx authCtx, EC2Connection connection) {
        try {
            EC2LikeConnectionTestResult testAwsCredentialsResult = ConnectionsTestService.testAwsCredentials(authCtx, connection);
            if (!testAwsCredentialsResult.connectionOK) {
                return testAwsCredentialsResult;
            }
            S3Client client = connection.getS3Client(authCtx);
            if (connection.allowManagedDatasets) {
                String defaultManagedBucket = connection.params.getDefaultManagedBucket();
                if (StringUtils.isBlank((String)defaultManagedBucket)) {
                    logger.warn((Object)"missing default managed dataset parameter");
                    return EC2LikeConnectionTestResult.warn("Warning: missing default bucket for managed datasets");
                }
                return this.testS3BucketAccess(client, defaultManagedBucket);
            }
            return EC2LikeConnectionTestResult.ok();
        }
        catch (Exception e) {
            logger.error((Object)"EC2 connection test failed", (Throwable)e);
            return EC2LikeConnectionTestResult.error((Exception)((Object)new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, (Throwable)e)));
        }
    }

    static boolean checkDatabricksVolume(VolumesAPI client, String catalog, String schema, String volume) {
        String volumeFullName = String.format("%s.%s.%s", catalog, schema, volume);
        try {
            VolumeInfo info = client.read(volumeFullName);
            return info != null;
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to get info for databricks volume " + volumeFullName), (Throwable)e);
            return false;
        }
    }

    public DatabricksLikeConnectionTestResult testDatabricksVolume(AuthCtx authCtx, DatabricksVolumeConnection connection) {
        try {
            VolumesAPI client = new VolumesAPI(connection.getApiClient(authCtx));
            try {
                client.read("main.default.notarealvolume");
            }
            catch (NotFound e) {
                logger.info((Object)"Databricks replied");
            }
            if (connection.allowManagedDatasets) {
                String defaultManagedVolume = connection.params.getDefaultManagedVolume();
                if (StringUtils.isBlank((String)defaultManagedVolume)) {
                    logger.warn((Object)"missing default managed dataset parameter");
                    return DatabricksLikeConnectionTestResult.warn("Warning: missing default volume for managed datasets");
                }
                if (!ConnectionsTestService.checkDatabricksVolume(client, connection.params.catalog, connection.params.schema, defaultManagedVolume)) {
                    logger.warn((Object)("volume does not exist: " + defaultManagedVolume));
                    return DatabricksLikeConnectionTestResult.warn("Warning: volume does not exist: " + defaultManagedVolume);
                }
            }
            return DatabricksLikeConnectionTestResult.ok();
        }
        catch (Exception e) {
            logger.error((Object)"Databricks volume connection test failed", (Throwable)e);
            return DatabricksLikeConnectionTestResult.error(e.getMessage());
        }
    }

    public EC2LikeConnectionTestResult testSageMaker_NT(AuthCtx authCtx, SageMakerConnection connection) {
        try {
            if (StringUtils.isEmpty((String)connection.params.regionOrEndpoint)) {
                logger.error((Object)"Missing region parameter");
                return EC2LikeConnectionTestResult.error("Missing region parameter");
            }
            if (!SageMakerUtils.isSageMakerSupported(connection.params.regionOrEndpoint)) {
                logger.errorV("SageMaker not supported in region %s", new Object[]{connection.params.regionOrEndpoint});
                return EC2LikeConnectionTestResult.error("SageMaker not supported in region " + connection.params.regionOrEndpoint);
            }
            SageMakerClient sageMakerClient = SageMakerUtils.loginSageMaker_NT(authCtx, connection, connection.params.regionOrEndpoint, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            SageMakerUtils.retrieveEndpointList_NT(sageMakerClient, "--dku-dummy--", false);
            return EC2LikeConnectionTestResult.ok();
        }
        catch (Exception e) {
            logger.error((Object)"SageMaker connection test failed", (Throwable)e);
            return EC2LikeConnectionTestResult.error(e);
        }
    }

    public AzureLikeConnectionTestResult testAzure(AuthCtx authCtx, AzureConnection connection) {
        try {
            ProxySettings proxySettings = connection.getProxySettings();
            AzureBlobModel.BlobServiceAccountHolder client = connection.getAzureBlobClient(authCtx, proxySettings);
            AzureBlobModel.BlobContainerHolder ctn = client.getContainerReference(connection.params.getDefaultManagedContainer());
            if (connection.allowManagedDatasets) {
                if (StringUtils.isBlank((String)connection.params.getDefaultManagedContainer())) {
                    logger.warn((Object)"missing default managed dataset parameter");
                    return AzureLikeConnectionTestResult.warn("Warning: missing default container for managed datasets");
                }
                ctn = client.getContainerReference(connection.params.getDefaultManagedContainer());
            }
            return AzureLikeConnectionTestResult.ok(ctn.exists());
        }
        catch (Exception e) {
            logger.error((Object)"Azure blob connection failed: ", (Throwable)e);
            return AzureLikeConnectionTestResult.error(e);
        }
    }

    public AzureLikeConnectionTestResult testAzureML_NT(AuthCtx authCtx, AzureMLConnection connection) {
        try {
            if (connection.params.authType != AzureConnection.AuthType.ENVIRONMENT) {
                if (StringUtils.isEmpty((String)connection.params.tenantId)) {
                    return AzureLikeConnectionTestResult.error("Missing Tenant id parameter");
                }
                if (StringUtils.isEmpty((String)connection.params.appId)) {
                    return AzureLikeConnectionTestResult.error("Missing App id parameter");
                }
                if (StringUtils.isEmpty((String)connection.params.appSecret)) {
                    return AzureLikeConnectionTestResult.error("Missing App secret parameter");
                }
            }
            AzureMLUtils.getAzureMLCredentials_NT(authCtx, connection);
            return AzureLikeConnectionTestResult.ok(false);
        }
        catch (Exception e) {
            logger.error((Object)"Azure ML connection failed: ", (Throwable)e);
            return AzureLikeConnectionTestResult.error(e);
        }
    }

    public GCSLikeConnectionTestResult testGCS(GCSConnection cnx, AuthCtx authCtx) {
        GCSclient client;
        try {
            client = cnx.getClient(authCtx, GoogleUserAgentBuilder.build(this.licenseStatusService));
        }
        catch (DKUSecurityException | IOException | RuntimeException e) {
            logger.error((Object)"GoogleCloudStorage test failed", e);
            return GCSLikeConnectionTestResult.error((Exception)e);
        }
        if (cnx.allowManagedDatasets) {
            String bucket = cnx.params.getDefaultManagedBucket();
            try {
                client.getBucket(bucket);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"GoogleCloudStorage test failed", (Throwable)e);
                return GCSLikeConnectionTestResult.warn("specified bucket does not exist");
            }
            catch (IOException e) {
                logger.error((Object)"GoogleCloudStorage test failed", (Throwable)e);
                return GCSLikeConnectionTestResult.error(e);
            }
        }
        return GCSLikeConnectionTestResult.ok();
    }

    public SharePointOnlineLikeConnectionTestResult testSharePointOnline(SharePointOnlineConnection connection, AuthCtx authCtx) {
        try {
            connection.decryptFields(this.symetricCryptoService);
            if (StringUtils.isEmpty((String)connection.params.tenantId)) {
                return SharePointOnlineLikeConnectionTestResult.error("Missing Tenant id parameter");
            }
            if (StringUtils.isEmpty((String)connection.params.appId)) {
                return SharePointOnlineLikeConnectionTestResult.error("Missing App id parameter");
            }
            if (StringUtils.equals((String)String.valueOf((Object)connection.params.authType), (String)"OAUTH2_APP") && StringUtils.isEmpty((String)connection.params.appSecret)) {
                return SharePointOnlineLikeConnectionTestResult.error("Missing App secret parameter");
            }
            if (StringUtils.isEmpty((String)connection.params.authorizationEndpoint)) {
                return SharePointOnlineLikeConnectionTestResult.error("Missing authorization endpoint parameter");
            }
            if (StringUtils.isEmpty((String)connection.params.tokenEndpoint)) {
                return SharePointOnlineLikeConnectionTestResult.error("Missing token endpoint parameter");
            }
            if (connection.allowManagedFolders || connection.allowManagedDatasets) {
                if (StringUtils.isEmpty((String)connection.params.defaultManagedSite)) {
                    return SharePointOnlineLikeConnectionTestResult.error("Missing default managed site parameter");
                }
                if (StringUtils.isEmpty((String)connection.params.defaultManagedDrive)) {
                    return SharePointOnlineLikeConnectionTestResult.error("Missing default managed drive parameter");
                }
                if (StringUtils.isEmpty((String)connection.params.defaultManagedPath)) {
                    return SharePointOnlineLikeConnectionTestResult.error("Missing default managed path parameter");
                }
            }
            ProxySettings proxySettings = connection.getProxySettings();
            SharePointOnlineConnection.SharePointOnlineClient client = connection.getSharePointOnlineClient(authCtx, proxySettings);
            client.pingSitesEndpoint();
            logger.info((Object)"SharePoint Online sites test ok");
            return SharePointOnlineLikeConnectionTestResult.ok();
        }
        catch (Exception e) {
            logger.error((Object)"SharePoint Online connection failed: ", (Throwable)e);
            return SharePointOnlineLikeConnectionTestResult.error(e);
        }
    }

    public GCSLikeConnectionTestResult testVertexAIModelDeployment(VertexAIModelDeploymentConnection connection, AuthCtx authCtx) {
        try {
            if (connection.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.KEYPAIR) {
                if (StringUtils.isEmpty((String)connection.params.appSecretContent)) {
                    return GCSLikeConnectionTestResult.error("Private key field can not be empty");
                }
            } else if (connection.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH) {
                if (StringUtils.isEmpty((String)connection.params.oauth2ClientId)) {
                    return GCSLikeConnectionTestResult.error("Client id field can not be empty");
                }
                if (StringUtils.isEmpty((String)connection.params.oauth2ClientSecret)) {
                    return GCSLikeConnectionTestResult.error("Client secret field can not be empty");
                }
            }
            try {
                ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
                ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = connection.getFullyResolvedCredentials(ctx, ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
                GoogleCredentials credentials = creds.toGoogleCredentials(ctx, connection);
                credentials = credentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
                credentials.refresh();
            }
            catch (Exception e) {
                return GCSLikeConnectionTestResult.error("Error when using credentials to get a token: " + e.getLocalizedMessage());
            }
            return GCSLikeConnectionTestResult.ok();
        }
        catch (Exception e) {
            logger.info((Object)("Vertex AI connection error: " + e.getMessage()), (Throwable)e);
            return GCSLikeConnectionTestResult.error(e);
        }
    }

    public DatabricksModelDeploymentConnectionTestResult testDatabricksModelDeployment(@Nonnull DatabricksModelDeploymentConnection connection, AuthCtx authCtx) {
        try {
            if (StringUtils.isBlank((String)connection.params.host)) {
                return DatabricksModelDeploymentConnectionTestResult.error("Host can not be empty");
            }
            try {
                InetAddress.getByName(connection.params.host);
            }
            catch (UnknownHostException e) {
                return DatabricksModelDeploymentConnectionTestResult.error("Host can not be resolved");
            }
            if (connection.params.authType == ConnectionWithDatabricksCredentials.AuthType.PERSONAL_ACCESS_TOKEN) {
                if (StringUtils.isEmpty((String)connection.params.personalAccessToken)) {
                    return DatabricksModelDeploymentConnectionTestResult.error("Personal access token can not be empty");
                }
            } else if (connection.params.authType == ConnectionWithDatabricksCredentials.AuthType.OAUTH2_APP) {
                if (StringUtils.isEmpty((String)connection.params.oauth2ClientId)) {
                    return DatabricksModelDeploymentConnectionTestResult.error("Client id field can not be empty");
                }
                if (StringUtils.isEmpty((String)connection.params.oauth2ClientSecret)) {
                    return DatabricksModelDeploymentConnectionTestResult.error("Client secret field can not be empty");
                }
            }
            try {
                FutureResponse<List<DatabricksRegisteredModel>> future = DatabricksUtils.startListRegisteredModels_NT((DSSAuthCtx)authCtx, connection, false, List.of());
                this.futureService.waitForFinalResponse(future.jobId);
            }
            catch (Exception e) {
                String error = "Error when listing registered models using this connection : " + e.getLocalizedMessage();
                if (null != e.getCause()) {
                    error = error + ". Cause: " + e.getCause().getLocalizedMessage();
                }
                return DatabricksModelDeploymentConnectionTestResult.error(error);
            }
            return DatabricksModelDeploymentConnectionTestResult.ok();
        }
        catch (Exception e) {
            logger.info((Object)("Databricks Model Deployment connection error: " + e.getMessage()), (Throwable)e);
            return DatabricksModelDeploymentConnectionTestResult.error(e);
        }
    }

    private void testLLMStructuredRef(AuthCtx authCtx, EnrichedLLMStructuredRef identifier, AbstractLLMConnection<?, ?, ?> connection) throws Exception {
        LLMClient client = identifier.type == LLMStructuredRef.LLMType.CUSTOM ? LLMClientFactory.getCustomLLMClient_NoCheck(authCtx, null, identifier, (CustomLLMConnection)connection) : LLMClientFactory.getRemoteLLM_NoCheck(authCtx, null, identifier, connection);
        if (connection.ignoreConnectionTest(identifier)) {
            return;
        }
        LLMModelHandle.Model model = connection.getLLMModel(identifier).getModel();
        if (model.canBeUsedForPurpose(AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION)) {
            LLMClient.EmbeddingQuery embeddingQuery = new LLMClient.EmbeddingQuery();
            embeddingQuery.text = "test";
            client.embedBatch(Collections.singletonList(embeddingQuery), new LLMClient.EmbeddingSettings());
        } else if (model.canBeUsedForPurpose(AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION)) {
            LLMClient.SingleCompletionQuery completionQuery = new LLMClient.SingleCompletionQuery();
            completionQuery.messages.add(new LLMClient.ChatMessage("user", "test"));
            LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
            completionSettings.maxOutputTokens = 5;
            client.completeBatch(Collections.singletonList(completionQuery), completionSettings);
        }
    }

    private LLMConnectionTestResult testLLMConnection(AuthCtx authCtx, AbstractLLMConnection<?, ?, ?> connection) {
        LLMModelHandle.Model invalidCustomModel;
        AbstractLLMConnection.AbstractLLMConnectionParams llmParams = connection.getLLMConnectionParams();
        if (llmParams.guardrailsPipelineSettings != null && llmParams.guardrailsPipelineSettings.guardrails != null && llmParams.guardrailsPipelineSettings.guardrails.stream().anyMatch(g -> g.enabled && "PIIDetector".equals(g.type))) {
            String piiCodeEnv = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.getPresidioBasedPIIDetectionCodeEnv();
            try {
                this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, piiCodeEnv);
            }
            catch (IOException e) {
                return LLMConnectionTestResult.error("The specified code environment for PII detection does not exist.", e);
            }
        }
        if ((invalidCustomModel = (LLMModelHandle.Model)connection.listAllModels().stream().filter(model -> !model.isValid()).findFirst().orElse(null)) != null) {
            return LLMConnectionTestResult.error("One of the models has invalid settings: " + invalidCustomModel.getInvalidityReason().orElse("[Unknown reason]"));
        }
        List<EnrichedLLMStructuredRef> selectedModels = connection.listAvailableLLMStructuredRefs(null);
        if (selectedModels.isEmpty()) {
            return LLMConnectionTestResult.error("No models selected");
        }
        for (EnrichedLLMStructuredRef identifier : selectedModels) {
            try {
                this.testLLMStructuredRef(authCtx, identifier, connection);
            }
            catch (Exception e) {
                String message = String.format("Error connecting to model %s", identifier.friendlyNameShort);
                logger.info((Object)String.format("%s connection - %s: %s", connection.getType(), message, e.getMessage()), (Throwable)e);
                return LLMConnectionTestResult.error(message, e);
            }
        }
        return LLMConnectionTestResult.ok();
    }

    public LLMConnectionTestResult testOpenAI(OpenAIConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testAzureOpenAI(AzureOpenAIConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testCohere(CohereConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testMistralAI(MistralAIConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testAnthropic(AnthropicConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testBedrock(BedrockConnection connection, AuthCtx authCtx) {
        if (connection.params.isFineTuningSetup()) {
            try {
                AmazonS3Client s3Client = connection.getS3Client(authCtx);
                boolean bucketExists = s3Client.doesBucketExistV2(connection.params.fineTuningSettings.bucketName);
                if (!bucketExists) {
                    logger.info((Object)"Fine-tuning bucket doesn't exist, it will be created when needed.");
                }
            }
            catch (Exception e) {
                return LLMConnectionTestResult.error("Error checking S3 connection for finetuning setup", e);
            }
        }
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testSageMakerGenericLLM(SageMakerGenericLLMConnection connection, AuthCtx authCtx) {
        if (StringUtils.isBlank((String)connection.params.region)) {
            logger.error((Object)"Missing region parameter");
            LLMConnectionTestResult.error("Missing region parameter");
        }
        if (!SageMakerUtils.isSageMakerSupported(connection.params.region)) {
            logger.errorV("SageMaker not supported in region %s", new Object[]{connection.params.region});
            LLMConnectionTestResult.error("SageMaker not supported in region " + connection.params.region);
        }
        if (GenericLLMHandling.FULLY_CUSTOM == connection.params.sageMakerModel.handling) {
            try {
                JsonParser.parseString((String)connection.params.customQuery).getAsJsonObject();
            }
            catch (Exception e) {
                LLMConnectionTestResult.error("Invalid JSON: " + connection.params.customQuery, e);
            }
            try {
                JsonPath.compile((String)connection.params.responseJsonPath, (Predicate[])new Predicate[0]);
            }
            catch (Exception e) {
                LLMConnectionTestResult.error("Invalid JsonPath for Response: " + connection.params.responseJsonPath, e);
            }
            if (StringUtils.isNotBlank((String)connection.params.promptTokensJsonPath)) {
                try {
                    JsonPath.compile((String)connection.params.promptTokensJsonPath, (Predicate[])new Predicate[0]);
                }
                catch (Exception e) {
                    LLMConnectionTestResult.error("Invalid JsonPath for Prompt Tokens: " + connection.params.promptTokensJsonPath, e);
                }
            }
            if (StringUtils.isNotBlank((String)connection.params.completionTokensJsonPath)) {
                try {
                    JsonPath.compile((String)connection.params.completionTokensJsonPath, (Predicate[])new Predicate[0]);
                }
                catch (Exception e) {
                    LLMConnectionTestResult.error("Invalid JsonPath for Completion Tokens: " + connection.params.completionTokensJsonPath, e);
                }
            }
        }
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testAzureLLM(AzureLLMConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testMosaic(MosaicMLConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testVertexAILLM(VertexAILLMConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testDatabricksLLM(DatabricksLLMConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testSnowflakeCortexLLM(SnowflakeCortexLLMConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    public LLMConnectionTestResult testCustomLLM(CustomLLMConnection connection, AuthCtx authCtx) {
        return this.testLLMConnection(authCtx, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HuggingFaceTestResult testHuggingFace(AuthCtx authCtx, HuggingFaceInferenceAPIConnection connection) {
        try (HuggingFaceClient client = null;){
            ICredentialsService.BasicCredential creds = connection.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ICredentialsService.BasicCredential.class);
            client = new HuggingFaceClient(creds.password);
            client.testAuthentification();
            HuggingFaceTestResult huggingFaceTestResult = HuggingFaceTestResult.ok();
            return huggingFaceTestResult;
        }
    }

    public VectorStoreConnectionTestResult testPinecone(PineconeConnection connection) {
        VectorStoreConnectionTestResult vectorStoreConnectionTestResult;
        connection.decryptFields(this.symetricCryptoService);
        PineconeRestClient client = new PineconeRestClient(connection.params.apiKey);
        try {
            vectorStoreConnectionTestResult = client.testAuth();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.info((Object)("Pinecone connection error: " + e.getMessage()), (Throwable)e);
                return VectorStoreConnectionTestResult.error(e);
            }
        }
        client.close();
        return vectorStoreConnectionTestResult;
    }

    public VectorStoreConnectionTestResult testAzureAISearch(AzureAISearchConnection connection, AuthCtx authCtx) {
        VectorStoreConnectionTestResult vectorStoreConnectionTestResult;
        AzureAISearchRestClient client = new AzureAISearchRestClient(connection, authCtx);
        try {
            vectorStoreConnectionTestResult = client.testAuth();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.info((Object)("Azure AI Search connection error: " + e.getMessage()), (Throwable)e);
                return VectorStoreConnectionTestResult.error(e);
            }
        }
        client.close();
        return vectorStoreConnectionTestResult;
    }

    public TwitterTestResult testTwitter(TwitterConnection connection) {
        try {
            TwitterConnection.SerializableTwitterCredentials creds = connection.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(DSSAuthCtx.newNone(), null), TwitterConnection.SerializableTwitterCredentials.class);
            String consumerKey = creds.api_key;
            String consumerSecret = creds.api_secret;
            String token = creds.token_key;
            String secret = creds.token_secret;
            ConfigurationBuilder confbuilder = new ConfigurationBuilder();
            confbuilder.setOAuthAccessToken(token).setOAuthAccessTokenSecret(secret).setOAuthConsumerKey(consumerKey).setOAuthConsumerSecret(consumerSecret);
            ProxySettings proxySettings = connection.getProxySettings();
            if (proxySettings.hasProxy()) {
                confbuilder.setHttpProxyHost(proxySettings.host);
                confbuilder.setHttpProxyPort(proxySettings.port);
                if (proxySettings.hasAuthentication()) {
                    confbuilder.setHttpProxyUser(proxySettings.username);
                    confbuilder.setHttpProxyUser(proxySettings.password);
                }
            }
            Twitter twitter = new TwitterFactory(confbuilder.build()).getInstance();
            twitter.verifyCredentials();
            return TwitterTestResult.ok();
        }
        catch (TwitterException e) {
            logger.info((Object)("Verifying credentials failed with error code : " + e.getErrorCode()));
            return TwitterTestResult.error((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.info((Object)("Twitter connection error: " + e.getMessage()), (Throwable)e);
            return TwitterTestResult.error(e);
        }
    }

    public KafkaTestResult testKafka(AuthCtx authCtx, KafkaConnection connection) {
        try {
            ArrayList<String> topics;
            JSONKafkaFormat.JSONKafkaFormatDeserializer deserializer = new JSONKafkaFormat.JSONKafkaFormatDeserializer(new JSONKafkaFormat.JSONKafkaFormatParams());
            JSONKafkaFormat.JSONKafkaFormatDeserializer keyDeserializer = new JSONKafkaFormat.JSONKafkaFormatDeserializer(new JSONKafkaFormat.JSONKafkaFormatParams());
            Properties props = connection.buildBasicProperties(authCtx, null);
            props.put("key.deserializer", keyDeserializer.getKafkaDeserializer());
            props.put("value.deserializer", deserializer.getKafkaDeserializer());
            props.put("group.id", props.getProperty("group.id.prefix", "dss_test-") + System.currentTimeMillis());
            props.put("enable.auto.commit", "true");
            try (AdminClient client = AdminClient.create((Properties)props);){
                ListTopicsOptions listingOptions = new ListTopicsOptions().timeoutMs(Integer.valueOf(10000));
                topics = new ArrayList<String>((Collection)client.listTopics(listingOptions).names().get());
            }
            Collections.sort(topics);
            return KafkaTestResult.ok(topics);
        }
        catch (Exception e) {
            logger.info((Object)("Kafka connection error: " + e.getMessage()), (Throwable)e);
            return KafkaTestResult.error(e);
        }
    }

    public KsqlTestResult testKsql(KafkaConnection connection) {
        KsqlTestResult ksqlTestResult;
        if (StringUtils.isBlank((String)connection.params.ksqlConnectionParams.serverUrl)) {
            return KsqlTestResult.error("No KSQL url specified");
        }
        KsqlRESTClient client = new KsqlRESTClient(connection.getKSqlParameters());
        try {
            ksqlTestResult = KsqlTestResult.ok(client.get("/info", JsonObject.class, new String[0]));
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.info((Object)("Ksql connection error: " + e.getMessage()), (Throwable)e);
                return KsqlTestResult.error(e);
            }
        }
        client.close();
        return ksqlTestResult;
    }

    public SQSTestResult testSQS(AuthCtx authCtx, SQSConnection connection) {
        SQSTestResult sQSTestResult;
        block10: {
            SqsClient client = connection.getSQSClient(authCtx);
            try {
                ListQueuesResponse res = client.listQueues();
                ArrayList<String> queues = new ArrayList<String>();
                if (res.hasQueueUrls()) {
                    for (String url : res.queueUrls()) {
                        queues.add(url.substring(url.lastIndexOf(47) + 1));
                    }
                }
                sQSTestResult = SQSTestResult.ok(queues);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.info((Object)("SQS connection error: " + e.getMessage()), (Throwable)e);
                    return SQSTestResult.error(e);
                }
            }
            client.close();
        }
        return sQSTestResult;
    }

    public MongoDBConnectionTestResult testMongoDB(AuthCtx authCtx, MongoDBConnection connection) {
        logger.info((Object)("Testing MongoDB connection\n" + String.valueOf(connection)));
        try (MongoDBConnectionWrapper dbConn = new MongoDBConnectionWrapper(authCtx, connection);){
            dbConn.test();
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("MongoDB connection configuration error: " + e.getMessage()), (Throwable)e);
            return MongoDBConnectionTestResult.configError(e.getMessage());
        }
        catch (UnknownHostException e) {
            logger.warn((Object)("MongoDB invalid host error: " + e.getMessage()));
            return MongoDBConnectionTestResult.connectionError("Invalid host: " + e.getMessage());
        }
        catch (MongoCommandException e) {
            logger.warn((Object)("MongoDB command error: " + e.getMessage()));
            return MongoDBConnectionTestResult.connectionError("Error sending command to server: " + e.getErrorMessage());
        }
        catch (MongoException e) {
            logger.warn((Object)("MongoDB connection error: " + e.getMessage()), (Throwable)e);
            return MongoDBConnectionTestResult.connectionError("Could not connect to server: " + e.getMessage());
        }
        catch (Exception e) {
            logger.warn((Object)"MongoDB connection unexpected error: ", (Throwable)e);
            return MongoDBConnectionTestResult.connectionError(e.getMessage());
        }
        return MongoDBConnectionTestResult.ok();
    }

    public DynamoDBConnectionTestResult testDynamoDB(AuthCtx authCtx, DynamoDBConnection connection) {
        logger.info((Object)("Testing DynamoDB connection\n" + String.valueOf(connection)));
        try (DynamoDBConnectionWrapper dbConn = new DynamoDBConnectionWrapper(authCtx, connection);){
            dbConn.testConnection();
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("DynamoDB connection configuration error: " + String.valueOf(e)));
            return DynamoDBConnectionTestResult.configError(e.getMessage());
        }
        catch (UnknownHostException e) {
            logger.warn((Object)("DynamoDB invalid host error: " + String.valueOf(e)));
            return DynamoDBConnectionTestResult.connectionError("Invalid host: " + e.getMessage());
        }
        catch (DynamoDbException e) {
            logger.warn((Object)("DynamoDB connection error: " + String.valueOf((Object)e)));
            return DynamoDBConnectionTestResult.connectionError("Could not connect to server: " + e.getMessage());
        }
        catch (Exception e) {
            logger.warn((Object)"DynamoDB connection unexpected error: ", (Throwable)e);
            return DynamoDBConnectionTestResult.connectionError(e);
        }
        return DynamoDBConnectionTestResult.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CassandraConnectionTestResult testCassandra(AuthCtx authCtx, CassandraConnection connection) {
        logger.info((Object)("Testing Cassandra connection\n" + String.valueOf(connection)));
        CassandraConnectionTestResult result = new CassandraConnectionTestResult();
        try {
            CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(authCtx, connection);
            try {
                result.clusterInfo = dbConn.test();
            }
            finally {
                CassandraUtil.releaseConnection(dbConn);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Cassandra connection configuration error: " + e.getMessage()));
            return CassandraConnectionTestResult.configError(e.getMessage());
        }
        catch (Exception e) {
            logger.warn((Object)"Cassandra connection error: ", (Throwable)e);
            return CassandraConnectionTestResult.connectionError(e);
        }
        return CassandraConnectionTestResult.ok();
    }

    public ElasticSearchConnectionTestResult testElasticSearch(AuthCtx authCtx, ElasticSearchConnection connection) throws Exception {
        String host = connection.params.host;
        if (host == null) {
            return ElasticSearchConnectionTestResult.error("Missing host parameter");
        }
        int port = connection.params.port;
        if (port == 0) {
            return ElasticSearchConnectionTestResult.error("Missing port parameter");
        }
        ElasticSearchHttpClient client = connection.getHttpClient(authCtx, null);
        try {
            HttpResponse resp = client.execute((HttpUriRequest)new HttpGet(connection.getTestURL()));
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Server didn't answer 200 but " + resp.getStatusLine().getStatusCode() + ": " + resp.getStatusLine().getReasonPhrase());
            }
            String versionNumber = null;
            ElasticSearchUtils.SearchDistribution distribution = null;
            if (connection.isAWSOpenSearchServerless()) {
                distribution = ElasticSearchUtils.SearchDistribution.OPEN_SEARCH;
                versionNumber = "unknown (AWS Serverless)";
            } else {
                JSONObject jresp = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
                distribution = ElasticSearchUtils.SearchDistribution.getDistribution(jresp);
                versionNumber = jresp.getJSONObject("version").getString("number");
            }
            ElasticSearchConnectionTestResult elasticSearchConnectionTestResult = ElasticSearchConnectionTestResult.ok(versionNumber, distribution);
            if (client != null) {
                client.close();
            }
            return elasticSearchConnectionTestResult;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.debug((Object)"The Elastic search connection under test is failing", (Throwable)e);
                return ElasticSearchConnectionTestResult.error(e);
            }
        }
    }

    public static class SQLConnectionTestResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public JsonObject testPayload;
        public String connectionWarningMsg;

        public static SQLConnectionTestResult ok(JsonObject testPayload) {
            SQLConnectionTestResult result = new SQLConnectionTestResult();
            result.connectionOK = true;
            result.testPayload = testPayload;
            return result;
        }

        public static SQLConnectionTestResult error(Exception e) {
            SQLConnectionTestResult result = new SQLConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            return result;
        }

        public static SQLConnectionTestResult errorFailedToLoadDriver(String driverClass, Throwable e) {
            return SQLConnectionTestResult.error((Exception)((Object)new CodedException((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_LOAD_DRIVER, "Failed to load JDBC driver (" + driverClass + "): ", e)));
        }
    }

    public static class PostgreSQLConnectionTestResult
    extends SQLConnectionTestResult {
        public String postGISversion;

        public PostgreSQLConnectionTestResult(SQLConnectionTestResult sqlTestResult) {
            this.connectionOK = sqlTestResult.connectionOK;
            this.connectionError = sqlTestResult.connectionError;
            this.testPayload = sqlTestResult.testPayload;
            this.connectionWarningMsg = sqlTestResult.connectionWarningMsg;
        }
    }

    public static class EC2LikeConnectionTestResult {
        public boolean connectionOK;
        public boolean connectionWarning;
        public String connectionErrorMsg;
        public SerializedError connectionError;

        public static EC2LikeConnectionTestResult ok() {
            EC2LikeConnectionTestResult result = new EC2LikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = false;
            return result;
        }

        public static EC2LikeConnectionTestResult warn(String message) {
            EC2LikeConnectionTestResult result = new EC2LikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static EC2LikeConnectionTestResult error(String message) {
            EC2LikeConnectionTestResult result = new EC2LikeConnectionTestResult();
            result.connectionOK = false;
            result.connectionErrorMsg = message;
            return result;
        }

        public static EC2LikeConnectionTestResult error(Exception e) {
            EC2LikeConnectionTestResult result = new EC2LikeConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class DatabricksLikeConnectionTestResult {
        public boolean connectionOK;
        public boolean connectionWarning;
        public String connectionErrorMsg;

        public static DatabricksLikeConnectionTestResult ok() {
            DatabricksLikeConnectionTestResult result = new DatabricksLikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = false;
            return result;
        }

        public static DatabricksLikeConnectionTestResult warn(String message) {
            DatabricksLikeConnectionTestResult result = new DatabricksLikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static DatabricksLikeConnectionTestResult error(String message) {
            DatabricksLikeConnectionTestResult result = new DatabricksLikeConnectionTestResult();
            result.connectionOK = false;
            result.connectionErrorMsg = message;
            return result;
        }
    }

    public static class AzureLikeConnectionTestResult {
        public boolean connectionOK;
        public boolean connectionWarning;
        public boolean containerOK;
        public String connectionErrorMsg;
        public SerializedError connectionError;

        public static AzureLikeConnectionTestResult ok(boolean containerExists) {
            AzureLikeConnectionTestResult result = new AzureLikeConnectionTestResult();
            result.connectionOK = true;
            result.containerOK = containerExists;
            return result;
        }

        public static AzureLikeConnectionTestResult warn(String message) {
            AzureLikeConnectionTestResult result = new AzureLikeConnectionTestResult();
            result.connectionOK = true;
            result.containerOK = false;
            result.connectionWarning = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static AzureLikeConnectionTestResult error(String message) {
            AzureLikeConnectionTestResult result = new AzureLikeConnectionTestResult();
            result.connectionOK = false;
            result.connectionErrorMsg = message;
            return result;
        }

        public static AzureLikeConnectionTestResult error(Exception e) {
            AzureLikeConnectionTestResult result = new AzureLikeConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class GCSLikeConnectionTestResult {
        public boolean connectionOK;
        public boolean connectionWarning;
        public String connectionErrorMsg;
        public SerializedError connectionError;

        public static GCSLikeConnectionTestResult ok() {
            GCSLikeConnectionTestResult result = new GCSLikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = false;
            return result;
        }

        public static GCSLikeConnectionTestResult warn(String message) {
            GCSLikeConnectionTestResult result = new GCSLikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static GCSLikeConnectionTestResult error(String message) {
            GCSLikeConnectionTestResult result = new GCSLikeConnectionTestResult();
            result.connectionOK = false;
            result.connectionErrorMsg = message;
            return result;
        }

        public static GCSLikeConnectionTestResult error(Exception e) {
            GCSLikeConnectionTestResult result = new GCSLikeConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class SharePointOnlineLikeConnectionTestResult {
        public boolean connectionOK;
        public boolean connectionWarning;
        public String connectionErrorMsg;
        public SerializedError connectionError;

        public static SharePointOnlineLikeConnectionTestResult ok() {
            SharePointOnlineLikeConnectionTestResult result = new SharePointOnlineLikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = false;
            return result;
        }

        public static SharePointOnlineLikeConnectionTestResult warn(String message) {
            SharePointOnlineLikeConnectionTestResult result = new SharePointOnlineLikeConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static SharePointOnlineLikeConnectionTestResult error(String message) {
            SharePointOnlineLikeConnectionTestResult result = new SharePointOnlineLikeConnectionTestResult();
            result.connectionOK = false;
            result.connectionErrorMsg = message;
            return result;
        }

        public static SharePointOnlineLikeConnectionTestResult error(Exception e) {
            SharePointOnlineLikeConnectionTestResult result = new SharePointOnlineLikeConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class DatabricksModelDeploymentConnectionTestResult {
        public boolean connectionOK;
        public boolean connectionWarning;
        public String connectionErrorMsg;
        public SerializedError connectionError;

        public static DatabricksModelDeploymentConnectionTestResult ok() {
            DatabricksModelDeploymentConnectionTestResult result = new DatabricksModelDeploymentConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = false;
            return result;
        }

        public static DatabricksModelDeploymentConnectionTestResult warn(String message) {
            DatabricksModelDeploymentConnectionTestResult result = new DatabricksModelDeploymentConnectionTestResult();
            result.connectionOK = true;
            result.connectionWarning = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static DatabricksModelDeploymentConnectionTestResult error(String message) {
            DatabricksModelDeploymentConnectionTestResult result = new DatabricksModelDeploymentConnectionTestResult();
            result.connectionOK = false;
            result.connectionErrorMsg = message;
            return result;
        }

        public static DatabricksModelDeploymentConnectionTestResult error(Exception e) {
            DatabricksModelDeploymentConnectionTestResult result = new DatabricksModelDeploymentConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class LLMConnectionTestResult {
        public boolean connectionOk = false;
        public String message = "Unknown error";
        public SerializedError connectionError;

        public static LLMConnectionTestResult ok() {
            LLMConnectionTestResult result = new LLMConnectionTestResult();
            result.connectionOk = true;
            return result;
        }

        public static LLMConnectionTestResult error(String message) {
            LLMConnectionTestResult result = new LLMConnectionTestResult();
            result.message = message;
            result.connectionError = new SerializedError();
            result.connectionError.title = message;
            return result;
        }

        public static LLMConnectionTestResult error(Exception e) {
            LLMConnectionTestResult result = new LLMConnectionTestResult();
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionError.title = e.getMessage();
            return result;
        }

        public static LLMConnectionTestResult error(String message, Exception e) {
            LLMConnectionTestResult result = new LLMConnectionTestResult();
            result.message = message;
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionError.title = message;
            return result;
        }
    }

    public static class HuggingFaceTestResult {
        public boolean ok = false;
        public String message = "Unknown error";
        public SerializedError connectionError;

        public static HuggingFaceTestResult ok() {
            HuggingFaceTestResult result = new HuggingFaceTestResult();
            result.ok = true;
            return result;
        }

        public static HuggingFaceTestResult error(String message) {
            HuggingFaceTestResult result = new HuggingFaceTestResult();
            result.message = message;
            return result;
        }

        public static HuggingFaceTestResult error(Exception e) {
            HuggingFaceTestResult result = new HuggingFaceTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class VectorStoreConnectionTestResult {
        public boolean ok = false;
        public String message = "Unknown error";
        public SerializedError connectionError;

        public static VectorStoreConnectionTestResult ok() {
            VectorStoreConnectionTestResult result = new VectorStoreConnectionTestResult();
            result.ok = true;
            return result;
        }

        public static VectorStoreConnectionTestResult error(String message) {
            VectorStoreConnectionTestResult result = new VectorStoreConnectionTestResult();
            result.message = message;
            return result;
        }

        public static VectorStoreConnectionTestResult error(Exception e) {
            VectorStoreConnectionTestResult result = new VectorStoreConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class TwitterTestResult {
        public boolean ok = false;
        public String message = "Unknown error";
        public SerializedError connectionError;

        public static TwitterTestResult ok() {
            TwitterTestResult result = new TwitterTestResult();
            result.ok = true;
            return result;
        }

        public static TwitterTestResult error(String message) {
            TwitterTestResult result = new TwitterTestResult();
            result.message = message;
            return result;
        }

        public static TwitterTestResult error(Exception e) {
            TwitterTestResult result = new TwitterTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class KafkaTestResult {
        public boolean ok = false;
        public String message = "Unknown error";
        public List<String> topics = new ArrayList<String>();
        public SerializedError connectionError;

        public static KafkaTestResult ok(List<String> topics) {
            KafkaTestResult result = new KafkaTestResult();
            result.ok = true;
            result.topics.addAll(topics);
            return result;
        }

        public static KafkaTestResult error(String message) {
            KafkaTestResult result = new KafkaTestResult();
            result.message = message;
            return result;
        }

        public static KafkaTestResult error(Exception e) {
            KafkaTestResult result = new KafkaTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class KsqlTestResult {
        public boolean ok = false;
        public String message = "Unknown error";
        public JsonObject info;
        public SerializedError connectionError;

        public static KsqlTestResult ok(JsonObject info) {
            KsqlTestResult result = new KsqlTestResult();
            result.ok = true;
            result.info = info;
            return result;
        }

        public static KsqlTestResult error(String message) {
            KsqlTestResult result = new KsqlTestResult();
            result.message = message;
            return result;
        }

        public static KsqlTestResult error(Exception e) {
            KsqlTestResult result = new KsqlTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class SQSTestResult {
        public boolean ok = false;
        public String message = "Unknown error";
        public List<String> queues = new ArrayList<String>();
        public SerializedError connectionError;

        public static SQSTestResult ok(List<String> queues) {
            SQSTestResult result = new SQSTestResult();
            result.ok = true;
            result.queues.addAll(queues);
            return result;
        }

        public static SQSTestResult error(String errorMessage) {
            SQSTestResult result = new SQSTestResult();
            result.message = errorMessage;
            return result;
        }

        public static SQSTestResult error(Exception e) {
            SQSTestResult result = new SQSTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class MongoDBConnectionTestResult {
        public boolean configOK;
        public String configErrorMsg;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public int sequenceId;
        public SerializedError connectionError;

        public static MongoDBConnectionTestResult ok() {
            MongoDBConnectionTestResult result = new MongoDBConnectionTestResult();
            result.configOK = true;
            result.connectionOK = true;
            return result;
        }

        public static MongoDBConnectionTestResult configError(String message) {
            MongoDBConnectionTestResult result = new MongoDBConnectionTestResult();
            result.configErrorMsg = message;
            return result;
        }

        public static MongoDBConnectionTestResult connectionError(String message) {
            MongoDBConnectionTestResult result = new MongoDBConnectionTestResult();
            result.configOK = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static MongoDBConnectionTestResult connectionError(Exception e) {
            MongoDBConnectionTestResult result = new MongoDBConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.configOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class DynamoDBConnectionTestResult {
        public boolean configOK;
        public String configErrorMsg;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public int sequenceId;
        public SerializedError connectionError;

        public static DynamoDBConnectionTestResult ok() {
            DynamoDBConnectionTestResult result = new DynamoDBConnectionTestResult();
            result.configOK = true;
            result.connectionOK = true;
            return result;
        }

        public static DynamoDBConnectionTestResult configError(String message) {
            DynamoDBConnectionTestResult result = new DynamoDBConnectionTestResult();
            result.configErrorMsg = message;
            return result;
        }

        public static DynamoDBConnectionTestResult connectionError(String message) {
            DynamoDBConnectionTestResult result = new DynamoDBConnectionTestResult();
            result.configOK = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static DynamoDBConnectionTestResult connectionError(Exception e) {
            DynamoDBConnectionTestResult result = new DynamoDBConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.configOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class CassandraConnectionTestResult {
        public boolean configOK;
        public String configErrorMsg;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public String clusterInfo;
        public SerializedError connectionError;

        public static CassandraConnectionTestResult ok() {
            CassandraConnectionTestResult result = new CassandraConnectionTestResult();
            result.configOK = true;
            result.connectionOK = true;
            return result;
        }

        public static CassandraConnectionTestResult configError(String message) {
            CassandraConnectionTestResult result = new CassandraConnectionTestResult();
            result.configErrorMsg = message;
            return result;
        }

        public static CassandraConnectionTestResult connectionError(String message) {
            CassandraConnectionTestResult result = new CassandraConnectionTestResult();
            result.configOK = true;
            result.connectionErrorMsg = message;
            return result;
        }

        public static CassandraConnectionTestResult connectionError(Exception e) {
            CassandraConnectionTestResult result = new CassandraConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.configOK = false;
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }

    public static class ElasticSearchConnectionTestResult {
        public boolean connectionOK;
        public String connectionErrorMsg;
        public String version;
        public ElasticSearchDialect dialect;
        public String distributionName;
        public SerializedError connectionError;

        public static ElasticSearchConnectionTestResult ok(String version, ElasticSearchUtils.SearchDistribution distribution) {
            ElasticSearchConnectionTestResult result = new ElasticSearchConnectionTestResult();
            result.connectionOK = true;
            result.version = version;
            result.dialect = distribution.getDialect(version);
            result.distributionName = distribution.displayName;
            return result;
        }

        public static ElasticSearchConnectionTestResult error(String message) {
            ElasticSearchConnectionTestResult result = new ElasticSearchConnectionTestResult();
            result.connectionErrorMsg = message;
            return result;
        }

        public static ElasticSearchConnectionTestResult error(Exception e) {
            ElasticSearchConnectionTestResult result = new ElasticSearchConnectionTestResult();
            result.connectionError = new SerializedError((Throwable)e, false);
            result.connectionErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return result;
        }
    }
}

