/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.featurestore.Usages;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExposedObjectsService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.exposedobjects");

    public void addObjectsExpositions(Map<String, Set<TaggableObjectsService.TaggableObjectRef>> toExposeByProject, Set<String> destinationProjects, MultiObjectsExposeSettings expositionSettings) throws Exception {
        Set<TaggableObjectsService.TaggableObjectRef> projectItems;
        if (!destinationProjects.isEmpty()) {
            for (Map.Entry<String, Set<TaggableObjectsService.TaggableObjectRef>> e : toExposeByProject.entrySet()) {
                String sourceProject = e.getKey();
                projectItems = e.getValue();
                this.addObjectsExpositions(sourceProject, destinationProjects, projectItems);
            }
        }
        if (expositionSettings.dashboard) {
            for (Map.Entry<String, Set<TaggableObjectsService.TaggableObjectRef>> e : toExposeByProject.entrySet()) {
                String projectKey = e.getKey();
                projectItems = e.getValue();
                this.makeVisibleOnDashboards(projectKey, projectItems);
            }
        }
    }

    private void makeVisibleOnDashboards(String projectKey, Set<TaggableObjectsService.TaggableObjectRef> projectItems) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        logger.info((Object)("Share objects on dashboards on project " + sp.projectKey));
        for (TaggableObjectsService.TaggableObjectRef ref : projectItems) {
            this.allowItemOnDashBoard(sp, ref);
        }
        this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
    }

    private void allowItemOnDashBoard(SerializedProject sp, TaggableObjectsService.TaggableObjectRef ref) {
        SmartObjectRef smartObjectRef = SmartObjectRef.fromResolved(ref.type, ref.projectKey, ref.id, sp.projectKey);
        sp.dashboardAuthorizations.getOrSetAuthorization(smartObjectRef).makeReadable();
    }

    public void addObjectsExpositions(String sourceProject, Collection<String> targetProjects, Collection<TaggableObjectsService.TaggableObjectRef> projectItems) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(sourceProject);
        logger.info((Object)("Expose objects from " + sp.projectKey + " to " + String.valueOf(targetProjects)));
        for (TaggableObjectsService.TaggableObjectRef ref : projectItems) {
            String localName = ref.getLoc().resolved().getId();
            ExposedObject exposedObject = null;
            for (ExposedObject eo : sp.exposedObjects.objects) {
                if (!eo.localName.equals(localName) || eo.type != ref.type) continue;
                exposedObject = eo;
                break;
            }
            if (exposedObject == null) {
                exposedObject = new ExposedObject(ref.type, localName, false);
                sp.exposedObjects.objects.add(exposedObject);
            }
            for (String targetProject : targetProjects) {
                if (exposedObject.canAccess(targetProject)) continue;
                ExposedObject.Rule rule = new ExposedObject.Rule();
                rule.targetProject = targetProject;
                exposedObject.rules.add(rule);
            }
        }
        this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
    }

    public ObjectsExpositions getObjectsExpositions(Set<TaggableObjectsService.TaggableObjectRef> items) throws IOException {
        HashMap<TaggableObjectsService.TaggableObjectRef, ObjectExposition> expositions = new HashMap<TaggableObjectsService.TaggableObjectRef, ObjectExposition>();
        for (TaggableObjectsService.TaggableObjectRef ref : items) {
            AnyLoc loc = ref.getLoc();
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(loc.getProjectKey());
            ObjectExposition objectExposition = new ObjectExposition();
            for (ExposedObject exposedObject : sp.exposedObjects.objects) {
                if (exposedObject == null || !exposedObject.localName.equals(loc.getId()) || !exposedObject.type.equals((Object)ref.type)) continue;
                objectExposition.quickSharingEnabled = exposedObject.quickSharingEnabled;
                for (ExposedObject.Rule rule : exposedObject.rules) {
                    SerializedProject targetProject = this.projectsService.getOrNullUnsafe(rule.targetProject);
                    if (targetProject != null) {
                        objectExposition.rules.add(ExposedObject.Rule.RuleWithName.fromRule(rule, targetProject.getDisplayName() + " (" + rule.targetProject + ")", false));
                        continue;
                    }
                    objectExposition.rules.add(ExposedObject.Rule.RuleWithName.fromRule(rule, rule.targetProject + " (deleted)", true));
                }
            }
            objectExposition.dashboardAllAuthorized = sp.dashboardAuthorizations.allAuthorized;
            for (SerializedProject.ReaderAuthorization da : sp.dashboardAuthorizations.authorizations) {
                if (!da.objectRef.objectId.equals(loc.getId()) || !da.objectRef.objectType.equals((Object)ref.type)) continue;
                objectExposition.dashboardAuthorizedModes = da.modes;
                break;
            }
            expositions.put(ref, objectExposition);
        }
        return ObjectsExpositions.merge(expositions);
    }

    public SerializedProject.ProjectExposedObjects getEnrichedExposedObjects(String projectKey) throws IOException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        for (int i = 0; i < sp.exposedObjects.objects.size(); ++i) {
            ExposedObject.ExposedObjectWithName exposedObjectWithName;
            ExposedObject exposedObject = sp.exposedObjects.objects.get(i);
            TaggableObjectsService.TaggableObject object = this.taggableObjectsReadService.getOrNullUnsafe(projectKey, exposedObject.type, exposedObject.localName);
            if (object != null) {
                exposedObjectWithName = ExposedObject.ExposedObjectWithName.fromExposedObject(exposedObject, object.getDisplayName());
                if (object.getTaggableType().equals((Object)ITaggingService.TaggableType.SAVED_MODEL)) {
                    exposedObjectWithName.setSavedModelMLCategory((SavedModel)object);
                }
            } else {
                exposedObjectWithName = ExposedObject.ExposedObjectWithName.fromExposedObject(exposedObject, exposedObject.localName + " (deleted)");
            }
            for (int j = 0; j < exposedObjectWithName.rules.size(); ++j) {
                ExposedObject.Rule rule = exposedObject.rules.get(j);
                SerializedProject project = this.projectsService.getOrNullUnsafe(rule.targetProject);
                if (project != null) {
                    exposedObjectWithName.rules.set(j, ExposedObject.Rule.RuleWithName.fromRule(rule, project.getDisplayName() + " (" + rule.targetProject + ")", false));
                    continue;
                }
                exposedObjectWithName.rules.set(j, ExposedObject.Rule.RuleWithName.fromRule(rule, rule.targetProject + " (deleted)", true));
            }
            sp.exposedObjects.objects.set(i, exposedObjectWithName);
        }
        return sp.exposedObjects;
    }

    public void saveObjectExposition(String sourceProjectKey, ITaggingService.TaggableType objectType, String objectId, ObjectExposition exposition, AuthCtx authCtx) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(sourceProjectKey);
        ExposedObject exposedObject = sp.exposedObjects.objects.stream().filter(o -> o.localName.equals(objectId) && o.type == objectType).findAny().orElse(null);
        if (exposedObject == null) {
            exposedObject = new ExposedObject(objectType, objectId, false);
            sp.exposedObjects.objects.add(exposedObject);
        }
        exposedObject.quickSharingEnabled = exposition.quickSharingEnabled;
        exposedObject.rules = exposition.rules;
        if (!exposedObject.quickSharingEnabled && exposedObject.rules != null && exposedObject.rules.isEmpty()) {
            sp.exposedObjects.objects.remove(exposedObject);
        }
        if (this.permissionsService.hasProjectPrivilege(authCtx, sourceProjectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS)) {
            boolean found = false;
            Iterator<SerializedProject.ReaderAuthorization> iter = sp.dashboardAuthorizations.authorizations.iterator();
            while (iter.hasNext()) {
                SerializedProject.ReaderAuthorization dashboardAuthorization = iter.next();
                if (dashboardAuthorization.objectRef.isForeign() || !dashboardAuthorization.objectRef.objectId.equals(objectId) || !dashboardAuthorization.objectRef.objectType.equals((Object)objectType)) continue;
                dashboardAuthorization.modes = exposition.dashboardAuthorizedModes;
                found = true;
                if (!dashboardAuthorization.modes.isEmpty()) break;
                iter.remove();
                break;
            }
            if (!found && !exposition.dashboardAuthorizedModes.isEmpty()) {
                SmartObjectRef smartObjectRef = new SmartObjectRef(objectType, objectId);
                sp.dashboardAuthorizations.authorizations.add(new SerializedProject.ReaderAuthorization(smartObjectRef, exposition.dashboardAuthorizedModes));
            }
            sp.dashboardAuthorizations.allAuthorized = exposition.dashboardAllAuthorized;
        }
        this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
    }

    public void renameObjectAuthorizations(String projectKey, ITaggingService.TaggableType type, String oldName, String newName) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        ExposedObject exposedObject = sp.exposedObjects.objects.stream().filter(o -> o.type.equals((Object)type) && o.localName.equals(oldName)).findAny().orElse(null);
        if (exposedObject != null) {
            exposedObject.localName = newName;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
        }
    }

    public void updateObjectExpositions(String projectKey, ITaggingService.TaggableType type, String objectId, Collection<String> addTargetProjectKeys, Collection<String> removedTargetProjectKeys) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        ExposedObject object = sp.exposedObjects.objects.stream().filter(o -> o.type.equals((Object)type) && o.localName.equals(objectId)).findAny().orElse(null);
        if (object != null) {
            for (String targetProjectKey : removedTargetProjectKeys) {
                object.rules.stream().filter(r -> r.targetProject.equals(targetProjectKey)).findAny().ifPresent(value -> object.rules.remove(value));
            }
            for (String targetProjectKey : addTargetProjectKeys) {
                ExposedObject.Rule rule = object.rules.stream().filter(r -> r.targetProject.equals(targetProjectKey)).findAny().orElse(null);
                if (rule != null) continue;
                rule = new ExposedObject.Rule();
                rule.targetProject = targetProjectKey;
                rule.appearOnFlow = true;
                object.rules.add(rule);
            }
        }
        this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
    }

    public void renameObjectDashboardAuthorizations(String projectKey, String objectProjectKey, ITaggingService.TaggableType objectType, String oldObjectId, String newObjectId) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        Iterator<SerializedProject.ReaderAuthorization> iter = sp.dashboardAuthorizations.authorizations.iterator();
        while (iter.hasNext()) {
            SerializedProject.ReaderAuthorization dashboardAuthorization = iter.next();
            if (!Objects.equals(objectProjectKey, dashboardAuthorization.objectRef.projectKey) || !dashboardAuthorization.objectRef.objectId.equals(oldObjectId) || !dashboardAuthorization.objectRef.objectType.equals((Object)objectType)) continue;
            if (dashboardAuthorization.modes.isEmpty()) {
                iter.remove();
            } else {
                dashboardAuthorization.objectRef.objectId = newObjectId;
            }
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
            break;
        }
    }

    public InfoMessage addExposedObject(String projectKey, ITaggingService.TaggableType type, String objectId, String targetProjectKey) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        ExposedObject exposedObject = sp.exposedObjects.objects.stream().filter(o -> type == o.type && objectId.equals(o.localName)).findAny().orElse(null);
        if (exposedObject == null) {
            exposedObject = new ExposedObject(type, objectId, false);
            sp.exposedObjects.objects.add(exposedObject);
        }
        if (!exposedObject.canAccess(targetProjectKey)) {
            ExposedObject.Rule newRule = new ExposedObject.Rule();
            newRule.targetProject = targetProjectKey;
            newRule.appearOnFlow = true;
            exposedObject.rules.add(newRule);
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
            return new InfoMessage(InfoMessage.Severity.SUCCESS, "Object successfully shared.", null);
        }
        return new InfoMessage(InfoMessage.Severity.INFO, "Object already shared.", null);
    }

    public void addExposedObject(String sourceProjectKey, List<ExposedObject> objectsToExpose) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sourceProject = this.projectsService.getMandatory(sourceProjectKey);
        SerializedProject.ProjectExposedObjects sourceProjectExposedObjects = sourceProject.exposedObjects;
        for (ExposedObject objectToExpose : objectsToExpose) {
            boolean addNewExposedObject = true;
            for (ExposedObject sourceProjectExposedObject : sourceProjectExposedObjects.objects) {
                boolean isObjectToExposeAlreadyExposed = objectToExpose.type == sourceProjectExposedObject.type && StringUtils.equals((String)objectToExpose.localName, (String)sourceProjectExposedObject.localName);
                if (!isObjectToExposeAlreadyExposed) continue;
                ExposedObject.Rule newExpositionRule = objectToExpose.rules.get(0);
                boolean addNewExpositionRuleForTargetProject = true;
                for (ExposedObject.Rule existingRule : sourceProjectExposedObject.rules) {
                    boolean isAlreadyExposedForTargetProject = StringUtils.equals((String)newExpositionRule.targetProject, (String)existingRule.targetProject);
                    if (!isAlreadyExposedForTargetProject) continue;
                    addNewExpositionRuleForTargetProject = false;
                    break;
                }
                if (!addNewExpositionRuleForTargetProject) continue;
                sourceProjectExposedObject.rules.add(newExpositionRule);
                addNewExposedObject = false;
                break;
            }
            if (!addNewExposedObject) continue;
            sourceProjectExposedObjects.objects.add(objectToExpose);
        }
        sourceProject.exposedObjects = sourceProjectExposedObjects;
        this.projectsService.save(sourceProject, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_AND_EXPOSED_ONLY);
    }

    public void unshare(String projectKey, List<String> unexposedProjects) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        SerializedProject sourceProject = this.projectsService.getMandatory(projectKey);
        for (ExposedObject sourceProjectExposedObject : sourceProject.exposedObjects.objects) {
            sourceProjectExposedObject.rules.removeIf(exposedObjectRule -> unexposedProjects.contains(exposedObjectRule.targetProject));
        }
        this.projectsService.save(sourceProject, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_AND_EXPOSED_ONLY);
    }

    public void unshare(Set<TaggableObjectsService.TaggableObjectRef> refs) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        this.unshare(refs, null);
    }

    public void unshare(Set<TaggableObjectsService.TaggableObjectRef> refs, String targetProjectKey) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            AnyLoc loc = ref.getLoc().resolved();
            SerializedProject sp = this.projectsService.getMandatory(loc.getProjectKey());
            boolean changed = false;
            Iterator<ExposedObject> iter = sp.exposedObjects.objects.iterator();
            while (iter.hasNext()) {
                ExposedObject exposedObject = iter.next();
                if (!exposedObject.localName.equals(loc.getId()) || !exposedObject.type.equals((Object)ref.type)) continue;
                Iterator<ExposedObject.Rule> iter2 = exposedObject.rules.iterator();
                while (iter2.hasNext()) {
                    ExposedObject.Rule r = iter2.next();
                    if (targetProjectKey != null && !targetProjectKey.equals(r.targetProject)) continue;
                    iter2.remove();
                    changed = true;
                }
                if (!exposedObject.rules.isEmpty() || exposedObject.quickSharingEnabled) continue;
                iter.remove();
                changed = true;
            }
            if (!changed) continue;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
        }
    }

    public boolean isQuickSharingEnabled(String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException {
        SerializedProject project = this.projectsService.getOrNullUnsafe(projectKey);
        return this.isQuickSharingEnabled(project, objectType, objectId);
    }

    public boolean isQuickSharingEnabled(SerializedProject project, ITaggingService.TaggableType objectType, String objectId) {
        if (!ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().quickSharingElementsEnabled) {
            return false;
        }
        return project != null && project.exposedObjects.objects.stream().filter(o -> o.type == objectType && o.localName.equals(objectId)).findAny().map(o -> o.quickSharingEnabled).orElse(false) != false;
    }

    public Set<TaggableObjectsService.TaggableObjectRef> getQuickSharedObjects(SerializedProject project, @Nullable ITaggingService.TaggableType type) {
        if (project == null || !ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().quickSharingElementsEnabled) {
            return Collections.emptySet();
        }
        return project.exposedObjects.objects.stream().filter(o -> (type == null || o.type == type) && o.quickSharingEnabled).map(o -> new TaggableObjectsService.TaggableObjectRef(project.projectKey, o.type, o.localName)).collect(Collectors.toSet());
    }

    public void enableQuickSharing(String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        if (!ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().quickSharingElementsEnabled) {
            throw new IllegalStateException("Quick sharing is globally disabled.");
        }
        SerializedProject project = this.projectsService.getMandatory(projectKey);
        ExposedObject exposedObject = project.exposedObjects.objects.stream().filter(o -> o.type == objectType && o.localName.equals(objectId)).findFirst().orElse(null);
        if (exposedObject == null) {
            exposedObject = new ExposedObject(objectType, objectId, false);
            project.exposedObjects.objects.add(exposedObject);
        } else if (exposedObject.quickSharingEnabled) {
            throw new IllegalArgumentException("Quick sharing is already enabled on " + projectKey + "." + String.valueOf((Object)objectType) + "." + objectId);
        }
        exposedObject.quickSharingEnabled = true;
        this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
    }

    public ExposedObject getExposedObject(String projectKey, ITaggingService.TaggableType objectType, String objectId) throws IOException {
        SerializedProject project = this.projectsService.getOrNullUnsafe(projectKey);
        if (project == null) {
            return null;
        }
        return project.exposedObjects.objects.stream().filter(o -> o.type == objectType && o.localName.equals(objectId)).findAny().orElse(null);
    }

    public void removeExposedObject(String projectKey, ITaggingService.TaggableType objectType, String objectId) throws CodedException, LimitsStatusComputer.LicenseLimitException, IOException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        boolean changed = sp.exposedObjects.objects.removeIf(o -> o.type.equals((Object)objectType) && o.localName.equals(objectId));
        if (changed) {
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
        }
    }

    private ObjectAuthorizations getObjectAuthorizationsInternal(String projectKey, String objectId, ITaggingService.TaggableType objectType, AuthCtx authCtx, Boolean precomputedCanReadObject) throws IOException, DKUSecurityException {
        ObjectAuthorizations objectAuthorizations = new ObjectAuthorizations();
        SerializedProject sp = this.projectsService.getOrNullUnsafe(projectKey);
        if (sp != null) {
            objectAuthorizations.isObjectSharingRequestEnabled = this.projectsService.isObjectSharingRequestEnabled(sp);
            objectAuthorizations.isQuicklyShareable = this.isQuickSharingEnabled(projectKey, objectType, objectId);
            objectAuthorizations.canManageExposedElements = this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
            objectAuthorizations.canWriteObject = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            objectAuthorizations.canShareToWorkspaces = ((DSSAuthCtx)authCtx).getPermissions().mayShareToWorkspaces() && this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.SHARE_TO_WORKSPACES);
            objectAuthorizations.canPublishToDataCollections = ((DSSAuthCtx)authCtx).getPermissions().mayPublishToDataCollections() && this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.PUBLISH_TO_DATA_COLLECTIONS);
            boolean impliesDirectAccessOnOriginal = objectAuthorizations.canShareToWorkspaces || objectAuthorizations.canPublishToDataCollections || objectAuthorizations.canWriteObject;
            boolean bl = objectAuthorizations.directAccessOnOriginal = impliesDirectAccessOnOriginal || this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            objectAuthorizations.canReadObject = precomputedCanReadObject == null ? objectAuthorizations.directAccessOnOriginal || this.projectsService.hasAnyReadPermissionRegardlessOfContext(authCtx, projectKey, objectType, objectId) : precomputedCanReadObject;
        }
        return objectAuthorizations;
    }

    public ObjectAuthorizations getObjectAuthorizations(String projectKey, String objectId, ITaggingService.TaggableType objectType, AuthCtx authCtx) throws IOException, DKUSecurityException {
        return this.getObjectAuthorizationsInternal(projectKey, objectId, objectType, authCtx, null);
    }

    public ObjectAuthorizations getObjectAuthorizations(String projectKey, String objectId, ITaggingService.TaggableType objectType, AuthCtx authCtx, boolean precomputedCanReadObject) throws IOException, DKUSecurityException {
        return this.getObjectAuthorizationsInternal(projectKey, objectId, objectType, authCtx, precomputedCanReadObject);
    }

    public Usages getUsages(AuthCtx user, String projectKey, String objectId, ITaggingService.TaggableType objectType) throws IOException, DKUSecurityException {
        ArrayList<Usages.Project> projectsUsingObject = new ArrayList<Usages.Project>();
        int usagesInNonAccessibleProjects = 0;
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        for (ExposedObject exposedObject : sp.exposedObjects.objects) {
            if (exposedObject == null || !exposedObject.localName.equals(objectId) || !exposedObject.type.equals((Object)objectType)) continue;
            for (ExposedObject.Rule rule : exposedObject.rules) {
                SerializedProject targetProject = this.projectsService.getOrNullUnsafe(rule.targetProject);
                if (targetProject == null) continue;
                boolean canAccess = this.permissionsService.hasAnyProjectAccess(user, targetProject.projectKey);
                if (canAccess || this.projectsService.isVisible(targetProject, gs)) {
                    projectsUsingObject.add(new Usages.Project(targetProject.projectKey, targetProject.name, canAccess, this.permissionsService.hasProjectPrivilege(user, targetProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)));
                    continue;
                }
                ++usagesInNonAccessibleProjects;
            }
        }
        Usages usages = new Usages();
        usages.projectsWithAccess = projectsUsingObject;
        usages.usagesInNonAccessibleProjects = usagesInNonAccessibleProjects;
        return usages;
    }

    public static class MultiObjectsExposeSettings {
        public boolean dashboard;
        public Map<String, MultiObjectsExposeProjectRule> projects;
    }

    public static class ObjectExposition {
        public boolean quickSharingEnabled;
        public boolean dashboardAllAuthorized;
        public Set<SerializedProject.ReaderAuthorization.Mode> dashboardAuthorizedModes = new HashSet<SerializedProject.ReaderAuthorization.Mode>();
        public List<ExposedObject.Rule> rules = new ArrayList<ExposedObject.Rule>();
    }

    public static class ObjectsExpositions {
        public List<TaggableObjectsService.TaggableObjectRef> dashboard = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        public List<TaggableObjectsService.TaggableObjectRef> quickSharedObjects = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        public Map<String, ProjectExposition> projects = new HashMap<String, ProjectExposition>();

        public static ObjectsExpositions merge(Map<TaggableObjectsService.TaggableObjectRef, ObjectExposition> expositions) {
            ObjectsExpositions ret = new ObjectsExpositions();
            for (Map.Entry<TaggableObjectsService.TaggableObjectRef, ObjectExposition> entry : expositions.entrySet()) {
                if (SerializedProject.ReaderAuthorization.canRead(entry.getValue().dashboardAuthorizedModes)) {
                    ret.dashboard.add(entry.getKey());
                }
                if (entry.getValue().quickSharingEnabled) {
                    ret.quickSharedObjects.add(entry.getKey());
                }
                for (ExposedObject.Rule rule : entry.getValue().rules) {
                    ExposedObject.Rule.RuleWithName r = (ExposedObject.Rule.RuleWithName)rule;
                    if (ret.projects.get(rule.targetProject) == null) {
                        ret.projects.put(rule.targetProject, new ProjectExposition(r.targetProjectDisplayName));
                    }
                    ret.projects.get((Object)rule.targetProject).items.add(entry.getKey());
                }
            }
            return ret;
        }
    }

    @UIModel
    public static class ObjectAuthorizations {
        public boolean canReadObject;
        public boolean canWriteObject;
        public boolean canManageExposedElements;
        public boolean canShareToWorkspaces;
        public boolean canPublishToDataCollections;
        public boolean isQuicklyShareable;
        public boolean isObjectSharingRequestEnabled;
        public boolean directAccessOnOriginal;
    }

    public static class MultiObjectsExposeProjectRule {
        public boolean exposeAll;
    }

    public static class ProjectExposition {
        public String projectDisplayName;
        public List<TaggableObjectsService.TaggableObjectRef> items = new ArrayList<TaggableObjectsService.TaggableObjectRef>();

        ProjectExposition(String projectDisplayName) {
            this.projectDisplayName = projectDisplayName;
        }
    }
}

