/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AnyLoc;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowZonesService {
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private ProjectsService projectsService;

    public void attachObjectToZone(String zoneId, String projectKey, TaggableObjectsService.TaggableObject newObj) throws IOException {
        this.attachObjectToZone(zoneId, projectKey, newObj.getRef(), false);
    }

    public void attachObjectToZone(String zoneId, String projectKey, TaggableObjectsService.TaggableObject newObj, boolean invalidateCache) throws IOException {
        this.attachObjectToZone(zoneId, projectKey, newObj.getRef(), invalidateCache);
    }

    public void attachObjectToZone(String zoneId, String projectKey, TaggableObjectsService.TaggableObjectRef newObjRef, boolean invalidateCache) throws IOException {
        SmartObjectRef smRef = SmartObjectRef.fromResolved(newObjRef.type, newObjRef.projectKey, newObjRef.id, projectKey);
        this.attachObjectToZone(zoneId, projectKey, smRef, invalidateCache);
    }

    public void attachObjectToZone(String zoneId, String projectKey, SmartObjectRef newObjRef, boolean invalidateCache) throws IOException {
        if (StringUtils.isBlank((String)zoneId)) {
            return;
        }
        TransactionContext.assertAttachedRWTransaction();
        ProjectFlowGraph projectGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        if (projectGraph != null) {
            Zone zoneFound;
            Zone newObjZone = projectGraph.getZone(newObjRef);
            if (newObjZone != null) {
                Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, newObjZone.getId());
                zone.removeItem(newObjRef);
                this.zonesDAO.save(projectKey, zone);
            }
            if ((zoneFound = projectGraph.getZone(zoneId)) != null && !Zone.DEFAULT_ZONE.getId().equals(zoneId)) {
                Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneFound.getId());
                zone.addItem(newObjRef);
                this.zonesDAO.save(projectKey, zone);
            }
            if (invalidateCache) {
                this.flowGraphService.invalidateCache(projectKey);
            }
        }
    }

    public List<TaggableObjectsService.TaggableObjectRef> attachObjectToZoneWithImpacts(String zoneId, String projectKey, SmartObjectRef newObjRef, boolean invalidateCache) throws IOException {
        this.attachObjectToZone(zoneId, projectKey, newObjRef, invalidateCache);
        List<GraphNode> impacts = this.computeMovingImpacts(projectKey, newObjRef);
        ArrayList<TaggableObjectsService.TaggableObjectRef> refs = new ArrayList<TaggableObjectsService.TaggableObjectRef>(impacts.size());
        for (GraphNode node : impacts) {
            if (node instanceof FlowRecipe) {
                SerializedRecipe model = ((FlowRecipe)node).getModel();
                this.attachObjectToZone(zoneId, projectKey, model);
                refs.add(model.getRef());
                continue;
            }
            if (!(node instanceof FlowComputable)) continue;
            AnyLoc anyLoc = AnyLoc.resolveFull(node.getFullId());
            TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(anyLoc.getProjectKey(), ((FlowComputable)node).getType().toTaggableType(), anyLoc.getId());
            this.attachObjectToZone(zoneId, projectKey, ref, true);
            refs.add(ref);
        }
        return refs;
    }

    private List<GraphNode> addSuccessors(GraphNode node, GraphNode realNode) {
        if (!(node instanceof FlowRunnable)) {
            return Collections.emptyList();
        }
        ArrayList<GraphNode> computedImpact = new ArrayList<GraphNode>();
        for (GraphNode graphNode : node.getSuccessors()) {
            if (realNode != null && Objects.equals(graphNode.getFullId(), realNode.getFullId())) continue;
            computedImpact.add(graphNode);
        }
        return computedImpact;
    }

    private List<GraphNode> computeMovingImpacts(String projectKey, SmartObjectRef ref) throws IOException {
        ProjectFlowGraph projectGraph = this.flowGraphService.getProjectGraph(projectKey, true);
        GraphNode node = ref.objectType == ITaggingService.TaggableType.RECIPE ? projectGraph.getRecipe(projectKey, ref.objectId) : projectGraph.getComputable(ref.getFullId(projectKey));
        ArrayList<GraphNode> computedImpact = new ArrayList<GraphNode>();
        if (node == null) {
            return computedImpact;
        }
        for (GraphNode graphNode : node.getPredecessors()) {
            if (graphNode == null || node instanceof FlowRunnable) continue;
            computedImpact.add(graphNode);
            computedImpact.addAll(this.addSuccessors(graphNode, node));
        }
        computedImpact.addAll(this.addSuccessors(node, null));
        return computedImpact;
    }

    public void shareObjectToZone(String zoneId, String projectKey, SmartObjectRef sharingItem) throws IOException {
        if (StringUtils.isBlank((String)zoneId)) {
            return;
        }
        TransactionContext.assertAttachedRWTransaction();
        Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
        zone.addZoneShared(sharingItem);
        this.zonesDAO.save(projectKey, zone);
    }

    public void detachObjectFromZone(String contextProjectKey, SmartObjectRef to) throws IOException {
        Zone zoneFound;
        TransactionContext.assertAttachedRWTransaction();
        ProjectFlowGraph projectGraph = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey);
        if (projectGraph != null && (zoneFound = projectGraph.getZone(to)) != null) {
            Zone zone = (Zone)this.zonesDAO.getMandatory(contextProjectKey, zoneFound.getId());
            zone.removeItem(to);
            this.zonesDAO.save(zone.getProjectKey(), zone);
        }
    }

    public void cleanupObjectFromZones(String projectKey, TaggableObjectsService.TaggableObject to) throws IOException {
        SmartObjectRef smRef = this.toSmartObjectRef(projectKey, to);
        this.detachObjectFromZone(projectKey, smRef);
        this.unshareObjectFromZones(projectKey, smRef);
    }

    private SmartObjectRef toSmartObjectRef(String contextProject, TaggableObjectsService.TaggableObject to) {
        return SmartObjectRef.fromResolved(to.getTaggableType(), to.getProjectKey(), to.getId(), contextProject);
    }

    public void unshareObjectFromZones(String contextProjectKey, SmartObjectRef smRef) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        for (Zone zone : this.zonesDAO.list(contextProjectKey)) {
            if (zone.getShared().isEmpty()) continue;
            zone.removeZoneShared(smRef);
            this.zonesDAO.save(contextProjectKey, zone);
        }
    }

    public void unshareObjectFromZone(String contextProjectKey, String zoneId, SmartObjectRef smRef) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        Zone zone = (Zone)this.zonesDAO.getMandatory(contextProjectKey, zoneId);
        if (zone.getShared().isEmpty()) {
            return;
        }
        zone.removeZoneShared(smRef);
        this.zonesDAO.save(contextProjectKey, zone);
    }

    public String retrieveZone(String projectKey, TaggableObjectsService.TaggableObject object) throws IOException {
        return this.retrieveZone(projectKey, SmartObjectRef.fromResolved(object.getTaggableType(), object.getProjectKey(), object.getId(), projectKey));
    }

    public String retrieveZone(String projectKey, TaggableObjectsService.TaggableObjectRef object) throws IOException {
        return this.retrieveZone(projectKey, SmartObjectRef.fromResolved(object.type, projectKey, object.id, projectKey));
    }

    public String retrieveZone(String projectKey, SmartObjectRef smartObjectRef) throws IOException {
        ProjectFlowGraph projectGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        if (projectGraph != null) {
            Zone zone = projectGraph.getZone(smartObjectRef);
            if (zone != null) {
                return zone.getId();
            }
            return Zone.DEFAULT_ZONE.getId();
        }
        return null;
    }

    public String retrieveInputZone(SerializedRecipe recipe) throws IOException {
        List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
        if (recipe.type.startsWith("CustomCode_") && inputs.isEmpty()) {
            inputs = recipe.getFlatInputs();
        }
        for (SerializedRecipe.RecipeInput input : inputs) {
            String zoneId;
            Dataset dataset = this.datasetAccessService.getOrNull(input.getLoc(recipe.projectKey));
            if (dataset == null || !StringUtils.isNotBlank((String)(zoneId = this.retrieveZone(recipe.projectKey, dataset.getModel())))) continue;
            return zoneId;
        }
        return null;
    }

    public String retrieveInputZone(LabelingTask labelingTask) throws IOException {
        List<LabelingTask.LabelingTaskInput> inputs = labelingTask.getFlatInputs();
        for (LabelingTask.LabelingTaskInput input : inputs) {
            String zoneId;
            Dataset dataset = this.datasetAccessService.getOrNull(input.getLoc(labelingTask.projectKey));
            if (dataset == null || !StringUtils.isNotBlank((String)(zoneId = this.retrieveZone(labelingTask.projectKey, dataset.getModel())))) continue;
            return zoneId;
        }
        return null;
    }

    public void create(String projectKey, Zone zone, AuthCtx authCtx) throws IOException {
        if (!Zone.DEFAULT_ZONE.getId().equals(zone.getId()) && this.zonesDAO.approximateCount(projectKey) == 0) {
            this.create(projectKey, Zone.DEFAULT_ZONE, authCtx);
        }
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        if (sp.settings.flowDisplaySettings.zonesManualPositioning) {
            this.computeNewZonePosition(projectKey, zone);
        }
        this.zonesDAO.save(projectKey, zone);
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.FLOW_ZONE, projectKey, zone.getId(), authCtx.getIdentifier(), TaggableObjectChangedEvent.ActionType.FLOW_ZONE_CREATE));
    }

    private void computeNewZonePosition(String projectKey, Zone zone) throws IOException {
        List allExistingZones = this.zonesDAO.listUnsafe(projectKey);
        double newX = allExistingZones.stream().map(Zone::getRightMostX).filter(Objects::nonNull).reduce(Math::max).orElse(0.0) + 100.0;
        double newY = allExistingZones.stream().map(Zone::getY).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
        zone.setCoordinates(newX, newY);
        zone.setDimensions(428.0, 428.0);
    }

    public void edit(String projectKey, Zone zone, AuthCtx authCtx) throws IOException {
        this.zonesDAO.save(projectKey, zone);
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.FLOW_ZONE, projectKey, zone.getId(), authCtx.getIdentifier(), TaggableObjectChangedEvent.ActionType.FLOW_ZONE_EDIT));
    }

    public void delete(String projectKey, String zoneId, AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.delete(projectKey, zoneId, authCtx, false);
    }

    private void delete(String projectKey, String zoneId, AuthCtx authCtx, boolean forceDefaultDeletion) throws IOException, UnauthorizedException {
        if (!forceDefaultDeletion && Objects.equals(zoneId, Zone.DEFAULT_ZONE.getId())) {
            throw new UnauthorizedException("Action forbidden", "cannot-delete-default-zone");
        }
        this.zonesDAO.delete(projectKey, zoneId);
        if (this.zonesDAO.approximateCount(projectKey) == 1) {
            this.delete(projectKey, Zone.DEFAULT_ZONE.getId(), authCtx, true);
        }
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.FLOW_ZONE, projectKey, zoneId, authCtx.getIdentifier(), TaggableObjectChangedEvent.ActionType.FLOW_ZONE_DELETE));
    }

    public List<Zone> listContains(String projectKey, ITaggingService.TaggableType type, String objectId) throws IOException {
        Preconditions.checkNotNull((Object)objectId, (Object)"objectID cannot be null");
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        Set<String> projectsExposedTo = sp.exposedObjects.getProjectsExposedTo(type, objectId);
        projectsExposedTo.add(projectKey);
        ArrayList<Zone> zones = new ArrayList<Zone>();
        for (String contextProjectKey : projectsExposedTo) {
            SmartObjectRef ref = SmartObjectRef.fromResolved(type, projectKey, objectId, contextProjectKey);
            List projectZones = this.zonesDAO.listUnsafe(contextProjectKey);
            if (projectZones == null || projectZones.isEmpty()) continue;
            for (Zone zone : projectZones) {
                if (!zone.getItems().contains(ref) && !zone.getShared().contains(ref)) continue;
                zones.add(zone);
            }
        }
        return zones;
    }
}

