/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DataCollectionPermissionsService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomepageContentService {
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DataCollectionsService dataCollectionService;
    @Autowired
    private DataCollectionPermissionsService dataCollectionPermissionsService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private AppsService appsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.homepage");

    public List<Article> getHomeArticles(AuthCtx authCtx) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
        Set<AnyLoc> all = generalSettings.personalHomePages.articles;
        ArrayList<Article> ret = new ArrayList<Article>();
        for (AnyLoc loc : all) {
            String projectKey = loc.getProjectKey();
            if (StringUtils.isEmpty((String)projectKey) || !this.projectsService.projectExists(projectKey) || !this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
            Article article = new Article();
            article.id = loc.getId();
            article.projectKey = projectKey;
            if (StringUtils.isEmpty((String)article.id)) continue;
            article.name = this.articlesCacheService.getNameMapping(article.projectKey, article.id);
            if (StringUtils.isEmpty((String)article.name)) continue;
            ret.add(article);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public List<HomepagePromotedContent> getHomepagePromotedContent(AuthCtx authCtx) throws IOException, DKUSecurityException {
        generalSettings = this.generalSettingsService.read();
        promotedContent = generalSettings.personalHomePages.promotedContent;
        ret = new ArrayList<HomepagePromotedContent>();
        block22: for (GeneralSettingsDAO.HomepagePromotedContent content : promotedContent) {
            projectKey = content.projectKey;
            if (content.type == null) {
                HomepageContentService.logger.warn((Object)"Unexpected null promoted content type");
                continue;
            }
            switch (1.$SwitchMap$com$dataiku$dip$server$services$HomepageContentService$HomePromotableType[content.type.ordinal()]) {
                case 1: {
                    if (!StringUtils.isNotBlank((String)content.id)) continue block22;
                    project = null;
                    try {
                        project = this.projectsService.getSummaryOrNull(authCtx, content.id);
                    }
                    catch (Exception e) {
                        HomepageContentService.logger.warn((Object)("Failed to get project: " + content.id));
                    }
                    if (project == null || !project.canReadProjectContent) continue block22;
                    ret.add(new PromotedProject(project.projectKey, (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customTitle, project.getDisplayName()}), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customDescription, project.shortDesc, project.description}), SerializedProject.ProjectAppType.APP_INSTANCE.equals((Object)project.projectAppType), content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId, project.imgColor));
                    break;
                }
                case 2: {
                    if (!StringUtils.isNotBlank((String)content.id)) continue block22;
                    manifest = null;
                    try {
                        manifest = this.appsService.getAppTemplateManifestUnsafe_T(content.id);
                        if (!this.appsService.hasAppInstantiatePerm_T(authCtx, manifest) && !this.appsService.isVisible(manifest, generalSettings)) {
                        }
                        ** GOTO lbl33
                    }
                    catch (Exception e) {
                        HomepageContentService.logger.warn((Object)("Failed to get app: " + content.id));
                    }
                    continue block22;
lbl33:
                    // 1 sources

                    ret.add(new PromotedApp(content.id, (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customTitle, manifest.label}), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customDescription, manifest.shortDesc, manifest.description}), content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId, manifest.imgColor));
                    break;
                }
                case 3: {
                    if (!StringUtils.isNotBlank((String)content.id)) continue block22;
                    workspace = null;
                    try {
                        workspace = this.workspacesService.getWorkspace(authCtx, content.id);
                    }
                    catch (Exception e) {
                        HomepageContentService.logger.warn((Object)("Failed to get workspace: " + content.id));
                    }
                    if (workspace == null || !workspace.currentUserPermissions.read) continue block22;
                    ret.add(new PromotedWorkspace(workspace.getId(), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customTitle, workspace.getDisplayName()}), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customDescription, workspace.shortDesc, workspace.description}), content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId, workspace.color));
                    break;
                }
                case 4: {
                    if (!StringUtils.isNotBlank((String)projectKey) || !StringUtils.isNotBlank((String)content.id) || !this.projectsService.projectExists(projectKey) || !this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue block22;
                    webApp = null;
                    try {
                        webApp = this.webAppsService.getOrNullUnsafe(projectKey, content.id);
                    }
                    catch (Exception e) {
                        HomepageContentService.logger.warn((Object)("Failed to get webApp: " + projectKey + " | " + content.id));
                    }
                    if (webApp == null) continue block22;
                    ret.add(new PromotedWebApp(content.projectKey, webApp.getId(), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customTitle, webApp.getDisplayName()}), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customDescription, webApp.shortDesc, webApp.description}), content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId));
                    break;
                }
                case 5: {
                    if (!StringUtils.isNotBlank((String)projectKey) || !StringUtils.isNotBlank((String)content.id) || !this.projectsService.projectExists(projectKey) || !this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue block22;
                    articleName = null;
                    try {
                        articleName = this.articlesCacheService.getNameMapping(projectKey, content.id);
                    }
                    catch (Exception e) {
                        HomepageContentService.logger.warn((Object)("Failed to get article name: " + projectKey + " | " + content.id));
                    }
                    if (StringUtils.isEmpty((String)articleName)) continue block22;
                    ret.add(new PromotedArticle(content.projectKey, content.id, (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customTitle, articleName}), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customDescription, this.wikisService.getArticlePayloadOrNull(projectKey, content.id)}), content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId));
                    break;
                }
                case 6: {
                    if (!StringUtils.isNotBlank((String)content.id)) continue block22;
                    dataCollection = null;
                    try {
                        dataCollection = this.dataCollectionService.getOrNullUnsafe(content.id);
                        if (!this.dataCollectionPermissionsService.hasDataCollectionPrivileges(authCtx, dataCollection, new Privileges.DataCollectionLevelPrivilegeType[]{Privileges.DataCollectionLevelPrivilegeType.READ})) {
                            continue block22;
                        }
                    }
                    catch (Exception e) {
                        HomepageContentService.logger.warn((Object)("Failed to get data collection: " + content.id));
                    }
                    if (dataCollection == null) continue block22;
                    ret.add(new PromotedDataCollection(content.id, (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customTitle, dataCollection.displayName}), (String)org.apache.commons.lang3.StringUtils.firstNonBlank((CharSequence[])new String[]{content.customDescription, dataCollection.description}), content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId, dataCollection.color));
                    break;
                }
                case 7: {
                    ret.add(new PromotedAdminMessage(content.customTitle, content.customDescription));
                    break;
                }
                case 8: {
                    ret.add(new PromotedLink(content.url, content.customTitle, content.customDescription, content.openInNewTab, content.thumbnailMode, content.customThumbnailImageId));
                    break;
                }
                default: {
                    HomepageContentService.logger.warn((Object)("Unexpected promoted content type: " + String.valueOf((Object)content.type)));
                }
            }
        }
        return ret;
    }

    public static enum HomePromotableType {
        PROJECT,
        APP,
        WORKSPACE,
        WEB_APP,
        ARTICLE,
        DATA_COLLECTION,
        ADMIN_MESSAGE,
        LINK;

    }

    public static class PromotedProject
    extends HomepagePromotedContent {
        String id;
        boolean isAppInstance;
        String color;

        public PromotedProject(String id, String displayName, String description, boolean isAppInstance, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId, String color) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.id = id;
            this.isAppInstance = isAppInstance;
            this.color = color;
        }

        private PromotedProject() {
        }
    }

    public static class PromotedApp
    extends HomepagePromotedContent {
        String id;
        String color;

        public PromotedApp(String id, String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId, String color) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.id = id;
            this.color = color;
        }

        private PromotedApp() {
        }
    }

    public static class PromotedWorkspace
    extends HomepagePromotedContent {
        String id;
        String color;

        public PromotedWorkspace(String id, String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId, String color) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.id = id;
            this.color = color;
        }

        private PromotedWorkspace() {
        }
    }

    public static class PromotedWebApp
    extends HomepagePromotedContent {
        String id;
        String projectKey;

        public PromotedWebApp(String projectKey, String id, String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.id = id;
            this.projectKey = projectKey;
        }

        private PromotedWebApp() {
        }
    }

    public static class PromotedArticle
    extends HomepagePromotedContent {
        String id;
        String projectKey;

        public PromotedArticle(String projectKey, String id, String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.id = id;
            this.projectKey = projectKey;
        }

        private PromotedArticle() {
        }
    }

    public static class PromotedDataCollection
    extends HomepagePromotedContent {
        String id;
        String color;

        public PromotedDataCollection(String id, String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId, String color) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.id = id;
            this.color = color;
        }

        private PromotedDataCollection() {
        }
    }

    public static class PromotedAdminMessage
    extends HomepagePromotedContent {
        public PromotedAdminMessage(String displayName, String description) {
            super(displayName, description, false, GeneralSettingsDAO.ThumbnailMode.NONE, null);
        }

        private PromotedAdminMessage() {
        }
    }

    public static class PromotedLink
    extends HomepagePromotedContent {
        String url;

        public PromotedLink(String url, String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId) {
            super(displayName, description, openInNewTab, thumbnailMode, customThumbnailImageId);
            this.url = url;
        }

        private PromotedLink() {
        }
    }

    @PolyJSON(value={@Mapping(value=PromotedProject.class, type="PROJECT"), @Mapping(value=PromotedApp.class, type="APP"), @Mapping(value=PromotedWorkspace.class, type="WORKSPACE"), @Mapping(value=PromotedWebApp.class, type="WEB_APP"), @Mapping(value=PromotedArticle.class, type="ARTICLE"), @Mapping(value=PromotedDataCollection.class, type="DATA_COLLECTION"), @Mapping(value=PromotedAdminMessage.class, type="ADMIN_MESSAGE"), @Mapping(value=PromotedLink.class, type="LINK")})
    @UIModel
    public static abstract class HomepagePromotedContent {
        String displayName;
        String description;
        public boolean openInNewTab;
        GeneralSettingsDAO.ThumbnailMode thumbnailMode;
        @Nullable
        public String customThumbnailImageId;

        protected HomepagePromotedContent(String displayName, String description, boolean openInNewTab, GeneralSettingsDAO.ThumbnailMode thumbnailMode, @Nullable String customThumbnailImageId) {
            this.displayName = displayName;
            this.description = description;
            this.openInNewTab = openInNewTab;
            this.thumbnailMode = thumbnailMode;
            this.customThumbnailImageId = customThumbnailImageId;
        }

        private HomepagePromotedContent() {
        }
    }
}

