/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.base.Preconditions;

public enum IndexableType {
    ALL("all", 0.0f),
    MEANING("meaning", 0.0f),
    PROJECT("project", 1.1f),
    WORKSPACE("workspace", 1.1f),
    DATA_COLLECTION("data_collection", 1.0f),
    DATASET("dataset", 1.0f),
    FEATURE_GROUP("dataset", 1.0f),
    ANALYSIS("analysis", 1.0f),
    SAVED_MODEL("saved_model", 1.0f),
    MODEL_EVALUATION_STORE("model_evaluation_store", 1.0f),
    MANAGED_FOLDER("managed_folder", 1.0f),
    SCENARIO("scenario", 1.0f),
    NOTEBOOK("notebook", 1.0f),
    RECIPE("recipe", 1.0f),
    DASHBOARD("dashboard", 1.0f),
    INSIGHT("insight", 1.0f),
    WEB_APP("web_app", 1.0f),
    REPORT("report", 1.0f),
    ARTICLE("article", 1.0f),
    STATISTICS_WORKSHEET("statistics_worksheet", 1.0f),
    MODEL_COMPARISON("model_comparison", 1.0f),
    FLOW_ZONE("flow_zone", 1.0f),
    DISCUSSION("discussion", 1.0f),
    LABELING_TASK("labeling_task", 1.0f),
    KNOWLEDGE_BANK("knowledge_bank", 1.0f),
    PROMPT_STUDIO("prompt_studio", 1.0f),
    CHART("chart", 1.0f),
    PAGE("page", 1.0f),
    CODE_STUDIO("code_studio", 1.0f),
    TABLE("table", 1.0f),
    COLUMN("column", 0.001f),
    FEATURE("column", 0.001f);

    private String index;
    private float boost;

    private IndexableType(String index, float boost) {
        this.index = index;
        this.boost = boost;
    }

    public String toString() {
        return this.index;
    }

    public String index() {
        return this.index;
    }

    public float boost() {
        return this.boost;
    }

    public static IndexableType get(ITaggingService.TaggableType taggableType) {
        Preconditions.checkNotNull((Object)((Object)taggableType), (Object)"No TaggableType provided to obtain IndexableType");
        switch (taggableType) {
            case ANALYSIS: {
                return ANALYSIS;
            }
            case DASHBOARD: {
                return DASHBOARD;
            }
            case DATASET: {
                return DATASET;
            }
            case INSIGHT: {
                return INSIGHT;
            }
            case MANAGED_FOLDER: {
                return MANAGED_FOLDER;
            }
            case PROJECT: {
                return PROJECT;
            }
            case WORKSPACE: {
                return WORKSPACE;
            }
            case RECIPE: {
                return RECIPE;
            }
            case REPORT: {
                return REPORT;
            }
            case SAVED_MODEL: {
                return SAVED_MODEL;
            }
            case MODEL_EVALUATION_STORE: {
                return MODEL_EVALUATION_STORE;
            }
            case WEB_APP: {
                return WEB_APP;
            }
            case ARTICLE: {
                return ARTICLE;
            }
            case STATISTICS_WORKSHEET: {
                return STATISTICS_WORKSHEET;
            }
            case MODEL_COMPARISON: {
                return MODEL_COMPARISON;
            }
            case SQL_NOTEBOOK: 
            case SEARCH_NOTEBOOK: 
            case JUPYTER_NOTEBOOK: {
                return NOTEBOOK;
            }
            case SCENARIO: {
                return SCENARIO;
            }
            case FLOW_ZONE: {
                return FLOW_ZONE;
            }
            case LABELING_TASK: {
                return LABELING_TASK;
            }
            case DATA_COLLECTION: {
                return DATA_COLLECTION;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return KNOWLEDGE_BANK;
            }
            case PROMPT_STUDIO: {
                return PROMPT_STUDIO;
            }
            case CODE_STUDIO: {
                return CODE_STUDIO;
            }
            case LAMBDA_SERVICE: 
            case STREAMING_ENDPOINT: 
            case API_DEPLOYER_DEPLOYMENT: 
            case API_DEPLOYER_INFRA: 
            case API_DEPLOYER_SERVICE: 
            case PROJECT_DEPLOYER_INFRA: 
            case PROJECT_DEPLOYER_PROJECT: 
            case PROJECT_DEPLOYER_DEPLOYMENT: 
            case CODE_STUDIO_TEMPLATE: {
                throw new IllegalArgumentException("TaggableType " + taggableType.toString() + " is not indexable");
            }
        }
        throw new NotImplementedException("No indexable type for taggableType " + String.valueOf((Object)taggableType));
    }

    public static IndexableType forName(String name) {
        return IndexableType.valueOf(name.toUpperCase());
    }
}

