/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeConversionService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.notebooks.JupyterVirtualPathService;
import com.dataiku.dip.notebooks.NotebookTemplateDesc;
import com.dataiku.dip.notebooks.NotebooksTemplatesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.recipes.code.julia.JuliaRecipeMeta;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AbstractTemplateService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.com.google.common.io.Files;
import com.dataiku.dss.shadelib.org.apache.commons.io.Charsets;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JupyterService
implements IJupyterService {
    @Autowired
    CodeConversionService codeConvService;
    @Autowired
    CustomFieldsService customFieldsService;
    @Autowired
    CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    LicenseEnforcementService licenseEnforcementService;
    @Autowired
    JupyterVirtualPathService virtualPathService;
    @Autowired
    GitReferencesService gitReferencesService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    public static final String GIT_KEY_DKU = "dkuGit";
    public static final String GIT_KEY_GIT_REFERENCE = "gitReference";
    static String gitKeyLastInteraction = "lastInteraction";
    static String gitKeyLastHash = "lastHash";
    static String gitKeyLastTimestamp = "lastTimestamp";
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private NotebooksTemplatesService templatesService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private IPermissionsService permService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jupyter");

    public static String getURL() {
        String port = System.getenv("DKU_IPYTHON_PORT");
        if (port == null) {
            port = "8888";
        }
        return "http://localhost:" + port + "/jupyter/";
    }

    @Override
    public JupyterNotebookListEntry getOrNullUnsafe(String projectKey, String notebookName) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), true, true, false);
    }

    @Override
    public JupyterNotebookListEntry getOrNull(String projectKey, String notebookName) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), false, true, false);
    }

    @Override
    public JupyterNotebookListEntry getOrNullWithGitInformation(String projectKey, String notebookName) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), false, true, true);
    }

    @Override
    public JupyterNotebookListEntry getMandatoryUnsafe(String projectKey, String notebookName, boolean withGitInformation) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), true, false, withGitInformation);
    }

    @Override
    public JupyterNotebookListEntry getMandatory(String projectKey, String notebookName, boolean withGitInformation) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), false, false, withGitInformation);
    }

    private JupyterNotebookListEntry get(String projectKey, String notebookName, RelFile notebookFile, boolean unsafe, boolean supportNull, boolean withGitInformation) throws IOException {
        NotebookSafeForWritingNew nb;
        TransactionRef t = TransactionContext.retrieveRead();
        JupyterNotebookListEntry jupyterNbk = new JupyterNotebookListEntry();
        jupyterNbk.projectKey = projectKey;
        jupyterNbk.name = StringUtils.removeEnd((String)notebookFile.getLeafName(), (String)".ipynb");
        logger.trace((Object)("Loading notebook file: " + jupyterNbk.name));
        try {
            nb = unsafe ? (NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, NotebookSafeForWritingNew.class) : (NotebookSafeForWritingNew)t.readObject(notebookFile, NotebookSafeForWritingNew.class);
        }
        catch (IOException e) {
            if (supportNull) {
                return null;
            }
            throw new NotFoundException(ITaggingService.TaggableType.JUPYTER_NOTEBOOK.name() + " does not exist: " + projectKey + "." + notebookName, (Throwable)e);
        }
        try {
            jupyterNbk.associatedRecipe = this.getAssociatedRecipe(nb);
            jupyterNbk.analyzedDataset = this.getAssociatedDataset(nb);
            JupyterKernelSpecInNotebook specInfo = this.getKernelSpecInfo(nb);
            if (specInfo == null) {
                jupyterNbk.language = "unknown";
                jupyterNbk.displayKernelSpec = null;
            } else {
                DisplayKernelSpec ks = new DisplayKernelSpec();
                ks.name = specInfo.name;
                jupyterNbk.language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
                jupyterNbk.displayKernelSpec = ks;
            }
            jupyterNbk.creator = this.getCreator(nb);
            if (jupyterNbk.creator != null) {
                jupyterNbk.creationTag = new VersionTag(jupyterNbk.creator, JupyterService.safeGetMetadataLong(nb, "createdOn"), 0L);
            }
            jupyterNbk.lastModifiedOn = t.getLastModified(notebookFile);
            jupyterNbk.lastGitInteraction = JupyterService.getLastGitInteraction(nb);
            JupyterService.setCreationTag(nb, jupyterNbk);
            JupyterService.setVersionTag(nb, jupyterNbk);
            TaggableObjectsService.TaggableObjectMetadata md = this.getMetadata(projectKey, notebookName);
            jupyterNbk.description = md.description;
            jupyterNbk.tags = md.tags;
            jupyterNbk.shortDesc = md.shortDesc;
            jupyterNbk.automationLocal = this.isAutomationLocal(nb);
            jupyterNbk.customFields = md.customFields;
            if (withGitInformation) {
                this.enrichWithGitInformation(jupyterNbk, nb);
            }
            return jupyterNbk;
        }
        catch (IOException e) {
            logger.error((Object)("Failed to read notebook: " + jupyterNbk.name), (Throwable)e);
            throw new IOException("Failed to read notebook: " + jupyterNbk.name);
        }
    }

    @Override
    public NotebookSafeForWritingNew loadNotebook(String projectKey, String name, boolean unsafe) throws IOException {
        RelFile notebookFile = this.getNotebookFile(projectKey, name);
        File notebookWithOutputsFile = this.getNotebookWithOutputsFile(projectKey, name);
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(notebookFile)) {
            throw new NotFoundException("Notebook '" + name + "' doesn't exist in " + projectKey);
        }
        return this.readNotebookFiles(notebookFile, notebookWithOutputsFile, unsafe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveSession> listActiveSessions() {
        DefaultHttpClient client = JupyterService.newHttpClient();
        ArrayList<ActiveSession> ret = new ArrayList<ActiveSession>();
        try {
            HttpGet get = new HttpGet(JupyterService.getURL() + "api/sessions");
            int timeout = JupyterService.getTimeout();
            HttpConnectionParams.setConnectionTimeout((HttpParams)get.getParams(), (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)get.getParams(), (int)timeout);
            get.addHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret((boolean)true));
            HttpResponse resp = client.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to query Jupyter : " + resp.getStatusLine().getReasonPhrase());
            }
            String data = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)Charsets.UTF_8);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Raw Jupyter sessions list: " + String.valueOf(JSON.parse((String)data, JsonArray.class))));
            }
            List activeSessions = (List)JSON.parse((String)data, (TypeToken)new TypeToken<List<JupyterSessionListAnswer>>(){});
            for (JupyterSessionListAnswer raw : activeSessions) {
                ActiveSession as = new ActiveSession();
                as.sessionId = raw.id;
                if (raw.kernel != null) {
                    as.kernelId = raw.kernel.id;
                    as.kernelConnections = raw.kernel.connections;
                    as.kernelExecutionState = raw.kernel.execution_state;
                    as.kernelPid = raw.kernel.pid;
                    try {
                        as.kernelLastActivityTime = DKUDateUtils.parseISOUTCWithMicroseconds((String)raw.kernel.last_activity);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot parse kernel last_activity", (Throwable)e);
                    }
                }
                as.sessionStartTime = raw.start_time;
                String virtualPath = raw.notebook.path.replaceAll("\\.ipynb$", "");
                if (this.virtualPathService.parseVirtualPath(as, virtualPath)) {
                    logger.info((Object)("Failed to parse virtual path from session: " + JSON.json((Object)raw)));
                    continue;
                }
                String[] sessionIdChunks = raw.id.split("__DKU__");
                if (sessionIdChunks.length != 1 && sessionIdChunks.length == 2) {
                    as.sessionCreatorDisplayName = as.sessionCreator = sessionIdChunks[0];
                }
                ret.add(as);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Could not list sessions, won't have shutdown details", (Throwable)e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
        logger.info((Object)("Active Jupyter sessions: " + JSON.json(ret)));
        return ret;
    }

    @Override
    public void addActiveSessions(AuthCtx authCtx, List<JupyterNotebookListEntry> ret) {
        this.addActiveSessions(authCtx, ret, true);
    }

    @Override
    public void addActiveSessions(AuthCtx authCtx, List<JupyterNotebookListEntry> ret, boolean onlyPersonalSessions) {
        List<ActiveSession> sessions = this.listActiveSessions();
        for (ActiveSession activeSession : sessions) {
            for (JupyterNotebookListEntry entry : ret) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Check session " + activeSession.notebookName + " VS " + entry.name + " (as:" + JSON.json((Object)activeSession)));
                }
                if (!activeSession.projectKey.equals(entry.projectKey) || !activeSession.notebookName.equals(entry.name)) continue;
                if (onlyPersonalSessions && (this.impersonationService.isEnabled() || this.virtualPathService.isNotebookIsolationByDSSUserEnabled()) && !authCtx.getIdentifier().equals(activeSession.sessionCreator)) {
                    logger.trace((Object)"  ignoring unowned session");
                    continue;
                }
                entry.activeSessions.add(activeSession);
            }
        }
    }

    @Override
    public void addKernelSpecInfo(AuthCtx authCtx, List<JupyterNotebookListEntry> ret) {
        HashMap kernelSpecsByName = Maps.newHashMap();
        try {
            for (KernelSpec kernelSpec : this.listKernelSpecs()) {
                kernelSpecsByName.put(kernelSpec.name, kernelSpec);
            }
        }
        catch (ConnectException e) {
            logger.error((Object)("Failed list notebooks kernels: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to list notebooks kernels", (Throwable)e);
        }
        for (JupyterNotebookListEntry entry : ret) {
            if (entry.displayKernelSpec == null) continue;
            String specName = entry.displayKernelSpec.name;
            DisplayKernelSpec ks = new DisplayKernelSpec();
            ks.name = specName;
            KernelSpec kernelSpec = (KernelSpec)kernelSpecsByName.get(specName);
            if (kernelSpec != null) {
                ks.envName = kernelSpec.envName;
                ks.containerConf = kernelSpec.containerConf;
                ks.projectKey = kernelSpec.projectKey;
                ks.bundleId = kernelSpec.bundleId;
            }
            entry.displayKernelSpec = ks;
        }
    }

    @Override
    public Collection<String> gatherTagsForProject(String projectKey) throws IOException {
        RelFile notebooksFolder;
        HashSet<String> tags = new HashSet<String>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isDirectory(notebooksFolder = this.getNotebooksDir(projectKey))) {
            for (RelFile notebookFile : t.listFiles(notebooksFolder, (RelFileFilter)new FileFilter("ipynb"))) {
                tags.addAll(this.getTags(notebookFile));
            }
        }
        return tags;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile notebooksFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(notebooksFolder = this.getNotebooksDir(projectKey))) {
            return 0;
        }
        return t.listFiles(notebooksFolder, (RelFileFilter)new FileFilter("ipynb")).size();
    }

    @Override
    public List<JupyterNotebookListEntry> list(AuthCtx authCtx, String projectKey) throws IOException {
        return this.list(projectKey, false, false);
    }

    @Override
    public List<JupyterNotebookListEntry> listWithGitInformation(AuthCtx authCtx, String projectKey) throws IOException {
        return this.list(projectKey, false, true);
    }

    @Override
    public List<JupyterNotebookListEntry> listSimple(AuthCtx authCtx, String projectKey) throws IOException {
        return this.list(projectKey, false, false);
    }

    @Override
    public List<JupyterNotebookListEntry> listUnsafe(AuthCtx authCtx, String projectKey) throws IOException {
        return this.list(projectKey, true, false);
    }

    @Override
    public List<JupyterNotebookListEntry> listUnsafeWithGitInformation(AuthCtx authCtx, String projectKey) throws IOException {
        return this.list(projectKey, true, true);
    }

    private List<JupyterNotebookListEntry> list(String projectKey, boolean unsafe, boolean withGitInformation) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<JupyterNotebookListEntry> ret = new ArrayList<JupyterNotebookListEntry>();
        RelFile notebooksFolder = this.getNotebooksDir(projectKey);
        if (!t.exists(notebooksFolder)) {
            return ret;
        }
        for (RelFile notebookFile : t.listFiles(notebooksFolder, (RelFileFilter)new FileFilter("ipynb"))) {
            JupyterNotebookListEntry jupyterNbk = new JupyterNotebookListEntry();
            jupyterNbk.projectKey = projectKey;
            jupyterNbk.name = StringUtils.removeEnd((String)notebookFile.getLeafName(), (String)".ipynb");
            try {
                logger.trace((Object)("Loading notebook file: " + jupyterNbk.name));
                NotebookSafeForWritingNew nb = unsafe ? (NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, NotebookSafeForWritingNew.class) : (NotebookSafeForWritingNew)t.readObject(notebookFile, NotebookSafeForWritingNew.class);
                jupyterNbk.associatedRecipe = this.getAssociatedRecipe(nb);
                jupyterNbk.analyzedDataset = this.getAssociatedDataset(nb);
                JupyterKernelSpecInNotebook specInfo = this.getKernelSpecInfo(nb);
                if (specInfo == null) {
                    jupyterNbk.language = "unknown";
                    jupyterNbk.displayKernelSpec = null;
                } else {
                    DisplayKernelSpec ks = new DisplayKernelSpec();
                    ks.name = specInfo.name;
                    jupyterNbk.language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
                    jupyterNbk.displayKernelSpec = ks;
                }
                jupyterNbk.creator = this.getCreator(nb);
                if (jupyterNbk.creator != null) {
                    jupyterNbk.creationTag = new VersionTag(jupyterNbk.creator, JupyterService.safeGetMetadataLong(nb, "createdOn"), 0L);
                }
                jupyterNbk.lastModifiedOn = t.getLastModified(notebookFile);
                jupyterNbk.lastGitInteraction = JupyterService.getLastGitInteraction(nb);
                JupyterService.setCreationTag(nb, jupyterNbk);
                JupyterService.setVersionTag(nb, jupyterNbk);
                TaggableObjectsService.TaggableObjectMetadata md = this.getMetadata(jupyterNbk.projectKey, jupyterNbk.name);
                jupyterNbk.tags = md.tags;
                jupyterNbk.description = md.description;
                jupyterNbk.shortDesc = md.shortDesc;
                jupyterNbk.automationLocal = this.isAutomationLocal(nb);
                jupyterNbk.customFields = md.customFields;
                if (withGitInformation) {
                    this.enrichWithGitInformation(jupyterNbk, nb);
                }
                ret.add(jupyterNbk);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to read notebook: " + jupyterNbk.name), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public List<JupyterNotebookListEntry> listActiveNotebooksUnsafe(List<ActiveSession> sessions, List<KernelSpec> kernelSpecs) {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<JupyterNotebookListEntry> ret = new ArrayList<JupyterNotebookListEntry>();
        HashMap kernelSpecsByName = Maps.newHashMap();
        for (KernelSpec kernelSpec : kernelSpecs) {
            kernelSpecsByName.put(kernelSpec.name, kernelSpec);
        }
        for (ActiveSession activeSession : sessions) {
            logger.info((Object)("ProjectKey: " + activeSession.projectKey + ", notebookName: " + activeSession.notebookName));
            RelFile notebookFile = this.getNotebookFile(activeSession.projectKey, activeSession.notebookName);
            JupyterNotebookListEntry jupyterNbk = new JupyterNotebookListEntry();
            jupyterNbk.projectKey = activeSession.projectKey;
            jupyterNbk.name = activeSession.notebookName;
            try {
                logger.trace((Object)("Loading notebook file: " + jupyterNbk.name));
                NotebookSafeForWritingNew nb = (NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, NotebookSafeForWritingNew.class);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("           Got : " + JSON.pretty((Object)nb)));
                }
                jupyterNbk.associatedRecipe = this.getAssociatedRecipe(nb);
                jupyterNbk.analyzedDataset = this.getAssociatedDataset(nb);
                JupyterKernelSpecInNotebook specInfo = this.getKernelSpecInfo(nb);
                if (specInfo == null) {
                    jupyterNbk.language = "unknown";
                    jupyterNbk.displayKernelSpec = null;
                } else {
                    KernelSpec kernelSpec = (KernelSpec)kernelSpecsByName.get(specInfo.name);
                    DisplayKernelSpec ks = KernelSpec.toKernelSpec(null, kernelSpec);
                    jupyterNbk.language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
                    jupyterNbk.displayKernelSpec = ks;
                }
                jupyterNbk.creator = this.getCreator(nb);
                jupyterNbk.lastModifiedOn = t.getLastModified(notebookFile);
                jupyterNbk.lastGitInteraction = JupyterService.getLastGitInteraction(nb);
                JupyterService.setCreationTag(nb, jupyterNbk);
                JupyterService.setVersionTag(nb, jupyterNbk);
                jupyterNbk.tags = this.getTags(jupyterNbk.projectKey, jupyterNbk.name);
                jupyterNbk.automationLocal = this.isAutomationLocal(nb);
                jupyterNbk.activeSessions.add(activeSession);
                ret.add(jupyterNbk);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to read notebook: " + jupyterNbk.name), (Throwable)e);
            }
        }
        return ret;
    }

    private List<String> readTagMetadata(NotebookSafeForWritingNew nb, List<String> tags) {
        if (nb.metadata != null && nb.metadata.has("tags")) {
            JsonArray array = nb.metadata.getAsJsonArray("tags");
            for (JsonElement elt : array) {
                tags.add(elt.getAsString());
            }
        }
        return tags;
    }

    private List<String> getTags(RelFile nbkFile) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<String> tags = new ArrayList<String>();
        NotebookSafeForWritingNew nb = (NotebookSafeForWritingNew)t.readObjectUnsafe(nbkFile, NotebookSafeForWritingNew.class);
        return this.readTagMetadata(nb, tags);
    }

    @Override
    public List<String> getTags(String projectKey, String name) throws IOException {
        RelFile f = this.getNotebookFile(projectKey, name);
        return this.getTags(f);
    }

    @Override
    public TaggableObjectsService.TaggableObjectMetadata getMetadata(String projectKey, String name) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile f = this.getNotebookFile(projectKey, name);
        NotebookSafeForWritingNew nb = (NotebookSafeForWritingNew)t.readObjectUnsafe(f, NotebookSafeForWritingNew.class);
        TaggableObjectsService.TaggableObjectMetadata md = new TaggableObjectsService.TaggableObjectMetadata();
        md.tags = this.getTags(f);
        md.shortDesc = JupyterService.safeGetMetadataStr(nb, "shortdesc");
        md.description = JupyterService.safeGetMetadataStr(nb, "description");
        md.customFields = JupyterService.safeGetMetadataJsonObject(nb, "customFields");
        return md;
    }

    @Override
    public JsonObject getJupyterMetadata(String projectKey, String name) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile f = this.getNotebookFile(projectKey, name);
        NotebookSafeForWritingNew nb = (NotebookSafeForWritingNew)t.readObjectUnsafe(f, NotebookSafeForWritingNew.class);
        return nb.metadata == null ? new JsonObject() : (JsonObject)JSON.deepCopy((Object)nb.metadata);
    }

    public static JsonObject safeGetMetadataJsonObject(NotebookSafeForWritingNew nb, String key) {
        if (nb.metadata == null || !nb.metadata.has(key) || !nb.metadata.get(key).isJsonObject()) {
            return null;
        }
        return nb.metadata.getAsJsonObject(key);
    }

    private static String safeGetMetadataStr(NotebookSafeForWritingNew nb, String key) {
        if (nb.metadata == null) {
            return null;
        }
        if (!nb.metadata.has(key)) {
            return null;
        }
        if (nb.metadata.get(key).isJsonNull()) {
            return null;
        }
        JsonPrimitive prim = nb.metadata.getAsJsonPrimitive(key);
        if (prim == null) {
            return null;
        }
        return prim.getAsString();
    }

    private static String safeGetMetadataStr(NotebookSafeForWritingNew nb, String key, String emptyValue) {
        String str = JupyterService.safeGetMetadataStr(nb, key);
        if (str == null) {
            return emptyValue;
        }
        return str;
    }

    private static Long safeGetMetadataLong(NotebookSafeForWritingNew nb, String key) {
        return JupyterService.safeGetMetadataLong(nb, key, 0L);
    }

    private static Long safeGetMetadataLong(NotebookSafeForWritingNew nb, String key, Long defaultValue) {
        String value = JupyterService.safeGetMetadataStr(nb, key);
        if (value == null) {
            return defaultValue;
        }
        return Long.decode(value);
    }

    private static Long getLastGitInteraction(NotebookSafeForWritingNew notebook) {
        if (notebook.metadata == null || !notebook.metadata.has(GIT_KEY_DKU) || notebook.metadata.get(GIT_KEY_DKU) == null || !notebook.metadata.get(GIT_KEY_DKU).isJsonObject()) {
            return 0L;
        }
        JsonObject dkuMetadata = notebook.metadata.getAsJsonObject(GIT_KEY_DKU);
        if (dkuMetadata == null || !dkuMetadata.has(gitKeyLastInteraction) || dkuMetadata.get(gitKeyLastInteraction) == null || !dkuMetadata.get(gitKeyLastInteraction).isJsonPrimitive()) {
            return 0L;
        }
        return dkuMetadata.getAsJsonPrimitive(gitKeyLastInteraction).getAsLong();
    }

    @Override
    public boolean exists(String projectKey, String id) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.isFile(this.getNotebookFile(projectKey, id));
    }

    private JupyterKernelSpecInNotebook getKernelSpecInfo(NotebookSafeForWritingNew nb) {
        if (nb.metadata != null) {
            if (nb.metadata.has("kernelspec")) {
                return (JupyterKernelSpecInNotebook)JSON.parse((JsonElement)nb.metadata.get("kernelspec"), JupyterKernelSpecInNotebook.class);
            }
            if (nb.metadata.has("language_info") && nb.metadata.getAsJsonObject("language_info").has("name")) {
                JupyterKernelSpecInNotebook kernelSpec = new JupyterKernelSpecInNotebook();
                kernelSpec.name = nb.metadata.getAsJsonObject("language_info").get("name").getAsString();
                return kernelSpec;
            }
            if (nb.metadata.has("application/vnd.databricks.v1+notebook") && nb.metadata.getAsJsonObject("application/vnd.databricks.v1+notebook").has("language")) {
                JupyterKernelSpecInNotebook kernelSpec = new JupyterKernelSpecInNotebook();
                kernelSpec.name = StringUtils.capitalize((String)nb.metadata.getAsJsonObject("application/vnd.databricks.v1+notebook").get("language").getAsString());
                return kernelSpec;
            }
        }
        return null;
    }

    private String getAssociatedRecipe(NotebookSafeForWritingNew nb) {
        return JupyterService.safeGetMetadataStr(nb, "associatedRecipe");
    }

    private String getAssociatedDataset(NotebookSafeForWritingNew nb) {
        return JupyterService.safeGetMetadataStr(nb, "analyzedDataset");
    }

    private boolean isAutomationLocal(NotebookSafeForWritingNew nb) {
        return nb.metadata != null && nb.metadata.has("automationLocal");
    }

    private String getCreator(NotebookSafeForWritingNew nb) {
        return JupyterService.safeGetMetadataStr(nb, "creator");
    }

    @Override
    public void setTags(String projectKey, String name, List<String> tags) throws IOException, CodedException {
        TaggableObjectsService.TaggableObjectMetadata metadata = this.getMetadata(projectKey, name);
        metadata.tags = tags;
        this.setMetaData(projectKey, name, metadata);
    }

    @Override
    public void setModifiedBy(NotebookSafeForWritingNew nb, String user) {
        if (nb.metadata != null) {
            nb.metadata.addProperty("modifiedBy", user);
        }
    }

    private JupyterNotebookListEntry getNotebookEntryList(String projectKey, String name, NotebookSafeForWritingNew nb) {
        JupyterNotebookListEntry notebook = new JupyterNotebookListEntry();
        notebook.projectKey = projectKey;
        notebook.name = name;
        notebook.associatedRecipe = this.getAssociatedDataset(nb);
        notebook.analyzedDataset = this.getAssociatedDataset(nb);
        JupyterKernelSpecInNotebook specInfo = this.getKernelSpecInfo(nb);
        if (specInfo == null) {
            notebook.language = "unknown";
            notebook.displayKernelSpec = null;
        } else {
            DisplayKernelSpec ks = new DisplayKernelSpec();
            ks.name = specInfo.name;
            notebook.language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
            notebook.displayKernelSpec = ks;
        }
        notebook.creator = this.getCreator(nb);
        notebook.lastModifiedOn = 0L;
        notebook.lastGitInteraction = JupyterService.getLastGitInteraction(nb);
        JupyterService.setCreationTag(nb, notebook);
        JupyterService.setVersionTag(nb, notebook);
        notebook.tags = this.readTagMetadata(nb, new ArrayList<String>());
        notebook.shortDesc = JupyterService.safeGetMetadataStr(nb, "shortdesc");
        notebook.description = JupyterService.safeGetMetadataStr(nb, "description");
        notebook.customFields = JupyterService.safeGetMetadataJsonObject(nb, "customFields");
        notebook.automationLocal = this.isAutomationLocal(nb);
        return notebook;
    }

    @Override
    public void setMetaData(String projectKey, String name, TaggableObjectsService.TaggableObjectMetadata metadata) throws IOException, CodedException {
        NotebookSafeForWritingNew ns = this.loadNotebook(projectKey, name, false);
        if (ns.metadata == null) {
            ns.metadata = new JsonObject();
        }
        JsonArray array = new JsonArray();
        for (String tag : metadata.tags) {
            array.add((JsonElement)new JsonPrimitive(tag));
        }
        ns.metadata.add("tags", (JsonElement)array);
        ns.metadata.addProperty("description", metadata.description);
        ns.metadata.addProperty("shortdesc", metadata.shortDesc);
        if (metadata.customFields != null) {
            ns.metadata.add("customFields", (JsonElement)metadata.customFields);
        }
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), this.getOrNullWithGitInformation(projectKey, name), this.getNotebookEntryList(projectKey, name, ns));
        this.saveNotebook(projectKey, name, ns);
        this.taggingService.onObjectSaved(projectKey, metadata.tags);
    }

    @Override
    public boolean deleteOutputs(String projectKey, String notebookName, AuthCtx authCtx) throws IOException {
        RelFile notebookFile;
        boolean needToCommitTransaction = false;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(notebookFile = this.getNotebookFile(projectKey, notebookName))) {
            throw new NotFoundException("Notebook does not exist: " + projectKey + "." + notebookName);
        }
        NotebookSafeForWritingNew notebook = this.readNotebookFiles(notebookFile, null, true);
        if (JupyterService.containsCellsOutputs(notebook)) {
            this.saveNotebook(projectKey, notebookName, JupyterService.shouldStripCellsOutputs() ? notebook : notebook.copyWithoutCellsOutputs());
            needToCommitTransaction = true;
        }
        this.deleteNotebookWithOutputsFiles(this.getNotebookWithOutputsFile(projectKey, notebookName));
        this.deleteNotebookWithOutputsFiles(this.getNotebookWithOutputsCheckpointFile(projectKey, notebookName));
        return needToCommitTransaction;
    }

    @Override
    public void delete(String projectKey, String name, AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        RelFile outFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.exists(outFile = this.getNotebookFile(projectKey, name))) {
            throw new NotFoundException("Notebook does not exist: " + projectKey + "." + name);
        }
        this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, this.getOrNullWithGitInformation(projectKey, name));
        this.deleteNotebookFiles(outFile, this.getNotebookWithOutputsFile(projectKey, name));
        this.deleteNotebookFiles(this.getCheckpointFile(projectKey, name), this.getNotebookWithOutputsCheckpointFile(projectKey, name));
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_DELETE));
        this.insightsService.deleteForSource(projectKey, ITaggingService.TaggableType.JUPYTER_NOTEBOOK, name);
    }

    private void setKernelName(String projectKey, NotebookSafeForWritingNew nb, String language, String envName, String containerConf) {
        CodeEnvModel.EnvLang envLang;
        logger.infoV("Setting kernel name lang=%s name=%s containerConf=%s", new Object[]{language, envName, containerConf});
        switch (language) {
            case "python": {
                envLang = CodeEnvModel.EnvLang.PYTHON;
                break;
            }
            case "julia": {
                envLang = CodeEnvModel.EnvLang.JULIA;
                break;
            }
            case "r": {
                envLang = CodeEnvModel.EnvLang.R;
                break;
            }
            default: {
                logger.info((Object)("Language " + language + " doesn't offer code envs"));
                return;
            }
        }
        String bundleId = null;
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            AutomationNodeCodeEnvsService codeEnvsServices = (AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class);
            try {
                CodeEnvModel.AutomationEnvRootDef env = codeEnvsServices.getEnvRootDef(envLang, envName);
                if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                    bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Could not find environment " + envName + ", assuming not versioned"), (Throwable)e);
            }
        }
        if (!"__BUILTIN__".equals(envName) && StringUtils.isNotBlank((String)envName)) {
            nb.metadata.getAsJsonObject("kernelspec").addProperty("name", JupyterCodeEnvUtils.getKernelName(envLang, envName, projectKey, bundleId, containerConf));
            nb.metadata.getAsJsonObject("kernelspec").addProperty("display_name", JupyterCodeEnvUtils.getDisplayName(envLang, envName, projectKey, bundleId, containerConf));
        } else if (StringUtils.isNotBlank((String)containerConf)) {
            nb.metadata.getAsJsonObject("kernelspec").addProperty("name", JupyterCodeEnvUtils.getKernelName(envLang, null, null, null, containerConf));
            nb.metadata.getAsJsonObject("kernelspec").addProperty("display_name", JupyterCodeEnvUtils.getDisplayName(envLang, null, null, null, containerConf));
        } else {
            String overrideName = null;
            String overrideDisplayName = null;
            switch (envLang) {
                case PYTHON: {
                    if (JupyterService.getKernelFolder("python3").isDirectory()) {
                        overrideName = "python3";
                        overrideDisplayName = "Python 3";
                        break;
                    }
                    overrideName = "python2";
                    overrideDisplayName = "Python 2";
                }
            }
            if (overrideName != null) {
                nb.metadata.getAsJsonObject("kernelspec").addProperty("name", overrideName);
                nb.metadata.getAsJsonObject("kernelspec").addProperty("display_name", overrideDisplayName);
            }
        }
        logger.info((Object)("Set kernel name done, metadata is now: " + JSON.json((Object)nb.metadata)));
    }

    public static File getKernelFolder(String kernelName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"jupyter-run", "jupyter", "kernels", kernelName});
    }

    @Override
    public JupyterNotebookListEntry getNotebookForAssociatedRecipe(String projectKey, String recipeName) throws IOException {
        for (JupyterNotebookListEntry entry : this.listWithGitInformation(DSSAuthCtx.newNone(), projectKey)) {
            if (!recipeName.equals(entry.associatedRecipe)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void updateNotebookForRecipeDeletion(String projectKey, String recipeName) throws IOException, CodedException {
        JupyterNotebookListEntry nb = this.getNotebookForAssociatedRecipe(projectKey, recipeName);
        if (nb != null) {
            NotebookSafeForWritingNew nbContent = this.loadNotebook(nb.projectKey, nb.name, false);
            if (nbContent.metadata != null) {
                if (nbContent.metadata.has("associatedRecipe")) {
                    nbContent.metadata.remove("associatedRecipe");
                }
                JupyterService.replaceTag(nbContent, "recipe-editor", "deleted-recipe-editor");
                this.taggingService.onObjectSaved(projectKey, Lists.newArrayList((Object[])new String[]{"deleted-recipe-editor"}));
                this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), nb, this.getNotebookEntryList(nb.projectKey, nb.name, nbContent));
                this.saveNotebook(nb.projectKey, nb.name, nbContent);
            }
        }
    }

    @Override
    public void associateNotebookWithRecipe(AuthCtx authCtx, String projectKey, String notebookName, String recipeName) throws IOException, CodedException {
        JupyterNotebookListEntry notebook = this.getMandatory(projectKey, notebookName, true);
        if (notebook != null) {
            NotebookSafeForWritingNew nbContent = this.loadNotebook(notebook.projectKey, notebook.name, false);
            if (nbContent.metadata == null) {
                nbContent.metadata = new JsonObject();
            }
            nbContent.metadata.addProperty("associatedRecipe", recipeName);
            JupyterService.replaceTag(nbContent, "deleted-recipe-editor", "recipe-editor");
            this.taggingService.onObjectSaved(projectKey, Lists.newArrayList((Object[])new String[]{"recipe-editor"}));
            this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), notebook, this.getNotebookEntryList(notebook.projectKey, notebook.name, nbContent));
            this.saveNotebook(notebook.projectKey, notebook.name, nbContent);
        }
    }

    private static void replaceTag(NotebookSafeForWritingNew nbContent, String tagToRemove, String tagToAdd) {
        if (!nbContent.metadata.has("tags")) {
            nbContent.metadata.add("tags", (JsonElement)new JsonArray());
        }
        JsonArray tags = nbContent.metadata.get("tags").getAsJsonArray();
        ArrayList<JsonElement> tagsToRemove = new ArrayList<JsonElement>();
        for (int i = 0; i < tags.size(); ++i) {
            if (!tagToRemove.equals(tags.get(i).getAsString())) continue;
            tagsToRemove.add(tags.get(i));
        }
        for (JsonElement oldTag : tagsToRemove) {
            tags.remove(oldTag);
        }
        tags.add((JsonElement)new JsonPrimitive(tagToAdd));
    }

    @Override
    public void updateNotebookForRecipeRenaming(String projectKey, String oldRecipeName, String newRecipeName) throws IOException, CodedException {
        JupyterNotebookListEntry nb = this.getNotebookForAssociatedRecipe(projectKey, oldRecipeName);
        if (nb != null) {
            NotebookSafeForWritingNew nbContent = this.loadNotebook(nb.projectKey, nb.name, false);
            if (nbContent.metadata == null) {
                nbContent.metadata = new JsonObject();
            }
            nbContent.metadata.addProperty("associatedRecipe", newRecipeName);
            this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), nb, this.getNotebookEntryList(nb.projectKey, nb.name, nbContent));
            this.saveNotebook(nb.projectKey, nb.name, nbContent);
        }
    }

    @Override
    public JupyterNotebookListEntry createNotebookForRecipe(AuthCtx user, String projectKey, AnyLoc loc, CodeEnvSelection codeEnvSelection, ContainerExecSelection containerSelection) throws Exception {
        String nbName;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(loc);
        JupyterNotebookListEntry jupy = this.getNotebookForAssociatedRecipe(projectKey, recipe.name);
        String language = this.recipeTypeToLanguage(recipe.getType());
        if (jupy == null) {
            StringTransmogrifier st2 = new StringTransmogrifier();
            for (JupyterNotebookListEntry entry : this.listSimple(DSSAuthCtx.newNone(), projectKey)) {
                st2.addAlreadyTransmogrified(entry.name);
            }
            nbName = st2.transmogrify("notebook editor for " + recipe.name);
        } else {
            nbName = jupy.name;
        }
        RelFile outFile = this.getNotebookFile(projectKey, nbName);
        AbstractTemplateService.TemplateDescs<NotebookTemplateDesc> templates = this.templatesService.listOfType(NotebookTemplateDesc.NotebookTemplateType.STANDALONE, language);
        NotebookSafeForWritingNew nb = this.templatesService.expandJupyter(projectKey, (NotebookTemplateDesc)templates.templates.get(0), NotebookTemplateDesc.NotebookTemplateType.STANDALONE, null);
        CodeEnvModel.EnvLang envLang = "python".equals(language) ? CodeEnvModel.EnvLang.PYTHON : ("r".equals(language) ? CodeEnvModel.EnvLang.R : ("julia".equals(language) ? CodeEnvModel.EnvLang.JULIA : null));
        String envName = null;
        String containerConf = null;
        logger.info((Object)("Finding envName for notebook envLang=" + String.valueOf((Object)envLang) + " envSelection=" + (codeEnvSelection != null ? JSON.json((Object)codeEnvSelection) : null) + " containerSelection=" + (containerSelection != null ? JSON.json((Object)containerSelection) : null)));
        if (envLang != null && codeEnvSelection != null) {
            envName = new CodeEnvSelector().selectForRecipe(projectKey, envLang, codeEnvSelection);
        }
        if (containerSelection != null) {
            containerConf = new ContainerExecConfigSelector().selectConfName_autoTXN(user, projectKey, containerSelection);
        }
        logger.info((Object)("Selected env for notebook : " + envName));
        this.setKernelName(projectKey, nb, language, StringUtils.defaultIfEmpty((String)envName, (String)"__BUILTIN__"), containerConf);
        ArrayList tags = Lists.newArrayList((Object[])new String[]{"recipe-editor"});
        this.setOrRetrieveAllMetaData(user, nb, tags, jupy, recipe.name);
        JsonObject notebookContent = this.codeConvService.recipeToNotebook(recipe.getType(), this.recipesDAO.getPayloadOrNull(projectKey, recipe.name), nb.metadata);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, this.getNotebookEntryList(projectKey, nbName, (NotebookSafeForWritingNew)JSON.parse((JsonElement)notebookContent, NotebookSafeForWritingNew.class)));
        t.writeObject(outFile, (Object)notebookContent);
        this.createCheckpoint(projectKey, nbName);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, nbName, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_CREATE));
        this.taggingService.onObjectSaved(projectKey, tags);
        return this.getMandatory(projectKey, nbName, false);
    }

    private void setOrRetrieveAllMetaData(AuthCtx user, NotebookSafeForWritingNew nb, List<String> tags, JupyterNotebookListEntry jupy, String name) {
        nb.metadata.addProperty("associatedRecipe", name);
        JsonArray tagsArr = new JsonArray();
        if (jupy != null) {
            jupy.tags.forEach(tag -> tagsArr.add((JsonElement)new JsonPrimitive(tag)));
            JsonObject dkuMetadata = new JsonObject();
            dkuMetadata.add(GIT_KEY_GIT_REFERENCE, (JsonElement)JSON.toJsonObject((Object)this.gitReferencesService.encryptProjectGitReference(jupy.gitReference)));
            dkuMetadata.addProperty(gitKeyLastInteraction, (Number)jupy.lastGitInteraction);
            nb.metadata.add(GIT_KEY_DKU, (JsonElement)dkuMetadata);
            nb.metadata.addProperty("shortdesc", jupy.shortDesc);
            nb.metadata.addProperty("description", jupy.description);
            nb.metadata.add("creationTag", (JsonElement)JSON.toJsonObject((Object)jupy.creationTag));
            nb.metadata.addProperty("creator", jupy.creator);
            if (jupy.creationTag != null) {
                nb.metadata.addProperty("createdOn", (Number)jupy.creationTag.getLastModifiedOn());
            }
        } else {
            tags.forEach(tag -> tagsArr.add((JsonElement)new JsonPrimitive(tag)));
        }
        this.setCommonMetadata(user, nb, tagsArr);
    }

    @Override
    public JupyterNotebookListEntry createNotebookForDataset(AuthCtx user, String projectKey, String name, String templateDesc, AnyLoc analyzedDataset, String envName, String containerConf) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        NotebookTemplateDesc td = (NotebookTemplateDesc)JSON.parse((String)templateDesc, NotebookTemplateDesc.class);
        if (td == null) {
            throw new IllegalArgumentException("Template descriptor is undefined");
        }
        RelFile outFile = this.getNotebookFile(projectKey, name);
        if (t.exists(outFile)) {
            throw ErrorContext.iaef((String)"Notebook %s already exists", (Object)name, (Object[])new Object[0]);
        }
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatory(analyzedDataset);
        NotebookSafeForWritingNew nb = this.templatesService.expandJupyter(projectKey, td, NotebookTemplateDesc.NotebookTemplateType.DATASET, dataset);
        if (nb.metadata != null && nb.metadata.has("kernelspec") && nb.metadata.get("kernelspec").getAsJsonObject().has("language")) {
            td.language = nb.metadata.get("kernelspec").getAsJsonObject().get("language").getAsString().toLowerCase();
        }
        logger.info((Object)("Create notebook in envName=" + envName + " containerConf=" + containerConf + " language=" + td.language));
        this.setKernelName(projectKey, nb, td.language, envName, containerConf);
        nb.metadata.addProperty("analyzedDataset", analyzedDataset.getSmartName(projectKey));
        this.setCommonMetadata(user, nb, new JsonArray());
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, this.getNotebookEntryList(projectKey, name, nb));
        t.writeObject(outFile, (Object)nb);
        this.createCheckpoint(projectKey, name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_CREATE));
        return this.getMandatory(projectKey, name, true);
    }

    @Override
    public JupyterNotebookListEntry createNotebookForRetrievableKnowledge(AuthCtx user, String projectKey, String name, NotebookTemplateDesc td, AnyLoc analyzedRetrievableKnowledge) throws Exception {
        RelFile outFile = this.getNotebookFile(projectKey, name);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(outFile)) {
            throw ErrorContext.iaef((String)"Notebook %s already exists", (Object)name, (Object[])new Object[0]);
        }
        RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(analyzedRetrievableKnowledge);
        String containerConf = rk.containerExecSelection.containerConf;
        String envName = rk.envSelection.envName;
        NotebookSafeForWritingNew nb = this.templatesService.expandJupyter(projectKey, td, NotebookTemplateDesc.NotebookTemplateType.RETRIEVABLE_KNOWLEDGE, rk);
        if (nb.metadata != null && nb.metadata.has("kernelspec") && nb.metadata.get("kernelspec").getAsJsonObject().has("language")) {
            td.language = nb.metadata.get("kernelspec").getAsJsonObject().get("language").getAsString().toLowerCase();
        }
        logger.info((Object)("Create notebook in envName=" + envName + " containerConf=" + containerConf + " language=" + td.language));
        this.setKernelName(projectKey, nb, td.language, envName, containerConf);
        this.setCommonMetadata(user, nb, new JsonArray());
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, this.getNotebookEntryList(projectKey, name, nb));
        t.writeObject(outFile, (Object)nb);
        this.createCheckpoint(projectKey, name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_CREATE));
        return this.getMandatory(projectKey, name, false);
    }

    @Override
    public JupyterNotebookListEntry createStandaloneNotebook(AuthCtx user, String projectKey, String name, NotebookTemplateDesc td, String envName, String containerConf) throws Exception {
        RelFile outFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(outFile = this.getNotebookFile(projectKey, name))) {
            throw ErrorContext.iaef((String)"Notebook %s already exists", (Object)name, (Object[])new Object[0]);
        }
        NotebookSafeForWritingNew nb = this.templatesService.expandJupyter(projectKey, td, NotebookTemplateDesc.NotebookTemplateType.STANDALONE, null);
        this.setKernelName(projectKey, nb, td.language, envName, containerConf);
        this.setCommonMetadata(user, nb, new JsonArray());
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, this.getNotebookEntryList(projectKey, name, nb));
        t.writeObject(outFile, (Object)nb);
        this.createCheckpoint(projectKey, name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_CREATE));
        return this.getMandatory(projectKey, name, true);
    }

    @Override
    public JupyterNotebookListEntry installNotebookFromFile(AuthCtx user, String projectKey, String name, @Nullable AnyLoc analyzedDataset, NotebookSafeForWritingNew notebook) throws IOException {
        return this.installNotebookFromFile(user, projectKey, name, analyzedDataset, notebook, false);
    }

    @Override
    public JupyterNotebookListEntry installNotebookFromFile(AuthCtx user, String projectKey, String name, @Nullable AnyLoc analyzedDataset, NotebookSafeForWritingNew notebook, boolean isCopy) throws IOException {
        RelFile outFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(outFile = this.getNotebookFile(projectKey, name))) {
            throw ErrorContext.iaef((String)"Notebook %s already exists", (Object)name, (Object[])new Object[0]);
        }
        if (notebook.metadata != null) {
            JupyterKernelSpecInNotebook specInfo;
            if (!notebook.metadata.has("kernelspec") && (specInfo = this.getKernelSpecInfo(notebook)) != null) {
                String language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
                JsonObject ks = new JsonObject();
                ks.addProperty("language", language);
                ks.addProperty("name", language);
                ks.addProperty("display_name", language);
                notebook.metadata.add("kernelspec", (JsonElement)ks);
            }
            if (analyzedDataset != null) {
                notebook.metadata.addProperty("analyzedDataset", analyzedDataset.getSmartName(projectKey));
            }
            this.setCommonMetadata(user, notebook, new JsonArray());
            if (isCopy && notebook.metadata.has("associatedRecipe")) {
                notebook.metadata.remove("associatedRecipe");
                if (notebook.metadata.has("tags")) {
                    JsonArray tags = notebook.metadata.getAsJsonArray("tags");
                    tags.remove((JsonElement)new JsonPrimitive("recipe-editor"));
                }
            }
        }
        this.saveNotebook(projectKey, name, notebook);
        this.createCheckpoint(projectKey, name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_CREATE));
        this.taggingService.onObjectSaved(projectKey, this.readTagMetadata(notebook, new ArrayList<String>()));
        return this.getMandatory(projectKey, name, true);
    }

    @Override
    public JupyterNotebookListEntry updateNotebookFromFile(AuthCtx user, String projectKey, String name, NotebookSafeForWritingNew notebook, @Nullable AnyLoc analyzedDataset) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile outFile = this.getNotebookFile(projectKey, name);
        JupyterNotebookListEntry notebookListEntry = this.get(projectKey, name, outFile, true, true, true);
        if (notebookListEntry == null) {
            throw ErrorContext.iaef((String)"Notebook:%s does not exists", (Object)name, (Object[])new Object[0]);
        }
        if (notebook.metadata != null) {
            if (analyzedDataset != null) {
                notebook.metadata.addProperty("analyzedDataset", analyzedDataset.getSmartName(projectKey));
            }
            JupyterService.addPropertyIfNotExist(notebook.metadata, "tags", new JsonArray());
            JupyterService.addPropertyIfNotExist(notebook.metadata, "createdOn", System.currentTimeMillis());
            JupyterService.addPropertyIfNotExist(notebook.metadata, "creator", user.getIdentifier());
            JupyterService.addPropertyIfNotExist(notebook.metadata, "modifiedBy", user.getIdentifier());
            if (notebookListEntry.gitReference != null) {
                JsonObject dkuMetadata = new JsonObject();
                dkuMetadata.add(GIT_KEY_GIT_REFERENCE, (JsonElement)JSON.toJsonObject((Object)notebookListEntry.gitReference));
                dkuMetadata.addProperty(gitKeyLastInteraction, (Number)System.currentTimeMillis());
                notebook.metadata.add(GIT_KEY_DKU, (JsonElement)dkuMetadata);
            }
        }
        this.saveNotebook(projectKey, name, notebook);
        this.createCheckpoint(projectKey, name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_EDIT));
        this.taggingService.onObjectSaved(projectKey, this.readTagMetadata(notebook, new ArrayList<String>()));
        return this.getMandatory(projectKey, name, true);
    }

    @Override
    public void rewriteNotebook(String projectKey, String name) {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile notebookFile = this.getNotebookFile(projectKey, name);
        try {
            NotebookSafeForWritingNew notebook = (NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, NotebookSafeForWritingNew.class);
            if (JupyterService.shouldStripCellsOutputs() && JupyterService.containsCellsOutputs(notebook)) {
                this.saveNotebook(projectKey, name, notebook);
                this.createCheckpoint(projectKey, name);
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Notebook does not exist, or cannot be rewritten: %s.%s", projectKey, name), (Throwable)e);
        }
    }

    public void stripCellOutputsFromNotebookFile(ReadWriteFS readWriteFS, RelFile notebookFile) {
        try {
            NotebookSafeForWritingNew notebook;
            if (readWriteFS.isFile(notebookFile) && JupyterService.containsCellsOutputs(notebook = (NotebookSafeForWritingNew)readWriteFS.readObject(notebookFile, NotebookSafeForWritingNew.class))) {
                readWriteFS.writeObject(notebookFile, (Object)notebook.copyWithoutCellsOutputs());
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unable to strip cells from notebook file %s", notebookFile), (Throwable)e);
        }
    }

    @Override
    public void unloadNotebookSessionsBeforeDeletion(AuthCtx authCtx, String projectKey, String notebookName) throws IOException {
        JupyterNotebookListEntry notebook = this.getJupyterNotebookWithActiveSessions(authCtx, projectKey, notebookName);
        for (ActiveSession session : notebook.activeSessions) {
            this.unloadSession(session.sessionId);
        }
    }

    private JupyterNotebookListEntry getJupyterNotebookWithActiveSessions(AuthCtx authCtx, String projectKey, String notebookName) throws IOException {
        JupyterNotebookListEntry notebook;
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            notebook = this.getMandatoryUnsafe(projectKey, notebookName, false);
        }
        this.addActiveSessions(authCtx, Collections.singletonList(notebook), false);
        return notebook;
    }

    @Override
    public NotebookSessionDeletion unloadSession(String sessionId) throws IOException {
        HttpDelete delete = new HttpDelete(JupyterService.getURL() + "api/sessions/" + sessionId);
        int timeout = JupyterService.getTimeout();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).setDefaultRequestConfig(defaultRequestConfig).build();){
            delete.addHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret((boolean)true));
            CloseableHttpResponse deleted = httpClient.execute((HttpUriRequest)delete);
            int deletionStatusCode = deleted.getStatusLine().getStatusCode();
            if (deletionStatusCode == 204) {
                NotebookSessionDeletion notebookSessionDeletion = new NotebookSessionDeletion(true, null);
                return notebookSessionDeletion;
            }
            if (deletionStatusCode == 410) {
                NotebookSessionDeletion notebookSessionDeletion = new NotebookSessionDeletion(true, "Kernel deleted before session");
                return notebookSessionDeletion;
            }
            if (deletionStatusCode == 404) {
                NotebookSessionDeletion notebookSessionDeletion = new NotebookSessionDeletion(false, "Session not found");
                return notebookSessionDeletion;
            }
            NotebookSessionDeletion notebookSessionDeletion = new NotebookSessionDeletion(false, null);
            return notebookSessionDeletion;
        }
    }

    private String recipeTypeToLanguage(String recipeType) {
        if (PythonRecipeMeta.META.getType().equals(recipeType) || PySparkRecipeMeta.META.getType().equals(recipeType)) {
            return "python";
        }
        if (RRecipeMeta.META.getType().equals(recipeType) || SparkRRecipeMeta.META.getType().equals(recipeType)) {
            return "r";
        }
        if (SparkScalaRecipeMeta.META.getType().equals(recipeType)) {
            return "scala";
        }
        if (JuliaRecipeMeta.META.getType().equals(recipeType)) {
            return "julia";
        }
        throw ErrorContext.iae((String)("Unknown recipe type:" + recipeType));
    }

    @Override
    public JupyterUserAuthorization getJupyterUserAuthorization(String user) throws IOException {
        JupyterUserAuthorization userAuthorization = new JupyterUserAuthorization();
        DSSAuthCtx liu = DSSAuthCtx.forUserFromUI(this.usersService, user, null);
        if (!this.canAccess(liu)) {
            userAuthorization.accessAllowed = false;
            return userAuthorization;
        }
        userAuthorization.accessAllowed = true;
        userAuthorization.admin = liu.isAdmin();
        return userAuthorization;
    }

    @Override
    public Optional<Pair<String, String>> getNameAndDisplayNameOfKernelSpecs(String projectKey, CodeEnvSelection codeEnvSelection) {
        String kernelDisplayName;
        String kernelName;
        String envName;
        try {
            envName = new CodeEnvSelector().selectForDoctor(projectKey, codeEnvSelection);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        try {
            kernelName = JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.PYTHON, envName, null, null, null);
        }
        catch (Error e) {
            return Optional.empty();
        }
        try {
            KernelSpec kernelSpecs = this.getKernelSpecs(kernelName);
            kernelDisplayName = kernelSpecs.displayName;
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)kernelName, (Object)kernelDisplayName));
    }

    @Override
    public List<String> listAuthorizedProjects(String user, List<String> filterProjectIdIn) throws IOException, DKUSecurityException {
        DSSAuthCtx liu = DSSAuthCtx.forUserFromUI(this.usersService, user, null);
        if (!this.canAccess(liu)) {
            return Collections.emptyList();
        }
        HashSet<String> projectKeyList = new HashSet<String>(this.projectsService.listProjectKeys());
        if (filterProjectIdIn != null) {
            projectKeyList.retainAll(filterProjectIdIn);
        }
        if (liu.isAdmin()) {
            return new ArrayList<String>(projectKeyList);
        }
        ArrayList<String> authorizedProjects = new ArrayList<String>();
        for (String projectKey : projectKeyList) {
            if (!this.permService.hasProjectPrivilege((AuthCtx)liu, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) continue;
            authorizedProjects.add(projectKey);
        }
        return authorizedProjects;
    }

    private boolean canAccess(AuthCtx liu) {
        return liu.isSafeCodeAllowed() && this.permService.canCreateActiveWebContent(liu);
    }

    private RelFile getProjectRootDir(String projectKey) {
        return new RelFile(new String[]{"projects", projectKey});
    }

    @Override
    public RelFile getNotebooksDir(String projectKey) {
        return this.getNotebooksDir(this.getProjectRootDir(projectKey));
    }

    public RelFile getNotebooksDir(RelFile projectRootDir) {
        return new RelFile(projectRootDir, new String[]{"ipython_notebooks"});
    }

    @Override
    public RelFile getCheckpointsDir(String projectKey, List<String> filePath) {
        return this.getCheckpointsDir(this.getProjectRootDir(projectKey), filePath);
    }

    private RelFile getCheckpointsDir(RelFile projectRootDir, List<String> filePath) {
        RelFile currentDir = this.getNotebooksDir(projectRootDir);
        for (int i = 0; i < filePath.size() - 1; ++i) {
            currentDir = currentDir.append(new String[]{filePath.get(i)});
        }
        return currentDir.append(new String[]{".ipynb_checkpoints"});
    }

    @Override
    public RelFile getNotebookFile(String projectKey, String name) {
        return this.getNotebookFile(this.getProjectRootDir(projectKey), name);
    }

    public RelFile getNotebookFile(RelFile projectRootDir, String name) {
        List<String> path = Arrays.asList(name.split("/"));
        path.set(path.size() - 1, path.get(path.size() - 1) + ".ipynb");
        return this.getNotebooksDir(projectRootDir).append(path.toArray(new String[0]));
    }

    @Override
    public RelFile getCheckpointFile(String projectKey, String name) {
        return this.getCheckpointFile(this.getProjectRootDir(projectKey), name);
    }

    public RelFile getCheckpointFile(RelFile projectRootDir, String name) {
        List<String> path = Arrays.asList(name.split("/"));
        String fileName = path.get(path.size() - 1) + "-checkpoint.ipynb";
        return this.getCheckpointsDir(projectRootDir, path).append(new String[]{fileName});
    }

    @Override
    public File getNotebooksDirAsFile(String projectKey) {
        return DKUApp.getFile((String[])new String[]{"config", this.getNotebooksDir(projectKey).getFullPath()});
    }

    @Override
    public File getNotebooksWithOutputsDir(String projectKey) {
        return DKUApp.getFile((String[])new String[]{"notebook_results", "jupyter", projectKey});
    }

    @Override
    public File getNotebookFileAsFile(String projectKey, String name) {
        List<String> path = Arrays.asList(name.split("/"));
        path.set(path.size() - 1, path.get(path.size() - 1) + ".ipynb");
        return DKUFileUtils.getWithin((File)this.getNotebooksDirAsFile(projectKey), (String[])path.toArray(new String[0]));
    }

    @Override
    public File getNotebookWithOutputsFile(String projectKey, String name) {
        List<String> path = Arrays.asList(name.split("/"));
        path.set(path.size() - 1, path.get(path.size() - 1) + ".ipynb");
        return DKUFileUtils.getWithin((File)this.getNotebooksWithOutputsDir(projectKey), (String[])path.toArray(new String[0]));
    }

    @Override
    public File getNotebookWithOutputsCheckpointDir(String projectKey, List<String> filePath) {
        File currentDir = this.getNotebooksWithOutputsDir(projectKey);
        for (int i = 0; i < filePath.size() - 1; ++i) {
            currentDir = new File(currentDir, filePath.get(i));
        }
        return new File(currentDir, ".ipynb_checkpoints");
    }

    @Override
    public File getNotebookWithOutputsCheckpointFile(String projectKey, String name) {
        List<String> path = Arrays.asList(name.split("/"));
        String fileName = path.get(path.size() - 1) + "-checkpoint.ipynb";
        return new File(this.getNotebookWithOutputsCheckpointDir(projectKey, path), fileName);
    }

    @Override
    public boolean isNotebookWithOutputsUpToDate(String projectKey, String name) {
        NotebookSafeForWritingNew notebook;
        NotebookSafeForWritingNew notebookWithOutputs;
        File notebookWithOutputsFile = this.getNotebookWithOutputsFile(projectKey, name);
        if (!notebookWithOutputsFile.isFile()) {
            return false;
        }
        try {
            notebookWithOutputs = (NotebookSafeForWritingNew)JSON.parseFile((File)notebookWithOutputsFile, NotebookSafeForWritingNew.class);
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to read notebook-with-outputs file: " + String.valueOf(notebookWithOutputsFile)), (Throwable)e);
            return false;
        }
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile notebookFile = this.getNotebookFile(projectKey, name);
        try {
            notebook = (NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, NotebookSafeForWritingNew.class);
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to read notebook file: " + String.valueOf(notebookFile)), (Throwable)e);
            return false;
        }
        return this.isNotebookWithOutputsUpToDate(notebook, notebookWithOutputs);
    }

    @Override
    public void ensureNotebookWithOutputsIsUpToDate(String projectKey, String name) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile notebookFile = this.getNotebookFile(projectKey, name);
        NotebookSafeForWritingNew notebook = (NotebookSafeForWritingNew)t.readObject(notebookFile, NotebookSafeForWritingNew.class);
        File notebookWithOutputsFile = this.getNotebookWithOutputsFile(projectKey, name);
        NotebookSafeForWritingNew notebookWithOutputs = null;
        try {
            notebookWithOutputs = (NotebookSafeForWritingNew)JSON.parseFile((File)notebookWithOutputsFile, NotebookSafeForWritingNew.class);
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to read notebook-with-outputs file: " + String.valueOf(notebookWithOutputsFile)), (Throwable)e);
        }
        if (!this.isNotebookWithOutputsUpToDate(notebook, notebookWithOutputs)) {
            logger.info((Object)("Notebook-with-outputs file: " + notebookWithOutputsFile.getName() + " is not up-to-date, replacing with the original notebook."));
            this.writeNotebookToNotebookWithOutputsFile(notebook, notebookWithOutputsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KernelSpec> listKernelSpecs() throws IOException {
        DefaultHttpClient client = JupyterService.newHttpClient();
        ArrayList<KernelSpec> ret = new ArrayList<KernelSpec>();
        try {
            HttpGet get = new HttpGet(JupyterService.getURL() + "api/kernelspecs");
            int timeout = ApplicationConfigurator.getParams().getIntParam("dku.jupyter_calls.timeout.ms", Integer.valueOf(10000));
            if (DKUtils.getEnvironment().containsKey("DKU_JUPYTER_TIMEOUT")) {
                timeout = Integer.parseInt(System.getenv("DKU_JUPYTER_TIMEOUT"));
            }
            HttpConnectionParams.setConnectionTimeout((HttpParams)get.getParams(), (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)get.getParams(), (int)timeout);
            get.addHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret((boolean)true));
            HttpResponse resp = client.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to query Jupyter : " + resp.getStatusLine().getReasonPhrase());
            }
            String data = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)Charsets.UTF_8);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("listKernelSpecs: raw=" + String.valueOf(JSON.parse((String)data, JsonObject.class))));
            }
            JupyterKernelSpecsAnswer kernelSpecs = (JupyterKernelSpecsAnswer)JSON.parse((String)data, JupyterKernelSpecsAnswer.class);
            for (JupyterKernelSpecAnswer jupyterKernelSpecAnswer : kernelSpecs.kernelspecs.values()) {
                KernelSpec spec = jupyterKernelSpecAnswer.toKernelSpec();
                ret.add(spec);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("listKernelSpecs: clean=" + JSON.json(ret)));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KernelSpec getKernelSpecs(String kernelName) throws IOException {
        DefaultHttpClient client = JupyterService.newHttpClient();
        try {
            HttpGet get = new HttpGet(JupyterService.getURL() + "api/kernelspecs");
            int timeout = JupyterService.getTimeout();
            HttpConnectionParams.setConnectionTimeout((HttpParams)get.getParams(), (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)get.getParams(), (int)timeout);
            get.addHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret((boolean)true));
            HttpResponse resp = client.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to query Jupyter : " + resp.getStatusLine().getReasonPhrase());
            }
            String data = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)Charsets.UTF_8);
            JupyterKernelSpecsAnswer kernelSpecs = (JupyterKernelSpecsAnswer)JSON.parse((String)data, JupyterKernelSpecsAnswer.class);
            for (JupyterKernelSpecAnswer jupyterKernelSpecAnswer : kernelSpecs.kernelspecs.values()) {
                if (!jupyterKernelSpecAnswer.name.equals(kernelName)) continue;
                KernelSpec kernelSpec = jupyterKernelSpecAnswer.toKernelSpec();
                return kernelSpec;
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
        throw new NotFoundException("Kernel spec \"" + kernelName + "\" does not exist.");
    }

    private static DefaultHttpClient newHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        return client;
    }

    @Override
    public JupyterNotebookListEntry gitCommitNotebook(AuthCtx user, String projectKey, String fileName, NotebookSafeForWritingNew notebook) throws IOException {
        notebook.metadata.addProperty("modifiedBy", user.getIdentifier());
        this.saveNotebook(projectKey, fileName, notebook);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, fileName, user, TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_EDIT));
        return this.getMandatory(projectKey, fileName, true);
    }

    @Override
    public JupyterNotebookListEntry gitRenameNotebook(AuthCtx user, String projectKey, String oldFileName, String newFileName) throws IOException {
        NotebookSafeForWritingNew notebook = this.loadNotebook(projectKey, oldFileName, false);
        this.markNotebookAsModifiedByUser(user, notebook);
        this.saveNotebook(projectKey, newFileName, notebook);
        this.deleteNotebookFiles(this.getNotebookFile(projectKey, oldFileName), this.getNotebookWithOutputsFile(projectKey, oldFileName));
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, newFileName, user, TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_RENAME));
        return this.getMandatory(projectKey, newFileName, true);
    }

    @Override
    public String gitCommitCheckpoint(AuthCtx user, String projectKey, String fileName) throws IOException {
        this.createCheckpoint(projectKey, fileName);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, fileName, user, TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_EDIT));
        return this.getCheckpointFile(projectKey, fileName).getLeafName();
    }

    @Override
    public String gitRestoreCheckpoint(AuthCtx user, String projectKey, String fileName) throws IOException {
        RelFile checkpointFile = this.getCheckpointFile(projectKey, fileName);
        File checkpointsWithOutputsFile = this.getNotebookWithOutputsCheckpointFile(projectKey, fileName);
        NotebookSafeForWritingNew notebook = this.readNotebookFiles(checkpointFile, checkpointsWithOutputsFile, false);
        this.markNotebookAsModifiedByUser(user, notebook);
        this.saveNotebook(projectKey, fileName, notebook);
        this.deleteNotebookFiles(checkpointFile, checkpointsWithOutputsFile);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, fileName, user, TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_EDIT));
        return this.getNotebookFile(projectKey, fileName).getLeafName();
    }

    @Override
    public String gitRenameCheckpoint(AuthCtx user, String projectKey, String oldFileName, String newFileName) throws IOException {
        RelFile oldFile = this.getCheckpointFile(projectKey, oldFileName);
        File oldOutputsFile = this.getNotebookWithOutputsCheckpointFile(projectKey, oldFileName);
        NotebookSafeForWritingNew notebook = this.readNotebookFiles(oldFile, oldOutputsFile, false);
        this.markNotebookAsModifiedByUser(user, notebook);
        RelFile newFile = this.getCheckpointFile(projectKey, newFileName);
        File newOutputsFile = this.getNotebookWithOutputsCheckpointFile(projectKey, newFileName);
        this.writeNotebookFiles(newFile, newOutputsFile, notebook);
        this.deleteNotebookFiles(oldFile, oldOutputsFile);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, newFileName, user, TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_RENAME));
        return newFile.getLeafName();
    }

    @Override
    public void checkLicenceForLanguage(AuthCtx user, String language) throws DKUSecurityException {
        this.licenseEnforcementService.checkRegularCodeAllowed(user);
    }

    @Override
    public void removeGitInformation(File file) throws IOException {
        NotebookSafeForWritingNew notebook = (NotebookSafeForWritingNew)JSON.parseFile((File)file, NotebookSafeForWritingNew.class);
        notebook.metadata.remove(GIT_KEY_DKU);
        JSON.prettyToFile((Object)notebook, (File)file);
    }

    @Override
    public void updateGitInformation(JupyterNotebookListEntry notebookListEntry, String commitHash, Long commitTimestamp) throws IOException {
        NotebookSafeForWritingNew notebook = this.loadNotebook(notebookListEntry.projectKey, notebookListEntry.name, false);
        if (notebook.metadata != null && notebook.metadata.has(GIT_KEY_DKU) && notebook.metadata.get(GIT_KEY_DKU) != null && notebook.metadata.get(GIT_KEY_DKU).isJsonObject()) {
            JsonObject dkuMetadata = notebook.metadata.getAsJsonObject(GIT_KEY_DKU);
            if (dkuMetadata.has(GIT_KEY_GIT_REFERENCE) && dkuMetadata.get(GIT_KEY_GIT_REFERENCE) != null && dkuMetadata.get(GIT_KEY_GIT_REFERENCE).isJsonObject()) {
                JsonObject gitReference = dkuMetadata.getAsJsonObject(GIT_KEY_GIT_REFERENCE);
                gitReference.remove(gitKeyLastHash);
                gitReference.addProperty(gitKeyLastHash, commitHash);
                gitReference.remove(gitKeyLastTimestamp);
                gitReference.addProperty(gitKeyLastTimestamp, (Number)commitTimestamp);
            }
            dkuMetadata.remove(gitKeyLastInteraction);
            dkuMetadata.addProperty(gitKeyLastInteraction, (Number)System.currentTimeMillis());
            this.saveNotebook(notebookListEntry.projectKey, notebookListEntry.name, notebook);
        }
    }

    @Override
    public void updateGitInformation(JupyterNotebookListEntry notebookListEntry, GitModel.GitReference reference) throws IOException {
        NotebookSafeForWritingNew notebook = this.loadNotebook(notebookListEntry.projectKey, notebookListEntry.name, false);
        if (notebook.metadata == null) {
            notebook.metadata = new JsonObject();
        }
        JsonObject dkuMetadata = new JsonObject();
        dkuMetadata.add(GIT_KEY_GIT_REFERENCE, (JsonElement)JSON.toJsonObject((Object)this.gitReferencesService.encryptProjectGitReference(reference)));
        dkuMetadata.addProperty(gitKeyLastInteraction, (Number)System.currentTimeMillis());
        notebook.metadata.add(GIT_KEY_DKU, (JsonElement)dkuMetadata);
        this.saveNotebook(notebookListEntry.projectKey, notebookListEntry.name, notebook);
    }

    @Override
    public void unlinkGitInformation(JupyterNotebookListEntry notebookListEntry) throws IOException {
        NotebookSafeForWritingNew notebook = this.loadNotebook(notebookListEntry.projectKey, notebookListEntry.name, false);
        if (notebook.metadata != null) {
            notebook.metadata.remove(GIT_KEY_DKU);
            this.saveNotebook(notebookListEntry.projectKey, notebookListEntry.name, notebook);
        }
    }

    private void enrichWithGitInformation(JupyterNotebookListEntry jupyterNbk, NotebookSafeForWritingNew nb) {
        JsonObject dkuMetadata;
        if (nb.metadata != null && nb.metadata.has(GIT_KEY_DKU) && nb.metadata.get(GIT_KEY_DKU) != null && nb.metadata.get(GIT_KEY_DKU).isJsonObject() && (dkuMetadata = nb.metadata.getAsJsonObject(GIT_KEY_DKU)).has(GIT_KEY_GIT_REFERENCE) && dkuMetadata.get(GIT_KEY_GIT_REFERENCE) != null && dkuMetadata.get(GIT_KEY_GIT_REFERENCE).isJsonObject()) {
            jupyterNbk.gitReference = this.gitReferencesService.decryptProjectGitReference((GitModel.GitReference)JSON.parse((JsonElement)dkuMetadata.getAsJsonObject(GIT_KEY_GIT_REFERENCE), GitModel.GitReference.class));
        }
    }

    private static void addPropertyIfNotExist(JsonObject jsonObject, String property, String value) {
        if (!jsonObject.has(property)) {
            jsonObject.addProperty(property, value);
        }
    }

    private static void addPropertyIfNotExist(JsonObject jsonObject, String property, JsonArray value) {
        if (!jsonObject.has(property) || !jsonObject.get(property).isJsonArray()) {
            jsonObject.add(property, (JsonElement)value);
        }
    }

    private static void addPropertyIfNotExist(JsonObject jsonObject, String property, Number value) {
        if (!jsonObject.has(property)) {
            jsonObject.addProperty(property, value);
        }
    }

    private void addPropertyIfNotExist(JsonObject jsonObject, String property, JsonObject value) {
        if (!jsonObject.has(property) || !jsonObject.get(property).isJsonObject()) {
            jsonObject.add(property, (JsonElement)value);
        }
    }

    private static void setCreationTag(NotebookSafeForWritingNew nb, JupyterNotebookListEntry jupyterNbk) {
        if (jupyterNbk.creator != null) {
            long defaultValue = jupyterNbk.lastModifiedOn != 0L ? jupyterNbk.lastModifiedOn : System.currentTimeMillis();
            jupyterNbk.creationTag = new VersionTag(jupyterNbk.creator, JupyterService.safeGetMetadataLong(nb, "createdOn", defaultValue), 0L);
        }
    }

    private static void setVersionTag(NotebookSafeForWritingNew nb, JupyterNotebookListEntry jupyterNbk) {
        String modifiedBy = JupyterService.safeGetMetadataStr(nb, "modifiedBy", jupyterNbk.creator);
        if (modifiedBy != null) {
            jupyterNbk.versionTag = new VersionTag(modifiedBy, jupyterNbk.lastModifiedOn, 1L);
        }
    }

    private NotebookSafeForWritingNew encodeNotebookMetadataGitRef(NotebookSafeForWritingNew notebook) {
        JsonObject dkuMetadata;
        if (notebook.metadata != null && notebook.metadata.get(GIT_KEY_DKU) != null && notebook.metadata.get(GIT_KEY_DKU).isJsonObject() && (dkuMetadata = notebook.metadata.getAsJsonObject(GIT_KEY_DKU)).has(GIT_KEY_GIT_REFERENCE) && dkuMetadata.get(GIT_KEY_GIT_REFERENCE) != null && dkuMetadata.get(GIT_KEY_GIT_REFERENCE).isJsonObject()) {
            GitModel.GitReference gitReference = this.gitReferencesService.encryptProjectGitReference((GitModel.GitReference)JSON.parse((JsonElement)dkuMetadata.getAsJsonObject(GIT_KEY_GIT_REFERENCE), GitModel.GitReference.class));
            dkuMetadata.remove(GIT_KEY_GIT_REFERENCE);
            dkuMetadata.add(GIT_KEY_GIT_REFERENCE, (JsonElement)JSON.toJsonObject((Object)gitReference));
        }
        return notebook;
    }

    private NotebookSafeForWritingNew decodeNotebookMetadataGitRef(NotebookSafeForWritingNew notebook) {
        JsonObject dkuMetadata;
        if (notebook.metadata != null && notebook.metadata.get(GIT_KEY_DKU) != null && notebook.metadata.get(GIT_KEY_DKU).isJsonObject() && (dkuMetadata = notebook.metadata.getAsJsonObject(GIT_KEY_DKU)).has(GIT_KEY_GIT_REFERENCE) && dkuMetadata.get(GIT_KEY_GIT_REFERENCE) != null && dkuMetadata.get(GIT_KEY_GIT_REFERENCE).isJsonObject()) {
            GitModel.GitReference gitReference = this.gitReferencesService.decryptProjectGitReference((GitModel.GitReference)JSON.parse((JsonElement)dkuMetadata.getAsJsonObject(GIT_KEY_GIT_REFERENCE), GitModel.GitReference.class));
            dkuMetadata.remove(GIT_KEY_GIT_REFERENCE);
            dkuMetadata.add(GIT_KEY_GIT_REFERENCE, (JsonElement)JSON.toJsonObject((Object)gitReference));
        }
        return notebook;
    }

    @Override
    public void saveNotebook(String projectKey, String name, NotebookSafeForWritingNew notebook) throws IOException {
        RelFile notebookFile = this.getNotebookFile(projectKey, name);
        File notebookWithOutputsFile = this.getNotebookWithOutputsFile(projectKey, name);
        this.writeNotebookFiles(notebookFile, notebookWithOutputsFile, this.encodeNotebookMetadataGitRef(notebook));
    }

    private void createCheckpoint(String projectKey, String name) throws IOException {
        File notebookWithOutputsFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile notebookFile = this.getNotebookFile(projectKey, name);
        RelFile checkpointFile = this.getCheckpointFile(projectKey, name);
        t.copyFile(notebookFile, checkpointFile);
        if (JupyterService.shouldStripCellsOutputs() && (notebookWithOutputsFile = this.getNotebookWithOutputsFile(projectKey, name)).isFile()) {
            File checkpointWithOutputsFile = this.getNotebookWithOutputsCheckpointFile(projectKey, name);
            DKUFileUtils.mkdirsParent((File)checkpointWithOutputsFile);
            Files.copy((File)notebookWithOutputsFile, (File)checkpointWithOutputsFile);
        }
    }

    private NotebookSafeForWritingNew readNotebookFiles(RelFile notebookFile, @Nullable File notebookWithOutputsFile, boolean unsafe) throws IOException {
        NotebookSafeForWritingNew notebookWithOutputs = null;
        if (notebookWithOutputsFile != null && notebookWithOutputsFile.isFile()) {
            try {
                notebookWithOutputs = (NotebookSafeForWritingNew)JSON.parseFile((File)notebookWithOutputsFile, NotebookSafeForWritingNew.class);
            }
            catch (IOException e) {
                logger.warn((Object)("Unable to read notebook-with-outputs file: " + String.valueOf(notebookWithOutputsFile)), (Throwable)e);
            }
        }
        TransactionRef t = TransactionContext.retrieveRead();
        NotebookSafeForWritingNew notebook = unsafe ? (NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, NotebookSafeForWritingNew.class) : (NotebookSafeForWritingNew)t.readObject(notebookFile, NotebookSafeForWritingNew.class);
        NotebookSafeForWritingNew upToDateNotebook = this.isNotebookWithOutputsUpToDate(notebook, notebookWithOutputs) ? notebookWithOutputs : notebook;
        return this.decodeNotebookMetadataGitRef(upToDateNotebook);
    }

    private void writeNotebookFiles(RelFile notebookFile, File notebookWithOutputsFile, NotebookSafeForWritingNew notebook) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.encodeNotebookMetadataGitRef(notebook);
        if (JupyterService.shouldStripCellsOutputs()) {
            t.writeObject(notebookFile, (Object)notebook.copyWithoutCellsOutputs());
            this.writeNotebookToNotebookWithOutputsFile(notebook, notebookWithOutputsFile);
        } else {
            t.writeObject(notebookFile, (Object)notebook);
        }
    }

    private void writeNotebookToNotebookWithOutputsFile(NotebookSafeForWritingNew notebook, File notebookWithOutputsFile) {
        try {
            DKUFileUtils.mkdirsParent((File)notebookWithOutputsFile);
            JSON.prettyToFile((Object)this.encodeNotebookMetadataGitRef(notebook), (File)notebookWithOutputsFile);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to save notebook-with-outputs file", (Throwable)e);
        }
    }

    private void deleteNotebookFiles(RelFile notebookFile, File notebookWithOutputsFile) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(notebookFile);
        this.deleteNotebookWithOutputsFiles(notebookWithOutputsFile);
    }

    private void deleteNotebookWithOutputsFiles(File notebookWithOutputsFile) {
        if (notebookWithOutputsFile.exists() && !notebookWithOutputsFile.delete()) {
            logger.warn((Object)String.format("Unable to delete notebook file with outputs: %s", notebookWithOutputsFile));
        }
    }

    private void setCommonMetadata(AuthCtx user, NotebookSafeForWritingNew nb, JsonArray tags) {
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            nb.metadata.addProperty("automationLocal", Boolean.valueOf(true));
        }
        JupyterService.addPropertyIfNotExist(nb.metadata, "creator", user.getIdentifier());
        JupyterService.addPropertyIfNotExist(nb.metadata, "createdOn", System.currentTimeMillis());
        JupyterService.addPropertyIfNotExist(nb.metadata, "tags", tags);
        this.addPropertyIfNotExist(nb.metadata, "customFields", this.customFieldsService.getDefaultCustomFields(ITaggingService.TaggableType.JUPYTER_NOTEBOOK.name()));
    }

    private void markNotebookAsModifiedByUser(AuthCtx user, NotebookSafeForWritingNew nb) {
        if (nb.metadata != null) {
            long versionNumber = nb.metadata.has("versionNumber") ? (long)nb.metadata.get("versionNumber").getAsInt() : 0L;
            nb.metadata.addProperty("modifiedBy", user.getIdentifier());
            nb.metadata.addProperty("versionNumber", (Number)(versionNumber + 1L));
        }
    }

    private boolean isNotebookWithOutputsUpToDate(NotebookSafeForWritingNew notebook, @Nullable NotebookSafeForWritingNew notebookWithOutputs) {
        return notebookWithOutputs != null && JSON.json((Object)notebook).equals(JSON.json((Object)notebookWithOutputs.copyWithoutCellsOutputs()));
    }

    private static boolean shouldStripCellsOutputs() {
        return DKUApp.getParams().getBoolParam("dku.jupyter.stripCellsOutputs", true);
    }

    public static boolean containsCellsOutputs(NotebookSafeForWritingNew notebook) {
        return notebook.cells.stream().filter(cell -> "code".equals(cell.cell_type)).anyMatch(cell -> !cell.outputs.isEmpty());
    }

    private static int getTimeout() {
        int defaultTimeout = 10000;
        try {
            int timeout = ApplicationConfigurator.getParams().getIntParam("dku.jupyter_calls.timeout.ms", Integer.valueOf(defaultTimeout));
            if (DKUtils.getEnvironment().containsKey("DKU_JUPYTER_TIMEOUT")) {
                timeout = Integer.parseInt(System.getenv("DKU_JUPYTER_TIMEOUT"));
            }
            return timeout;
        }
        catch (NumberFormatException e) {
            logger.warn((Object)"Invalid DKU Jupyter timeout parameter", (Throwable)e);
            return defaultTimeout;
        }
    }

    public static class JupyterNotebookListEntry
    extends TaggableObjectsService.TaggableObject {
        public String projectKey;
        public String name;
        public String language;
        public DisplayKernelSpec displayKernelSpec;
        public boolean automationLocal;
        public String associatedRecipe;
        public String analyzedDataset;
        public String creator;
        public List<ActiveSession> activeSessions = new ArrayList<ActiveSession>();
        public long lastModifiedOn;
        public GitModel.GitReference gitReference;
        public long lastGitInteraction;

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.JUPYTER_NOTEBOOK;
        }

        @Override
        public String getProjectKey() {
            return this.projectKey;
        }

        @Override
        public String getId() {
            return this.name;
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }

        @Override
        public void setProjectKey(String projectKey) {
            this.projectKey = projectKey;
        }

        @Override
        public void setId(String id) {
            this.name = id;
        }
    }

    public static class NotebookSafeForWritingNew {
        public JsonObject metadata;
        public int nbformat;
        public int nbformat_minor;
        public List<CellForWriting> cells = new ArrayList<CellForWriting>();

        public NotebookSafeForWritingNew copyWithoutCellsOutputs() {
            NotebookSafeForWritingNew result = new NotebookSafeForWritingNew();
            result.metadata = this.metadata;
            result.nbformat = this.nbformat;
            result.nbformat_minor = this.nbformat_minor;
            result.cells = this.cells.stream().map(CellForWriting::copyWithoutOutputs).collect(Collectors.toList());
            return result;
        }
    }

    public static class JupyterKernelSpecInNotebook {
        public String name;
        public String language;
        public String display_name;
    }

    public static class DisplayKernelSpec {
        public String name;
        public String envName;
        public String projectKey;
        public String bundleId;
        public String containerConf;
    }

    private static class JupyterSessionListAnswer {
        Kernel kernel;
        long start_time;
        Notebook notebook;
        String id;

        private JupyterSessionListAnswer() {
        }

        private static class Notebook {
            String path;

            private Notebook() {
            }
        }

        private static class Kernel {
            String id;
            int connections;
            String last_activity;
            String execution_state;
            Integer pid;
            String name;

            private Kernel() {
            }
        }
    }

    public static class ActiveSession {
        public String projectKey;
        public String notebookName;
        public String sessionCreator;
        public String sessionCreatorDisplayName;
        public String sessionUnixOwner;
        public String sessionId;
        public String kernelId;
        public Integer kernelPid;
        public int kernelConnections;
        public long kernelLastActivityTime;
        public String kernelExecutionState;
        public long sessionStartTime;
    }

    public static class KernelSpec
    extends DisplayKernelSpec {
        public String language;
        public String displayName;
        public List<String> argv;

        public static DisplayKernelSpec toKernelSpec(String kernelName, KernelSpec ks) {
            DisplayKernelSpec spec = new DisplayKernelSpec();
            spec.name = kernelName;
            if (ks != null) {
                spec.envName = ks.envName;
                spec.containerConf = ks.containerConf;
                spec.projectKey = ks.projectKey;
                spec.bundleId = ks.bundleId;
            }
            return spec;
        }
    }

    public static class NotebookSessionDeletion {
        public final boolean success;
        public final String message;

        NotebookSessionDeletion(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }

    public static class JupyterUserAuthorization {
        public boolean accessAllowed;
        public boolean admin;
    }

    public static class JupyterKernelSpecsAnswer {
        public Map<String, JupyterKernelSpecAnswer> kernelspecs = Maps.newHashMap();
    }

    public static class JupyterKernelSpecAnswer {
        public String name;
        public Map<String, String> resources = Maps.newHashMap();
        public JupyterKernelSpec spec = new JupyterKernelSpec();

        public KernelSpec toKernelSpec() {
            KernelSpec ks = new KernelSpec();
            ks.name = this.name;
            ks.displayName = this.spec.display_name;
            ks.language = this.spec.language;
            ks.argv = this.spec.argv;
            ks.containerConf = this.spec.metadata.get("containerConf");
            ks.envName = this.spec.metadata.get("envName");
            ks.projectKey = this.spec.metadata.get("projectKey");
            ks.bundleId = this.spec.metadata.get("bundleId");
            return ks;
        }
    }

    public static class CellForWriting {
        public Integer execution_count = 0;
        public String cell_type = "code";
        public JsonObject metadata = new JsonObject();
        public List<String> source = new ArrayList<String>();
        public List<JsonObject> outputs = new ArrayList<JsonObject>();

        public static void registerAdapter() {
            JSON.registerAdapter(CellForWriting.class, (Object)new JSON.Adapter<CellForWriting>(){

                public CellForWriting deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) {
                    CellForWriting cell = new CellForWriting();
                    JsonObject jsonObj = json.getAsJsonObject();
                    if (jsonObj.get("execution_count") != null && !jsonObj.get("execution_count").isJsonNull()) {
                        cell.execution_count = jsonObj.get("execution_count").getAsInt();
                    }
                    if (jsonObj.get("cell_type") != null && !jsonObj.get("cell_type").isJsonNull()) {
                        cell.cell_type = jsonObj.get("cell_type").getAsString();
                    }
                    if (jsonObj.get("metadata") != null && jsonObj.get("metadata").isJsonObject()) {
                        cell.metadata = jsonObj.get("metadata").getAsJsonObject();
                    }
                    if (jsonObj.get("source") != null) {
                        if (jsonObj.get("source").isJsonArray()) {
                            for (JsonElement sourceLine : jsonObj.get("source").getAsJsonArray()) {
                                if (!sourceLine.isJsonPrimitive()) continue;
                                cell.source.add(sourceLine.getAsString());
                            }
                        } else if (!jsonObj.get("source").isJsonNull()) {
                            cell.source.add(jsonObj.get("source").getAsString());
                        }
                    }
                    if (jsonObj.get("outputs") != null && jsonObj.get("outputs").isJsonArray()) {
                        for (JsonElement output : jsonObj.get("outputs").getAsJsonArray()) {
                            if (!output.isJsonObject()) continue;
                            cell.outputs.add(output.getAsJsonObject());
                        }
                    }
                    return cell;
                }

                public JsonElement serialize(CellForWriting params, Type type, JsonSerializationContext ctx) {
                    JsonObject jsonObj = new JsonObject();
                    if ("code".equals(params.cell_type)) {
                        jsonObj.add("execution_count", (JsonElement)new JsonPrimitive((Number)params.execution_count));
                    }
                    jsonObj.add("cell_type", (JsonElement)new JsonPrimitive(params.cell_type));
                    jsonObj.add("metadata", (JsonElement)params.metadata);
                    JsonArray sourceArray = JSON.toJsonArray(params.source);
                    jsonObj.add("source", (JsonElement)sourceArray);
                    JsonArray outputArray = JSON.toJsonArray(params.outputs);
                    if ("code".equals(params.cell_type)) {
                        jsonObj.add("outputs", (JsonElement)outputArray);
                    }
                    return jsonObj;
                }
            });
        }

        public CellForWriting copyWithoutOutputs() {
            CellForWriting result = new CellForWriting();
            result.source = this.source;
            result.cell_type = this.cell_type;
            result.metadata = this.metadata;
            result.outputs = new ArrayList<JsonObject>();
            result.execution_count = 0;
            return result;
        }
    }

    public static class JupyterKernelSpec {
        public String language;
        public String display_name;
        public List<String> argv = Lists.newArrayList();
        public Map<String, String> metadata = Maps.newHashMap();
    }
}

