/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.agents.tools.AgentToolsCRUDService;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.llm.promptstudio.PromptStudiosCRUDService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeCRUDService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.SearchNotebooksService;
import com.dataiku.dip.server.services.TaggableObjectCodes;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggableObjectsDeletionService {
    @Autowired
    private DatasetDeletionService datasetsDeletionService;
    @Autowired
    private DatasetSaveService datasetsSaveService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private PromptStudiosCRUDService promptStudiosCRUDService;
    @Autowired
    private RetrievableKnowledgeCRUDService retrievableKnowledgeCRUDService;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private StreamingEndpointService streamingEndpointService;
    @Autowired
    private RecipeSaveService recipesSaveService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private SearchNotebooksService searchNotebooksService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private ModelComparisonsCRUDService modelComparisonsCRUDService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private ExploresService exploreService;
    @Autowired
    private DatasetRenameService datasetRenameService;
    @Autowired
    private AgentToolsCRUDService agentToolsCRUDService;
    private static final Logger logger = Logger.getLogger((String)"dku.taggableobjects.delete");

    public DeletionImpact computeDeletionImpact(@Nullable String contextProjectKey, TaggableObjectsService.TaggableObject to, @Nullable DeletionRequestItem deletionRequestItem, Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx) throws Exception {
        DeletionImpact impact = null;
        ITaggingService.TaggableType type = to.getTaggableType();
        type.assertNotFakeType();
        boolean deleteAndReconnect = deletionRequestItem != null && deletionRequestItem.options != null && deletionRequestItem.options.deleteAndReconnect;
        switch (type) {
            case DATASET: {
                SerializedDataset sd = (SerializedDataset)to;
                Dataset ds = Dataset.fromSerializedUnsafe(sd);
                impact = this.datasetsDeletionService.computeDeletionImpact(authCtx, contextProjectKey != null ? contextProjectKey : ds.getProjectKey(), ds, ignored, deleteAndReconnect);
                if (!deleteAndReconnect) break;
                impact.deletedDatasets.add(new ImpactedDataset(sd.projectKey, sd.name, sd.type));
                break;
            }
            case MANAGED_FOLDER: {
                impact = this.managedFoldersService.computeDeletionImpact(authCtx, contextProjectKey != null ? contextProjectKey : to.getProjectKey(), to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case STREAMING_ENDPOINT: {
                impact = this.streamingEndpointService.computeDeletionImpact(authCtx, contextProjectKey, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case SAVED_MODEL: {
                impact = this.savedModelsCRUDService.computeDeletionImpact(authCtx, contextProjectKey != null ? contextProjectKey : to.getProjectKey(), to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case MODEL_EVALUATION_STORE: {
                impact = this.modelEvaluationStoresCRUDService.computeDeletionImpact(authCtx, contextProjectKey != null ? contextProjectKey : to.getProjectKey(), to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case LABELING_TASK: {
                impact = this.labelingTasksCRUDService.computeDeletionImpact(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case CODE_STUDIO: {
                impact = this.codeStudioObjectsService.computeDeletionImpact(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                impact = this.retrievableKnowledgeCRUDService.computeDeletionImpact(authCtx, contextProjectKey != null ? contextProjectKey : to.getProjectKey(), to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case JUPYTER_NOTEBOOK: 
            case INSIGHT: 
            case DASHBOARD: {
                break;
            }
            case RECIPE: {
                if (!deleteAndReconnect) break;
                SerializedRecipe sr = (SerializedRecipe)to;
                impact = new DeletionImpact();
                impact.deletedRecipes.add(new ImpactedRecipe(sr.getProjectKey(), sr.name, sr.type));
                break;
            }
            case REPORT: 
            case WEB_APP: 
            case SCENARIO: 
            case ANALYSIS: 
            case STATISTICS_WORKSHEET: 
            case MODEL_COMPARISON: 
            case SQL_NOTEBOOK: 
            case SEARCH_NOTEBOOK: 
            case ARTICLE: 
            case FLOW_ZONE: {
                break;
            }
            case LAMBDA_SERVICE: 
            case PROJECT: {
                throw new IllegalArgumentException("Impossible to delete projects this way");
            }
            case DATA_COLLECTION: {
                throw new IllegalArgumentException("Impossible to delete data collections this way");
            }
        }
        if (impact == null) {
            impact = new DeletionImpact();
        }
        this.genericDeletionImpact(contextProjectKey, to, impact, ignored, authCtx);
        return impact;
    }

    private void genericDeletionImpact(@Nullable String contextProjectKey, TaggableObjectsService.TaggableObject to, DeletionImpact impact, Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx) throws IOException, DKUSecurityException {
        SerializedProject.ProjectExposedObjects exposedObjects = this.exposedObjectsService.getEnrichedExposedObjects(to.getProjectKey());
        for (ExposedObject eo : exposedObjects.objects) {
            if (!to.getId().equals(eo.localName) || eo.type != to.getTaggableType()) continue;
            for (ExposedObject.Rule rule : eo.rules) {
                ExposedObject.Rule.RuleWithName rwn = (ExposedObject.Rule.RuleWithName)rule;
                if (!this.projectsService.projectExists(rule.targetProject)) continue;
                if (this.permissionsService.hasProjectPrivilege(authCtx, rule.targetProject, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                    if (rwn.targetProject.equals(contextProjectKey)) continue;
                    impact.exposedToProjects.add(new ImpactedProject(rwn.targetProject, rwn.targetProjectDisplayName));
                    continue;
                }
                impact.exposedToUnaccessibleProjects.add(new ImpactedProject(DKUtils.md5Base64((String)rwn.targetProject), ""));
            }
        }
        try {
            for (Insight insight : this.insightsService.listForSourceUnsafe(to.getProjectKey(), to.getTaggableType(), to.getId())) {
                if (ignored != null && ignored.contains(new TaggableObjectsService.TaggableObjectRef(insight))) continue;
                impact.deletedInsights.add(new ImpactedInsight(insight.projectKey, insight.id, insight.name, insight.getClass().getName()));
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to get impacted insights for deletion: " + String.valueOf(to)), (Throwable)e);
        }
        try {
            for (Scenario scenario : this.scenariosService.listForSource(to.getProjectKey(), to.getProjectKey(), to.getTaggableType(), to.getId(), true)) {
                if (ignored != null && ignored.contains(new TaggableObjectsService.TaggableObjectRef(scenario))) continue;
                impact.deletedScenarios.add(new ImpactedScenario(scenario.getProjectKey(), scenario.getId(), scenario.getName()));
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to get impacted senarios for deletion: " + String.valueOf(to)), (Throwable)e);
        }
    }

    private InfoMessage.InfoMessages preDeletionClear_NT(TaggableObjectsService.TaggableObject to, AuthCtx authCtx, DeletionOptions options, PreDeletionContext preDeletionContext) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        ITaggingService.TaggableType type = to.getTaggableType();
        type.assertNotFakeType();
        switch (type) {
            case DATASET: {
                SerializedDataset sd = (SerializedDataset)to;
                Dataset ds = Dataset.fromSerializedUnsafe(sd);
                ret.mergeFrom(this.datasetsDeletionService.clearDatasetForDeletion_NT(authCtx, ds, options, preDeletionContext));
                break;
            }
            case MANAGED_FOLDER: {
                ManagedFolder mf = (ManagedFolder)to;
                if (options == null || !options.dropData) break;
                this.managedFoldersService.clear(authCtx, mf);
                break;
            }
            case LABELING_TASK: {
                LabelingTask lt = (LabelingTask)to;
                if (options != null && options.dropData) {
                    this.labelingTasksCRUDService.clearLabelingTaskForDeletion(lt);
                }
                this.labelingTasksCRUDService.dropMetadataTable(lt);
                break;
            }
            case SAVED_MODEL: {
                throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot clear saved models");
            }
            case MODEL_EVALUATION_STORE: {
                throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot clear saved evaluation stores");
            }
            case STREAMING_ENDPOINT: {
                throw new CodedException((InfoMessage.MessageCode)TaggableObjectCodes.ERR_OBJECT_OPERATION_NOT_AVAILABLE_FOR_TYPE, "Cannot clear streaming endpoints");
            }
            case CODE_STUDIO: 
            case INSIGHT: 
            case DASHBOARD: 
            case RECIPE: 
            case REPORT: 
            case WEB_APP: 
            case SCENARIO: 
            case ANALYSIS: 
            case STATISTICS_WORKSHEET: 
            case MODEL_COMPARISON: 
            case ARTICLE: 
            case FLOW_ZONE: {
                break;
            }
            case SQL_NOTEBOOK: {
                break;
            }
            case SEARCH_NOTEBOOK: {
                break;
            }
            case JUPYTER_NOTEBOOK: {
                this.jupyterService.unloadNotebookSessionsBeforeDeletion(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case LAMBDA_SERVICE: {
                throw new NotImplementedException("Delete API service");
            }
            case PROJECT: {
                throw new IllegalArgumentException("Impossible to delete projects this way");
            }
            case DATA_COLLECTION: {
                throw new IllegalArgumentException("Impossible to delete data collections this way");
            }
        }
        return ret;
    }

    public void delete(TaggableObjectsService.TaggableObject to, Set<TaggableObjectsService.TaggableObjectRef> ignored, boolean deleteAndReconnect, AuthCtx authCtx) throws Exception {
        ITaggingService.TaggableType type = to.getTaggableType();
        type.assertNotFakeType();
        switch (type) {
            case DATASET: {
                Dataset ds = Dataset.fromSerializedUnsafe((SerializedDataset)to);
                this.datasetsDeletionService.performDeletion(ds, ignored, authCtx, deleteAndReconnect);
                this.datasetsSaveService.delete(to.getProjectKey(), to.getId());
                break;
            }
            case MANAGED_FOLDER: {
                this.managedFoldersService.performDeletion(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case SAVED_MODEL: {
                this.savedModelsCRUDService.performDeletion(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case MODEL_EVALUATION_STORE: {
                this.modelEvaluationStoresCRUDService.performDeletion(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case STREAMING_ENDPOINT: {
                this.streamingEndpointService.performDeletion(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case LABELING_TASK: {
                this.labelingTasksCRUDService.delete(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case RECIPE: {
                this.recipesSaveService.delete(to.getProjectKey(), to.getId());
                break;
            }
            case ANALYSIS: {
                this.analysisCRUDService.delete(to.getProjectKey(), to.getId());
                break;
            }
            case STATISTICS_WORKSHEET: {
                this.worksheetsService.delete(to.getRef());
                break;
            }
            case MODEL_COMPARISON: {
                this.modelComparisonsCRUDService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                this.retrievableKnowledgeCRUDService.delete(authCtx, to.getProjectKey(), to.getId(), ignored);
                break;
            }
            case AGENT_TOOL: {
                this.agentToolsCRUDService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case PROMPT_STUDIO: {
                this.promptStudiosCRUDService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case WEB_APP: {
                this.webAppsService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case CODE_STUDIO: {
                this.codeStudioObjectsService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case REPORT: {
                this.reportsService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case SCENARIO: {
                this.scenariosService.delete(to.getProjectKey(), to.getId());
                break;
            }
            case DASHBOARD: {
                this.dashboardsService.delete(to.getProjectKey(), to.getId());
                break;
            }
            case INSIGHT: {
                this.insightsService.delete(to.getProjectKey(), to.getId());
                break;
            }
            case JUPYTER_NOTEBOOK: {
                this.jupyterService.delete(to.getProjectKey(), to.getId(), authCtx);
                break;
            }
            case SQL_NOTEBOOK: {
                this.sqlNotebooksService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case SEARCH_NOTEBOOK: {
                this.searchNotebooksService.delete(authCtx, to.getProjectKey(), to.getId());
                break;
            }
            case ARTICLE: {
                this.wikisService.deleteArticle(to.getProjectKey(), to.getId(), false);
                break;
            }
            case FLOW_ZONE: {
                this.flowZonesService.delete(to.getProjectKey(), to.getId(), authCtx);
                break;
            }
            case LAMBDA_SERVICE: {
                throw new NotImplementedException("Delete API service");
            }
            case PROJECT: {
                throw new IllegalArgumentException("Impossible to delete projects this way");
            }
            case DATA_COLLECTION: {
                throw new IllegalArgumentException("Impossible to delete data collections this way");
            }
        }
        TaggableObjectsService.TaggableObjectRef objectRef = new TaggableObjectsService.TaggableObjectRef(to.getProjectKey(), to.getTaggableType(), to.getId());
        this.exposedObjectsService.unshare(new HashSet<TaggableObjectsService.TaggableObjectRef>(Collections.singletonList(objectRef)));
        this.workspacesService.notifyObjectDeleted(authCtx, objectRef);
    }

    private void rewireAroundRecipe(SerializedRecipe recipe, AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        List<SerializedRecipe.RecipeInput> predecessorInputs = recipe.getFlatInputs();
        if (predecessorInputs.isEmpty()) {
            throw ErrorContext.iae((String)"Cannot do delete and reconnect on a recipe with no inputs");
        }
        if (predecessorInputs.size() > 1) {
            throw ErrorContext.iae((String)"Cannot do delete and reconnect on a recipe that has multiple inputs");
        }
        SerializedRecipe.RecipeInput predecessorInput = predecessorInputs.get(0);
        DatasetLocUtils.DatasetLoc predecessorDsLoc = predecessorInput.getLoc(recipe.getProjectKey()).toDatasetLoc();
        ProjectFlowGraph flowGraph = this.flowGraphService.getProjectGraph(recipe.getProjectKey(), false);
        FlowRecipe flowRecipe = flowGraph.getRecipe(recipe.getProjectKey(), recipe.getId());
        this.doForEachSuccessorRecipe(flowRecipe, (successorRecipe, successorDsLoc) -> {
            ImpactedRecipe impactedSuccessorRecipe = new ImpactedRecipe(recipe.getProjectKey(), successorRecipe.getName(), successorRecipe.getType());
            this.datasetRenameService.performRenamingForRecipe((DatasetLocUtils.DatasetLoc)successorDsLoc, predecessorDsLoc, authCtx, impactedSuccessorRecipe);
        });
    }

    private void doForEachSuccessorRecipe(FlowRecipe flowRecipe, ThrowingBiConsumer<FlowRecipe, DatasetLocUtils.DatasetLoc> action) throws IOException, DKUSecurityException, CodedException {
        List<? extends GraphNode> successors = flowRecipe.getSuccessors();
        List successorFlowDatasets = successors.stream().filter(FlowDataset.class::isInstance).map(FlowDataset.class::cast).collect(Collectors.toList());
        if (successors.size() != successorFlowDatasets.size()) {
            throw ErrorContext.iae((String)"Cannot do delete and reconnect on a recipe with outputs that are not datasets");
        }
        for (FlowDataset successorFlowDS : successorFlowDatasets) {
            DatasetLocUtils.DatasetLoc successorDsLoc = new AnyLoc(flowRecipe.getProjectKey(), successorFlowDS.getRef(flowRecipe.getProjectKey())).toDatasetLoc();
            if (successorFlowDS.getSuccessors().isEmpty()) {
                throw ErrorContext.iae((String)"Cannot do delete and reconnect on a recipe at the end of the flow");
            }
            for (GraphNode graphNode : successorFlowDS.getSuccessors()) {
                if (!(graphNode instanceof FlowRecipe)) {
                    throw ErrorContext.iae((String)"Failed trying to do delete and reconnect - successor datasets have successors that are not recipes");
                }
                FlowRecipe successorRecipe = (FlowRecipe)graphNode;
                action.accept(successorRecipe, successorDsLoc);
            }
        }
    }

    public DeletionImpact computeDeletionImpact(@Nullable String contextProjectKey, Set<DeletionRequestItem> deletionRequests, Set<ImpactedComputable> unsharingRequests, Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx) throws Exception {
        ArrayList<DeletionImpact> di = new ArrayList<DeletionImpact>();
        for (DeletionRequestItem dr : deletionRequests) {
            this.failIfCannotDelete(dr, authCtx);
            TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe(dr);
            DeletionImpact deletionImpact = this.computeDeletionImpact(contextProjectKey, to, dr, ignored, authCtx);
            di.add(deletionImpact);
        }
        for (ImpactedComputable ur : unsharingRequests) {
            DeletionRequestItem dr = new DeletionRequestItem(ur.projectKey, ur.type, ur.id);
            TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe(dr);
            DeletionImpact unsharedDeletionImpact = this.computeDeletionImpact(contextProjectKey, to, dr, ignored, authCtx);
            if (contextProjectKey != null && !contextProjectKey.equals(to.getProjectKey())) {
                unsharedDeletionImpact.deletedRecipes = unsharedDeletionImpact.deletedRecipes.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.foreignReadableRecipes.clear();
                unsharedDeletionImpact.deletedDatasets = unsharedDeletionImpact.deletedDatasets.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.foreignReadableDatasets.clear();
                unsharedDeletionImpact.deletedAnalyses = unsharedDeletionImpact.deletedAnalyses.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.foreignReadableAnalyses.clear();
                unsharedDeletionImpact.deletedWorksheets = unsharedDeletionImpact.deletedWorksheets.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.deletedScenarios = unsharedDeletionImpact.deletedScenarios.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.deletedInsights = unsharedDeletionImpact.deletedInsights.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.deletedLabelingTasks = unsharedDeletionImpact.deletedLabelingTasks.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.foreignReadableLabelingTasks.clear();
                unsharedDeletionImpact.deletedSavedModels = unsharedDeletionImpact.deletedSavedModels.stream().filter(o -> o.projectKey.equals(contextProjectKey)).collect(Collectors.toSet());
                unsharedDeletionImpact.foreignReadableSavedModels.clear();
                if (unsharedDeletionImpact.availableOptions != null && unsharedDeletionImpact.availableOptions.size() > 1 && unsharedDeletionImpact.availableOptions.containsKey(ur.projectKey + "." + ur.id)) {
                    HashMap<String, AvailableDeletionOptions> availableOptions = new HashMap<String, AvailableDeletionOptions>();
                    for (Map.Entry<String, AvailableDeletionOptions> availableOption : unsharedDeletionImpact.availableOptions.entrySet()) {
                        if (!availableOption.getKey().startsWith(contextProjectKey + ".") && !availableOption.getKey().startsWith(ur.projectKey + "." + ur.id)) continue;
                        availableOptions.put(availableOption.getKey(), availableOption.getValue());
                    }
                    unsharedDeletionImpact.availableOptions = availableOptions;
                }
                unsharedDeletionImpact.exposedToProjects.clear();
                unsharedDeletionImpact.exposedToUnaccessibleProjects.clear();
                unsharedDeletionImpact.impactedDataCollections.clear();
                unsharedDeletionImpact.impactedUnaccessibleDataCollections.clear();
            }
            di.add(unsharedDeletionImpact);
        }
        di.add(this.dashboardsService.computeDeletionImpact(deletionRequests, ignored, authCtx));
        return DatasetDeletionService.merge(di);
    }

    public DeletionResult delete_NT(Collection<DeletionRequestItem> toDelete, Map<DeletionRequestItem, TaggableObjectsService.TaggableObject> taggableObjectsMap, String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx) throws IOException, CodedException, DKUSecurityException {
        DeletionResult result = new DeletionResult();
        Set<Insight> insightsToDeleteAfter = null;
        for (DeletionRequestItem dr2 : toDelete) {
            if (dr2.type != ITaggingService.TaggableType.DASHBOARD) continue;
            try (Transaction t = this.transactionService.beginRead();){
                insightsToDeleteAfter = this.dashboardsService.getInsightsToDeleteWithDashboards(authCtx, contextProjectKey, toDelete, ignored);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get insights to delete with dashboards", (Throwable)e);
            }
            break;
        }
        HashMap<DeletionRequestItem, PreDeletionContext> preDeletionContextByItem = new HashMap<DeletionRequestItem, PreDeletionContext>();
        Map<Pair, List<DeletionRequestItem>> itemsToClearByProjectAndType = toDelete.stream().collect(Collectors.groupingBy(dr -> new Pair((Object)dr.projectKey, (Object)dr.type)));
        for (List<DeletionRequestItem> list : itemsToClearByProjectAndType.values()) {
            for (int i = 0; i < list.size(); ++i) {
                DeletionRequestItem dr3 = list.get(i);
                PreDeletionContext preDeletionContext = new PreDeletionContext();
                preDeletionContext.inProjectDeletion = false;
                preDeletionContext.lastItemWithDQStatusFromThisProject = i == list.size() - 1;
                preDeletionContextByItem.put(dr3, preDeletionContext);
            }
        }
        for (DeletionRequestItem deletionRequestItem : toDelete) {
            boolean deleteAndReconnect = deletionRequestItem.options != null && deletionRequestItem.options.deleteAndReconnect;
            boolean deleteAndReconnectRecipe = deleteAndReconnect && deletionRequestItem.type == ITaggingService.TaggableType.RECIPE;
            try {
                TaggableObjectsService.TaggableObject to = taggableObjectsMap.get(deletionRequestItem);
                if (deletionRequestItem.options != null && (deletionRequestItem.options.dropData || deletionRequestItem.options.dropMetastoreTable) || this.shouldAlwaysBeClearedBeforeDelete(to)) {
                    result.mergeFrom(this.preDeletionClear_NT(to, authCtx, deletionRequestItem.options, (PreDeletionContext)preDeletionContextByItem.get(deletionRequestItem)));
                }
                try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                    if (deleteAndReconnectRecipe) {
                        this.rewireAroundRecipe((SerializedRecipe)to, authCtx);
                    }
                    this.delete(to, ignored, deleteAndReconnect, authCtx);
                    this.flowZonesService.cleanupObjectFromZones(contextProjectKey, to);
                    t.commitV(deleteAndReconnectRecipe ? "Deleted %s %s and reconnected the flow around it" : "Deleted %s %s", new Object[]{to.getTaggableType().toHumanReadableString(), to.getFullId()});
                }
                this.auditTrailService.generic("taggable-object-delete").with("itemType", deletionRequestItem.type.toString()).with("projectKey", deletionRequestItem.projectKey).with("id", deletionRequestItem.id).emit();
            }
            catch (Exception e) {
                result.withWarningV(TaggableObjectCodes.ERR_OBJECT_UNEXPECTED_ERROR, "Failed to delete item: " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
                logger.error((Object)("Failed to delete item " + String.valueOf(deletionRequestItem)), (Throwable)e);
                this.auditTrailService.failure("taggable-item-delete", (Throwable)e).with("itemType", deletionRequestItem.type.toString()).with("projectKey", deletionRequestItem.projectKey).with("id", deletionRequestItem.id).emit();
            }
        }
        HashSet<String> dashboardIds = new HashSet<String>();
        for (DeletionRequestItem dr5 : toDelete) {
            if (dr5.type != ITaggingService.TaggableType.DASHBOARD) continue;
            dashboardIds.add(dr5.id);
        }
        if (!dashboardIds.isEmpty() && insightsToDeleteAfter != null) {
            try (RWTransaction rWTransaction = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                for (Insight insight : insightsToDeleteAfter) {
                    this.insightsService.delete(insight.projectKey, insight.id);
                }
                rWTransaction.commit("Deleted insights with dashboards");
            }
        }
        this.flowGraphService.invalidateCache();
        return result;
    }

    private boolean shouldAlwaysBeClearedBeforeDelete(TaggableObjectsService.TaggableObject to) {
        return to instanceof SerializedDataset || to instanceof JupyterService.JupyterNotebookListEntry || to instanceof LabelingTask;
    }

    public void failIfCannotDelete(TaggableObjectsService.TaggableObjectRef ref, AuthCtx authCtx) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(ref.projectKey, ref.id);
        this.projectsService.checkPerm(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        if (ref.type == ITaggingService.TaggableType.RECIPE) {
            boolean deleteAndReconnect;
            boolean bl = deleteAndReconnect = ref instanceof DeletionRequestItem && ((DeletionRequestItem)ref).options.deleteAndReconnect;
            if (deleteAndReconnect) {
                TaggableObjectsService.TaggableObject recipeTo = this.taggableObjectsReadService.getMandatory(ref);
                this.failIfCannotDeleteAndReconnect((SerializedRecipe)recipeTo, authCtx);
            }
        }
    }

    private void failIfCannotDeleteAndReconnect(SerializedRecipe targetRecipe, AuthCtx authCtx) throws IOException, CodedException, DKUSecurityException {
        ProjectFlowGraph flowGraph = this.flowGraphService.getProjectGraphUnsafe(targetRecipe.getProjectKey());
        List<SerializedRecipe.RecipeInput> targetInputs = targetRecipe.getFlatInputs();
        if (targetInputs.isEmpty()) {
            throw ErrorContext.iae((String)"Cannot do delete and reconnect on a recipe with no inputs");
        }
        if (targetInputs.size() > 1) {
            throw ErrorContext.iae((String)"Cannot do delete and reconnect on a recipe that has multiple inputs");
        }
        SerializedRecipe.RecipeInput targetInput = targetInputs.get(0);
        if (targetInput == null) {
            throw ErrorContext.iae((String)"Failed trying to do delete and reconnect on a recipe as input was null");
        }
        AnyLoc predecessorLoc = targetInput.getLoc(targetRecipe.getProjectKey());
        FlowDataset predecessorFlowDataset = (FlowDataset)flowGraph.datasets.get(predecessorLoc.getFullName());
        if (predecessorFlowDataset == null) {
            throw ErrorContext.iae((String)"Cannot do delete and reconnect if the input to the recipe is not a dataset");
        }
        Dataset predecessorDataset = this.datasetAccessService.getMandatory(targetRecipe.getProjectKey(), predecessorLoc.getId());
        FlowRecipe flowRecipe = flowGraph.getRecipe(targetRecipe.getProjectKey(), targetRecipe.getId());
        Set successorRecipeIdsSoFar = predecessorFlowDataset.getSuccessors().stream().filter(FlowRecipe.class::isInstance).map(FlowRecipe.class::cast).map(recipe -> recipe.getFullId()).filter(id -> !targetRecipe.getFullId().equals(id)).collect(Collectors.toSet());
        SerializedProject serializedProject = this.projectsService.getMandatoryUnsafe(targetRecipe.getProjectKey());
        this.doForEachSuccessorRecipe(flowRecipe, (successorRecipe, successorDsLocation) -> {
            Dataset successorDataset = this.datasetAccessService.getMandatoryUnsafe(targetRecipe.getProjectKey(), successorDsLocation.getId());
            Set<String> projectsExposedTo = serializedProject.exposedObjects.getProjectsExposedTo(ITaggingService.TaggableType.DATASET, successorDataset.getName());
            if (!projectsExposedTo.isEmpty()) {
                throw ErrorContext.iae((String)"Cannot do delete and reconnect as a successor dataset is shared");
            }
            if (!successorDataset.getType().equals(predecessorDataset.getType())) {
                throw ErrorContext.iae((String)"Cannot do delete and reconnect as dataset types do not match");
            }
            this.recipesSaveService.failIfNotAllowed(successorRecipe.getModel(), authCtx, null);
            if (!successorRecipeIdsSoFar.add(successorRecipe.getFullId())) {
                throw ErrorContext.iae((String)"Cannot do delete and reconnect as reconnected datasets would feed into the same recipe");
            }
            SerializedRecipe serializedRecipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(successorRecipe.getProjectKey(), successorRecipe.getName());
            if (serializedRecipe != null && serializedRecipe.getInputsUnsafe().containsKey("veloop")) {
                throw ErrorContext.iae((String)"Cannot do delete and reconnect as one of the successor datasets is a driving dataset");
            }
        });
    }

    public void stopExposeObjects_NT(AuthCtx authCtx, Set<TaggableObjectsService.TaggableObjectRef> items, String targetProjectKey) throws Exception {
        HashSet<TaggableObjectsService.TaggableObjectRef> itemsToStopSharing = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            for (TaggableObjectsService.TaggableObjectRef item : items) {
                AnyLoc loc = item.getLoc().resolved();
                if (!this.projectsService.isObjectAvailableInProject(new SmartObjectRef(loc.getProjectKey(), item.type, loc.getId()), targetProjectKey)) continue;
                if (this.permissionsService.hasProjectPrivilege(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS) || this.permissionsService.hasProjectPrivilege(authCtx, targetProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                    itemsToStopSharing.add(item);
                    continue;
                }
                throw new UnauthorizedException("Not enough permission to stop sharing object " + String.valueOf(loc) + " from project " + targetProjectKey, "project-authorization-failure");
            }
            for (TaggableObjectsService.TaggableObjectRef item : items) {
                DeletionImpact impact = this.computeDeletionImpact(targetProjectKey, this.taggableObjectsReadService.getMandatory(item), null, null, authCtx);
                Set recipesToDelete = impact.deletedRecipes.stream().filter(recipe -> recipe.projectKey.equals(targetProjectKey)).collect(Collectors.toSet());
                for (Object recipe2 : recipesToDelete) {
                    this.recipesSaveService.delete(((ImpactedRecipe)recipe2).projectKey, ((ImpactedRecipe)recipe2).name);
                }
                Set labelingTasksToDelete = impact.deletedLabelingTasks.stream().filter(labelingTask -> labelingTask.projectKey.equals(targetProjectKey)).collect(Collectors.toSet());
                for (Object labelingTask2 : labelingTasksToDelete) {
                    this.labelingTasksCRUDService.delete(authCtx, ((ImpactedLabelingTask)labelingTask2).projectKey, ((ImpactedLabelingTask)labelingTask2).id, null);
                }
                Set<ImpactedExploreSettings> exploreSettingsToDelete = impact.deletedExploreSettings;
                for (ImpactedExploreSettings exploreSettings : exploreSettingsToDelete) {
                    this.exploreService.delete(exploreSettings.projectKey, exploreSettings.datasetSmartName);
                }
                Set<ImpactedSavedModel> savedModelsToDelete = impact.deletedSavedModels;
                for (ImpactedSavedModel savedModel : savedModelsToDelete) {
                    this.savedModelsCRUDService.performDeletion(authCtx, savedModel.projectKey, savedModel.id, null);
                }
            }
            if (!itemsToStopSharing.isEmpty()) {
                this.exposedObjectsService.unshare(itemsToStopSharing, targetProjectKey);
            }
            t.commit("Updated exposed objects");
        }
        this.flowGraphService.invalidateCache();
    }

    public static class DeletionRequestItem
    extends TaggableObjectsService.TaggableObjectRef {
        public String displayName;
        public DeletionOptions options = new DeletionOptions();

        public DeletionRequestItem(String projectKey, ITaggingService.TaggableType type, String id) {
            super(projectKey, type, id);
        }
    }

    public static class DeletionOptions {
        public boolean dropData;
        public boolean dropMetastoreTable;
        public boolean deleteAndReconnect;
        public boolean deleteOrphanInsights;
    }

    public static class DeletionImpact {
        public Set<ImpactedRecipe> deletedRecipes = new HashSet<ImpactedRecipe>();
        public Set<ImpactedRecipe> foreignReadableRecipes = new HashSet<ImpactedRecipe>();
        public Set<ImpactedLabelingTask> deletedLabelingTasks = new HashSet<ImpactedLabelingTask>();
        public Set<ImpactedLabelingTask> foreignReadableLabelingTasks = new HashSet<ImpactedLabelingTask>();
        public Set<ImpactedDataset> deletedDatasets = new HashSet<ImpactedDataset>();
        public Set<ImpactedDataset> foreignReadableDatasets = new HashSet<ImpactedDataset>();
        public Set<ImpactedAnalysis> deletedAnalyses = new HashSet<ImpactedAnalysis>();
        public Set<ImpactedAnalysis> foreignReadableAnalyses = new HashSet<ImpactedAnalysis>();
        public Set<ImpactedWorksheet> deletedWorksheets = new HashSet<ImpactedWorksheet>();
        public Set<ImpactedScenario> deletedScenarios = new HashSet<ImpactedScenario>();
        public Set<ImpactedProject> exposedToProjects = new HashSet<ImpactedProject>();
        public Set<ImpactedProject> exposedToUnaccessibleProjects = new HashSet<ImpactedProject>();
        public Set<ImpactedInsight> deletedInsights = new HashSet<ImpactedInsight>();
        public Set<ImpactedWebApp> deletedWebApps = new HashSet<ImpactedWebApp>();
        public Set<ImpactedExploreSettings> deletedExploreSettings = new HashSet<ImpactedExploreSettings>();
        public Set<ImpactedSavedModel> deletedSavedModels = new HashSet<ImpactedSavedModel>();
        public Set<ImpactedSavedModel> foreignReadableSavedModels = new HashSet<ImpactedSavedModel>();
        public Set<ImpactedDataCollection> impactedDataCollections = new HashSet<ImpactedDataCollection>();
        public Set<String> impactedUnaccessibleDataCollections = new HashSet<String>();
        public Set<ImpactedComputable> toUnshare = new HashSet<ImpactedComputable>();
        public Map<String, AvailableDeletionOptions> availableOptions = new HashMap<String, AvailableDeletionOptions>();

        public void merge(DeletionImpact other) {
            if (other == null) {
                return;
            }
            this.deletedRecipes.addAll(other.deletedRecipes);
            this.foreignReadableRecipes.addAll(other.foreignReadableRecipes);
            this.deletedLabelingTasks.addAll(other.deletedLabelingTasks);
            this.foreignReadableLabelingTasks.addAll(other.foreignReadableLabelingTasks);
            this.deletedDatasets.addAll(other.deletedDatasets);
            this.foreignReadableDatasets.addAll(other.foreignReadableDatasets);
            this.deletedAnalyses.addAll(other.deletedAnalyses);
            this.foreignReadableAnalyses.addAll(other.foreignReadableAnalyses);
            this.deletedWorksheets.addAll(other.deletedWorksheets);
            this.deletedScenarios.addAll(other.deletedScenarios);
            this.deletedWebApps.addAll(other.deletedWebApps);
            this.deletedExploreSettings.addAll(other.deletedExploreSettings);
            this.deletedSavedModels.addAll(other.deletedSavedModels);
            this.foreignReadableSavedModels.addAll(other.foreignReadableSavedModels);
            this.impactedDataCollections.addAll(other.impactedDataCollections);
            this.impactedUnaccessibleDataCollections.addAll(other.impactedUnaccessibleDataCollections);
            this.exposedToProjects.addAll(other.exposedToProjects);
            this.exposedToUnaccessibleProjects.addAll(other.exposedToUnaccessibleProjects);
            for (ImpactedInsight ii : other.deletedInsights) {
                if (this.deletedInsights.contains(ii) && ii.optional) continue;
                this.deletedInsights.add(ii);
            }
            this.toUnshare.addAll(other.toUnshare);
            this.availableOptions.putAll(other.availableOptions);
        }
    }

    public static class ImpactedDataset {
        public String projectKey;
        public String name;
        public String type;

        public ImpactedDataset(String projectKey, String name, String type) {
            this.projectKey = projectKey;
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.name, this.type});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedDataset)) {
                return false;
            }
            ImpactedDataset other = (ImpactedDataset)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type);
        }
    }

    public static class ImpactedRecipe {
        public String projectKey;
        public String name;
        public String type;

        public ImpactedRecipe(String projectKey, String name, String type) {
            this.projectKey = projectKey;
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.name, this.type});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedRecipe)) {
                return false;
            }
            ImpactedRecipe other = (ImpactedRecipe)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type);
        }
    }

    public static class ImpactedProject {
        public String projectKey;
        public String projectName;

        public ImpactedProject(String projectKey, String projectName) {
            this.projectKey = projectKey;
            this.projectName = projectName;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.projectKey});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedProject)) {
                return false;
            }
            ImpactedProject other = (ImpactedProject)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey);
        }
    }

    public static class ImpactedInsight {
        public final String projectKey;
        public final String id;
        public final String name;
        public final String type;
        public boolean optional;

        public ImpactedInsight(String projectKey, String id, String name, String type) {
            this.projectKey = projectKey;
            this.id = id;
            this.name = name;
            this.type = type;
        }

        public ImpactedInsight(Insight insight) {
            this.projectKey = insight.projectKey;
            this.id = insight.id;
            this.name = insight.name;
            this.type = insight.type;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id, this.name, this.type});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedInsight)) {
                return false;
            }
            ImpactedInsight other = (ImpactedInsight)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type);
        }
    }

    public static class ImpactedScenario {
        public String projectKey;
        public String id;
        public String name;

        public ImpactedScenario(String projectKey, String id, String name) {
            this.projectKey = projectKey;
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id, this.name});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedScenario)) {
                return false;
            }
            ImpactedScenario other = (ImpactedScenario)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name);
        }
    }

    public static class PreDeletionContext {
        public boolean inProjectDeletion;
        public boolean lastItemWithDQStatusFromThisProject;
    }

    @FunctionalInterface
    private static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws IOException, DKUSecurityException, RuntimeException, CodedException;
    }

    public static class ImpactedComputable {
        public String projectKey;
        public ITaggingService.TaggableType type;
        public String id;
        public String displayName;
    }

    public static class AvailableDeletionOptions {
        public boolean isDropDataDangerous;
        public boolean shouldGiveOptionToDropData;
        public boolean canDropMetastoreTable;
        public boolean deleteOrphanInsights;
    }

    public static class DeletionResult
    extends InfoMessage.InfoMessages {
        public List<Dataset> delayedClearManagedDatasets = null;
        public List<ManagedFolder> delayedClearOutputManagedFolders = null;
        public List<LabelingTask> delayedClearLabelingTasks = null;
    }

    public static class ImpactedLabelingTask {
        public String projectKey;
        public String id;
        public String name;

        public ImpactedLabelingTask(String projectKey, String id, String name) {
            this.projectKey = projectKey;
            this.name = name;
            this.id = id;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedLabelingTask)) {
                return false;
            }
            ImpactedLabelingTask other = (ImpactedLabelingTask)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id);
        }
    }

    public static class ImpactedExploreSettings {
        public String projectKey;
        public String datasetSmartName;

        public ImpactedExploreSettings(String projectKey, String datasetSmartName) {
            this.projectKey = projectKey;
            this.datasetSmartName = datasetSmartName;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.datasetSmartName});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedExploreSettings)) {
                return false;
            }
            ImpactedExploreSettings other = (ImpactedExploreSettings)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.datasetSmartName, (Object)other.datasetSmartName);
        }
    }

    public static class ImpactedSavedModel {
        public String projectKey;
        public String id;
        public String name;
        public SavedModel.SavedModelType savedModelType;

        public ImpactedSavedModel(String projectKey, String id, String name, SavedModel.SavedModelType savedModelType) {
            this.projectKey = projectKey;
            this.id = id;
            this.name = name;
            this.savedModelType = savedModelType;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id, this.name, this.savedModelType});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedSavedModel)) {
                return false;
            }
            ImpactedSavedModel other = (ImpactedSavedModel)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.savedModelType), (Object)((Object)other.savedModelType));
        }
    }

    public static class ImpactedWorksheet
    extends ImmutableValueObject {
        public final String projectKey;
        public final String id;
        public final String name;

        public ImpactedWorksheet(String projectKey, String id, String name) {
            this.projectKey = projectKey;
            this.id = id;
            this.name = name;
        }
    }

    public static class ImpactedAnalysis {
        public final String projectKey;
        public final String datasetName;
        public final String id;
        public final String name;

        public ImpactedAnalysis(String projectKey, String datasetName, String id, String name) {
            this.projectKey = projectKey;
            this.datasetName = datasetName;
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.name, this.id, this.datasetName});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedAnalysis)) {
                return false;
            }
            ImpactedAnalysis other = (ImpactedAnalysis)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.datasetName, (Object)other.datasetName);
        }
    }

    public static class DeletionError {
        public String msg;
        public String cause;
    }

    public static class ImpactedDataQualityRule {
        public String projectKey;
        public String datasetName;
        public String ruleId;

        public ImpactedDataQualityRule(String projectKey, String datasetName, String ruleId) {
            this.projectKey = projectKey;
            this.datasetName = datasetName;
            this.ruleId = ruleId;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.datasetName, this.ruleId});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedDataQualityRule)) {
                return false;
            }
            ImpactedDataQualityRule other = (ImpactedDataQualityRule)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.datasetName, (Object)other.datasetName) && Objects.equal((Object)this.ruleId, (Object)other.ruleId);
        }
    }

    public static class ImpactedDataCollection {
        public String id;
        public String name;

        public ImpactedDataCollection(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.id, this.name});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedDataCollection)) {
                return false;
            }
            ImpactedDataCollection other = (ImpactedDataCollection)o;
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name);
        }
    }

    public static class ImpactedNotebook {
        public String projectKey;
        public String id;
        public String name;
        public String language;

        public ImpactedNotebook(String projectKey, String id, String name, String language) {
            this.projectKey = projectKey;
            this.id = id;
            this.name = name;
            this.language = language;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id, this.name, this.language});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedNotebook)) {
                return false;
            }
            ImpactedNotebook other = (ImpactedNotebook)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.language, (Object)other.language);
        }
    }

    public static class ImpactedWikiArticle {
        public String projectKey;
        public String id;
        public boolean hasRefToDataset;
        public boolean hasAttachmentToDataset;

        public ImpactedWikiArticle(String projectKey, String id, boolean hasRefToDataset, boolean hasAttachmentToDataset) {
            this.projectKey = projectKey;
            this.id = id;
            this.hasRefToDataset = hasRefToDataset;
            this.hasAttachmentToDataset = hasAttachmentToDataset;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id, this.hasRefToDataset, this.hasAttachmentToDataset});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedWikiArticle)) {
                return false;
            }
            ImpactedWikiArticle other = (ImpactedWikiArticle)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.hasRefToDataset, (Object)other.hasRefToDataset) && Objects.equal((Object)this.hasAttachmentToDataset, (Object)other.hasAttachmentToDataset);
        }
    }

    public static class ImpactedZone {
        public String projectKey;
        public String zoneId;
        public boolean isItems;

        public ImpactedZone(String projectKey, String zoneId, boolean isItems) {
            this.projectKey = projectKey;
            this.zoneId = zoneId;
            this.isItems = isItems;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.zoneId, this.isItems});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedZone)) {
                return false;
            }
            ImpactedZone other = (ImpactedZone)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.zoneId, (Object)other.zoneId) && Objects.equal((Object)this.isItems, (Object)other.isItems);
        }
    }

    public static class ImpactedWebApp {
        public String projectKey;
        public String name;
        public String id;
        public String type;

        public ImpactedWebApp(String projectKey, String name, String id, String type) {
            this.projectKey = projectKey;
            this.name = name;
            this.id = id;
            this.type = type;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.name, this.id});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedWebApp)) {
                return false;
            }
            ImpactedWebApp other = (ImpactedWebApp)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.id, (Object)other.id);
        }
    }

    public static class ImpactedReport {
        public String projectKey;
        public String id;
        public String name;

        public ImpactedReport(String projectKey, String id, String name) {
            this.projectKey = projectKey;
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return DKUtils.hashCode((Object[])new Object[]{this.projectKey, this.id, this.name});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImpactedReport)) {
                return false;
            }
            ImpactedReport other = (ImpactedReport)o;
            return Objects.equal((Object)this.projectKey, (Object)other.projectKey) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name);
        }
    }
}

