/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.dao.AnalysisCoreDAO;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationComparatorsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.datacollections.DataCollectionsDAO;
import com.dataiku.dip.eda.worksheets.WorksheetsDAO;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.workspaces.WorkspacesDAO;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggableObjectsReadService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    private ReportsDAO reportsDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private ModelEvaluationComparatorsDAO modelEvaluationComparatorsDAO;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private AnalysisCoreDAO analysisCoreDAO;
    @Autowired
    private WorksheetsDAO worksheetsDAO;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private WorkspacesDAO workspacesDAO;
    @Autowired
    private DataCollectionsDAO dataCollectionsDAO;

    public List<TaggableObjectsService.TaggableObject> listUnsafe(String projectKey, @Nullable ITaggingService.TaggableType type) throws IOException {
        ArrayList<TaggableObjectsService.TaggableObject> objects = new ArrayList<TaggableObjectsService.TaggableObject>();
        if (type == null) {
            objects.addAll(this.datasetsDAO.listUnsafe(projectKey));
            objects.addAll(this.managedFolderDAO.listUnsafe(projectKey));
            objects.addAll(this.recipesDAO.listUnsafe(projectKey));
            objects.addAll(this.analysisCoreDAO.listUnsafe(projectKey));
            objects.addAll(this.worksheetsDAO.listUnsafe(projectKey));
            objects.addAll(this.modelEvaluationComparatorsDAO.listUnsafe(projectKey));
            objects.addAll(this.savedModelsDAO.listUnsafe(projectKey));
            objects.addAll(this.modelEvaluationStoresDAO.listUnsafe(projectKey));
            objects.addAll(this.promptStudioDAO.listUnsafe(projectKey));
            objects.addAll(this.retrievableKnowledgeDAO.listUnsafe(projectKey));
            objects.addAll(this.agentToolsDAO.listUnsafe(projectKey));
            objects.addAll(this.labelingTasksDAO.listUnsafe(projectKey));
            objects.addAll(this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey));
            objects.addAll(this.sqlNotebooksDAO.listUnsafe(projectKey));
            objects.addAll(this.searchNotebooksDAO.listUnsafe(projectKey));
            objects.addAll(this.scenariosDAO.listUnsafe(projectKey));
            objects.addAll(this.insightsDAO.listUnsafe(projectKey));
            objects.addAll(this.dashboardsDAO.listUnsafe(projectKey));
            objects.addAll(this.webAppsDAO.listUnsafe(projectKey));
            objects.addAll(this.reportsDAO.listUnsafe(projectKey));
            objects.addAll(this.articlesDAO.listUnsafe(projectKey));
            objects.addAll(this.lambdaServicesDAO.listUnsafe(projectKey));
            objects.addAll(this.zonesDAO.listUnsafe(projectKey));
        } else {
            type.assertNotFakeType();
            switch (type) {
                case DATASET: {
                    objects.addAll(this.datasetsDAO.listUnsafe(projectKey));
                    break;
                }
                case MANAGED_FOLDER: {
                    objects.addAll(this.managedFolderDAO.listUnsafe(projectKey));
                    break;
                }
                case STREAMING_ENDPOINT: {
                    objects.addAll(this.streamingEndpointsDAO.listUnsafe(projectKey));
                    break;
                }
                case RECIPE: {
                    objects.addAll(this.recipesDAO.listUnsafe(projectKey));
                    break;
                }
                case ANALYSIS: {
                    objects.addAll(this.analysisCoreDAO.listUnsafe(projectKey));
                    break;
                }
                case STATISTICS_WORKSHEET: {
                    objects.addAll(this.worksheetsDAO.listUnsafe(projectKey));
                    break;
                }
                case SAVED_MODEL: {
                    objects.addAll(this.savedModelsDAO.listUnsafe(projectKey));
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    objects.addAll(this.modelEvaluationStoresDAO.listUnsafe(projectKey));
                    break;
                }
                case LABELING_TASK: {
                    objects.addAll(this.labelingTasksDAO.listUnsafe(projectKey));
                    break;
                }
                case JUPYTER_NOTEBOOK: {
                    objects.addAll(this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey));
                    break;
                }
                case SQL_NOTEBOOK: {
                    objects.addAll(this.sqlNotebooksDAO.listUnsafe(projectKey));
                    break;
                }
                case SEARCH_NOTEBOOK: {
                    objects.addAll(this.searchNotebooksDAO.listUnsafe(projectKey));
                    break;
                }
                case SCENARIO: {
                    objects.addAll(this.scenariosDAO.listUnsafe(projectKey));
                    break;
                }
                case INSIGHT: {
                    objects.addAll(this.insightsDAO.listUnsafe(projectKey));
                    break;
                }
                case DASHBOARD: {
                    objects.addAll(this.dashboardsDAO.listUnsafe(projectKey));
                    break;
                }
                case WEB_APP: {
                    objects.addAll(this.webAppsDAO.listUnsafe(projectKey));
                    break;
                }
                case CODE_STUDIO: {
                    objects.addAll(this.codeStudioObjectsDAO.listUnsafe(projectKey));
                    break;
                }
                case REPORT: {
                    objects.addAll(this.reportsDAO.listUnsafe(projectKey));
                    break;
                }
                case LAMBDA_SERVICE: {
                    objects.addAll(this.lambdaServicesDAO.listUnsafe(projectKey));
                    break;
                }
                case ARTICLE: {
                    objects.addAll(this.articlesDAO.listUnsafe(projectKey));
                    break;
                }
                case FLOW_ZONE: {
                    objects.addAll(this.zonesDAO.listUnsafe(projectKey));
                    break;
                }
                case MODEL_COMPARISON: {
                    objects.addAll(this.modelEvaluationComparatorsDAO.listUnsafe(projectKey));
                    break;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    objects.addAll(this.retrievableKnowledgeDAO.listUnsafe(projectKey));
                    break;
                }
                case AGENT_TOOL: {
                    objects.addAll(this.agentToolsDAO.listUnsafe(projectKey));
                    break;
                }
                case PROMPT_STUDIO: {
                    objects.addAll(this.promptStudioDAO.listUnsafe(projectKey));
                    break;
                }
                case PROJECT: {
                    break;
                }
            }
        }
        return objects;
    }

    public TaggableObjectsService.TaggableObject getOrNullUnsafe(String projectKey, ITaggingService.TaggableType type, String id) throws IOException {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"TaggableType not specified");
        type.assertNotFakeType();
        switch (type) {
            case PROJECT: {
                return this.projectsDAO.getOrNullUnsafe(projectKey);
            }
            case DATASET: {
                return (TaggableObjectsService.TaggableObject)this.datasetsDAO.getOrNullUnsafe(projectKey, id);
            }
            case SAVED_MODEL: {
                return (TaggableObjectsService.TaggableObject)this.savedModelsDAO.getOrNullUnsafe(projectKey, id);
            }
            case MODEL_EVALUATION_STORE: {
                return (TaggableObjectsService.TaggableObject)this.modelEvaluationStoresDAO.getOrNullUnsafe(projectKey, id);
            }
            case MANAGED_FOLDER: {
                return (TaggableObjectsService.TaggableObject)this.managedFolderDAO.getOrNullUnsafe(projectKey, id);
            }
            case STREAMING_ENDPOINT: {
                return (TaggableObjectsService.TaggableObject)this.streamingEndpointsDAO.getOrNullUnsafe(projectKey, id);
            }
            case WEB_APP: {
                return (TaggableObjectsService.TaggableObject)this.webAppsDAO.getOrNullUnsafe(projectKey, id);
            }
            case CODE_STUDIO: {
                return (TaggableObjectsService.TaggableObject)this.codeStudioObjectsDAO.getOrNullUnsafe(projectKey, id);
            }
            case REPORT: {
                return (TaggableObjectsService.TaggableObject)this.reportsDAO.getOrNullUnsafe(projectKey, id);
            }
            case JUPYTER_NOTEBOOK: {
                return this.jupyterService.getOrNullUnsafe(projectKey, id);
            }
            case SCENARIO: {
                return (TaggableObjectsService.TaggableObject)this.scenariosDAO.getOrNullUnsafe(projectKey, id);
            }
            case DASHBOARD: {
                return (TaggableObjectsService.TaggableObject)this.dashboardsDAO.getOrNullUnsafe(projectKey, id);
            }
            case INSIGHT: {
                return (TaggableObjectsService.TaggableObject)this.insightsDAO.getOrNullUnsafe(projectKey, id);
            }
            case RECIPE: {
                return (TaggableObjectsService.TaggableObject)this.recipesDAO.getOrNullUnsafe(projectKey, id);
            }
            case LABELING_TASK: {
                return (TaggableObjectsService.TaggableObject)this.labelingTasksDAO.getOrNullUnsafe(projectKey, id);
            }
            case SQL_NOTEBOOK: {
                return this.sqlNotebooksDAO.getOrNullUnsafe(projectKey, id);
            }
            case SEARCH_NOTEBOOK: {
                return this.searchNotebooksDAO.getOrNullUnsafe(projectKey, id);
            }
            case ARTICLE: {
                return (TaggableObjectsService.TaggableObject)this.articlesDAO.getOrNullUnsafe(projectKey, id);
            }
            case LAMBDA_SERVICE: {
                return (TaggableObjectsService.TaggableObject)this.lambdaServicesDAO.getOrNullUnsafe(projectKey, id);
            }
            case ANALYSIS: {
                return (TaggableObjectsService.TaggableObject)this.analysisCoreDAO.getOrNullUnsafe(projectKey, id);
            }
            case STATISTICS_WORKSHEET: {
                return this.worksheetsDAO.getOrNullUnsafe(projectKey, id);
            }
            case MODEL_COMPARISON: {
                return (TaggableObjectsService.TaggableObject)this.modelEvaluationComparatorsDAO.getOrNullUnsafe(projectKey, id);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return (TaggableObjectsService.TaggableObject)this.retrievableKnowledgeDAO.getOrNullUnsafe(projectKey, id);
            }
            case AGENT_TOOL: {
                return (TaggableObjectsService.TaggableObject)this.agentToolsDAO.getOrNullUnsafe(projectKey, id);
            }
            case PROMPT_STUDIO: {
                return (TaggableObjectsService.TaggableObject)this.promptStudioDAO.getOrNullUnsafe(projectKey, id);
            }
            case FLOW_ZONE: {
                return (TaggableObjectsService.TaggableObject)this.zonesDAO.getOrNullUnsafe(projectKey, id);
            }
            case WORKSPACE: {
                return this.workspacesDAO.getOrNullUnsafe(id);
            }
            case DATA_COLLECTION: {
                return this.dataCollectionsDAO.getOrNullUnsafe(id);
            }
        }
        throw new NotImplementedException("getOrNullUnsafe not implemented for taggable type " + String.valueOf((Object)type));
    }

    public TaggableObjectsService.TaggableObject getMandatoryUnsafe(String projectKey, ITaggingService.TaggableType type, String objectId) throws IOException {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"TaggableType not specified");
        type.assertNotFakeType();
        switch (type) {
            case PROJECT: {
                return this.projectsDAO.getMandatoryUnsafe(projectKey);
            }
            case DATASET: {
                return (TaggableObjectsService.TaggableObject)this.datasetsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case SAVED_MODEL: {
                return (TaggableObjectsService.TaggableObject)this.savedModelsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case MODEL_EVALUATION_STORE: {
                return (TaggableObjectsService.TaggableObject)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case MANAGED_FOLDER: {
                return (TaggableObjectsService.TaggableObject)this.managedFolderDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case LABELING_TASK: {
                return (TaggableObjectsService.TaggableObject)this.labelingTasksDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case STREAMING_ENDPOINT: {
                return (TaggableObjectsService.TaggableObject)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case WEB_APP: {
                return (TaggableObjectsService.TaggableObject)this.webAppsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case CODE_STUDIO: {
                return (TaggableObjectsService.TaggableObject)this.codeStudioObjectsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case REPORT: {
                return (TaggableObjectsService.TaggableObject)this.reportsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case JUPYTER_NOTEBOOK: {
                return this.jupyterService.getMandatoryUnsafe(projectKey, objectId, false);
            }
            case SCENARIO: {
                return (TaggableObjectsService.TaggableObject)this.scenariosDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case DASHBOARD: {
                return (TaggableObjectsService.TaggableObject)this.dashboardsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case INSIGHT: {
                return (TaggableObjectsService.TaggableObject)this.insightsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case RECIPE: {
                return (TaggableObjectsService.TaggableObject)this.recipesDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case SQL_NOTEBOOK: {
                return this.sqlNotebooksDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case SEARCH_NOTEBOOK: {
                return this.searchNotebooksDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case ANALYSIS: {
                return (TaggableObjectsService.TaggableObject)this.analysisCoreDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case STATISTICS_WORKSHEET: {
                return this.worksheetsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case MODEL_COMPARISON: {
                return (TaggableObjectsService.TaggableObject)this.modelEvaluationComparatorsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return (TaggableObjectsService.TaggableObject)this.retrievableKnowledgeDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case AGENT_TOOL: {
                return (TaggableObjectsService.TaggableObject)this.agentToolsDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case PROMPT_STUDIO: {
                return (TaggableObjectsService.TaggableObject)this.promptStudioDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case LAMBDA_SERVICE: {
                return (TaggableObjectsService.TaggableObject)this.lambdaServicesDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case ARTICLE: {
                return (TaggableObjectsService.TaggableObject)this.articlesDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case FLOW_ZONE: {
                return (TaggableObjectsService.TaggableObject)this.zonesDAO.getMandatoryUnsafe(projectKey, objectId);
            }
            case WORKSPACE: {
                return this.workspacesDAO.getMandatoryUnsafe(objectId);
            }
            case DATA_COLLECTION: {
                return this.dataCollectionsDAO.getMandatoryUnsafe(objectId);
            }
        }
        throw new NotImplementedException("getMandatoryUnsafe not implemented for taggable type " + String.valueOf((Object)type));
    }

    public TaggableObjectsService.TaggableObject getMandatoryUnsafe(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        AnyLoc loc = ref.getLoc().resolved();
        return this.getMandatoryUnsafe(loc.getProjectKey(), ref.type, loc.getId());
    }

    public TaggableObjectsService.TaggableObject getMandatory(String projectKey, ITaggingService.TaggableType type, String objectId) throws IOException {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"TaggableType not specified");
        type.assertNotFakeType();
        switch (type) {
            case PROJECT: {
                return this.projectsDAO.getMandatory(projectKey);
            }
            case FLOW_ZONE: {
                return (TaggableObjectsService.TaggableObject)this.zonesDAO.getMandatory(projectKey, objectId);
            }
            case DATASET: {
                return (TaggableObjectsService.TaggableObject)this.datasetsDAO.getMandatory(projectKey, objectId);
            }
            case SAVED_MODEL: {
                return (TaggableObjectsService.TaggableObject)this.savedModelsDAO.getMandatory(projectKey, objectId);
            }
            case MODEL_EVALUATION_STORE: {
                return (TaggableObjectsService.TaggableObject)this.modelEvaluationStoresDAO.getMandatory(projectKey, objectId);
            }
            case LABELING_TASK: {
                return (TaggableObjectsService.TaggableObject)this.labelingTasksDAO.getMandatory(projectKey, objectId);
            }
            case MANAGED_FOLDER: {
                return (TaggableObjectsService.TaggableObject)this.managedFolderDAO.getMandatory(projectKey, objectId);
            }
            case STREAMING_ENDPOINT: {
                return (TaggableObjectsService.TaggableObject)this.streamingEndpointsDAO.getMandatory(projectKey, objectId);
            }
            case WEB_APP: {
                return (TaggableObjectsService.TaggableObject)this.webAppsDAO.getMandatory(projectKey, objectId);
            }
            case CODE_STUDIO: {
                return (TaggableObjectsService.TaggableObject)this.codeStudioObjectsDAO.getMandatory(projectKey, objectId);
            }
            case REPORT: {
                return (TaggableObjectsService.TaggableObject)this.reportsDAO.getMandatory(projectKey, objectId);
            }
            case JUPYTER_NOTEBOOK: {
                return this.jupyterService.getMandatory(projectKey, objectId, false);
            }
            case SCENARIO: {
                return (TaggableObjectsService.TaggableObject)this.scenariosDAO.getMandatory(projectKey, objectId);
            }
            case DASHBOARD: {
                return (TaggableObjectsService.TaggableObject)this.dashboardsDAO.getMandatory(projectKey, objectId);
            }
            case INSIGHT: {
                return (TaggableObjectsService.TaggableObject)this.insightsDAO.getMandatory(projectKey, objectId);
            }
            case RECIPE: {
                return (TaggableObjectsService.TaggableObject)this.recipesDAO.getMandatory(projectKey, objectId);
            }
            case SQL_NOTEBOOK: {
                return this.sqlNotebooksDAO.getMandatory(projectKey, objectId);
            }
            case SEARCH_NOTEBOOK: {
                return this.searchNotebooksDAO.getMandatory(projectKey, objectId);
            }
            case ANALYSIS: {
                return (TaggableObjectsService.TaggableObject)this.analysisCoreDAO.getMandatory(projectKey, objectId);
            }
            case STATISTICS_WORKSHEET: {
                return this.worksheetsDAO.getMandatory(projectKey, objectId);
            }
            case MODEL_COMPARISON: {
                return (TaggableObjectsService.TaggableObject)this.modelEvaluationComparatorsDAO.getMandatory(projectKey, objectId);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return (TaggableObjectsService.TaggableObject)this.retrievableKnowledgeDAO.getMandatory(projectKey, objectId);
            }
            case AGENT_TOOL: {
                return (TaggableObjectsService.TaggableObject)this.agentToolsDAO.getMandatory(projectKey, objectId);
            }
            case PROMPT_STUDIO: {
                return (TaggableObjectsService.TaggableObject)this.promptStudioDAO.getMandatory(projectKey, objectId);
            }
            case ARTICLE: {
                return (TaggableObjectsService.TaggableObject)this.articlesDAO.getMandatory(projectKey, objectId);
            }
            case LAMBDA_SERVICE: {
                return (TaggableObjectsService.TaggableObject)this.lambdaServicesDAO.getMandatory(projectKey, objectId);
            }
            case WORKSPACE: {
                return this.workspacesDAO.getMandatory(objectId);
            }
            case DATA_COLLECTION: {
                return this.dataCollectionsDAO.getMandatory(objectId);
            }
        }
        throw new NotImplementedException("getMandatory not implemented for taggable type " + String.valueOf((Object)type));
    }

    public TaggableObjectsService.TaggableObject getMandatory(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        return this.getMandatory(ref.projectKey, ref.type, ref.id);
    }

    public TaggableObjectsService.TaggableObject getOrNullUnsafe(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        return this.getOrNullUnsafe(ref.projectKey, ref.type, ref.id);
    }

    public boolean exists(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        return this.exists(ref.projectKey, ref.type, ref.id);
    }

    public boolean exists(String projectKey, ITaggingService.TaggableType type, String id) throws IOException {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"TaggableType not specified");
        type.assertNotFakeType();
        switch (type) {
            case PROJECT: {
                return this.projectsDAO.projectExists(projectKey);
            }
            case DATASET: {
                return this.datasetsDAO.exists(projectKey, id);
            }
            case SAVED_MODEL: {
                return this.savedModelsDAO.exists(projectKey, id);
            }
            case MODEL_EVALUATION_STORE: {
                return this.modelEvaluationStoresDAO.exists(projectKey, id);
            }
            case LABELING_TASK: {
                return this.labelingTasksDAO.exists(projectKey, id);
            }
            case MANAGED_FOLDER: {
                return this.managedFolderDAO.exists(projectKey, id);
            }
            case STREAMING_ENDPOINT: {
                return this.streamingEndpointsDAO.exists(projectKey, id);
            }
            case WEB_APP: {
                return this.webAppsDAO.exists(projectKey, id);
            }
            case CODE_STUDIO: {
                return this.codeStudioObjectsDAO.exists(projectKey, id);
            }
            case REPORT: {
                return this.reportsDAO.exists(projectKey, id);
            }
            case SCENARIO: {
                return this.scenariosDAO.exists(projectKey, id);
            }
            case DASHBOARD: {
                return this.dashboardsDAO.exists(projectKey, id);
            }
            case INSIGHT: {
                return this.insightsDAO.exists(projectKey, id);
            }
            case RECIPE: {
                return this.recipesDAO.exists(projectKey, id);
            }
            case SQL_NOTEBOOK: {
                return this.sqlNotebooksDAO.exists(projectKey, id);
            }
            case SEARCH_NOTEBOOK: {
                return this.searchNotebooksDAO.exists(projectKey, id);
            }
            case ARTICLE: {
                return this.articlesDAO.exists(projectKey, id);
            }
            case LAMBDA_SERVICE: {
                return this.lambdaServicesDAO.exists(projectKey, id);
            }
            case ANALYSIS: {
                return this.analysisCoreDAO.exists(projectKey, id);
            }
            case STATISTICS_WORKSHEET: {
                return this.worksheetsDAO.exists(projectKey, id);
            }
            case MODEL_COMPARISON: {
                return this.modelEvaluationComparatorsDAO.exists(projectKey, id);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return this.retrievableKnowledgeDAO.exists(projectKey, id);
            }
            case AGENT_TOOL: {
                return this.agentToolsDAO.exists(projectKey, id);
            }
            case PROMPT_STUDIO: {
                return this.promptStudioDAO.exists(projectKey, id);
            }
            case JUPYTER_NOTEBOOK: {
                return this.jupyterService.exists(projectKey, id);
            }
            case FLOW_ZONE: {
                return this.zonesDAO.exists(projectKey, id);
            }
            case WORKSPACE: {
                return this.workspacesDAO.exists(id);
            }
            case DATA_COLLECTION: {
                return this.dataCollectionsDAO.exists(id);
            }
        }
        throw new NotImplementedException("exists not implemented for taggable type " + String.valueOf((Object)type));
    }

    public SmartObjectRef.SmartObjectRefWithName enrichSmartObjectRef(SmartObjectRef ref, String contextProjectKey) throws IOException {
        TaggableObjectsService.TaggableObject object = this.getMandatoryUnsafe(ref.getProjectKey(contextProjectKey), ref.objectType, ref.objectId);
        SmartObjectRef.SmartObjectRefWithName smartObjectRefWithName = new SmartObjectRef.SmartObjectRefWithName(ref, object.getDisplayName());
        if (object.getTaggableType().equals((Object)ITaggingService.TaggableType.SAVED_MODEL)) {
            smartObjectRefWithName.setSavedModelMLCategory((SavedModel)object);
        }
        return smartObjectRefWithName;
    }
}

