/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsCRUDService;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.flow.ISavedModelsCRUDService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudiosCRUDService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeCRUDService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.SearchNotebooksService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggableObjectsSaveService {
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private ISavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private PromptStudiosCRUDService promptStudiosCRUDService;
    @Autowired
    private RetrievableKnowledgeCRUDService retrievableKnowledgeCRUDService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private StreamingEndpointService streamingEndpointService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private SearchNotebooksService searchNotebooksService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private ModelComparisonsCRUDService modelComparisonsCRUDService;
    @Autowired
    private AgentToolsCRUDService agentToolsCRUDService;

    public Boolean save(TaggableObjectsService.TaggableObject to) throws Exception {
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        Preconditions.checkArgument((to.getTaggableType() != null ? 1 : 0) != 0, (Object)"TaggableType not specified");
        assert (to.getTaggableType() != null);
        Boolean modified = this.taggingService.onObjectSaved(to.getProjectKey(), to.tags);
        ITaggingService.TaggableType type = to.getTaggableType();
        type.assertNotFakeType();
        switch (type) {
            case DATASET: {
                SerializedDataset dataset = (SerializedDataset)to;
                this.datasetSaveService.save(to.getProjectKey(), to.getId(), dataset, authCtx);
                return modified;
            }
            case RECIPE: {
                SerializedRecipe recipe = (SerializedRecipe)to;
                this.recipeSaveService.save(to.getProjectKey(), recipe, null);
                return modified;
            }
            case LABELING_TASK: {
                LabelingTask labelingTask = (LabelingTask)to;
                this.labelingTasksCRUDService.upsertLabelingTask(labelingTask, null);
                return modified;
            }
            case SAVED_MODEL: {
                SavedModel sm = (SavedModel)to;
                this.savedModelsCRUDService.save(sm, false, false);
                return modified;
            }
            case MODEL_EVALUATION_STORE: {
                ModelEvaluationStore mes = (ModelEvaluationStore)to;
                this.modelEvaluationStoresCRUDService.save(mes, false, false);
                return modified;
            }
            case AGENT_TOOL: {
                AgentTool tool = (AgentTool)to;
                this.agentToolsCRUDService.save(tool, false);
                return modified;
            }
            case PROMPT_STUDIO: {
                PromptStudio studio = (PromptStudio)to;
                this.promptStudiosCRUDService.save(studio, false);
                return modified;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                RetrievableKnowledge rk = (RetrievableKnowledge)to;
                this.retrievableKnowledgeCRUDService.save(rk, false);
                return modified;
            }
            case MANAGED_FOLDER: {
                ManagedFolder mf = (ManagedFolder)to;
                this.managedFoldersService.save(mf, false, false);
                return modified;
            }
            case STREAMING_ENDPOINT: {
                StreamingEndpoint se = (StreamingEndpoint)to;
                this.streamingEndpointService.save(se, false);
                return modified;
            }
            case WEB_APP: {
                WebApp webApp = (WebApp)to;
                this.webAppsService.save(webApp, false);
                return modified;
            }
            case CODE_STUDIO: {
                CodeStudioObject codeStudioObject = (CodeStudioObject)to;
                this.codeStudioObjectsService.save(codeStudioObject, false);
                return modified;
            }
            case REPORT: {
                Report report = (Report)to;
                this.reportsService.save(report, null, false);
                return modified;
            }
            case SCENARIO: {
                Scenario scenario = (Scenario)to;
                this.scenariosService.save(to.getProjectKey(), scenario);
                return modified;
            }
            case DASHBOARD: {
                Dashboard dashboard = (Dashboard)to;
                this.dashboardsService.save(dashboard, false);
                return modified;
            }
            case INSIGHT: {
                Insight insight = (Insight)to;
                this.insightsService.save(insight, false, null);
                return modified;
            }
            case SQL_NOTEBOOK: {
                SQLNotebook notebook = (SQLNotebook)to;
                this.sqlNotebooksService.save(notebook, false);
                return modified;
            }
            case SEARCH_NOTEBOOK: {
                SearchNotebook searchNotebook = (SearchNotebook)to;
                this.searchNotebooksService.save(searchNotebook, false);
                return modified;
            }
            case ANALYSIS: {
                AnalysisCoreParams acp = (AnalysisCoreParams)to;
                this.analysisCRUDService.saveCore(acp, false);
                return modified;
            }
            case ARTICLE: {
                Article article = (Article)to;
                this.wikisService.saveArticle(article, null);
                return modified;
            }
            case STATISTICS_WORKSHEET: {
                Worksheet worksheet = (Worksheet)to;
                this.customPolicyHooksRegistry.onPreObjectSave(authCtx, this.worksheetsService.getWorksheetOrNull(to.getProjectKey(), to.getId()), to);
                this.worksheetsService.saveWorksheet(authCtx, worksheet);
                return modified;
            }
            case MODEL_COMPARISON: {
                ModelComparison modelComparison = (ModelComparison)to;
                this.modelComparisonsCRUDService.save(authCtx, modelComparison, false, false);
                return modified;
            }
            case LAMBDA_SERVICE: {
                LambdaService config = (LambdaService)to;
                this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), (TaggableObjectsService.TaggableObject)this.lambdaServicesDAO.getOrNull(to.getProjectKey(), to.getId()), to);
                this.lambdaServicesDAO.save(config);
                this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.LAMBDA_SERVICE, config.projectKey, config.id, authCtx, TaggableObjectChangedEvent.ActionType.LAMBDA_SERVICE_EDIT));
                return modified;
            }
            case FLOW_ZONE: {
                Zone zone = (Zone)to;
                this.flowZonesService.edit(zone.getProjectKey(), zone, authCtx);
                this.flowGraphService.invalidateCache(zone.getProjectKey());
                return modified;
            }
            case PROJECT: {
                throw new IllegalArgumentException("Cannot save a project this way");
            }
            case DATA_COLLECTION: {
                throw new IllegalArgumentException("Cannot save a data collection this way");
            }
            case JUPYTER_NOTEBOOK: {
                throw new IllegalArgumentException("Cannot save a Jupyter Notebook this way");
            }
        }
        throw new NotImplementedException("generic save not implemented for taggable type " + String.valueOf((Object)to.getTaggableType()));
    }
}

