/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.apideployer.published.PublishedProjectsService;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ImagesDAO;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.dao.UsersActivityDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.license.TrialToken;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.backend.GroupChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.notifications.emails.WelcomeEmailBuilder;
import com.dataiku.dip.server.services.ATSurveyService;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.NPSSurveyService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserCodes;
import com.dataiku.dip.server.services.UserDataService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.mail.Multipart;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersService
implements DkuUsersService {
    private static final String baseLoginPatten = "[a-zA-Z0-9@.+_-]+";
    private static final Pattern loginPattern = Pattern.compile("^[a-zA-Z0-9@.+_-]+$");
    private static final Pattern mentionPattern = Pattern.compile("@[a-zA-Z0-9@.+_-]+");
    private static final Pattern validGroupPattern = Pattern.compile("^[a-zA-Z0-9@.+_-]{1,80}$");
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private ImagesDAO imagesDAO;
    @Autowired
    private UsersDAO dao;
    @Autowired
    private ProjectsService projectService;
    @Autowired
    private LicenseEnforcementService limitsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UserDataService userDataService;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private AutomationNodeInfrasService automationNodeInfrasService;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private UsersActivityDAO usersActivityDAO;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private SessionsDAO sessionDao;
    @Autowired
    private VariablesService variablesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.users");

    public static Pair<LicenseEnforcementService.TrialTokenStatus, String> computeTrialStatusAndResultingUserProfile(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User u) {
        LicenseEnforcementService.TrialTokenStatus trialStatus = LicenseEnforcementService.getTrialTokenStatus(u);
        String resultingUserProfile = UsersService.computeResultingUserProfile(gs, u, u.userProfile, trialStatus);
        return new Pair((Object)trialStatus, (Object)resultingUserProfile);
    }

    private static String computeResultingUserProfile(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User user, String existingUserProfile, LicenseEnforcementService.TrialTokenStatus trialStatus) {
        String resultingUserProfile = existingUserProfile;
        if (trialStatus.exists) {
            if (trialStatus.expired) {
                switch (gs.licensingSettings.trialExpirationBehavior) {
                    case SWITCH_TO_NORMAL_LICENSE: {
                        break;
                    }
                    case SWITCH_TO_OTHER_PROFILE: {
                        resultingUserProfile = gs.licensingSettings.trialExpirationTargetProfile;
                        break;
                    }
                    case SWITCH_TO_NONE: {
                        resultingUserProfile = "NONE";
                    }
                }
            } else if (trialStatus.valid && user.trialToken.content.userProfile != null) {
                resultingUserProfile = user.trialToken.content.userProfile;
            }
        }
        return resultingUserProfile;
    }

    public DkuUser getUserWithCaseSensitiveRule(String login) throws IOException {
        return this.areLoginsCaseSensitive() ? this.dao.getOrNull(login) : this.dao.getUserIgnoreCaseOrNull(login);
    }

    public DkuUser createForeignUser(UserSourceType sourceType, String login, String displayName, String email, Set<String> groups, String userProfile) throws CodedException, IOException, LimitsStatusComputer.LicenseLimitException {
        UsersDAO.User u = new UsersDAO.User(login, sourceType);
        u.displayName = displayName;
        u.email = email;
        u.userProfile = userProfile;
        u.groups = new ArrayList<String>(groups);
        this.dao.addForeignUser(u);
        this.pubSub.publishAfterTransaction(new UserChangedEvent(u.login, UserChangedEvent.ActionType.CREATED));
        this.limitsService.checkPermissionChangeIsValid();
        return u;
    }

    public List<? extends DkuGroup> listGroups() throws IOException {
        return this.dao.listGroups();
    }

    public List<? extends DkuUser> listUsers() throws IOException {
        return this.dao.listUsers();
    }

    public List<? extends DkuUser> listUsersUnsafe() throws IOException {
        return this.dao.listUsersUnsafe();
    }

    public UserDiff updateUser(DkuUser user) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        UsersDAO.User userToUpdate = this.getInternalUserOrNullUnsafe(user.getLogin());
        userToUpdate.displayName = user.getDisplayName();
        userToUpdate.sourceType = user.getUserSourceType();
        userToUpdate.groups = user.getGroups();
        userToUpdate.enabled = user.isEnabled();
        userToUpdate.email = user.getEmail();
        userToUpdate.userProfile = user.getUserProfile();
        UserSaveContext usc = UserSaveContext.buildExternalSourceUpdate();
        UserDiff userDiff = this.saveUser(userToUpdate, false, usc, null);
        this.limitsService.checkPermissionChangeIsValid();
        return userDiff;
    }

    public void disableDkuUser(String userLogin) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        DkuUser syncedUser = this.getUserWithCaseSensitiveRule(userLogin);
        syncedUser.setEnabled(false);
        this.updateUser(syncedUser);
        this.sessionDao.removeExistingSessionsForUser(userLogin);
    }

    public boolean userHasACommonGroupWithAuthCtx(AuthCtx authCtx, String userLogin) throws IOException {
        UsersDAO.User user = this.dao.getMandatoryUnsafe(userLogin);
        return this.userHasACommonGroupWithAuthCtx(authCtx, user);
    }

    public boolean userHasACommonGroupWithAuthCtx(AuthCtx authCtx, UsersDAO.User user) {
        for (String candidateGroup : user.groups) {
            if (!authCtx.getGroupsIfRelevant().contains(candidateGroup)) continue;
            return true;
        }
        return false;
    }

    public List<UIUser> listUsersEnabledOnly_RestrictionCheck_NoLeak(AuthCtx authCtx) throws IOException {
        return this.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx, null);
    }

    public List<UIUser> listUsersWithDisabled_RestrictionCheck_NoLeak(AuthCtx authCtx) throws IOException {
        return this.listUsers_RestrictionCheck_NoLeak(authCtx, null, true, false);
    }

    public List<UIUser> listUsersEnabledOnly_RestrictionCheck_NoLeak(AuthCtx authCtx, String groupFilter) throws IOException {
        return this.listUsers_RestrictionCheck_NoLeak(authCtx, groupFilter, false, false);
    }

    public List<UIUser> listExpiredTrialUsers(AuthCtx authCtx) throws IOException, UnauthorizedException {
        ArrayList<UIUser> ret = new ArrayList<UIUser>();
        if (!authCtx.isAdmin()) {
            throw new UnauthorizedException("Only instance administrators are allowed to list expired trial users", "denied");
        }
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        for (UsersDAO.User u : this.dao.listUsers()) {
            UIUser uiu = new UIUser(u);
            uiu.computeTrialStatus(gs, u);
            if (!uiu.trialStatus.expired) continue;
            ret.add(uiu);
        }
        return ret;
    }

    public List<UIUser> listUsers_RestrictionCheck_NoLeak(AuthCtx authCtx, String groupFilter, boolean includeDisabled, boolean includeProfileAndTrialComputation) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        ArrayList<UIUser> ret = new ArrayList<UIUser>();
        for (UsersDAO.User u : this.dao.listUsers()) {
            boolean addIt;
            boolean bl = addIt = includeDisabled || u.enabled;
            if (gs.security.restrictUsersAndGroupsVisibility) {
                if (authCtx == null) {
                    throw new IOException("Cannot verify users and groups visibility. Using this in a free edition ?");
                }
                if (!authCtx.isAdmin()) {
                    if (u.groups == null) {
                        addIt = false;
                    } else {
                        boolean matchesAGroup = false;
                        for (String candidateGroup : u.groups) {
                            if (!authCtx.getGroupsIfRelevant().contains(candidateGroup)) continue;
                            matchesAGroup = true;
                            break;
                        }
                        if (!matchesAGroup) {
                            addIt = false;
                        }
                    }
                }
            }
            if (!(groupFilter == null || u.groups != null && u.groups.contains(groupFilter))) {
                addIt = false;
            }
            if (!addIt) continue;
            UIUser uiu = new UIUser(u);
            if (includeProfileAndTrialComputation) {
                uiu.computeTrialStatus(gs, u);
            }
            ret.add(uiu);
        }
        return ret;
    }

    public boolean hasAdminUsers(AuthCtx authCtx) throws IOException {
        for (UIUser user : this.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx)) {
            if (!this.isAdmin(user.login)) continue;
            return true;
        }
        return false;
    }

    public GroupsSecurity listGroupNamesWithSecurity(AuthCtx authCtx, boolean localOnly) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        return new GroupsSecurity(this.listGroupNames(authCtx, localOnly), !gs.security.restrictUsersAndGroupsVisibility);
    }

    public List<String> listGroupNames(AuthCtx authCtx, boolean localOnly) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        ArrayList<String> ret = new ArrayList<String>();
        for (UsersDAO.Group g : this.dao.listGroupsUnsafe()) {
            boolean addIt = true;
            if (gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin() && !authCtx.getGroupsIfRelevant().contains(g.name)) {
                addIt = false;
            }
            if (localOnly && g.sourceType != UserSourceType.LOCAL) {
                addIt = false;
            }
            if (!addIt) continue;
            ret.add(g.name);
        }
        return ret;
    }

    public List<UsersDAO.Group> listGroupsFull() throws IOException {
        return this.dao.listGroups();
    }

    private void checkCanEditEmailAndDisplayName(AuthCtx authCtx, UserDTOBase existingUser, UserDTOBase newUser) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (!(authCtx.isAdmin() || Objects.equals(existingUser.email, newUser.email) && Objects.equals(existingUser.displayName, newUser.displayName) || gs.security.enableEmailAndDisplayNameModification)) {
            throw new DKUSecurityException("You are not allowed to edit your email or display name.");
        }
    }

    public UserDiff editUserFromUI_PasswordCheck_AllowedFieldsOnly(UIUser inputUser, AuthCtx authCtx) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException, DKUSecurityException {
        if (!(StringUtils.isBlank((String)inputUser.oldPassword) && StringUtils.isBlank((String)inputUser.password) || !StringUtils.isBlank((String)inputUser.oldPassword) && this.checkPassword(inputUser.login, inputUser.oldPassword))) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_WRONG_PASSWORD, "Your old password is wrong");
        }
        UIUser realUser = this.getUser_NoLeak(inputUser.login);
        realUser = (UIUser)JSON.deepCopy((Object)realUser);
        this.checkCanEditEmailAndDisplayName(authCtx, realUser, inputUser);
        realUser.email = inputUser.email;
        realUser.displayName = inputUser.displayName;
        realUser.oldPassword = inputUser.oldPassword;
        realUser.password = inputUser.password;
        if (inputUser.userProperties != null) {
            realUser.userProperties = inputUser.userProperties;
        }
        if (inputUser.secrets != null) {
            realUser.secrets = inputUser.secrets;
        }
        return this.editUserFromUI_NoCheck(realUser, authCtx);
    }

    public UserDiff editUserFromAPI_AllowedFieldsOnly(APIUser inputUser, AuthCtx authCtx) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException, DKUSecurityException {
        APIUser cleanUser = this.getUserForAPI_NoCheck_WithSensitive(authCtx, inputUser.login);
        cleanUser = (APIUser)JSON.deepCopy((Object)cleanUser);
        this.checkCanEditEmailAndDisplayName(authCtx, cleanUser, inputUser);
        cleanUser.email = inputUser.email;
        if (inputUser.userProperties != null) {
            cleanUser.userProperties = inputUser.userProperties;
        }
        if (inputUser.secrets != null) {
            cleanUser.secrets = inputUser.secrets;
        }
        if (inputUser.credentials != null) {
            cleanUser.credentials = inputUser.credentials;
        }
        return this.editUserFromAPI_NoCheck(cleanUser, authCtx);
    }

    public boolean checkPassword(String login, String password) throws IOException, CodedException {
        return this.areLoginsCaseSensitive() ? this.dao.checkLogin(login, password) : this.dao.checkLoginIgnoreCase(login, password);
    }

    public boolean areLoginsCaseSensitive() {
        return ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.caseSensitiveLogins;
    }

    public UIUser getUserOrNull_NoLeak(String login) throws IOException {
        UsersDAO.User user = this.dao.getOrNull(login);
        return user != null ? this.makeUIUser_NoSensitive(user) : null;
    }

    public UIUser getUser_NoLeak(String login) throws IOException {
        return this.makeUIUser_NoSensitive(this.dao.getMandatory(login));
    }

    public UIUser getUserForUI_WithSensitive(String login) throws IOException {
        UsersDAO.User user = this.dao.getMandatory(login);
        UIUser uiUser = this.makeUIUser_NoSensitive(user);
        uiUser.adminProperties = user.adminProperties;
        uiUser.userProperties = user.userProperties;
        uiUser.secrets = user.secrets;
        return uiUser;
    }

    public UIUser getUserForUI_RestrictionCheck_UserSensitive(AuthCtx authCtx, String login, boolean includeProfileAndTrialComputation) throws IOException, DKUSecurityException {
        UsersDAO.User user = this.dao.getOrNull(login);
        boolean allowed = true;
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (user == null && gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin()) {
            throw new UnauthorizedException("You may not view this profile", "profile-forbidden");
        }
        if (user == null) {
            throw new NotFoundException("User does not exist");
        }
        if (gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin()) {
            if (user.groups == null) {
                allowed = false;
            } else {
                boolean matchesAGroup = false;
                for (String candidateGroup : user.groups) {
                    if (!authCtx.getGroupsIfRelevant().contains(candidateGroup)) continue;
                    matchesAGroup = true;
                    break;
                }
                if (!matchesAGroup) {
                    allowed = false;
                }
            }
        }
        if (!allowed) {
            throw new UnauthorizedException("You may not view this profile", "profile-forbidden");
        }
        UIUser uiUser = this.makeUIUser_NoSensitive(user);
        if (authCtx.getAssociatedDSSUserMand().equals(user.login)) {
            uiUser.userProperties = user.userProperties;
            uiUser.secrets = user.secrets;
        }
        if (includeProfileAndTrialComputation) {
            uiUser.computeTrialStatus(gs, user);
            if (!authCtx.isAdmin()) {
                uiUser.trialStatus = null;
            }
        }
        return uiUser;
    }

    public APIUser getUserForAPI_NoCheck_WithSensitive(AuthCtx authCtx, String login) throws IOException {
        return this.getUserForAPI_NoCheck_WithSensitive(authCtx, login, false);
    }

    public APIUser getUserForAPI_NoCheck_WithSensitive(AuthCtx authCtx, String login, boolean includeProfileAndTrialComputation) throws IOException {
        UsersDAO.User user = this.dao.getMandatory(login);
        APIUser uiUser = this.makeAPIUser_NoSensitive(user);
        if (includeProfileAndTrialComputation) {
            GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
            uiUser.computeTrialStatus(gs, user);
            if (!authCtx.isAdmin()) {
                uiUser.trialStatus = null;
            }
        }
        uiUser.adminProperties = user.adminProperties;
        uiUser.userProperties = user.userProperties;
        uiUser.secrets = user.secrets;
        uiUser.credentials = user.credentials;
        return uiUser;
    }

    public APIUser getUserForAPI_NoCheck_WithUserSensitive(String login) throws IOException {
        UsersDAO.User user = this.dao.getMandatory(login);
        APIUser uiUser = this.makeAPIUser_NoSensitive(user);
        uiUser.userProfile = this.getResultingUserProfileForTrials(user);
        uiUser.userProperties = user.userProperties;
        uiUser.secrets = user.secrets;
        uiUser.credentials = user.credentials;
        return uiUser;
    }

    private UIUser makeUIUser_NoSensitive(UsersDAO.User u) throws IOException {
        assert (u != null);
        UIUser ud = new UIUser(u);
        ud.objectImgHash = this.imagesDAO.getOriginalImageHash(null, "USER", u.login);
        ud.userProfile = this.limitsService.getUserProfileByNameOrFallback((String)u.userProfile).profile;
        return ud;
    }

    private APIUser makeAPIUser_NoSensitive(UsersDAO.User u) throws IOException {
        assert (u != null);
        APIUser ud = new APIUser(u, new APIUserPreferences(this.userSettingsService.getForUser(u.login)));
        ud.objectImgHash = this.imagesDAO.getOriginalImageHash(null, "USER", u.login);
        return ud;
    }

    private String getResultingUserProfileForTrials(UsersDAO.User user) {
        try {
            GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
            Pair<LicenseEnforcementService.TrialTokenStatus, String> trialStatusAndResultingProfile = UsersService.computeTrialStatusAndResultingUserProfile(gs, user);
            return (String)trialStatusAndResultingProfile.second;
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to retrieve trial status", (Throwable)e);
            return user.userProfile;
        }
    }

    public boolean isAdmin(String login) throws IOException {
        UsersDAO.User u = this.dao.getMandatoryUnsafe(login);
        for (String groupName : u.groups) {
            UsersDAO.Group g = this.dao.getGroupUnsafe(groupName);
            if (g == null || !g.isAdmin()) continue;
            return true;
        }
        return false;
    }

    public boolean isDisabled(String login) throws IOException {
        UsersDAO.User u = this.dao.getMandatoryUnsafe(login);
        return !u.enabled;
    }

    private void enableDisableUserAdmin(String login, boolean enable) throws IOException {
        UsersDAO.User u = this.dao.getMandatory(login);
        u.enabled = enable;
        this.dao.saveUser(u);
    }

    public void enableDisableUsersAdmin(List<String> logins, AuthCtx u, boolean enable) throws IOException {
        if (!enable) {
            this.makeCurrentLoginLast(logins, u.getAssociatedDSSUser());
        }
        for (String login : logins) {
            this.enableDisableUserAdmin(login, enable);
        }
    }

    public void deleteUserAdmin(String login) throws Exception {
        for (SerializedProject sp : this.projectService.listAll()) {
            boolean changed = false;
            ListIterator<SerializedProject.PermissionItem> it = sp.permissions.listIterator();
            while (it.hasNext()) {
                SerializedProject.PermissionItem pi = it.next();
                if (pi == null || !login.equals(pi.user)) continue;
                it.remove();
                changed = true;
            }
            if (!changed) continue;
            logger.info((Object)("Changed permissions of project " + sp.projectKey));
            this.projectService.setPermissions(sp, true);
        }
        this.dao.deleteUser(login);
        this.userSettingsService.deleteUser(login);
        this.userDataService.deleteUser(login);
        this.pubSub.publishAfterTransaction(new UserChangedEvent(login, UserChangedEvent.ActionType.DELETED));
    }

    public boolean isValidLogin(String login) {
        return !StringUtils.isBlank((String)login) && loginPattern.matcher(login).find();
    }

    public void sendWelcomeEmail(DkuUser user) {
        try {
            GeneralSettingsDAO.GeneralSettings generalSettings = this.gsDAO.getUnsafeAutoTXN();
            GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings = generalSettings.welcomeEmailSettings;
            if (welcomeEmailSettings == null || !welcomeEmailSettings.enabled) {
                return;
            }
            String profile = user.getUserProfile();
            if (profile == null || "NONE".equals(profile) || user.isWelcomeEmailSent()) {
                return;
            }
            String userLogin = user.getLogin();
            String userEmail = user.getEmail();
            WelcomeEmailBuilder welcomeEmailBuilder = new WelcomeEmailBuilder(this.variablesService);
            UserSettingsService.EmailNotificationsSettings params = welcomeEmailBuilder.createWelcomeEmailParams(generalSettings);
            String recipient = welcomeEmailBuilder.getRecipient(userLogin, userEmail);
            String emailBody = welcomeEmailBuilder.createWelcomeEmailBody(welcomeEmailSettings);
            Multipart content = welcomeEmailBuilder.makeEmailContent(params, emailBody);
            EmailNotificationsSender sender = new EmailNotificationsSender();
            Future<InfoMessage.InfoMessages> emailSendingFuture = sender.sendToUser(recipient, params, content);
            emailSendingFuture.get();
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                UsersDAO.User dkuUser = this.dao.getOrNull(user.getLogin());
                dkuUser.setWelcomeEmailSent();
                this.dao.saveUser(dkuUser);
                t.commit("Set welcome email sent");
            }
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Couldn't send email to '%s' because '%s'", StringUtils.isBlank((String)user.getEmail()) ? user.getLogin() : user.getEmail(), e.getMessage()), (Throwable)e);
        }
    }

    public void testWelcomeEmail(String email, GeneralSettingsDAO.GeneralSettings generalSettings, List<IntegrationChannel> integrationChannels) throws Exception {
        try {
            GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings = generalSettings.welcomeEmailSettings;
            if (welcomeEmailSettings == null || !welcomeEmailSettings.enabled) {
                logger.error((Object)"Welcome email settings not enabled");
                throw new IllegalArgumentException("Welcome email settings not enabled");
            }
            EmailNotificationsSender sender = new EmailNotificationsSender();
            WelcomeEmailBuilder welcomeEmailBuilder = new WelcomeEmailBuilder(this.variablesService);
            UserSettingsService.EmailNotificationsSettings params = welcomeEmailBuilder.createWelcomeEmailParams(generalSettings);
            String emailBody = welcomeEmailBuilder.createWelcomeEmailBody(welcomeEmailSettings);
            Multipart content = welcomeEmailBuilder.makeEmailContent(params, emailBody);
            Future<InfoMessage.InfoMessages> emailSendingFuture = sender.sendToUser(email, params, generalSettings, integrationChannels, content);
            emailSendingFuture.get();
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Couldn't send email to '%s' because '%s'", email, e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public void sendWelcomeEmailWhenProfileChange(DkuUser oldUser) {
        UsersDAO.User newUser;
        if (oldUser == null) {
            return;
        }
        try (Transaction rt = this.transactionService.retrieveOrBeginRead();){
            newUser = this.dao.getOrNull(oldUser.getLogin());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (newUser == null) {
            return;
        }
        if (!Objects.equals(newUser.getUserProfile(), oldUser.getUserProfile()) && "NONE".equals(oldUser.getUserProfile())) {
            this.sendWelcomeEmail(newUser);
        }
    }

    private void check(boolean condition, String msg) throws CodedException {
        if (!condition) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_CRUD_INVALID_SETTINGS, msg);
        }
    }

    public InfoMessage.InfoMessages addUserAdmin_NT(UIUser inputUser, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        TransactionContext.assertNoAttachedTransaction();
        this.check(StringUtils.isNotBlank((String)inputUser.displayName), "Display name cannot be empty");
        this.check(StringUtils.isNotBlank((String)inputUser.login), "Login cannot be empty");
        this.check(inputUser.login.length() >= 1, "Login name is too short (min. 1 character)");
        this.check(this.isValidLogin(inputUser.login), "Login is invalid or contains special characters");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            boolean userWillUseALicense;
            UsersDAO.User usr;
            this.permissionsService.checkAdmin(authCtx);
            switch (inputUser.sourceType) {
                case LOCAL: {
                    usr = this.dao.addUser(inputUser.login, inputUser.password);
                    usr.displayName = inputUser.displayName;
                    usr.groups = inputUser.groups;
                    usr.email = inputUser.email;
                    usr.userProfile = inputUser.userProfile;
                    this.updateUserTrialTokenIfDataikerCloudAdmin(usr, inputUser.trialToken, authCtx);
                    break;
                }
                case PAM: 
                case LDAP: 
                case AZURE_AD: 
                case CUSTOM: {
                    usr = new UsersDAO.User(inputUser.login, inputUser.sourceType);
                    usr.displayName = inputUser.displayName;
                    usr.email = inputUser.email;
                    usr.groups = inputUser.groups;
                    usr.userProfile = inputUser.userProfile;
                    this.updateUserTrialTokenIfDataikerCloudAdmin(usr, inputUser.trialToken, authCtx);
                    this.dao.addForeignUser(usr);
                    break;
                }
                case LOCAL_NO_AUTH: {
                    usr = this.dao.addUser(inputUser.login, null);
                    usr.displayName = inputUser.displayName;
                    usr.groups = inputUser.groups;
                    usr.email = inputUser.email;
                    usr.userProfile = inputUser.userProfile;
                    usr.sourceType = UserSourceType.LOCAL_NO_AUTH;
                    this.updateUserTrialTokenIfDataikerCloudAdmin(usr, inputUser.trialToken, authCtx);
                    break;
                }
                default: {
                    throw new DSSInternalErrorException("Invalid  auth source type: " + String.valueOf(inputUser.sourceType));
                }
            }
            if (inputUser.adminProperties != null) {
                usr.adminProperties = inputUser.adminProperties;
            }
            if (inputUser.userProperties != null) {
                usr.userProperties = inputUser.userProperties;
            }
            UserSaveContext usc = inputUser.sourceType == UserSourceType.LOCAL && StringUtils.isNotBlank((String)inputUser.password) ? UserSaveContext.buildDefaultWithPassword(inputUser.password) : UserSaveContext.buildDefaultWithoutPassword();
            this.saveUser(usr, true, usc, authCtx);
            boolean bl = userWillUseALicense = usr.trialToken == null && !"NONE".equals(usr.userProfile);
            if (userWillUseALicense) {
                this.limitsService.checkUsersOverQuota("create a user");
            }
            t.commit("Created user " + usr.login);
            this.sendWelcomeEmail(usr);
            InfoMessage.InfoMessages infoMessages = ret;
            return infoMessages;
        }
    }

    private void makeCurrentLoginLast(List<String> logins, String currentLogin) {
        if (logins.contains(currentLogin)) {
            logins.removeAll(Collections.singletonList(currentLogin));
            logins.add(currentLogin);
        }
    }

    private void removeUsersFromGroups(List<String> logins, List<String> groupNames, AuthCtx authCtx) throws IOException, CodedException {
        for (String groupName : groupNames) {
            for (String login : logins) {
                this.removeUserFromGroup(login, groupName, authCtx);
            }
        }
    }

    private UserDiff removeUserFromGroup(String login, String group, AuthCtx authCtx) throws IOException, CodedException {
        UsersDAO.User usr = this.dao.getMandatory(login);
        if (!usr.groups.contains(group)) {
            return new UserDiff();
        }
        usr.groups.remove(group);
        return this.saveUser(usr, false, UserSaveContext.buildDefaultWithoutPassword(), authCtx);
    }

    private void addUsersToGroups(List<String> users, List<String> groupNames, AuthCtx authCtx) throws IOException, CodedException {
        for (String groupName : groupNames) {
            UsersDAO.Group group = this.getGroupMandatory(groupName);
            for (String user : users) {
                this.addUserToGroup(user, group.name, authCtx);
            }
        }
    }

    private void addUserToGroup(String login, String group, AuthCtx authCtx) throws IOException, CodedException {
        UsersDAO.User usr = this.dao.getMandatory(login);
        if (usr.groups.contains(group)) {
            return;
        }
        usr.groups.add(group);
        this.saveUser(usr, false, UserSaveContext.buildDefaultWithoutPassword(), authCtx);
    }

    public UserDiff editUserFromUI_NoCheck(UIUser inputUser, AuthCtx authCtx) throws IOException, CodedException {
        boolean setSecurePassword;
        this.check(StringUtils.isNotBlank((String)inputUser.displayName), "Display name cannot be empty");
        UsersDAO.User usr = this.dao.getMandatory(inputUser.login);
        this.updateUserFromDTOBase(usr, inputUser);
        if (inputUser.adminProperties != null) {
            usr.adminProperties = inputUser.adminProperties;
        }
        if (inputUser.userProperties != null) {
            usr.userProperties = inputUser.userProperties;
        }
        this.updateSecretsIfNeeded(usr, inputUser.secrets);
        boolean bl = setSecurePassword = !StringUtils.isBlank((String)inputUser.password) && inputUser.sourceType == UserSourceType.LOCAL;
        if (setSecurePassword) {
            usr.setSecurePassword(inputUser.password);
        }
        UserSaveContext usc = setSecurePassword ? UserSaveContext.buildDefaultWithPassword(inputUser.password) : UserSaveContext.buildDefaultWithoutPassword();
        return this.saveUser(usr, false, usc, authCtx);
    }

    public UserDiff editUserFromAPI_NoCheck(APIUser inputUser, AuthCtx authCtx) throws IOException, CodedException {
        boolean setSecurePassword;
        this.check(StringUtils.isNotBlank((String)inputUser.displayName), "Display name cannot be empty");
        UsersDAO.User usr = this.dao.getMandatory(inputUser.login);
        this.updateUserSettings(inputUser.login, inputUser.preferences);
        this.updateUserFromDTOBase(usr, inputUser);
        if (inputUser.adminProperties != null) {
            usr.adminProperties = inputUser.adminProperties;
        }
        if (inputUser.userProperties != null) {
            usr.userProperties = inputUser.userProperties;
        }
        this.updateSecretsIfNeeded(usr, inputUser.secrets);
        if (inputUser.credentials != null) {
            for (Map.Entry<String, ICredentialsService.StoredCredential> e : inputUser.credentials.entrySet()) {
                if (e.getValue().password == null) continue;
                e.getValue().password = this.symetricCryptoService.encryptIfNotEncryptedOrEmpty(e.getValue().password);
            }
            usr.credentials = inputUser.credentials;
        }
        boolean bl = setSecurePassword = !StringUtils.isBlank((String)inputUser.password) && inputUser.sourceType == UserSourceType.LOCAL;
        if (setSecurePassword) {
            usr.setSecurePassword(inputUser.password);
        }
        UserSaveContext usc = setSecurePassword ? UserSaveContext.buildDefaultWithPassword(inputUser.password) : UserSaveContext.buildDefaultWithoutPassword();
        this.updateUserTrialTokenIfDataikerCloudAdmin(usr, inputUser.trialToken, authCtx);
        return this.saveUser(usr, false, usc, authCtx);
    }

    private void updateUserSettings(String login, APIUserPreferences inputUserPreferences) throws IOException {
        UserSettingsService.UserSettings userSettings = this.userSettingsService.getForUser(login);
        userSettings.uiLanguage = inputUserPreferences.uiLanguage;
        userSettings.mentionEmails.enabled = inputUserPreferences.mentionEmails;
        userSettings.discussionEmails.enabled = inputUserPreferences.discussionEmails;
        userSettings.accessRequestEmails.enabled = inputUserPreferences.accessRequestEmails;
        userSettings.grantedAccessEmails.enabled = inputUserPreferences.grantedAccessEmails;
        userSettings.grantedPluginRequestEmails.enabled = inputUserPreferences.grantedPluginRequestEmails;
        userSettings.pluginRequestEmails.enabled = inputUserPreferences.pluginRequestEmails;
        userSettings.instanceAccessRequestsEmails.enabled = inputUserPreferences.instanceAccessRequestsEmails;
        userSettings.profileUpgradeRequestsEmails.enabled = inputUserPreferences.profileUpgradeRequestsEmails;
        userSettings.codeEnvCreationRequestEmails.enabled = inputUserPreferences.codeEnvCreationRequestEmails;
        userSettings.grantedCodeEnvCreationRequestEmails.enabled = inputUserPreferences.grantedCodeEnvCreationRequestEmails;
        userSettings.digests.enabled = inputUserPreferences.dailyDigestsEmails;
        userSettings.offlineQueue.enabled = inputUserPreferences.offlineActivityEmails;
        userSettings.disableFlowZoomTracking = !inputUserPreferences.rememberPositionFlow;
        userSettings.frontendNotifications.loginLogout = inputUserPreferences.loginLogoutNotifications;
        userSettings.frontendNotifications.watchedObjectsEditions = inputUserPreferences.watchedObjectsEditionsNotifications;
        userSettings.frontendNotifications.objectOnProjectCreatedDeleted = inputUserPreferences.objectOnCurrentProjectCreatedDeletedNotifications;
        userSettings.frontendNotifications.anyObjectOnProjectEdited = inputUserPreferences.anyObjectOnCurrentProjectEditedNotifications;
        userSettings.frontendNotifications.watchStar = inputUserPreferences.watchStarOnCurrentProjectNotifications;
        userSettings.frontendNotifications.otherUsersTasks = inputUserPreferences.otherUsersJobsTasksNotifications;
        userSettings.frontendNotifications.requestAccess = inputUserPreferences.requestAccessNotifications;
        userSettings.frontendNotifications.scenarioRun = inputUserPreferences.scenarioRunNotifications;
        this.userSettingsService.setUserSettings(login, userSettings);
    }

    private void updateUserFromDTOBase(UsersDAO.User user, UserDTOBase dto) throws IOException {
        user.sourceType = dto.sourceType;
        user.email = dto.email;
        user.displayName = dto.displayName;
        user.enabled = dto.enabled;
        ArrayList<String> newGrps = new ArrayList<String>();
        if (user.groups != null) {
            for (String groupName : user.groups) {
                UsersDAO.Group group;
                if (newGrps.contains(groupName) || (group = this.dao.getGroupUnsafe(groupName)) == null || group.sourceType == UserSourceType.LOCAL) continue;
                newGrps.add(groupName);
            }
        }
        if (dto.groups != null) {
            for (String groupName : dto.groups) {
                if (newGrps.contains(groupName)) continue;
                newGrps.add(groupName);
            }
        }
        user.groups = newGrps;
        user.userProfile = dto.userProfile;
    }

    private void updateSecretsIfNeeded(UsersDAO.User user, List<AbstractSQLConnection.CustomDatabaseProperty> secrets) {
        if (secrets == null) {
            return;
        }
        for (AbstractSQLConnection.CustomDatabaseProperty secret : secrets) {
            if (!secret.secret) continue;
            secret.value = this.symetricCryptoService.encryptIfNotEncryptedOrEmpty(secret.value);
        }
        user.secrets = secrets;
    }

    private void updateUserTrialTokenIfDataikerCloudAdmin(UsersDAO.User user, @Nullable TrialToken trialToken, AuthCtx authCtx) {
        if (!this.permissionsService.isCloudDataikerAdmin(authCtx)) {
            return;
        }
        if (trialToken != null) {
            TrialToken.Content tokenContent = trialToken.content;
            if (!Objects.equals(tokenContent.login, user.login) || !Objects.equals(tokenContent.userProfile, user.userProfile)) {
                throw new IllegalArgumentException("Trial token content does not match user information");
            }
        }
        user.trialToken = trialToken;
    }

    public UsersDAO.Group getGroup(String groupName) throws IOException {
        return this.dao.getGroup(groupName);
    }

    public UsersDAO.Group getGroupMandatory(String groupName) throws IOException {
        return this.dao.getGroupMandatory(groupName);
    }

    public void addGroup(UsersDAO.Group group) throws IOException, CodedException {
        this.check(StringUtils.isNotBlank((String)group.name), "Empty group name");
        this.check(!group.name.contains(" "), "Group name must not contain spaces");
        this.check(group.name.length() <= 80, "Group name is too long (80 characters maximum)");
        this.check(validGroupPattern.matcher(group.name).find(), "Group name is invalid or contains special characters");
        this.check(group.sourceType != UserSourceType.SAAS && group.sourceType != UserSourceType.PAM, "Invalid group source type");
        this.pubSub.publishAfterTransaction((DSSEvent)new GroupChangedEvent(group.name, GroupChangedEvent.ActionType.CREATED));
        this.dao.addGroup(group);
    }

    public InfoMessage.InfoMessages deleteGroup(AuthCtx user, String groupName) throws Exception {
        Object pi;
        ListIterator<Object> it;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        this.dao.getGroupMandatoryUnsafe(groupName);
        for (UsersDAO.User u : this.dao.listUsers()) {
            if (!u.groups.remove(groupName)) continue;
            UserSaveContext usc = UserSaveContext.buildDefaultWithoutPassword();
            this.saveUser(u, false, usc, user);
        }
        for (SerializedProject sp : this.projectService.listAll()) {
            boolean changed = false;
            it = sp.permissions.listIterator();
            while (it.hasNext()) {
                pi = it.next();
                if (pi == null || !groupName.equals(((SerializedProject.PermissionItem)pi).group)) continue;
                it.remove();
                changed = true;
            }
            if (!changed) continue;
            logger.info((Object)("Changed permissions of project " + sp.projectKey));
            this.projectService.setPermissions(sp);
        }
        for (ProjectFolder pf : this.projectFoldersService.listAll_Uncheck()) {
            boolean changed = false;
            it = pf.permissions.listIterator();
            while (it.hasNext()) {
                pi = (ProjectFolder.PermissionItem)it.next();
                if (pi == null || !((ProjectFolder.PermissionItem)pi).group.equals(groupName)) continue;
                it.remove();
                changed = true;
            }
            if (!changed) continue;
            logger.info((Object)("Changed permissions of project folder " + pf.name + " (" + pf.id + ")"));
            this.projectFoldersService.saveProjectFolder_Uncheck(pf);
        }
        this.apiNodeInfrasService.removeGroupFromPermissions_Uncheck(groupName);
        this.automationNodeInfrasService.removeGroupFromPermissions_Uncheck(groupName);
        this.publishedAPIServicesService.removeGroupFromPermissions_Uncheck(groupName);
        this.publishedProjectsService.removeGroupFromPermissions_Uncheck(groupName);
        this.dao.deleteGroup(groupName);
        this.pubSub.publishAfterTransaction((DSSEvent)new GroupChangedEvent(groupName, GroupChangedEvent.ActionType.DELETED));
        if (this.impersonationResolverService.isEnabled()) {
            ret.withInfo((InfoMessage.MessageCode)UserCodes.INFO_USER_GLOBAL_HDFS_ACL_RESYNC_REQUIRED, "After group deletion, you might need to resync all HDFS ACLs");
        }
        return ret;
    }

    public GroupDiff updateGroup(UsersDAO.Group group) throws IOException {
        this.dao.getGroupMandatory(group.name);
        GroupDiff groupDiff = this.dao.saveGroup(group);
        this.pubSub.publishAfterTransaction((DSSEvent)new GroupChangedEvent(group.name, GroupChangedEvent.ActionType.EDITED));
        return groupDiff;
    }

    public UserDiff saveUser(UsersDAO.User u, boolean isCreationActionType, UserSaveContext usc, AuthCtx authCtx) throws IOException, CodedException {
        return this.saveUser(u, isCreationActionType ? UserChangedEvent.ActionType.CREATED : UserChangedEvent.ActionType.EDITED, usc, authCtx);
    }

    public UserDiff saveUser(UsersDAO.User u, UserChangedEvent.ActionType actionType, UserSaveContext usc, AuthCtx authCtx) throws IOException, CodedException {
        if (usc.type != UserSaveContextType.INSTANCE_INIT && usc.type != UserSaveContextType.EXTERNAL_SOURCE_UPDATE) {
            this.customPolicyHooksRegistry.onPreUserSave(authCtx, this.dao.getOrNull(u.login), u, usc);
        }
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus lls = this.limitsService.getFeaturesStatus();
        if (!lls.userSecurityAllowed) {
            logger.infoV("Security not enabled, making the user an administrator: %s", new Object[]{u.login});
            boolean alreadyAnAdmin = false;
            for (String existingGroup : u.groups) {
                UsersDAO.Group g = this.dao.getGroupUnsafe(existingGroup);
                if (g == null || !g.isAdmin()) continue;
                alreadyAnAdmin = true;
                break;
            }
            if (!alreadyAnAdmin) {
                logger.info((Object)"Not currently in an admin group, creating a new one");
                String newGroupName = String.format("%s-admin-%s", u.login, SecretKeyGenerator.generate((int)6));
                UsersDAO.Group g = new UsersDAO.Group();
                g.sourceType = UserSourceType.LOCAL;
                g.name = newGroupName;
                g.withAdmin(true);
                this.dao.saveGroup(g);
                u.groups.add(newGroupName);
            }
        }
        UserDiff userDiff = this.dao.saveUser(u);
        this.pubSub.publishAfterTransaction(new UserChangedEvent(u.login, actionType));
        return userDiff;
    }

    public UsersDAO.GroupPermissions getUserEffectiveGroupPermissions(UsersDAO.User user) throws IOException {
        UsersDAO.GroupPermissions computed = UsersDAO.GroupPermissions.baseGroupPermissionsForUnion();
        for (UsersDAO.Group group : this.dao.listGroupsUnsafe()) {
            if (!user.groups.contains(group.name)) continue;
            computed = computed.union(group);
        }
        return computed;
    }

    public InfoMessage.InfoMessages prepareDeleteUsers_NT(List<String> logins, AuthCtx user) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            this.makeCurrentLoginLast(logins, user.getAssociatedDSSUser());
            for (String login : logins) {
                this.deleteUserAdmin(login);
            }
            InfoMessage.InfoMessages infoMessages = this.checkCurrentState(user);
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareDisableUsers_NT(List<String> logins, AuthCtx user) throws IOException, DKUSecurityException {
        try (RWTransaction ignored = this.transactionService.beginNonCommittableWriteAsDSS();){
            this.enableDisableUsersAdmin(logins, user, false);
            InfoMessage.InfoMessages infoMessages = this.checkCurrentState(user);
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareDeleteGroup_NT(String groupName, AuthCtx user) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            this.deleteGroup(user, groupName);
            InfoMessage.InfoMessages infoMessages = this.checkCurrentState(user);
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareEditUser_NT(UIUser uiUser, AuthCtx user) throws LimitsStatusComputer.LicenseLimitException, IOException, DKUSecurityException, CodedException {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            this.editUserFromUI_NoCheck(uiUser, user);
            InfoMessage.InfoMessages infoMessages = this.checkCurrentState(user);
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareAssignUsersToGroups_NT(List<String> logins, List<String> groupsToAdd, List<String> groupsToRemove, AuthCtx user) throws IOException, DKUSecurityException, CodedException {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            this.removeUsersFromGroups(logins, groupsToRemove, user);
            this.addUsersToGroups(logins, groupsToAdd, user);
            InfoMessage.InfoMessages infoMessages = this.checkCurrentState(user);
            return infoMessages;
        }
    }

    public void deleteUsersAdmin(List<String> logins, AuthCtx user) throws Exception {
        this.makeCurrentLoginLast(logins, user.getAssociatedDSSUser());
        for (String login : logins) {
            this.deleteUserAdmin(login);
        }
    }

    public void assignUsersToGroups(List<String> logins, List<String> groupsToAdd, List<String> groupsToRemove, AuthCtx user) throws IOException, CodedException {
        this.makeCurrentLoginLast(logins, user.getAssociatedDSSUser());
        this.removeUsersFromGroups(logins, groupsToRemove, user);
        this.addUsersToGroups(logins, groupsToAdd, user);
    }

    public void assignUsersToProfile(List<String> logins, String newProfile, AuthCtx authCtx) throws IOException, CodedException {
        this.makeCurrentLoginLast(logins, authCtx.getAssociatedDSSUser());
        for (String login : logins) {
            UsersDAO.User user = this.dao.getMandatory(login);
            user.userProfile = newProfile;
            this.saveUser(user, false, UserSaveContext.buildDefaultWithoutPassword(), authCtx);
        }
    }

    public InfoMessage.InfoMessages prepareUpdateGroup_NT(UsersDAO.Group group, AuthCtx user) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            this.updateGroup(group);
            InfoMessage.InfoMessages infoMessages = this.checkCurrentState(user);
            return infoMessages;
        }
    }

    private InfoMessage.InfoMessages checkCurrentState(AuthCtx user) throws IOException, DKUSecurityException {
        String dssUser;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (!this.hasAdminUsers(user)) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_REMOVING_LAST_ADMIN, null).summarize();
        }
        if (this.getUserOrNull_NoLeak(dssUser = user.getAssociatedDSSUserMand()) == null) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_DELETING_OWN_ACCOUNT, null).summarize();
        } else if (!this.isAdmin(dssUser)) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_REVOKING_OWN_ADMIN, null).summarize();
        } else if (this.isDisabled(dssUser)) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_DISABLING_OWN_ADMIN, null).summarize();
        }
        return messages;
    }

    public Set<String> getMentions(String s) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        if (StringUtils.isBlank((String)s)) {
            return ret;
        }
        Matcher matcher = mentionPattern.matcher(s);
        while (matcher.find()) {
            String matched = matcher.group();
            String login = matched.substring(1);
            if (ret.contains(login) || this.dao.getOrNull(login) == null) continue;
            ret.add(login);
        }
        return ret;
    }

    public Set<String> getMentionsNoExistenceCheck(String s) {
        HashSet<String> ret = new HashSet<String>();
        Matcher matcher = mentionPattern.matcher(s);
        while (matcher.find()) {
            String matched = matcher.group();
            String login = matched.substring(1);
            ret.add(login);
        }
        return ret;
    }

    public List<PublicUser> getPublicUsers(Collection<String> logins) throws IOException {
        return this.dao.getPublicUsers(logins);
    }

    public UsersDAO.User getInternalUserOrNullUnsafe(String login) throws IOException {
        return this.dao.getOrNullUnsafe(login);
    }

    public UsersDAO.User getInternalMandatoryUnsafe(String login) throws IOException {
        return this.dao.getMandatoryUnsafe(login);
    }

    public List<UsersDAO.User> listUsersInternalUnsafeEnabledOnly() throws IOException {
        ArrayList<UsersDAO.User> res = new ArrayList<UsersDAO.User>();
        for (UsersDAO.User user : this.dao.listUsersUnsafe()) {
            if (!user.enabled) continue;
            res.add(user);
        }
        return res;
    }

    public List<UsersDAO.User> listUsersInternalUnsafeEnabledOnlyForGroup(String groupName) throws IOException {
        ArrayList<UsersDAO.User> res = new ArrayList<UsersDAO.User>();
        for (UsersDAO.User user : this.dao.listUsersUnsafe()) {
            if (!user.enabled || !user.groups.contains(groupName)) continue;
            res.add(user);
        }
        return res;
    }

    public List<UsersDAO.User> getUsersInternalUnsafeEnabledOnlyByLogins(Collection<String> logins) throws IOException {
        HashSet<String> loginsSet = new HashSet<String>(logins);
        ArrayList<UsersDAO.User> res = new ArrayList<UsersDAO.User>();
        for (UsersDAO.User user : this.dao.listUsersUnsafe()) {
            if (!user.enabled || !loginsSet.contains(user.login)) continue;
            res.add(user);
        }
        return res;
    }

    public List<UsersDAO.User> listUsersInternalEnabledOnly() throws IOException {
        return this.dao.listUsers().stream().filter(user -> user.enabled).collect(Collectors.toList());
    }

    public PublicUser getPublicUser(String login) throws IOException {
        return this.dao.getPublicUser(login);
    }

    public UserLastActivity getUserLastActivity(String login) throws IOException {
        return this.usersActivityDAO.getUserLastActivity(login);
    }

    public Map<String, UserLastActivity> getAllUsersActivity(boolean recreateOnError) throws IOException {
        return this.usersActivityDAO.getAllUsersActivity(recreateOnError);
    }

    public static Multimap<String, String> buildLoginsByEmailMap(List<? extends DkuUser> users) {
        HashMultimap loginsByEmails = HashMultimap.create();
        users.forEach(arg_0 -> UsersService.lambda$buildLoginsByEmailMap$1((Multimap)loginsByEmails, arg_0));
        return loginsByEmails;
    }

    private static /* synthetic */ void lambda$buildLoginsByEmailMap$1(Multimap loginsByEmails, DkuUser user) {
        String login = user.getLogin();
        String email = user.getEmail();
        if (StringUtils.isNotBlank((String)email)) {
            loginsByEmails.put((Object)email.toLowerCase(Locale.ROOT), (Object)login);
        }
        if (StringUtils.indexOf((String)login, (char)'@') > 0) {
            loginsByEmails.put((Object)login.toLowerCase(Locale.ROOT), (Object)login);
        }
    }

    public static class UserSaveContext {
        public final UserSaveContextType type;
        public final String password;

        private UserSaveContext(UserSaveContextType type, String password) {
            this.type = type;
            this.password = password;
        }

        public static UserSaveContext buildInstanceInit() {
            return new UserSaveContext(UserSaveContextType.INSTANCE_INIT, null);
        }

        public static UserSaveContext buildExternalSourceUpdate() {
            return new UserSaveContext(UserSaveContextType.EXTERNAL_SOURCE_UPDATE, null);
        }

        public static UserSaveContext buildDefaultWithoutPassword() {
            return new UserSaveContext(UserSaveContextType.DEFAULT_WITHOUT_PASSWORD, null);
        }

        public static UserSaveContext buildDefaultWithPassword(String pwd) {
            return new UserSaveContext(UserSaveContextType.DEFAULT_WITH_PASSWORD, pwd);
        }
    }

    @UIModel
    public static class UIUser
    extends UserDTOBase {
        public String oldPassword;
        public String password;
        public JsonObject adminProperties;
        public JsonObject userProperties;
        public List<AbstractSQLConnection.CustomDatabaseProperty> secrets;
        public UserLastActivity activity;
        @Nullable
        public TrialToken trialToken;

        public UIUser() {
        }

        public UIUser(UsersDAO.User u) {
            this.login = u.login;
            this.sourceType = u.sourceType;
            this.displayName = u.displayName;
            this.groups = u.groups;
            this.email = u.email;
            this.npsSurveySettings = u.npsSurveySettings;
            this.atSurveySettings = u.atSurveySettings;
            this.enabled = u.enabled;
            this.creationDate = u.creationDate;
            this.userProfile = u.userProfile;
        }

        public String toString() {
            return "UIUser{login='" + this.login + "', sourceType=" + String.valueOf(this.sourceType) + ", displayName='" + this.displayName + "', groups=" + String.valueOf(this.groups) + ", email='" + this.email + "'}";
        }

        public String getLogin() {
            return this.login;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getUserProfile() {
            return this.userProfile;
        }

        public void setUserProfile(String userProfile) {
            this.userProfile = userProfile;
        }

        public UserSourceType getUserSourceType() {
            return this.sourceType;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public void addGroupMembership(String group) {
            this.groups.add(group);
        }

        public void removeGroupMembership(String group) {
            this.groups.remove(group);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    @UIModel
    public static class GroupsSecurity {
        public List<String> groups;
        public boolean mayShowAllUsersGroup;

        public GroupsSecurity(List<String> groups, boolean mayShowAllUsersGroup) {
            this.groups = groups;
            this.mayShowAllUsersGroup = mayShowAllUsersGroup;
        }
    }

    public static class UserDTOBase {
        public String login;
        public UserSourceType sourceType;
        public String displayName;
        public List<String> groups;
        public String email;
        public String userProfile;
        @UINullable
        public Long creationDate;
        public NPSSurveyService.NPSSurveySettings npsSurveySettings;
        public ATSurveyService.ATSurveySettings atSurveySettings;
        public Boolean enabled;
        public long objectImgHash;
        public LicenseEnforcementService.TrialTokenStatus trialStatus;
        public String resultingUserProfile;

        public void computeTrialStatus(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User u) {
            this.trialStatus = LicenseEnforcementService.getTrialTokenStatus(u);
            this.resultingUserProfile = UsersService.computeResultingUserProfile(gs, u, this.userProfile, this.trialStatus);
        }
    }

    public static class APIUser
    extends UserDTOBase {
        public JsonObject adminProperties;
        public JsonObject userProperties;
        public List<AbstractSQLConnection.CustomDatabaseProperty> secrets;
        public Map<String, ICredentialsService.StoredCredential> credentials;
        public String password;
        @Nullable
        public TrialToken trialToken;
        public int activeWebSocketSesssions;
        public APIUserPreferences preferences;

        private APIUser() {
        }

        public APIUser(UsersDAO.User u, APIUserPreferences userPreferences) {
            this.login = u.login;
            this.sourceType = u.sourceType;
            this.displayName = u.displayName;
            this.groups = u.groups;
            this.email = u.email;
            this.userProfile = u.userProfile;
            this.npsSurveySettings = u.npsSurveySettings;
            this.atSurveySettings = u.atSurveySettings;
            this.enabled = u.enabled;
            this.creationDate = u.creationDate;
            this.preferences = userPreferences;
        }

        public APIUser(UIUser ui) {
            this.login = ui.login;
            this.sourceType = ui.sourceType;
            this.displayName = ui.displayName;
            this.groups = ui.groups;
            this.email = ui.email;
            this.userProfile = ui.resultingUserProfile != null ? ui.resultingUserProfile : ui.userProfile;
            this.npsSurveySettings = ui.npsSurveySettings;
            this.atSurveySettings = ui.atSurveySettings;
            this.enabled = ui.enabled;
            this.creationDate = ui.creationDate;
            this.trialStatus = ui.trialStatus;
        }
    }

    public static class APIUserPreferences {
        public String uiLanguage;
        public boolean mentionEmails;
        public boolean discussionEmails;
        public boolean accessRequestEmails;
        public boolean grantedAccessEmails;
        public boolean grantedPluginRequestEmails;
        public boolean pluginRequestEmails;
        public boolean instanceAccessRequestsEmails;
        public boolean profileUpgradeRequestsEmails;
        public boolean codeEnvCreationRequestEmails;
        public boolean grantedCodeEnvCreationRequestEmails;
        public boolean dailyDigestsEmails;
        public boolean offlineActivityEmails;
        public boolean rememberPositionFlow;
        public boolean loginLogoutNotifications;
        public boolean watchedObjectsEditionsNotifications;
        public boolean objectOnCurrentProjectCreatedDeletedNotifications;
        public boolean anyObjectOnCurrentProjectEditedNotifications;
        public boolean watchStarOnCurrentProjectNotifications;
        public boolean otherUsersJobsTasksNotifications;
        public boolean requestAccessNotifications;
        public boolean scenarioRunNotifications;

        public APIUserPreferences() {
        }

        public APIUserPreferences(UserSettingsService.UserSettings settings) {
            if (settings == null) {
                settings = new UserSettingsService.UserSettings();
            }
            this.uiLanguage = settings.uiLanguage == null ? UserSettingsService.UserSettings.DEFAULT_LANG : settings.uiLanguage;
            this.mentionEmails = settings.mentionEmails.enabled;
            this.discussionEmails = settings.discussionEmails.enabled;
            this.accessRequestEmails = settings.accessRequestEmails.enabled;
            this.grantedAccessEmails = settings.grantedAccessEmails.enabled;
            this.grantedPluginRequestEmails = settings.grantedPluginRequestEmails.enabled;
            this.pluginRequestEmails = settings.pluginRequestEmails.enabled;
            this.instanceAccessRequestsEmails = settings.instanceAccessRequestsEmails.enabled;
            this.profileUpgradeRequestsEmails = settings.profileUpgradeRequestsEmails.enabled;
            this.codeEnvCreationRequestEmails = settings.codeEnvCreationRequestEmails.enabled;
            this.grantedCodeEnvCreationRequestEmails = settings.grantedCodeEnvCreationRequestEmails.enabled;
            this.loginLogoutNotifications = settings.frontendNotifications.loginLogout;
            this.watchedObjectsEditionsNotifications = settings.frontendNotifications.watchedObjectsEditions;
            this.objectOnCurrentProjectCreatedDeletedNotifications = settings.frontendNotifications.objectOnProjectCreatedDeleted;
            this.anyObjectOnCurrentProjectEditedNotifications = settings.frontendNotifications.anyObjectOnProjectEdited;
            this.watchStarOnCurrentProjectNotifications = settings.frontendNotifications.watchStar;
            this.otherUsersJobsTasksNotifications = settings.frontendNotifications.otherUsersTasks;
            this.requestAccessNotifications = settings.frontendNotifications.requestAccess;
            this.scenarioRunNotifications = settings.frontendNotifications.scenarioRun;
            this.dailyDigestsEmails = settings.digests.enabled;
            this.offlineActivityEmails = settings.offlineQueue.enabled;
            this.rememberPositionFlow = !settings.disableFlowZoomTracking;
        }
    }

    public static enum UserSaveContextType {
        INSTANCE_INIT,
        EXTERNAL_SOURCE_UPDATE,
        DEFAULT_WITHOUT_PASSWORD,
        DEFAULT_WITH_PASSWORD;

    }
}

