/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.analysis;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.text.Clusterer;
import com.dataiku.dip.shaker.text.NGramClusterer;
import com.dataiku.dip.shaker.text.SetBasedClusterer;
import com.dataiku.dip.utils.DKULogger;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CategoryClusterer {
    private static final boolean multithreaded = true;
    Clusterer clusterer;
    float radius;
    int timeOut;
    int ngramsBlockSize;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.shaker.analysis.clusterer");

    public CategoryClusterer(boolean setBased, float radius, int timeOut, int blockSize) {
        this.ngramsBlockSize = blockSize;
        this.radius = radius;
        this.timeOut = timeOut;
        this.clusterer = setBased ? new SetBasedClusterer(true) : new NGramClusterer(true, this.ngramsBlockSize);
    }

    public void clusterize(MemTable mt, String columnName) {
        logger.debug((Object)"Begin populating clusterer");
        MemColumn cd = mt.column(columnName);
        for (MemRow mr : mt.rows) {
            String val;
            if (mr.isDeleted() || (val = mr.get(cd)) == null || val.equals("")) continue;
            this.clusterer.populate(val);
        }
        this.clusterer.endPopulate();
        logger.debug((Object)"End populating clusterer");
    }

    public CategoryClusters getClusters() {
        logger.debug((Object)"Begin clustering");
        List<Set<String>> results = this.clusterer.getClusters(this.radius, this.timeOut);
        CategoryClusters res = new CategoryClusters();
        res.timedOut = this.clusterer.hasTimedOut();
        res.values = new String[results.size()][];
        int i = 0;
        for (Set<String> r : results) {
            res.values[i] = new String[r.size()];
            int j = 0;
            Iterator<String> iterator = r.iterator();
            while (iterator.hasNext()) {
                String e;
                res.values[i][j] = e = iterator.next();
                ++j;
            }
            ++i;
        }
        logger.debug((Object)"End clustering");
        return res;
    }

    public class CategoryClusters {
        public boolean timedOut;
        public String[][] values;
    }
}

