/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.custom.CustomJavaFormatParams;
import com.dataiku.dip.input.formats.LineFormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.mrimpl.DiagnosticsHandler;
import com.dataiku.dip.shaker.mrimpl.ShakerEnvironment;
import com.dataiku.dip.shaker.mrimpl.formats.AvroInputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.CSVInputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.CustomJavaFormatInputAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.HiveInputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.LineInputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.ParquetInputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.ContextType;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class UniversalFileInputFormat
extends FileInputFormat<Void, RowWithFactories> {
    public static final String INPUT_DATASET_CONFIG = "dku.shaker.input.config";
    public static final String INPUT_DATASET_FORMAT_CLASS = "dku.shaker.input.format.class";
    private static final DKULogger logger = DKULogger.getLogger(UniversalFileInputFormat.class);
    private WarningsContext warningsContext = new WarningsContext();
    private FileInputFormat<Void, RowWithFactories> inputFormat;
    private RowFactory rowFactory = new StreamRowFactory();
    private ColumnFactory columnFactory = new StreamColumnFactory();

    public static void setInputDatasetConfig(Configuration jobConf, DatasetConfig dsConf) {
        Preconditions.checkNotNull((Object)dsConf);
        jobConf.set(INPUT_DATASET_CONFIG, JSON.pretty((Object)dsConf));
    }

    public static DatasetConfig getInputDatasetConfig(Configuration jobConf) {
        ShakerEnvironment.setup();
        String val = jobConf.get(INPUT_DATASET_CONFIG);
        if (StringUtils.isBlank((String)val)) {
            throw new RuntimeException("Invalid blank param dku.shaker.input.config");
        }
        return (DatasetConfig)JSON.parse((String)val, DatasetConfig.class);
    }

    public static Class<? extends FileInputFormat<Void, RowWithFactories>> getFormatAdapter(FormatParams formatParams) {
        if (formatParams instanceof ParquetFormatConfig) {
            return ParquetInputFormatAdapter.class;
        }
        if (formatParams instanceof CSVFormatConfig) {
            return CSVInputFormatAdapter.class;
        }
        if (formatParams instanceof HiveFileFormatConfig) {
            return HiveInputFormatAdapter.class;
        }
        if (formatParams instanceof AvroFormatConfig) {
            return AvroInputFormatAdapter.class;
        }
        if (formatParams instanceof LineFormatExtractor.Config) {
            return LineInputFormatAdapter.class;
        }
        if (formatParams instanceof CustomJavaFormatParams) {
            return CustomJavaFormatInputAdapter.class;
        }
        return null;
    }

    public static void registerDependencies(AuthCtx authCtx, Dataset dataset, List<SimpleKeyValue> configKeys, List<File> resourceJars) throws IOException, DKUSecurityException {
        FormatParams formatParams = dataset.getFormatParams();
        logger.info((Object)("Check if format " + formatParams.getClass().getCanonicalName() + " has dependencies"));
        if (formatParams instanceof CustomJavaFormatParams) {
            CustomJavaFormatInputAdapter.registerDependencies(authCtx, dataset, configKeys, resourceJars);
            configKeys.add(new SimpleKeyValue(INPUT_DATASET_FORMAT_CLASS, CustomJavaFormatInputAdapter.class.getCanonicalName()));
        }
    }

    private void lazyInit(Configuration hadoopJobConf) throws IOException {
        if (this.inputFormat == null) {
            String formatAdapterClass = hadoopJobConf.get(INPUT_DATASET_FORMAT_CLASS);
            if (StringUtils.isNotBlank((String)formatAdapterClass)) {
                try {
                    Class<?> formatAdapterClazz = Class.forName(formatAdapterClass);
                    Method loadMethod = formatAdapterClazz.getMethod("loadDependencies", Configuration.class);
                    loadMethod.invoke(null, hadoopJobConf);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IOException("Unknown format class", e);
                }
            }
            logger.info((Object)"init: loading dku.shaker.input.config");
            DatasetConfig inputConf = UniversalFileInputFormat.getInputDatasetConfig(hadoopJobConf);
            logger.info((Object)("init: dataset = " + inputConf.dataset.projectKey + "." + inputConf.dataset.name));
            FormatParams formatParams = inputConf.dataset.getFormatParams();
            Class<? extends FileInputFormat<Void, RowWithFactories>> inputFormatClass = UniversalFileInputFormat.getFormatAdapter(formatParams);
            if (inputFormatClass != null) {
                logger.info((Object)("Using input format adapter : " + inputFormatClass.getName()));
                Object[] args = new Object[]{this.columnFactory, this.rowFactory, inputConf, this.warningsContext};
                try {
                    this.inputFormat = inputFormatClass.cast(ConstructorUtils.invokeConstructor(inputFormatClass, (Object[])args));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to instantiate input format adapter for : " + inputConf.dataset.formatType, e);
                }
            } else {
                throw new RuntimeException("Unsupported input format : " + inputConf.dataset.formatType);
            }
        }
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        this.lazyInit(job.getConfiguration());
        return this.inputFormat.getSplits(job);
    }

    public RecordReader<Void, RowWithFactories> createRecordReader(InputSplit inputSplit, final TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        try {
            this.lazyInit(taskAttemptContext.getConfiguration());
            final RecordReader realRecordReader = this.inputFormat.createRecordReader(inputSplit, taskAttemptContext);
            return new RecordReader<Void, RowWithFactories>(){

                public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext2) throws IOException, InterruptedException {
                    try {
                        realRecordReader.initialize(inputSplit, taskAttemptContext2);
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext2);
                        throw e;
                    }
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    try {
                        return realRecordReader.nextKeyValue();
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext);
                        throw e;
                    }
                }

                public Void getCurrentKey() throws IOException, InterruptedException {
                    try {
                        return (Void)realRecordReader.getCurrentKey();
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext);
                        throw e;
                    }
                }

                public RowWithFactories getCurrentValue() throws IOException, InterruptedException {
                    try {
                        return (RowWithFactories)realRecordReader.getCurrentValue();
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext);
                        throw e;
                    }
                }

                public float getProgress() throws IOException, InterruptedException {
                    try {
                        return realRecordReader.getProgress();
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext);
                        throw e;
                    }
                }

                public void close() throws IOException {
                    try {
                        realRecordReader.close();
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext);
                        throw e;
                    }
                    finally {
                        DiagnosticsHandler.saveWarningsContext(ContextType.INPUT, taskAttemptContext, UniversalFileInputFormat.this.warningsContext);
                    }
                }
            };
        }
        catch (Exception e) {
            DiagnosticsHandler.saveFatalError(ContextType.INPUT, e, taskAttemptContext);
            throw e;
        }
    }
}

