/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.PluginEntryPoint;
import com.dataiku.dip.contribs.PythonContrib;
import com.dataiku.dip.contribs.PythonContribService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.meanings.AbstractBasicMeaningsService;
import com.dataiku.dip.meanings.ScopedBasicMeaningsPseudoService;
import com.dataiku.dip.meanings.SharedBasicMeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStepDeserializer;
import com.dataiku.dip.shaker.processors.EnrichWithBuildContextProcessor;
import com.dataiku.dip.shaker.processors.EnrichWithRecordContextProcessor;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.bigdata.GenerateBigData;
import com.dataiku.dip.shaker.processors.cleansing.FillEmptyWithComputedValue;
import com.dataiku.dip.shaker.processors.cleansing.FillEmptyWithValue;
import com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnBadType;
import com.dataiku.dip.shaker.processors.cleansing.MergeLongTailValues;
import com.dataiku.dip.shaker.processors.cleansing.RemoveRowsOnEmpty;
import com.dataiku.dip.shaker.processors.cleansing.SplitInvalidCells;
import com.dataiku.dip.shaker.processors.cleansing.UpDownFiller;
import com.dataiku.dip.shaker.processors.expr.CreateColumnWithGREL;
import com.dataiku.dip.shaker.processors.expr.ExtractNumbers;
import com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResult;
import com.dataiku.dip.shaker.processors.expr.GrokProcessor;
import com.dataiku.dip.shaker.processors.expr.MatchCounter;
import com.dataiku.dip.shaker.processors.expr.NGramExtract;
import com.dataiku.dip.shaker.processors.expr.SplitIntoChunks;
import com.dataiku.dip.shaker.processors.expr.TextSimplifierProcessor;
import com.dataiku.dip.shaker.processors.expr.Tokenizer;
import com.dataiku.dip.shaker.processors.filtering.ColumnsSelector;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnDate;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnExplicitConditions;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnNumericalRange;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnValue;
import com.dataiku.dip.shaker.processors.geo.ChangeCRSProcessor;
import com.dataiku.dip.shaker.processors.geo.GeoDistanceProcessor;
import com.dataiku.dip.shaker.processors.geo.GeoIPResolver;
import com.dataiku.dip.shaker.processors.geo.GeoPointBufferProcessor;
import com.dataiku.dip.shaker.processors.geo.GeoPointCreator;
import com.dataiku.dip.shaker.processors.geo.GeoPointExtractor;
import com.dataiku.dip.shaker.processors.geo.GeocoderProcessor;
import com.dataiku.dip.shaker.processors.geo.GeometryInfoExtractor;
import com.dataiku.dip.shaker.processors.geo.NearestNeighbourGeoJoiner;
import com.dataiku.dip.shaker.processors.join.MemoryEquiJoiner;
import com.dataiku.dip.shaker.processors.numbers.BinnerProcessor;
import com.dataiku.dip.shaker.processors.numbers.CurrencyConverterProcessor;
import com.dataiku.dip.shaker.processors.numbers.MeanProcessor;
import com.dataiku.dip.shaker.processors.numbers.MinMaxProcessor;
import com.dataiku.dip.shaker.processors.numbers.NumericalCombinator;
import com.dataiku.dip.shaker.processors.numbers.NumericalFormatConverter;
import com.dataiku.dip.shaker.processors.numbers.RoundProcessor;
import com.dataiku.dip.shaker.processors.publicdata.EnrichFrenchDepartement;
import com.dataiku.dip.shaker.processors.publicdata.EnrichFrenchPostcode;
import com.dataiku.dip.shaker.processors.reshaping.ArrayFold;
import com.dataiku.dip.shaker.processors.reshaping.ArrayUnfold;
import com.dataiku.dip.shaker.processors.reshaping.ConcatArraysProcessor;
import com.dataiku.dip.shaker.processors.reshaping.MultiColumnByPrefixFold;
import com.dataiku.dip.shaker.processors.reshaping.MultiColumnFold;
import com.dataiku.dip.shaker.processors.reshaping.NestProcessor;
import com.dataiku.dip.shaker.processors.reshaping.ObjectFoldProcessor;
import com.dataiku.dip.shaker.processors.reshaping.Pivot;
import com.dataiku.dip.shaker.processors.reshaping.RepeatableUnfold;
import com.dataiku.dip.shaker.processors.reshaping.SplitFold;
import com.dataiku.dip.shaker.processors.reshaping.SplitUnfold;
import com.dataiku.dip.shaker.processors.reshaping.Transpose;
import com.dataiku.dip.shaker.processors.reshaping.Unfold;
import com.dataiku.dip.shaker.processors.reshaping.ZipArraysProcessor;
import com.dataiku.dip.shaker.processors.time.DateComponentsExtractor;
import com.dataiku.dip.shaker.processors.time.DateDifference;
import com.dataiku.dip.shaker.processors.time.DateFormatter;
import com.dataiku.dip.shaker.processors.time.DateIncrement;
import com.dataiku.dip.shaker.processors.time.DateParser;
import com.dataiku.dip.shaker.processors.time.DateTruncate;
import com.dataiku.dip.shaker.processors.time.UNIXTimestampParser;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysComputer;
import com.dataiku.dip.shaker.processors.transform.ArrayExtractProcessor;
import com.dataiku.dip.shaker.processors.transform.ArraySortProcessor;
import com.dataiku.dip.shaker.processors.transform.ColumnCopier;
import com.dataiku.dip.shaker.processors.transform.ColumnPseudonymization;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.ColumnReorder;
import com.dataiku.dip.shaker.processors.transform.ColumnSplitter;
import com.dataiku.dip.shaker.processors.transform.ColumnsConcat;
import com.dataiku.dip.shaker.processors.transform.ComputeNTile;
import com.dataiku.dip.shaker.processors.transform.CurrencySplitter;
import com.dataiku.dip.shaker.processors.transform.FillColumn;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.shaker.processors.transform.LongTailGrouper;
import com.dataiku.dip.shaker.processors.transform.MeaningTranslate;
import com.dataiku.dip.shaker.processors.transform.RegexpExtractor;
import com.dataiku.dip.shaker.processors.transform.StringTransformer;
import com.dataiku.dip.shaker.processors.transform.SwitchCase;
import com.dataiku.dip.shaker.processors.transform.UseRowAsHeader;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfRule;
import com.dataiku.dip.shaker.processors.typespecific.BooleanNot;
import com.dataiku.dip.shaker.processors.typespecific.EmailSplitter;
import com.dataiku.dip.shaker.processors.typespecific.JSONFlattener;
import com.dataiku.dip.shaker.processors.typespecific.JSONPathExtractor;
import com.dataiku.dip.shaker.processors.typespecific.MeasureNormalize;
import com.dataiku.dip.shaker.processors.typespecific.QueryStringSplitter;
import com.dataiku.dip.shaker.processors.typespecific.TypeSetter;
import com.dataiku.dip.shaker.processors.typespecific.URLSplitter;
import com.dataiku.dip.shaker.processors.typespecific.UserAgentClassifier;
import com.dataiku.dip.shaker.processors.typespecific.VisitorIdGenerator;
import com.dataiku.dip.shaker.processors.udf.PythonContribProcessor;
import com.dataiku.dip.shaker.processors.udf.PythonUDF;
import com.dataiku.dip.shaker.server.ProcessorLibraryDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class BaseProcessorsFactory {
    public static final String NULL_VALUE = "";
    static Map<String, ProcessorMeta<?, ?>> processorLibrary = new ConcurrentHashMap();
    private static final Logger logger = Logger.getLogger((String)"dku.shaker.processors");

    public static void loadClass() {
    }

    public static synchronized void addBuiltinProcessor(ProcessorMeta<?, ?> processorMeta) {
        ScriptStepDeserializer.registerStepParams(processorMeta.getName(), processorMeta.stepParamClass());
        processorLibrary.put(processorMeta.getName(), processorMeta);
    }

    public static void addProcessor(PluginEntryPoint entryPoint, ProcessorMeta<?, ?> processorMeta) {
        BaseProcessorsFactory.addBuiltinProcessor(processorMeta);
        processorMeta.plugin = entryPoint.getPluginId();
    }

    public static ProcessorLibraryDesc getStandardLibrary(Params p, String language) {
        ArrayList processors = Lists.newArrayList(processorLibrary.values());
        Function<String, Void> moveToEnd = name -> {
            ProcessorMeta found = null;
            Iterator iter = processors.iterator();
            while (iter.hasNext()) {
                ProcessorMeta pm = (ProcessorMeta)iter.next();
                if (!name.equals(pm.getName())) continue;
                found = pm;
                iter.remove();
                break;
            }
            if (found != null) {
                processors.add(found);
            }
            return null;
        };
        moveToEnd.apply(MemoryEquiJoiner.META.getName());
        moveToEnd.apply(MemoryEquiJoiner.META_FUZZY.getName());
        moveToEnd.apply(NearestNeighbourGeoJoiner.META.getName());
        return new ProcessorLibraryDesc(p, language, processors);
    }

    public static JsonObject getReport(ProcessorScriptStep step) {
        JsonObject ret = new JsonObject();
        ret.addProperty("processorType", step.type);
        if (processorLibrary.containsKey(step.type)) {
            try {
                ProcessorMeta<?, ?> processorMeta = processorLibrary.get(step.type);
                Object oret = processorMeta.selfReportCast(step.params);
                if (oret != null) {
                    ret = (JsonObject)JSON.parse((String)JSON.json((Object)oret), JsonObject.class);
                    ret.addProperty("processorType", step.type);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to get report for processor:" + e.getMessage()));
            }
        }
        return ret;
    }

    public static Processor build(ProcessorScriptStep step, PipelineContext context) throws Exception {
        return BaseProcessorsFactory.getMeta(step).validateAndBuild(step.params, context);
    }

    public static ProcessorMeta<?, ?> getMeta(ProcessorScriptStep step) throws Exception {
        return BaseProcessorsFactory.getMeta(step.type);
    }

    public static ProcessorMeta<?, ?> getMeta(String type) throws Exception {
        if (processorLibrary.containsKey(type)) {
            return processorLibrary.get(type);
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Unknown processor type: " + type + ". May have been provided by a deleted plugin.");
    }

    static {
        BaseProcessorsFactory.addBuiltinProcessor(FindReplace.META);
        BaseProcessorsFactory.addBuiltinProcessor(SwitchCase.META);
        BaseProcessorsFactory.addBuiltinProcessor(VisualIfRule.META);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnSplitter.META);
        BaseProcessorsFactory.addBuiltinProcessor(StringTransformer.META);
        BaseProcessorsFactory.addBuiltinProcessor(CreateColumnWithGREL.META);
        BaseProcessorsFactory.addBuiltinProcessor(GrokProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(RegexpExtractor.META);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnsConcat.META);
        BaseProcessorsFactory.addBuiltinProcessor(TextSimplifierProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(Tokenizer.META);
        BaseProcessorsFactory.addBuiltinProcessor(SplitIntoChunks.META);
        BaseProcessorsFactory.addBuiltinProcessor(NGramExtract.META);
        BaseProcessorsFactory.addBuiltinProcessor(ExtractNumbers.META);
        BaseProcessorsFactory.addBuiltinProcessor(BooleanNot.META);
        BaseProcessorsFactory.addBuiltinProcessor(MeasureNormalize.META);
        BaseProcessorsFactory.addBuiltinProcessor(ArrayExtractProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(ArraySortProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(MeaningTranslate.META);
        BaseProcessorsFactory.addBuiltinProcessor(CurrencySplitter.META);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnReorder.META);
        BaseProcessorsFactory.addBuiltinProcessor(ComputeNTile.META);
        BaseProcessorsFactory.addBuiltinProcessor(FillColumn.META);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnPseudonymization.META);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnValue.META_FILTER);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnValue.META_FLAG);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnsSelector.META);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnDate.META_FILTER);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnDate.META_FLAG);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnNumericalRange.META_FILTER);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnNumericalRange.META_FLAG);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnCustomFormulaResult.META_FILTER);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnCustomFormulaResult.META_FLAG);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnExplicitConditions.META_FILTER);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnBadType.META_FILTER);
        BaseProcessorsFactory.addBuiltinProcessor(FilterAndFlagOnBadType.META_FLAG);
        BaseProcessorsFactory.addBuiltinProcessor(RemoveRowsOnEmpty.META);
        BaseProcessorsFactory.addBuiltinProcessor(FillEmptyWithValue.META);
        BaseProcessorsFactory.addBuiltinProcessor(SplitInvalidCells.META);
        BaseProcessorsFactory.addBuiltinProcessor(UpDownFiller.META);
        BaseProcessorsFactory.addBuiltinProcessor(NumericalFormatConverter.META);
        BaseProcessorsFactory.addBuiltinProcessor(MergeLongTailValues.META);
        BaseProcessorsFactory.addBuiltinProcessor(FillEmptyWithComputedValue.META);
        BaseProcessorsFactory.addBuiltinProcessor(UserAgentClassifier.META);
        BaseProcessorsFactory.addBuiltinProcessor(QueryStringSplitter.META);
        BaseProcessorsFactory.addBuiltinProcessor(URLSplitter.META);
        BaseProcessorsFactory.addBuiltinProcessor(EmailSplitter.META);
        BaseProcessorsFactory.addBuiltinProcessor(VisitorIdGenerator.META);
        BaseProcessorsFactory.addBuiltinProcessor(JSONFlattener.META);
        BaseProcessorsFactory.addBuiltinProcessor(JSONPathExtractor.META);
        BaseProcessorsFactory.addBuiltinProcessor(DateParser.META);
        BaseProcessorsFactory.addBuiltinProcessor(UNIXTimestampParser.META);
        BaseProcessorsFactory.addBuiltinProcessor(DateComponentsExtractor.META);
        BaseProcessorsFactory.addBuiltinProcessor(DateFormatter.META);
        BaseProcessorsFactory.addBuiltinProcessor(DateDifference.META);
        BaseProcessorsFactory.addBuiltinProcessor(HolidaysComputer.META);
        BaseProcessorsFactory.addBuiltinProcessor(DateIncrement.META);
        BaseProcessorsFactory.addBuiltinProcessor(DateTruncate.META);
        BaseProcessorsFactory.addBuiltinProcessor(BinnerProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(NumericalCombinator.META);
        BaseProcessorsFactory.addBuiltinProcessor(RoundProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(MeanProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(MinMaxProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(CurrencyConverterProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(GeoIPResolver.META);
        BaseProcessorsFactory.addBuiltinProcessor(GeoPointExtractor.META);
        BaseProcessorsFactory.addBuiltinProcessor(GeoPointCreator.META);
        BaseProcessorsFactory.addBuiltinProcessor(NearestNeighbourGeoJoiner.META);
        BaseProcessorsFactory.addBuiltinProcessor(GeocoderProcessor.META);
        if (BuiltinsLoader.geoToolsAvailable()) {
            BaseProcessorsFactory.addBuiltinProcessor(ChangeCRSProcessor.META);
        } else {
            logger.warn((Object)"Java 7, not loading 'change coordinates' processor");
        }
        BaseProcessorsFactory.addBuiltinProcessor(GeometryInfoExtractor.META);
        BaseProcessorsFactory.addBuiltinProcessor(GeoDistanceProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(GeoPointBufferProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(EnrichFrenchDepartement.META);
        BaseProcessorsFactory.addBuiltinProcessor(EnrichFrenchPostcode.META);
        BaseProcessorsFactory.addBuiltinProcessor(Unfold.META);
        BaseProcessorsFactory.addBuiltinProcessor(ArrayUnfold.META);
        BaseProcessorsFactory.addBuiltinProcessor(SplitUnfold.META);
        BaseProcessorsFactory.addBuiltinProcessor(RepeatableUnfold.META);
        BaseProcessorsFactory.addBuiltinProcessor(SplitFold.META);
        BaseProcessorsFactory.addBuiltinProcessor(ArrayFold.META);
        BaseProcessorsFactory.addBuiltinProcessor(ObjectFoldProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(MultiColumnFold.META);
        BaseProcessorsFactory.addBuiltinProcessor(Pivot.META);
        BaseProcessorsFactory.addBuiltinProcessor(ZipArraysProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(ConcatArraysProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(MultiColumnByPrefixFold.META);
        BaseProcessorsFactory.addBuiltinProcessor(NestProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(MemoryEquiJoiner.META);
        BaseProcessorsFactory.addBuiltinProcessor(MemoryEquiJoiner.META_FUZZY);
        BaseProcessorsFactory.addBuiltinProcessor(UseRowAsHeader.META);
        BaseProcessorsFactory.addBuiltinProcessor(PythonUDF.META);
        BaseProcessorsFactory.addBuiltinProcessor(GenerateBigData.META);
        BaseProcessorsFactory.addBuiltinProcessor(Transpose.META);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnCopier.META);
        BaseProcessorsFactory.addBuiltinProcessor(MatchCounter.META);
        BaseProcessorsFactory.addBuiltinProcessor(EnrichWithRecordContextProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(EnrichWithBuildContextProcessor.META);
        BaseProcessorsFactory.addBuiltinProcessor(ColumnRenamer.META);
        BaseProcessorsFactory.addBuiltinProcessor(TypeSetter.META);
        BaseProcessorsFactory.addBuiltinProcessor(LongTailGrouper.META);
        if (ApplicationConfigurator.isConfigured()) {
            for (PythonContrib contrib : new PythonContribService().getContribs()) {
                BaseProcessorsFactory.addBuiltinProcessor(new PythonContribProcessor(contrib, null).getMeta());
            }
        }
    }

    public static class PipelineContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final AbstractBasicMeaningsService basicMeaningsService;

        protected PipelineContext(AbstractBasicMeaningsService basicMeaningsService) {
            this.basicMeaningsService = basicMeaningsService;
        }

        public PipelineContext(List<UserDefinedMeaning> userDefinedMeanings) {
            this(new ScopedBasicMeaningsPseudoService(userDefinedMeanings));
        }

        public static PipelineContext fakePipelineContext() {
            return new PipelineContext(Lists.newArrayList());
        }

        public static PipelineContext sharedPipelineContext() {
            return new PipelineContext((AbstractBasicMeaningsService)SpringUtils.getBean(SharedBasicMeaningsService.class));
        }
    }
}

