/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.shaker.processors.StaticColumnsCreatorProcessor;
import com.dataiku.dip.shaker.types.MeaningDetector;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StaticColumnsCreatorAdapter<T extends StaticColumnsCreatorProcessor>
extends SingleRowProcessor
implements Processor {
    protected final T processor;
    private List<Column> inputColumns = new ArrayList<Column>();
    private List<Column> outputColumns = new ArrayList<Column>();
    private static Logger logger = Logger.getLogger((String)"dip.shaker.scca");

    public StaticColumnsCreatorAdapter(T processor) {
        this.processor = processor;
    }

    public void init() {
        List<String> requiredInputs = this.processor.getRequiredInputs();
        List<SchemaColumn> producedOutputs = this.processor.getProducedOutputs();
        String lastInput = null;
        for (String requiredInput : requiredInputs) {
            this.inputColumns.add(this.getColumnFactory().column(requiredInput, Processor.ProcessorRole.INPUT_COLUMN));
            lastInput = requiredInput;
        }
        if (lastInput == null) {
            for (SchemaColumn producedOutput : producedOutputs) {
                this.outputColumns.add(this.getColumnFactory().column(producedOutput.getName()));
            }
        } else {
            for (int i = producedOutputs.size() - 1; i >= 0; --i) {
                SchemaColumn col = producedOutputs.get(i);
                Column cd = this.getColumnFactory().columnAfter(lastInput, col.getName(), Processor.ProcessorRole.OUTPUT_COLUMN);
                this.outputColumns.add(0, cd);
                if (!(cd instanceof MemColumn) || !StringUtils.isNotBlank((String)col.getMeaning())) continue;
                try {
                    String dataTypeName = "com.dataiku.dip.shaker.types." + col.getMeaning();
                    ((MemColumn)cd).forceType((MeaningDetector)Class.forName(dataTypeName).newInstance());
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)("Unable to instantiate non-user-defined meaning '" + col.getMeaning() + "'"));
                }
            }
        }
    }

    public void processRow(Row row) throws Exception {
        Object v;
        StaticColumnsCreatorProcessor.Input input = new StaticColumnsCreatorProcessor.Input();
        for (Column inCD : this.inputColumns) {
            v = row.get(inCD);
            if (v == null || ((String)v).isEmpty()) {
                input.values.add(null);
                continue;
            }
            input.values.add(v);
        }
        StaticColumnsCreatorProcessor.Output output = this.processor.produceRow(input);
        for (int i = 0; i < this.outputColumns.size(); ++i) {
            v = output.values.get(i);
            if (v == null) continue;
            row.put(this.outputColumns.get(i), v.toString());
        }
    }

    public void postProcess() {
    }
}

