/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.StaticColumnsCreatorAdapterWithResourceFiles;
import com.dataiku.dip.shaker.processors.StaticColumnsCreatorProcessor;
import com.dataiku.dip.shaker.processors.geo.GeoIPResolverParameter;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.geoip.fastgeo.FastGeoIP2;
import com.dataiku.geoip.fastgeo.GeoIPService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GeoIPResolver {
    public static final ProcessorMeta<StaticColumnsCreatorAdapterWithResourceFiles<StreamImpl>, GeoIPResolverParameter> META = new ProcessorMeta<StaticColumnsCreatorAdapterWithResourceFiles<StreamImpl>, GeoIPResolverParameter>(){

        @Override
        public String getName() {
            return "GeoIPResolver";
        }

        @Override
        public String getDocPage() {
            return "geoip";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC, ProcessorTag.WEB, ProcessorTag.ENRICH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.HELP", "Extract geographic information from an IP address, including:\n\n* **Country name**\n* **Country code** 2, 3 letters\n* **Region:** Generate three new columns:\n * **Region code.** Depending on country, this can be a state code, a region code, a department identifier, ...\n * **Region name.** Depending on country, this can be a state name, a region name, a department name, ...\n * **Region hierarchy.** When available, this is a comma-separated hierarchical list of region names, from most general to most specific\n* **City name**\n* **Postal code**\n* **Latitude and longitude**\n* **GeoPoint**\n* **Timezone identifier**\n* **Continent name**\n\n*Warning*: The precision of the GeoIP database varies widely upon on the visitor's ISP.");
        }

        @Override
        public Class<GeoIPResolverParameter> stepParamClass() {
            return GeoIPResolverParameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION", 1.actionVerb("Resolve") + " GeoIP"), true).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.IN_COL", "IP Column")).withMNESParam("outColPrefix", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.OUT_COL_PREFIX", "Prefix for generated output columns")).withBoolDefaultTrue("extract_country", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_COUNTRY", "Extract country"), null).withBool("extract_countrycode", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_COUNTRYCODE", "Extract country code"), null).withBoolDefaultTrue("extract_countrycode3", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_COUNTRYCODE3", "Extract country code (3 letters)"), null).withBoolDefaultTrue("extract_region", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_REGION", "Extract region"), null).withBoolDefaultTrue("extract_city", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_CITY", "Extract city"), null).withBool("extract_postalcode", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_POSTALCODE", "Extract postal code")).withBool("extract_latlng", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_LATLNG", "Extract lat/lng"), null).withBoolDefaultTrue("extract_geopoint", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_GEOPOINT", "Extract GeoPoint"), null).withBool("extract_timezone", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_TIMEZONE", "Extract timezone")).withBool("extract_continentcode", this.translate(language, "SHAKER.PROCESSOR.GeoIPResolver.DESCRIPTION.EXTRACT_CONTINENTCODE", "Extract continent code"));
        }

        @Override
        public StaticColumnsCreatorAdapterWithResourceFiles<StreamImpl> build(GeoIPResolverParameter params) {
            return new StaticColumnsCreatorAdapterWithResourceFiles<StreamImpl>(new StreamImpl(params)){

                @Override
                public Map<String, File> gatherRequirements() {
                    HashMap<String, File> ret = new HashMap<String, File>();
                    ret.put("dku.geoip.db", new File(ApplicationConfigurator.getInstallFolder(), "resources/GeoLite2City.fgdb.gz"));
                    return ret;
                }

                @Override
                public void setRequiredFiles(Map<String, File> requiredFiles) {
                    ((StreamImpl)this.processor).geoIPDBFile = requiredFiles.get("dku.geoip.db");
                }
            };
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL, ProcessorCapabilities.STATIC_COLUMNS_CREATOR, ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS, ProcessorCapabilities.TYPE_FIXED_COLUMNS_CREATOR);
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public StaticColumnsCreatorProcessor buildStaticColumnsCreator(StepParams params) {
            return new StreamImpl((GeoIPResolverParameter)params);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws IOException {
            return new SnowflakeUDFSQLTranslator((GeoIPResolverParameter)parameter);
        }

        @Override
        public Object selfReport(GeoIPResolverParameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"inCol"});
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof GeoIPResolverParameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            GeoIPResolverParameter resolverParams = (GeoIPResolverParameter)pss.params;
            if (StringUtils.isBlank((String)resolverParams.inCol)) {
                throw new IllegalConfigurationException("Missing IP column information for lineage on the GeoIO resolver processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)resolverParams.outColPrefix)) {
                    ArrayList<String> features = new ArrayList<String>();
                    if (resolverParams.extract_continentcode) {
                        features.add("continent");
                    }
                    if (resolverParams.extract_timezone) {
                        features.add("timezone");
                    }
                    if (resolverParams.extract_latlng) {
                        features.add("longitude");
                        features.add("latitude");
                    }
                    if (resolverParams.extract_geopoint) {
                        features.add("geopoint");
                    }
                    if (resolverParams.extract_postalcode) {
                        features.add("postal_code");
                    }
                    if (resolverParams.extract_city) {
                        features.add("city");
                    }
                    if (resolverParams.extract_region) {
                        features.add("region_hierarchy");
                        features.add("region");
                        features.add("region_code");
                    }
                    if (resolverParams.extract_countrycode) {
                        features.add("country_code");
                    }
                    if (resolverParams.extract_countrycode3) {
                        features.add("country_code3");
                    }
                    if (resolverParams.extract_country) {
                        features.add("country");
                    }
                    features.forEach(feature -> {
                        String outCol = resolverParams.outColPrefix + feature;
                        if (!Objects.equals(resolverParams.inCol, outCol)) {
                            updatedDatasetPairLineage.removeRelationsOnColumn(outCol);
                            updatedDatasetPairLineage.addFactorizedColumnRelations(resolverParams.inCol, outCol);
                        }
                    });
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private static Logger logger = Logger.getLogger((String)"dku.shaker");

    public static enum Fields {
        POSTAL_CODE,
        LATITUDE,
        LONGITUDE,
        COUNTRY,
        CITY,
        TIMEZONE,
        REGION,
        COUNTRY_CODE,
        CONTINENT_CODE,
        COUNTRY_CODE3;

    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final GeoIPResolverParameter parameter;
        private final String functionName;

        private SnowflakeUDFSQLTranslator(GeoIPResolverParameter parameter) {
            this.parameter = parameter;
            this.functionName = "geoipResolve_" + SecretKeyGenerator.generate();
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.LOG4J_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_NET_JAR);
            resources.add(new SnowflakeUDFProcessorTranslator.SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"resources/GeoLite2City.fgdb.gz"}), ""));
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.geo.GeoIPResolverUDF.process", "data STRING, settings STRING", "STRING, STRING", "ARRAY");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.LOG4J_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_NET_JAR);
            def.imports.add("GeoLite2City.fgdb.gz");
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            String paramAsJSON = JSON.json((Object)this.parameter);
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            chain.select(ebf.expr(String.format("%s(%s, %s)", this.functionName, d.quoteIdentifier(this.parameter.inCol), d.quoteString(paramAsJSON))), "GEOIP_RESULT");
            SQLQueryWithSchema outer = chain.makeSubquery();
            int next = 0;
            SchemaColumn inputSchemaColumn = outer.getCurrentColumn(this.parameter.inCol);
            if (this.parameter.extract_continentcode) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "continent", false);
            }
            if (this.parameter.extract_timezone) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "timezone", false);
            }
            if (this.parameter.extract_latlng) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.DOUBLE, this.parameter.outColPrefix + "longitude", false);
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.DOUBLE, this.parameter.outColPrefix + "latitude", false);
            }
            if (this.parameter.extract_geopoint) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "geopoint", false);
            }
            if (this.parameter.extract_postalcode) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "postal_code", false);
            }
            if (this.parameter.extract_city) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "city", false);
            }
            if (this.parameter.extract_region) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "region_hierarchy", false);
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "region", false);
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "region_code", false);
            }
            if (this.parameter.extract_countrycode) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "country_code", false);
            }
            if (this.parameter.extract_countrycode3) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "country_code3", false);
            }
            if (this.parameter.extract_country) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("GEOIP_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "country", false);
            }
            outer.deleteColumn("GEOIP_RESULT");
            outer.deleteSelect("GEOIP_RESULT");
            return outer;
        }
    }

    static class StreamImpl
    implements StaticColumnsCreatorProcessor {
        private static final long serialVersionUID = 1L;
        private final GeoIPResolverParameter parameter;
        private FastGeoIP2 fastAPI;
        private HashMap<String, String> countryCodeMap;
        private File geoIPDBFile;

        StreamImpl(GeoIPResolverParameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public void init(Map<String, File> resources) {
            this.geoIPDBFile = resources.get("dku.geoip.db");
        }

        @Override
        public List<String> getRequiredInputs() {
            return Lists.newArrayList((Object[])new String[]{this.parameter.inCol});
        }

        @Override
        public List<SchemaColumn> getProducedOutputs() {
            ArrayList<SchemaColumn> ret = new ArrayList<SchemaColumn>();
            if (this.parameter.extract_continentcode) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "continent", Type.STRING));
            }
            if (this.parameter.extract_timezone) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "timezone", Type.STRING));
            }
            if (this.parameter.extract_latlng) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "longitude", Type.DOUBLE));
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "latitude", Type.DOUBLE));
            }
            if (this.parameter.extract_geopoint) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "geopoint", Type.STRING));
            }
            if (this.parameter.extract_postalcode) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "postal_code", Type.STRING));
            }
            if (this.parameter.extract_city) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "city", Type.STRING));
            }
            if (this.parameter.extract_region) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "region_hierarchy", Type.STRING));
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "region", Type.STRING).withForcedMeaning("Text"));
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "region_code", Type.STRING));
            }
            if (this.parameter.extract_countrycode) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "country_code", Type.STRING));
            }
            if (this.parameter.extract_countrycode3) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "country_code3", Type.STRING));
            }
            if (this.parameter.extract_country) {
                ret.add(new SchemaColumn(this.parameter.outColPrefix + "country", Type.STRING));
            }
            return ret;
        }

        @Override
        public StaticColumnsCreatorProcessor.Output produceRow(StaticColumnsCreatorProcessor.Input input) throws Exception {
            InetAddress addr;
            block44: {
                Object iV;
                if (this.fastAPI == null) {
                    this.fastAPI = GeoIPService.getInstance((File)this.geoIPDBFile);
                }
                if (this.countryCodeMap == null) {
                    Locale[] availableLocales = Locale.getAvailableLocales();
                    this.countryCodeMap = new HashMap();
                    for (Locale l : availableLocales) {
                        try {
                            this.countryCodeMap.put(l.getCountry(), l.getISO3Country());
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                }
                String iCV = (iV = input.values.get(0)) == null ? null : iV.toString();
                addr = null;
                try {
                    if (iCV != null && iCV.length() > 2) {
                        addr = InetAddresses.forString((String)iCV);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!iCV.contains(",")) break block44;
                    try {
                        String[] ips = iCV.split(",");
                        for (int i = ips.length - 1; i >= 0; --i) {
                            String ip = ips[i].trim();
                            if (ip.matches("(^127\\.0\\.0\\.1)|(^10\\.)|(^172\\.1[6-9]\\.)|(^172\\.2[0-9]\\.)|(^172\\.3[0-1]\\.)|(^192\\.168\\.)")) continue;
                            addr = InetAddresses.forString((String)ip);
                        }
                    }
                    catch (IllegalArgumentException e2) {
                        addr = null;
                    }
                }
            }
            FastGeoIP2.Result details = null;
            if (addr != null) {
                try {
                    details = this.fastAPI.find(addr);
                }
                catch (Exception e) {
                    logger.warn((Object)"GeoIP processing failed ", (Throwable)e);
                }
            }
            StaticColumnsCreatorProcessor.Output output = new StaticColumnsCreatorProcessor.Output();
            if (details == null) {
                if (this.parameter.extract_continentcode) {
                    output.values.add(null);
                }
                if (this.parameter.extract_timezone) {
                    output.values.add(null);
                }
                if (this.parameter.extract_latlng) {
                    output.values.add(null);
                    output.values.add(null);
                }
                if (this.parameter.extract_geopoint) {
                    output.values.add(null);
                }
                if (this.parameter.extract_postalcode) {
                    output.values.add(null);
                }
                if (this.parameter.extract_city) {
                    output.values.add(null);
                }
                if (this.parameter.extract_region) {
                    output.values.add(null);
                    output.values.add(null);
                    output.values.add(null);
                }
                if (this.parameter.extract_countrycode) {
                    output.values.add(null);
                }
                if (this.parameter.extract_countrycode3) {
                    output.values.add(null);
                }
                if (this.parameter.extract_country) {
                    output.values.add(null);
                }
            } else {
                if (this.parameter.extract_continentcode) {
                    output.values.add(details.getContinent());
                }
                if (this.parameter.extract_timezone) {
                    output.values.add(details.getTimezone());
                }
                if (this.parameter.extract_latlng) {
                    String longitude = details.getLongitude();
                    String latitude = details.getLatitude();
                    if (StringUtils.isNotBlank((String)longitude)) {
                        output.values.add(Double.parseDouble(longitude));
                    } else {
                        output.values.add(null);
                    }
                    if (StringUtils.isNotBlank((String)latitude)) {
                        output.values.add(Double.parseDouble(latitude));
                    } else {
                        output.values.add(null);
                    }
                }
                if (this.parameter.extract_geopoint) {
                    String lat = details.getLatitude();
                    String lon = details.getLongitude();
                    if (StringUtils.isNotBlank((String)lat) && StringUtils.isNotBlank((String)lon)) {
                        output.values.add("POINT(" + lon + " " + lat + ")");
                    } else {
                        output.values.add(null);
                    }
                }
                if (this.parameter.extract_postalcode) {
                    output.values.add(details.getPostalCode());
                }
                if (this.parameter.extract_city) {
                    output.values.add(details.getCity());
                }
                if (this.parameter.extract_region) {
                    Object regionHierarchy = "";
                    String mostSpecificName = "";
                    String mostSpecificCode = "";
                    boolean first = true;
                    for (FastGeoIP2.Result.Subdivision sub : details.getSubdivisions()) {
                        if (!first) {
                            regionHierarchy = (String)regionHierarchy + ",";
                        }
                        regionHierarchy = (String)regionHierarchy + sub.name;
                        mostSpecificName = sub.name;
                        mostSpecificCode = sub.code;
                        first = false;
                    }
                    output.values.add(regionHierarchy);
                    output.values.add(mostSpecificName);
                    output.values.add(mostSpecificCode);
                }
                if (this.parameter.extract_countrycode) {
                    output.values.add(details.getCountryCode());
                }
                if (this.parameter.extract_countrycode3) {
                    output.values.add(this.countryCodeMap.get(details.getCountryCode()));
                }
                if (this.parameter.extract_country) {
                    output.values.add(details.getCountry());
                }
            }
            return output;
        }
    }
}

