/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalyzer;
import com.dataiku.dip.shaker.facet.AlphanumFacetBuilderNoHapax;
import com.dataiku.dip.shaker.facet.AlphanumFacetWithMap;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Gender;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TableColoringService {
    public static final int BIN_UNCOLORED = 0;
    public static final int BIN_EMPTY = -1;
    public static final int BIN_HAPAX = -2;
    public static final int BIN_INVALID = -3;
    public static final int ALPHANUM_MAX_COLORED_BINS = 11;
    private HashFunction hashfunc;
    private Boolean booleanMeaning = new Boolean();
    private Gender genderMeaning = new Gender();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.coloring");

    public TableColoringService() {
        this.randomizeColors();
    }

    public void randomizeColors() {
        this.hashfunc = Hashing.murmur3_128((int)((int)System.currentTimeMillis()));
    }

    public void prepareColorScaleSchemeAndSetProgressBar(SerializedShakerScript.TableColoring coloring, MemTable table, MemColumn column, int maxColoredBins, ColoringDefinition.ColorScaleDef colorScaleDef) {
        if (column == null || column.selectedType == null) {
            return;
        }
        this.prepareColorScaleScheme(table, column, colorScaleDef);
        ArrayList<SerializedMemTableV2.Header.ProgressBarChunk> progressBarChunks = new ArrayList<SerializedMemTableV2.Header.ProgressBarChunk>();
        if (column.analysisForColoring != null) {
            NumericalVariableAnalysis analysis = column.analysisForColoring;
            long total = 0L;
            for (int i = 0; i < analysis.histogramLowerBounds.length; ++i) {
                total += (long)analysis.histogram[i];
            }
            total += (long)(analysis.missing + analysis.bad);
            total += (long)(analysis.bottomOutliers + analysis.topOutliers);
            int indexMax = analysis.histogramLowerBounds.length - 1;
            for (int i = 0; i < analysis.histogramLowerBounds.length; ++i) {
                double lower = analysis.histogramLowerBounds[i];
                double upper = analysis.histogramUpperBounds[i];
                double ratio = 0.0;
                if (total > 0L) {
                    int value = analysis.histogram[i];
                    if (i == 0) {
                        value += analysis.bottomOutliers;
                    }
                    if (i == indexMax) {
                        value += analysis.topOutliers;
                    }
                    ratio = (double)value / (double)total;
                }
                progressBarChunks.add(new SerializedMemTableV2.Header.ProgressBarChunk("CN-" + (i + 1), lower, upper, ratio));
            }
        } else if (column.facetForColoring != null) {
            AlphanumFacetWithMap facet = column.facetForColoring;
            for (int i = 0; i < facet.counts.length; ++i) {
                String val = facet.values[i];
                int bin = (int)this.getColorBin(coloring.valueColoringMode, column, val, maxColoredBins);
                progressBarChunks.add(new SerializedMemTableV2.Header.ProgressBarChunk(column.colorPalette + "-" + bin, val, facet.percentages[i]));
            }
        }
        column.progressBarChunks = progressBarChunks;
    }

    public void prepareColorScaleScheme(MemTable table, MemColumn column, ColoringDefinition.ColorScaleDef colorScaleDef) {
        if (column == null || column.selectedType == null) {
            return;
        }
        if (column.selectedType.type.isDouble()) {
            NumericalVariableAnalysis out;
            int nbBins = colorScaleDef != null && colorScaleDef.sample != null && colorScaleDef.sample.size() > 0 ? colorScaleDef.sample.size() : 5;
            NumericalVariableAnalyzer analyzer = new NumericalVariableAnalyzer(--nbBins);
            analyzer.niceBounds = false;
            analyzer.analyse(table, column.getName(), null);
            if (colorScaleDef != null && (colorScaleDef.min < colorScaleDef.max || Math.abs(colorScaleDef.max - colorScaleDef.min) < 1.0E-6) && (out = analyzer.getOut()) != null) {
                out.max = colorScaleDef.max;
                out.min = colorScaleDef.min;
                if (Math.abs(out.max - out.min) < 1.0E-6) {
                    out.min -= 1.0;
                }
            }
            analyzer.compute();
            column.analysisForColoring = analyzer.getOut();
        } else {
            column.facetForColoring = new AlphanumFacetBuilderNoHapax().build(table, column, 11);
        }
        column.colorPalette = this.getColorPalette(column);
    }

    private void setRulesSchemeProgressBarFromFilterDescs(MemTable table, String columnName, List<FilterDesc> filterDescs) {
        MemColumn col = table.getColumn(columnName);
        if (col == null) {
            return;
        }
        HashMap<Integer, Integer> matchedRuleIndexToCounts = new HashMap<Integer, Integer>();
        List<Expression> expressions = TableColoringService.buildExpressions(filterDescs, table);
        for (int rowIndex = 0; rowIndex < table.rows.size(); ++rowIndex) {
            MemRow row = table.rows.get(rowIndex);
            int matchedRuleIndex = TableColoringService.findFirstMatchingRule(expressions, row);
            if (matchedRuleIndex == -1) continue;
            matchedRuleIndexToCounts.merge(matchedRuleIndex, 1, Integer::sum);
        }
        col.progressBarChunks = matchedRuleIndexToCounts.entrySet().stream().map(kv -> new SerializedMemTableV2.Header.ProgressBarChunk(((Integer)kv.getKey()).toString(), (double)((Integer)kv.getValue()).intValue() / (double)table.rows.size())).collect(Collectors.toList());
    }

    private void setRulesSchemeProgressBarFromColumnsRules(MemTable table, String columnName, List<ColoringDefinition.ColumnRules> columnsRules) {
        columnsRules.stream().filter(r -> r.column.equals(columnName)).findFirst().ifPresent(rules -> this.setRulesSchemeProgressBarFromFilterDescs(table, columnName, rules.rulesDesc));
    }

    private void setRulesSchemeProgressBarFromRulesGroup(MemTable table, String columnName, ColoringDefinition.RulesGroup rulesGroup) {
        this.setRulesSchemeProgressBarFromFilterDescs(table, columnName, rulesGroup.getBasedOnColumnFilterDescs(columnName));
    }

    public void prepareColoring(SerializedShakerScript.TableColoring coloring, MemTable table) {
        switch (coloring.scheme) {
            case FILL_ONLY: {
                break;
            }
            case INDIVIDUAL_COLUMNS_VALUES: {
                for (String column : coloring.individualColumns) {
                    this.prepareColorScaleSchemeAndSetProgressBar(coloring, table, table.getColumn(column), 11, null);
                }
                break;
            }
            case ALL_COLUMNS_VALUES: {
                for (MemColumn col : table.columnsList) {
                    this.prepareColorScaleSchemeAndSetProgressBar(coloring, table, col, 11, null);
                }
                break;
            }
            case MEANING_AND_STATUS: {
                break;
            }
            case SINGLE_COLUMN_VALUES: {
                if (!table.hasNonDeletedColumn(coloring.singleColumn)) break;
                this.prepareColorScaleSchemeAndSetProgressBar(coloring, table, table.getColumn(coloring.singleColumn), 11, null);
                break;
            }
            case SINGLE_VALUE_HIGHLIGHT: {
                break;
            }
            case INDIVIDUAL_COLUMNS_RULES: {
                for (ColoringDefinition.ColumnRules columnRules : coloring.individualColumnsRules) {
                    this.setRulesSchemeProgressBarFromFilterDescs(table, columnRules.column, columnRules.rulesDesc);
                }
                break;
            }
            case SINGLE_COLUMN_RULES: {
                if (!table.hasNonDeletedColumn(coloring.singleColumn)) break;
                this.setRulesSchemeProgressBarFromColumnsRules(table, coloring.singleColumn, coloring.individualColumnsRules);
                break;
            }
            case COLORING_GROUPS: {
                for (MemColumn col : table.columnsList) {
                    ColoringDefinition.ColoringGroup coloringGroup = ColoringDefinition.findAppliedColoringGroup(coloring.coloringGroups, (String)col.getName());
                    if (coloringGroup == null) continue;
                    if (coloringGroup.isBasedOnTargetedColumn(col.getName())) {
                        if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.COLOR_SCALE) {
                            int maxColoredBins = coloringGroup.colorScaleDef != null ? coloringGroup.colorScaleDef.sample.size() : 11;
                            this.prepareColorScaleSchemeAndSetProgressBar(coloring, table, col, maxColoredBins, coloringGroup.colorScaleDef);
                            continue;
                        }
                        if (coloringGroup.scheme != ColoringDefinition.ColoringGroupScheme.RULES || coloringGroup.scope != ColoringDefinition.ColoringGroupScope.COLUMNS && coloringGroup.scope != ColoringDefinition.ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN) continue;
                        this.setRulesSchemeProgressBarFromRulesGroup(table, col.getName(), coloringGroup.rulesGroup);
                        continue;
                    }
                    if (!coloringGroup.isBasedOnAnotherColumn(col.getName()) || coloringGroup.scheme != ColoringDefinition.ColoringGroupScheme.COLOR_SCALE || !table.hasNonDeletedColumn(coloringGroup.basedOnColumnName)) continue;
                    MemColumn basedOnColumn = table.getColumn(coloringGroup.basedOnColumnName);
                    if (basedOnColumn.analysisForColoring != null || basedOnColumn.facetForColoring != null) continue;
                    this.prepareColorScaleScheme(table, basedOnColumn, coloringGroup.colorScaleDef);
                }
                break;
            }
        }
    }

    public float getColorBin(ColoringDefinition.ValueColoringMode valueColoringMode, MemColumn column, String val, int maxColoredBins) {
        if (StringUtils.isBlank((String)val)) {
            return -1.0f;
        }
        if (column.analysisForColoring != null) {
            double numerator;
            double dval = column.selectedType.type.doubleValue(val);
            if (Double.isNaN(dval)) {
                return -3.0f;
            }
            int bin = this.getHistogramColorBin(column.analysisForColoring, dval);
            if (bin == 0) {
                return 0.0f;
            }
            double[] histogram = column.analysisForColoring.chistogram[bin - 1];
            double nbValues = histogram[2];
            if (nbValues == 0.0) {
                return bin;
            }
            double min = histogram[0];
            double max = histogram[1];
            double coefficient = (max - min) / nbValues;
            for (numerator = 0.0; numerator < nbValues && !(dval <= min + numerator * coefficient); numerator += 1.0) {
            }
            return (float)bin + (float)(numerator / nbValues);
        }
        if (column.facetForColoring != null) {
            if (column.selectedType.type.getMeaningId().equals("Boolean")) {
                java.lang.Boolean b = this.booleanMeaning.parseNoFail(val);
                if (b == null) {
                    return -3.0f;
                }
                if (b.booleanValue()) {
                    return 2.0f;
                }
                return 1.0f;
            }
            if (column.selectedType.type.getMeaningId().equals("Gender")) {
                Gender.ValidGender vg = this.genderMeaning.parseNoFail(val);
                if (vg == null) {
                    return -3.0f;
                }
                if (vg.isFemale) {
                    return 1.0f;
                }
                return 2.0f;
            }
            if (column.facetForColoring.frequent.contains(val)) {
                if (valueColoringMode == ColoringDefinition.ValueColoringMode.HASH && maxColoredBins > 0) {
                    return 1 + Math.abs(this.hashfunc.hashString((CharSequence)val, StandardCharsets.UTF_8).asInt()) % maxColoredBins;
                }
                return column.facetForColoring.frequentIndex.get(val) + 1;
            }
            if (column.facetForColoring.infrequent.contains(val)) {
                return 0.0f;
            }
            return -2.0f;
        }
        return -3.0f;
    }

    private int getHistogramColorBin(NumericalVariableAnalysis analysisForColoring, double value) {
        for (int i = 0; i < analysisForColoring.histogramLowerBounds.length; ++i) {
            if (!(value < analysisForColoring.histogramUpperBounds[i]) && !(Math.abs(value - analysisForColoring.histogramUpperBounds[i]) < 1.0E-6)) continue;
            return i + 1;
        }
        return analysisForColoring.histogramLowerBounds.length;
    }

    public String getColorPalette(MemColumn column) {
        if (column.selectedType.type.getMeaningId().equals("Boolean")) {
            return "CB";
        }
        if (column.selectedType.type.getMeaningId().equals("Gender")) {
            return "CG";
        }
        if (column.analysisForColoring == null) {
            return "CA1";
        }
        return "CN";
    }

    public static List<Expression> buildExpressions(List<FilterDesc> filterDescs, MemTable table) {
        return filterDescs.stream().map(filter -> {
            try {
                String grel = FilterDescUtils.translateAstToGrel(filter);
                Expression expr = new Expression(grel);
                expr.setColumnFactory(table);
                return expr;
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse rule");
                return null;
            }
        }).collect(Collectors.toList());
    }

    public static int findFirstMatchingRule(List<Expression> expressions, MemRow row) {
        for (int exprIndex = 0; exprIndex < expressions.size(); ++exprIndex) {
            Expression expr = expressions.get(exprIndex);
            if (expr == null) continue;
            try {
                Object res = expr.evaluate(row);
                if (!(res instanceof java.lang.Boolean) || !java.lang.Boolean.TRUE.equals(res)) continue;
                return exprIndex;
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to apply rule");
            }
        }
        return -1;
    }
}

