/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnNumericalRange;
import com.dataiku.dip.shaker.sql.AbstractSqlFilterAndFlagOnSimpleCriteria;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class SqlFilterAndFlagOnNumericalRange
extends AbstractSqlFilterAndFlagOnSimpleCriteria {
    public SqlFilterAndFlagOnNumericalRange(SQLQueryWithSchema chain, FilterAndFlagOnNumericalRange.Parameter parameter) {
        super(chain, parameter);
    }

    @Override
    protected ExpressionBuilder exprFor(String column) {
        Preconditions.checkArgument((this.chain.getCurrentColumn(column) != null ? 1 : 0) != 0, (Object)("No schema column found for column " + column));
        ExpressionBuilder comparableCol = this.chain.col(column);
        Optional<SchemaColumn> inputColumn = this.chain.getInputColumn(column);
        if (!inputColumn.isPresent()) {
            logger.debugV("No schema column found for column %s", new Object[]{column});
            return comparableCol;
        }
        if (!((SchemaColumn)inputColumn.get()).getType().isNumeric()) {
            comparableCol = comparableCol.castToFloat();
        }
        Double min = this.getTypedParameter().min;
        Double max = this.getTypedParameter().max;
        if (min == null && max != null) {
            return comparableCol.lte(this.ebf.cst(max));
        }
        if (min != null && max == null) {
            return comparableCol.gte(this.ebf.cst(min));
        }
        return comparableCol.gte(this.ebf.cst(min)).and(comparableCol.lte(this.ebf.cst(max)));
    }

    private FilterAndFlagOnNumericalRange.Parameter getTypedParameter() {
        return (FilterAndFlagOnNumericalRange.Parameter)this.getTypedParams();
    }
}

