/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.text;

import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dip.utils.ErrorContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StringNormalizationMode implements Labelled
{
    EXACT{

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            return StringNormalizationMode.translate(language, "SHAKER.TEXT.NORMALIZATION.EXACT", "Exact (no transformation)");
        }
    }
    ,
    LOWERCASE{

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            return StringNormalizationMode.translate(language, "SHAKER.TEXT.NORMALIZATION.LOWERCASE", "Ignore case");
        }
    }
    ,
    NORMALIZED{

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            return StringNormalizationMode.translate(language, "SHAKER.TEXT.NORMALIZATION.NORMALIZED", "Normalize (ignore accents)");
        }
    };

    public static final String PARAM_KEY = "normalization";

    public static StringNormalizationMode forName(String mode) {
        try {
            return StringNormalizationMode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw ErrorContext.iaef((String)"Unknown String normalization mode: %s - Expected 'exact', 'lowercase' or 'normalized'", (Object)mode, (Object[])new Object[0]);
        }
    }

    public static StringNormalizationMode forName(String mode, StringNormalizationMode defaultValue) {
        if (mode == null) {
            return defaultValue;
        }
        return StringNormalizationMode.forName(mode);
    }

    public String apply(String in) {
        switch (this) {
            case EXACT: {
                return in;
            }
            case LOWERCASE: {
                return in.toLowerCase();
            }
            case NORMALIZED: {
                return StringNormalizer.normalize((String)in.toLowerCase());
            }
        }
        throw new Error("Unreachable");
    }

    private static String translate(String lang, String id, String defaultValue) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return ts.translate(lang, id, defaultValue, new Object[0]);
    }
}

