/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SparkExecutionConfig {
    public static final String DEFAULT_CONFIG_NAME = "default";
    public String name;
    public String description;
    public ClusterPropertyList conf = new ClusterPropertyList();
    public SparkKubernetesSettings kubernetesSettings = new SparkKubernetesSettings();
    public SparkCloudCredentialsSettings cloudCredentialsSettings = new SparkCloudCredentialsSettings();

    public SparkExecutionConfig() {
    }

    public SparkExecutionConfig(SparkExecutionConfig sparkExecutionConfig) {
        this.name = sparkExecutionConfig.name;
        this.description = sparkExecutionConfig.description;
        this.conf = sparkExecutionConfig.conf.deepCopy();
        this.kubernetesSettings = sparkExecutionConfig.kubernetesSettings.deepCopy();
        this.cloudCredentialsSettings = sparkExecutionConfig.cloudCredentialsSettings.deepCopy();
    }

    public SparkExecutionConfig deepCopy() {
        return new SparkExecutionConfig(this);
    }

    public SparklyrConfig toSparklyrConfig(SparkSettings sparkSettings, HadoopSettings hadoopSettings, AuthCtx authCtx, String projectKey) {
        SparklyrConfig ret = new SparklyrConfig();
        for (ClusterProperty entry : this.conf) {
            ret.conf.put(entry.key, entry.value);
        }
        for (File f : SparkSubmitHelper.build(projectKey, authCtx, sparkSettings, hadoopSettings, null, null).getJarsList(false, false)) {
            ret.jars.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static SparklyrConfig toSparklyrConfig(List<SimpleKeyValue> sconf, SparkSettings sparkSettings, HadoopSettings hadoopSettings, AuthCtx authCtx, String projectKey) {
        SparklyrConfig ret = new SparklyrConfig();
        for (SimpleKeyValue entry : sconf) {
            ret.conf.put(entry.key, entry.value);
        }
        for (File f : SparkSubmitHelper.build(projectKey, authCtx, sparkSettings, hadoopSettings, null, null).getJarsList(false, false)) {
            ret.jars.add(f.getAbsolutePath());
        }
        return ret;
    }

    public List<String> toSparkSubmitArgs(SparkSettings sparkSettings, HadoopSettings hadoopSettings, AuthCtx authCtx, String projectKey) {
        SparkSubmitHelper helper = SparkSubmitHelper.build(projectKey, authCtx, sparkSettings, hadoopSettings, null, null);
        SparkSubmitJob job = new SparkSubmitJob();
        helper.buildCommandArgs(job, this.conf);
        ArrayList<String> ret = new ArrayList<String>();
        for (SimpleKeyValue entry : job.conf) {
            ret.add("--conf");
            ret.add(entry.key + "=" + entry.value);
        }
        ret.addAll(job.submitArgs);
        ret.add("--jars");
        ret.add(helper.getJars(false, false));
        return ret;
    }

    public static List<String> toSparkSubmitArgs(List<SimpleKeyValue> sconf, List<String> pyFiles, SparkSettings sparkSettings, HadoopSettings hadoopSettings, AuthCtx authCtx, String projectKey) {
        SparkSubmitHelper helper = SparkSubmitHelper.build(projectKey, authCtx, sparkSettings, hadoopSettings, null, null);
        SparkSubmitJob job = new SparkSubmitJob();
        helper.buildCommandArgs(job, sconf);
        ArrayList<String> ret = new ArrayList<String>();
        for (SimpleKeyValue entry : job.conf) {
            ret.add("--conf");
            ret.add(entry.key + "=" + entry.value);
        }
        ret.addAll(job.submitArgs);
        if (!pyFiles.isEmpty()) {
            ret.add("--py-files");
            ret.add(StringUtils.join(pyFiles, (String)","));
        }
        ret.add("--jars");
        ret.add(helper.getJars(false, false));
        return ret;
    }

    public boolean hasConfKey(String ... keys) {
        HashSet keysToTest = Sets.newHashSet((Object[])keys);
        for (ClusterProperty kv : this.conf) {
            if (!keysToTest.contains(kv.key)) continue;
            return true;
        }
        return false;
    }

    public static class SparkKubernetesSettings
    extends ContainerExecUtils.KubernetesAwareContainerConfig {
        public boolean managedKubernetes;
        private String managedNamespace = "default";
        public KubernetesAuthenticationMode authenticationMode = KubernetesAuthenticationMode.BUILTIN;
        public String executorPodTemplate;
        public String executorPodTemplateContainerName;

        @Override
        public String getRequestedKubernetesNamespace() {
            return this.managedNamespace;
        }

        protected SparkKubernetesSettings() {
            super(ContainerExecUtils.BaseImageType.SPARK);
        }

        public SparkKubernetesSettings(SparkKubernetesSettings sparkKubernetesSettings) {
            super(sparkKubernetesSettings);
            this.managedKubernetes = sparkKubernetesSettings.managedKubernetes;
            this.managedNamespace = sparkKubernetesSettings.managedNamespace;
            this.authenticationMode = sparkKubernetesSettings.authenticationMode;
            this.executorPodTemplate = sparkKubernetesSettings.executorPodTemplate;
            this.executorPodTemplateContainerName = sparkKubernetesSettings.executorPodTemplateContainerName;
            this.noImplicitK8sClusterAndNoDefaultClusterId = sparkKubernetesSettings.noImplicitK8sClusterAndNoDefaultClusterId;
        }

        public SparkKubernetesSettings deepCopy() {
            return new SparkKubernetesSettings(this);
        }
    }

    public static class SparkCloudCredentialsSettings {
        public boolean enabled;
        public CloudCredentialsProvidingSettings aws = new CloudCredentialsProvidingSettings();
        public CloudCredentialsProvidingSettings azure = new CloudCredentialsProvidingSettings();
        public CloudCredentialsProvidingSettings gcp = new CloudCredentialsProvidingSettings();

        public SparkCloudCredentialsSettings() {
        }

        public SparkCloudCredentialsSettings(SparkCloudCredentialsSettings sparkCloudCredentialsSettings) {
            this.enabled = sparkCloudCredentialsSettings.enabled;
            this.aws = sparkCloudCredentialsSettings.aws.deepCopy();
            this.azure = sparkCloudCredentialsSettings.azure.deepCopy();
            this.gcp = sparkCloudCredentialsSettings.gcp.deepCopy();
        }

        SparkCloudCredentialsSettings deepCopy() {
            return new SparkCloudCredentialsSettings(this);
        }

        public static class CloudCredentialsProvidingSettings {
            public CloudCredentialsProvidingMode mode = CloudCredentialsProvidingMode.NONE;
            public List<String> connections = new ArrayList<String>();
            public boolean provideGlueClientCredential = true;

            CloudCredentialsProvidingSettings() {
            }

            CloudCredentialsProvidingSettings(CloudCredentialsProvidingSettings settings) {
                this.mode = settings.mode;
                this.provideGlueClientCredential = settings.provideGlueClientCredential;
                this.connections.addAll(settings.connections);
            }

            CloudCredentialsProvidingSettings deepCopy() {
                return new CloudCredentialsProvidingSettings(this);
            }
        }

        public static enum CloudCredentialsProvidingMode {
            NONE,
            FIRST_MATCH,
            ANY_MATCH;

        }
    }

    public static class SparklyrConfig {
        public Map<String, String> conf = new HashMap<String, String>();
        public List<String> jars = new ArrayList<String>();
    }

    public static enum KubernetesAuthenticationMode {
        BUILTIN,
        PROXY_WITH_DSS_ACCOUNT,
        DYNAMIC_SERVICE_ACCOUNT;

    }
}

