/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.sparksql.DkuPreparedStatementBase;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DkuDatasetReadPreparedStatement
extends DkuPreparedStatementBase {
    private final AuthCtx authCtx;
    private final HadoopSettings hadoopSettings;
    private final Dataset dataset;
    private final SamplingParam sampling;
    private final List<String> partitions;
    private final List<String> columnNames;
    private final String filterExpression;
    private static Logger logger = Logger.getLogger((String)"dip.livy.statement.prepared");

    public DkuDatasetReadPreparedStatement(DkuSparkSQLConnection connection, int fetchSize, AuthCtx authCtx, HadoopSettings hadoopSettings, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        super(connection, fetchSize);
        this.authCtx = authCtx;
        this.hadoopSettings = hadoopSettings;
        this.dataset = dataset;
        this.sampling = sampling;
        this.partitions = partitions;
        this.columnNames = columnNames;
        this.filterExpression = filterExpression;
    }

    @Override
    protected void doPrepare() throws SQLException {
        logger.info((Object)"Opening dataset");
        this.response = this.connection.getSparkSQLHandler().readDataset(this.authCtx, this.hadoopSettings, this.dataset.getModel(), this.sampling, this.partitions, this.columnNames, this.filterExpression);
        if (this.response.error != null) {
            throw new SQLException(StringUtils.defaultIfBlank((String)this.response.error.message, (String)"Failed to execute sql"), new APIError.SerializedErrorException(this.response.error));
        }
    }

    public Schema getSchema() {
        return this.response.schema;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw new Error("should not be called");
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new Error("should not be called");
    }

    @Override
    public boolean execute() throws SQLException {
        throw new Error("should not be called");
    }

    @Override
    public void addBatch() throws SQLException {
        throw new Error("should not be called");
    }
}

