/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.bigquery.BigQueryDatasetConfig;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SchemaReader;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class BigQueryUtils {
    public static void checkPartitioningConsistency(AuthCtx authCtx, AbstractSQLConnection connection, AbstractSQLDatasetHandler.AbstractSQLConfig config, @Nullable PartitioningScheme partitioningScheme) throws IOException, DKUSecurityException, SQLException, CodedException {
        SQLDialect dialect = connection.getDialect();
        if (BigQueryUtils.shouldCheckPartitioningConsistency(connection, config)) {
            boolean partitioningMismatch;
            SchemaReader.TablePartitionInfo tablePartitionInfo = dialect.retrieveTablePartitionInfo(authCtx, connection, config.catalog, config.schema, config.table);
            boolean datasetIsPartitioned = partitioningScheme != null && partitioningScheme.isPartitioned();
            boolean bigQueryTableIsPartitioned = tablePartitionInfo != null && tablePartitionInfo.dimension != null;
            boolean bl = partitioningMismatch = datasetIsPartitioned && !bigQueryTableIsPartitioned;
            if (partitioningMismatch) {
                throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Connection settings forbid writing to a non-partitioned BigQuery table if the dataset is partitioned");
            }
        }
    }

    private static boolean shouldCheckPartitioningConsistency(AbstractSQLConnection connection, AbstractSQLDatasetHandler.AbstractSQLConfig config) {
        AbstractSQLConnection.AbstractSQLParams abstractSQLParams = connection.getParams();
        if (abstractSQLParams instanceof BigQueryConnection.Params) {
            BigQueryConnection.Params connectionParams = (BigQueryConnection.Params)abstractSQLParams;
            if (config instanceof BigQueryDatasetConfig) {
                BigQueryDatasetConfig bigQueryDatasetConfig = (BigQueryDatasetConfig)config;
                return bigQueryDatasetConfig.forbidPartitionsWriteToNonPartitionedTable.isEnabled() || bigQueryDatasetConfig.forbidPartitionsWriteToNonPartitionedTable.isInherited() && connectionParams.forbidPartitionsWriteToNonPartitionedTable;
            }
        }
        return false;
    }
}

