/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLDatabaseMetadataRetriever {
    public static final String REMARKS = "REMARKS";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String TABLE_TYPE = "TABLE_TYPE";
    public static final String TABLE_CAT = "TABLE_CAT";
    private final String connectionName;
    private final boolean includeSystemTables;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.metadata");

    public SQLDatabaseMetadataRetriever(String connectionName, boolean includeSystemTables) {
        this.connectionName = connectionName;
        this.includeSystemTables = includeSystemTables;
    }

    public List<ForeignKey> getForeignKeys(SQLConnectionProvider.SQLConnectionData connData, DatabaseMetaData meta) {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        try {
            return this.getForeignKeysByParameters(meta, null, null, null);
        }
        catch (Throwable e) {
            logger.warn((Object)"Could not fetch foreign keys at once, trying by enumeration", e);
            for (Table table : this.getTables(connData, meta)) {
                try {
                    result.addAll(this.getForeignKeysByParameters(meta, table.getTableKey().getCatalog(), table.getTableKey().getSchema(), table.getTableKey().name));
                }
                catch (Throwable t) {
                    logger.error((Object)"Could not fetch foreign keys", t);
                    return result;
                }
            }
            return result;
        }
    }

    private List<ForeignKey> getForeignKeysByParameters(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        ResultSet exportedKeysRs = meta.getExportedKeys(catalog, schema, table);
        while (exportedKeysRs.next()) {
            DatabaseObjectKey pkTableKey = new DatabaseObjectKey(this.connectionName, exportedKeysRs.getString("PKTABLE_CAT"), exportedKeysRs.getString("PKTABLE_SCHEM"), exportedKeysRs.getString("PKTABLE_NAME"));
            DatabaseObjectKey fkTableKey = new DatabaseObjectKey(this.connectionName, exportedKeysRs.getString("FKTABLE_CAT"), exportedKeysRs.getString("FKTABLE_SCHEM"), exportedKeysRs.getString("FKTABLE_NAME"));
            ForeignKey foreignKey = new ForeignKey(pkTableKey, fkTableKey, exportedKeysRs.getString("PKCOLUMN_NAME"), exportedKeysRs.getString("FKCOLUMN_NAME"), exportedKeysRs.getString("PK_NAME"), exportedKeysRs.getString("FK_NAME"));
            result.add(foreignKey);
        }
        return result;
    }

    public List<UserDefinedType> getUDTs(DatabaseMetaData meta) {
        ArrayList<UserDefinedType> result = new ArrayList<UserDefinedType>();
        try {
            ResultSet udtRs = meta.getUDTs(null, null, null, null);
            while (udtRs.next()) {
                DatabaseObjectKey key = new DatabaseObjectKey(this.connectionName, udtRs.getString("TYPE_CAT"), udtRs.getString("TYPE_SCHEM"), udtRs.getString("TYPE_NAME"));
                new UserDefinedType(key, udtRs.getString("CLASS_NAME"), udtRs.getString(REMARKS));
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Could not fetch User Defined Types", e);
        }
        return result;
    }

    public List<UserDefinedTypeAttribute> getAttributes(DatabaseMetaData meta) {
        ArrayList<UserDefinedTypeAttribute> result = new ArrayList<UserDefinedTypeAttribute>();
        try {
            ResultSet attributesRs = meta.getAttributes(null, null, null, null);
            while (attributesRs.next()) {
                DatabaseObjectKey typeKey = new DatabaseObjectKey(this.connectionName, attributesRs.getString("TYPE_CAT"), attributesRs.getString("TYPE_SCHEM"), attributesRs.getString("TYPE_NAME"));
                DatabaseObjectKey typeTableKey = new DatabaseObjectKey(this.connectionName, attributesRs.getString("SCOPE_CATALOG"), attributesRs.getString("SCOPE_SCHEMA"), attributesRs.getString("SCOPE_TABLE"));
                UserDefinedTypeAttribute userDefinedTypeAttribute = new UserDefinedTypeAttribute(typeKey, typeTableKey, attributesRs.getString("ATTR_NAME"), attributesRs.getString("ATTR_TYPE_NAME"), attributesRs.getString(REMARKS));
                result.add(userDefinedTypeAttribute);
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Could not fetch attributes", (Throwable)e);
        }
        return result;
    }

    public List<ColumnWithLoc> getColumns(SQLDialect dialect, DatabaseMetaData meta, String catalog, String schema, String name) {
        ArrayList<ColumnWithLoc> result = new ArrayList<ColumnWithLoc>();
        try {
            String tableSearchPattern = dialect.escapeSchemaOrTableNameForJDBCMetadataQuerying(name);
            String schemaSearchPattern = dialect.escapeSchemaOrTableNameForJDBCMetadataQuerying(schema);
            logger.infoV("Querying meta columns with catalog=%s schemaPattern=%s tablePattern=%s", new Object[]{catalog, schemaSearchPattern, tableSearchPattern});
            ResultSet rs2 = meta.getColumns(catalog, schemaSearchPattern, tableSearchPattern, null);
            while (rs2.next()) {
                ColumnWithLoc cwl = new ColumnWithLoc();
                cwl.tableKey = new DatabaseObjectKey(this.connectionName, rs2.getString(TABLE_CAT), rs2.getString("TABLE_SCHEM"), rs2.getString("TABLE_NAME"));
                cwl.column = new Column(rs2.getString("COLUMN_NAME"), rs2.getString(REMARKS), rs2.getString("TYPE_NAME"), null);
                result.add(cwl);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Could not fetch columns", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Table> getTables(SQLConnectionProvider.SQLConnectionWrapper conn, DatabaseMetaData meta) {
        List<Table> tables;
        Boolean oracleRemarksReportingEnabled = SQLUtils.getRemarksReportingForOracle(conn);
        if (oracleRemarksReportingEnabled != null && !oracleRemarksReportingEnabled.booleanValue()) {
            SQLUtils.setRemarksReportingForOracle(conn, true);
        }
        try {
            tables = this.getTables(conn.getConnectionData(), meta);
        }
        finally {
            if (oracleRemarksReportingEnabled != null && !oracleRemarksReportingEnabled.booleanValue()) {
                SQLUtils.setRemarksReportingForOracle(conn, false);
            }
        }
        Map<Object, Object> commentsByTable = new HashMap();
        if (conn.getConnectionData().getType() != ConnectionUtils.SQLConnectionType.DATABRICKS) {
            return tables;
        }
        try {
            commentsByTable = SQLUtils.getDatabricksCommentsOnTables(conn, null, null, null);
        }
        catch (SQLException e) {
            logger.warn((Object)"Could not fetch tables", (Throwable)e);
        }
        for (Table table : tables) {
            SQLUtils.SQLTable sqlTable = new SQLUtils.SQLTable(table.getTableKey().getCatalog(), table.getTableKey().getSchema(), table.getTableKey().getName());
            table.setRemarks((String)commentsByTable.get(sqlTable));
        }
        return tables;
    }

    public List<Table> getTables(SQLConnectionProvider.SQLConnectionData connData, DatabaseMetaData meta) {
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            ArrayList browsedTypes = Lists.newArrayList((Object[])new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM", "EXTERNAL_TABLE", "VIRTUAL_VIEW"});
            if (this.includeSystemTables) {
                browsedTypes.add("SYSTEM TABLE");
            }
            String filteringCatalog = SQLUtils.getFilteringCatalogToListSchemas(connData);
            ResultSet tablesRs = meta.getTables(filteringCatalog, null, null, browsedTypes.toArray(new String[0]));
            while (tablesRs.next()) {
                DatabaseObjectKey tableKey = new DatabaseObjectKey(this.connectionName, tablesRs.getString(TABLE_CAT), tablesRs.getString("TABLE_SCHEM"), tablesRs.getString("TABLE_NAME"));
                tables.add(new Table(tableKey, tablesRs.getString(TABLE_TYPE), tablesRs.getString(REMARKS)));
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Could not fetch tables", e);
        }
        return tables;
    }

    public List<Index> getIndexes(SQLConnectionProvider.SQLConnectionData connData, DatabaseMetaData meta) {
        ArrayList<Index> result = new ArrayList();
        try {
            result = this.getIndexByParameters(meta, null, null, null);
        }
        catch (Throwable e) {
            logger.warn((Object)"Could not fetch indices at once, trying by enumeration", e);
            for (Table table : this.getTables(connData, meta)) {
                try {
                    result.addAll(this.getIndexByParameters(meta, table.getTableKey().getCatalog(), table.getTableKey().getSchema(), table.getTableKey().name));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Could not fetch indices for table " + String.valueOf(table.getTableKey())), t);
                    return result;
                }
            }
        }
        return result;
    }

    private List<Index> getIndexByParameters(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        ArrayList<Index> result = new ArrayList<Index>();
        ResultSet indexInfoRs = meta.getIndexInfo(catalog, schema, table, false, false);
        while (indexInfoRs.next()) {
            DatabaseObjectKey tableKey = new DatabaseObjectKey(this.connectionName, indexInfoRs.getString(TABLE_CAT), indexInfoRs.getString("TABLE_SCHEM"), indexInfoRs.getString("TABLE_NAME"));
            result.add(new Index(tableKey, indexInfoRs.getString("INDEX_NAME"), indexInfoRs.getString("COLUMN_NAME"), indexInfoRs.getString("FILTER_CONDITION")));
        }
        return result;
    }

    public static class Table {
        public final DatabaseObjectKey tableKey;
        public final String type;
        public String remarks;

        public Table(DatabaseObjectKey tableKey, String type, String remarks) {
            this.tableKey = tableKey;
            this.type = type;
            this.remarks = remarks;
        }

        public DatabaseObjectKey getTableKey() {
            return this.tableKey;
        }

        public String getType() {
            return this.type;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public String toString() {
            return "Table{tableKey=" + String.valueOf(this.tableKey) + ", type='" + this.type + "', remarks='" + this.remarks + "'}";
        }
    }

    public static class ForeignKey {
        public final DatabaseObjectKey pkTableKey;
        public final DatabaseObjectKey fkTableKey;
        public final String pkColumnName;
        public final String fkColumnName;
        public final String pkName;
        public final String fkName;

        public ForeignKey(DatabaseObjectKey pkTableKey, DatabaseObjectKey fkTableKey, String pkColumnName, String fkColumnName, String pkName, String fkName) {
            this.pkTableKey = pkTableKey;
            this.fkTableKey = fkTableKey;
            this.pkColumnName = pkColumnName;
            this.fkColumnName = fkColumnName;
            this.pkName = pkName;
            this.fkName = fkName;
        }
    }

    public static class UserDefinedType {
        public final DatabaseObjectKey key;
        public final String className;
        public final String remarks;

        public UserDefinedType(DatabaseObjectKey key, String className, String remarks) {
            this.key = key;
            this.className = className;
            this.remarks = remarks;
        }
    }

    public static class UserDefinedTypeAttribute {
        public final DatabaseObjectKey typeKey;
        public final DatabaseObjectKey typeTableKey;
        public final String name;
        public final String typeName;
        public final String remarks;

        public UserDefinedTypeAttribute(DatabaseObjectKey typeKey, DatabaseObjectKey typeTableKey, String name, String typeName, String remarks) {
            this.typeKey = typeKey;
            this.typeTableKey = typeTableKey;
            this.name = name;
            this.typeName = typeName;
            this.remarks = remarks;
        }
    }

    public static class ColumnWithLoc {
        public DatabaseObjectKey tableKey;
        public Column column;
    }

    public static class Column {
        public final String name;
        public final String remarks;
        public final String typeName;
        public final String pseudoColumnUsage;

        public Column(String name, String remarks, String typeName, String pseudoColumnUsage) {
            this.name = name;
            this.remarks = remarks;
            this.typeName = typeName;
            this.pseudoColumnUsage = pseudoColumnUsage;
        }
    }

    public static class Index {
        public final DatabaseObjectKey tableKey;
        public final String name;
        public final String columnName;
        public final String condition;

        public Index(DatabaseObjectKey tableKey, String name, String columnName, String condition) {
            this.tableKey = tableKey;
            this.name = name;
            this.columnName = columnName;
            this.condition = condition;
        }
    }
}

