/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;

public class SybaseIQSQLDialect
extends GenericSQLDialect {
    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, -6, "tinyint null", new Integer[0]);
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, 5, "smallint null", new Integer[0]);
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, 4, "integer null", new Integer[0]);
            }
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.BIGINT, -5, "bigint null", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float null", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double null", new Integer[]{7, 2});
            }
            case STRING: {
                if (schemaColumn.getMaxLength() == -1) {
                    this.throwUnsupportedUnlimitedStringLength(schemaColumn.getName(), dataset);
                }
                return new DSSTypeSQLMapping(Type.STRING, -1, "varchar(" + schemaColumn.getMaxLength() + ") null", new Integer[]{2003, 1, 1111, 12, -16, -9});
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, 4, "integer null", new Integer[]{-7});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp null", new Integer[0]);
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case ARRAY: 
            case OBJECT: {
                this.throwUnhandledColumnType(schemaColumn, dataset);
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 32000;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    public int getIdentifiersMaxLength() {
        return -1;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return false;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public String getId() {
        return "SybaseIQ";
    }
}

