/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.datasets.sql.SynapseDatasetConfig;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NamedLock;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SynapseSQLDialect
extends SQLServerSQLDialect {
    private static final Logger logger = Logger.getLogger((String)"dku.sql.synapse");

    @Override
    public int getMaxPossibleVarcharLen() {
        return 4000;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return columnName;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "datetime2(3)", new Integer[]{91});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, "CONCAT", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                StringBuilder sb = new StringBuilder("CONCAT (");
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    String value = this.toSQLNoBrackets(args[i]);
                    if (SynapseSQLDialect.this.isStringType(args[i])) {
                        sb.append(value);
                    } else {
                        sb.append(" CAST( ").append(value).append(" AS NVARCHAR)");
                    }
                    sb.append(" COLLATE DATABASE_DEFAULT");
                }
                return sb.append(")").toString();
            }
        });
    }

    @Override
    public String getCreateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if ("custom".equals(config.tableCreationMode)) {
            String statement = config.customCreateStatement;
            return statement.replace("$DKU_CREATE_TABLE_FIELDS", this.getCreateTableFieldsSQL(dataset, messages));
        }
        String createTable = "CREATE TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n" + this.getCreateTableFieldsSQL(dataset, messages) + ")";
        if (ifNotExist) {
            return "IF OBJECT_ID(N'" + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + "', N'U') IS NULL\n" + createTable + this.getDistribution(dataset);
        }
        return createTable + this.getDistribution(dataset);
    }

    @Override
    public void createTableIfNeeded(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (this.shouldDelegatePrepareSqlWriteToJEK(dataset)) {
            this.delegatePrepareSqlWriteToJEK(dataset, Output.WriteMode.APPEND, null, messages);
        }
        String lockName = "com.dataiku.dip.synapse." + dataset.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            this.doCreateTableIfNeeded(authCtx, connData, conn, dataset, dropPartitionedTableOnSchemaMismatch, messages);
        }
    }

    private void doCreateTableIfNeeded(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        boolean autocommitMode;
        boolean partitioned = dataset.getPartitioningSchema().isPartitioned();
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        boolean bl = autocommitMode = "Synapse".equals(connData.getConnection().type) || connData.getConnection().getParams().autocommitMode;
        if (this.tableExists(authCtx, connData, conn, config.catalog, config.schema, config.table)) {
            try {
                SchemaReader.isManagedSchemaCompatible(dataset.getSchema(), dataset, conn, config.catalog, config.schema, config.table, connData);
            }
            catch (Exception e) {
                try {
                    this.ensureAutocommitMode(autocommitMode, conn);
                    if (partitioned && !dropPartitionedTableOnSchemaMismatch) {
                        throw new SQLException("Cannot write table" + config.table + ", table already exists but with an incompatible schema" + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
                    }
                    this.dropOnMismatch(conn, connData, config, dataset, e, messages);
                }
                catch (SQLException nested) {
                    this.checkIsAzureSynapse(conn);
                    throw nested;
                }
                finally {
                    this.restoreAutocommitMode(autocommitMode, conn);
                }
            }
        } else {
            try {
                this.ensureAutocommitMode(autocommitMode, conn);
                SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, new InfoMessage.InfoMessages(), false), messages);
            }
            catch (SQLException e) {
                this.checkIsAzureSynapse(conn);
                throw e;
            }
            finally {
                this.restoreAutocommitMode(autocommitMode, conn);
            }
        }
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " WITH (DISTRIBUTION = ROUND_ROBIN) AS " + selectExpr};
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        Object createTable = "";
        if (ifNotExist) {
            createTable = (String)createTable + "IF OBJECT_ID(N'" + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + "', N'U') IS NULL\n";
        }
        createTable = (String)createTable + "CREATE TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n";
        createTable = (String)createTable + this.getCreateTableFieldsSQL(dataset, messages);
        createTable = (String)createTable + ")";
        return (String)createTable + this.getDistribution(dataset);
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    protected boolean supportEscapeKeywordAfterLikeOperator() {
        return false;
    }

    @Override
    public void dropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (this.shouldDelegatePrepareSqlWriteToJEK(dataset)) {
            this.delegatePrepareSqlWriteToJEK(dataset, Output.WriteMode.OVERWRITE, partition, messages);
        }
        String lockName = "com.dataiku.dip.synapse." + dataset.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            this.doDropAndRecreateTableOrPartition(authCtx, connData, conn, dataset, partition, dropPartitionedTableOnSchemaMismatch, messages);
        }
    }

    private String getDistribution(Dataset dataset) {
        Object distributionConfig = "";
        if (dataset.getParams() instanceof SynapseDatasetConfig) {
            SynapseDatasetConfig synapseConfig = dataset.getParamsAs(SynapseDatasetConfig.class);
            if (synapseConfig.tableDistributionMode != null) {
                switch (synapseConfig.tableDistributionMode) {
                    case HASH: {
                        distributionConfig = "DISTRIBUTION = HASH(" + this.quoteIdentifier(synapseConfig.distributionHashColumn) + ")";
                        break;
                    }
                    case REPLICATE: {
                        distributionConfig = "DISTRIBUTION = REPLICATE";
                        break;
                    }
                    default: {
                        distributionConfig = "DISTRIBUTION = ROUND_ROBIN";
                        break;
                    }
                }
            } else {
                distributionConfig = "DISTRIBUTION = ROUND_ROBIN";
            }
        }
        return " WITH (" + (String)distributionConfig + ")";
    }

    private void doDropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        block13: {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
            String partitionId = partition != null ? partition.id() : null;
            boolean autocommitMode = "Synapse".equals(connData.getConnection().type) || connData.getConnection().getParams().autocommitMode;
            try {
                this.ensureAutocommitMode(autocommitMode, conn);
                if (dataset.getPartitioningSchema().isPartitioned()) {
                    logger.info((Object)("Preparing to write partition " + partitionId + " of " + dataset.getName()));
                    if (this.tableExists(authCtx, connData, conn, config.catalog, config.schema, config.table)) {
                        try {
                            SchemaReader.isManagedSchemaCompatible(dataset.getSchema(), dataset, conn, config.catalog, config.schema, config.table, connData);
                            logger.info((Object)"Table exists with compatible schema");
                        }
                        catch (Exception e) {
                            if (dropPartitionedTableOnSchemaMismatch) {
                                this.dropOnMismatch(conn, connData, config, dataset, e, messages);
                            }
                            throw new SQLException("Cannot write to partition " + partitionId + ", table already exists but with an incompatible schema: " + ExceptionUtils.getMessageWithCauses((Throwable)e), e);
                        }
                    } else {
                        logger.info((Object)"Creating table");
                        SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, false), messages);
                        conn.commit();
                    }
                    logger.info((Object)("Deleting records for " + partitionId));
                    ExpressionBuilder clause = ExpressionUtils.getPartitionFilterClause(dataset.getPartitioningSchema(), dataset, partition, connData.getDialect());
                    String deleteSQL = "DELETE FROM " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " WHERE " + clause.toSQL(this);
                    SQLUtils.safeExec(conn, deleteSQL, true, messages);
                    break block13;
                }
                try {
                    SQLUtils.safeExec(conn, "DROP TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table), messages);
                }
                catch (SQLException e) {
                    logger.info((Object)("Drop table failed, table probably did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
                logger.info((Object)"Creating table");
                SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, false), messages);
            }
            catch (SQLException e) {
                this.checkIsAzureSynapse(conn);
                throw e;
            }
            finally {
                this.restoreAutocommitMode(autocommitMode, conn);
            }
        }
    }

    public void checkIsAzureSynapse(SQLConnectionProvider.SQLConnectionWrapper conn) throws CodedIOException {
        String sqlServerVersion = this.getSQLServerVersion(conn);
        if (!this.isSQLServerDataWarehouse(sqlServerVersion)) {
            throw new CodedIOException((InfoMessage.MessageCode)SQLCodes.ERR_NOT_SYNAPSE, "'" + sqlServerVersion + "' does not look like an Azure Synapse Dedicated SQL pool.");
        }
    }

    private void ensureAutocommitMode(boolean autocommitMode, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException, CodedIOException {
        if (!autocommitMode) {
            conn.setAutoCommit(true);
            try {
                SQLUtils.safeExec(conn, "ROLLBACK TRANSACTION");
            }
            catch (SQLException e) {
                this.checkIsAzureSynapse(conn);
                throw e;
            }
        }
    }

    private void restoreAutocommitMode(boolean autocommitMode, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        if (!autocommitMode) {
            conn.setAutoCommit(false);
        }
    }

    private boolean isSQLServerDataWarehouse(String version) {
        return version != null && version.toLowerCase(Locale.ENGLISH).contains("data warehouse");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getSQLServerVersion(SQLConnectionProvider.SQLConnectionWrapper conn) {
        try (Statement statement = conn.createStatement();){
            String string;
            block18: {
                ResultSet resultSet;
                block16: {
                    String string2;
                    block17: {
                        resultSet = statement.executeQuery("SELECT @@VERSION");
                        try {
                            if (!resultSet.next()) break block16;
                            string2 = resultSet.getString(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                string = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return string;
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to retrieve SQL Server version", (Throwable)e);
            return null;
        }
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        if (rounding == DateRounding.WEEK || rounding == DateRounding.QUARTER) {
            throw new IllegalArgumentException("Rounding " + String.valueOf(rounding) + "  is not implemented on Synapse");
        }
        return super.dateTrunc(inputDateExpression, rounding);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        if (rounding == DateRounding.WEEK || rounding == DateRounding.QUARTER) {
            throw new IllegalArgumentException("Rounding " + String.valueOf(rounding) + "  is not implemented on Synapse");
        }
        return super.dateonlyTrunc(inputDateExpression, rounding);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        if (rounding == DateRounding.WEEK || rounding == DateRounding.QUARTER) {
            throw new IllegalArgumentException("Rounding " + String.valueOf(rounding) + "  is not implemented on Synapse");
        }
        return super.datetimenotzTrunc(inputDateExpression, rounding);
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        if (DatePart.DAY_OF_WEEK.equals((Object)part)) {
            return "(DATEPART(dw, " + inputDateExpression + ") + 5) % 7 + 1";
        }
        return super.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        if (DatePart.DAY_OF_WEEK.equals((Object)part)) {
            return "(DATEPART(dw, " + inputDateExpression + ") + 5) % 7 + 1";
        }
        return super.dateonlyPartExpression(inputDateExpression, part);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        if (DatePart.DAY_OF_WEEK.equals((Object)part)) {
            return "(DATEPART(dw, " + inputDateExpression + ") + 5) % 7 + 1";
        }
        return super.datetimenotzPartExpression(inputDateExpression, part);
    }

    @Override
    public String getLogClause(double base, String argument) {
        return this.getLogClauseForSingleArgumentLog(base, argument);
    }

    @Override
    public String getId() {
        return "Synapse";
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableMaterializedTemporaryTableWriter(this, false){

            @Override
            protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
                return String.format("SELECT TOP 0 * INTO %s FROM %s", tempFullName, targetFullName);
            }
        };
    }
}

