/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.TeradataDatasetConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.RowSizeLimiter;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.TeradataTz;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheLoader;
import com.dataiku.dss.shadelib.com.google.common.cache.LoadingCache;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TeradataSQLDialect
extends GenericSQLDialect {
    public static final long TOPN_MAX_VALUE = Integer.MAX_VALUE;
    private static final LoadingCache<String, DateTimeFormatter> dateParserCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, DateTimeFormatter>(){

        public DateTimeFormatter load(String assumedTz) {
            return DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.forID((String)assumedTz));
        }
    });
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql.teradata");

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, -6, "byteint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 6, "float", new Integer[]{7, 2});
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, -6, "byteint", new Integer[0]);
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp with time zone", new Integer[0]);
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[0]);
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public boolean hasCaseInsensitiveComparisons() {
        return true;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        StringBuilder sb = new StringBuilder();
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        sb.append("CREATE MULTISET TABLE " + (ifNotExist ? "IF NOT EXISTS " : "") + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        int i = 0;
        for (SchemaColumn col : dataset.getSchema().getColumns()) {
            sb.append("\t" + this.quoteIdentifier(col.getName()) + " " + this.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl);
            if (i < dataset.getSchema().getColumns().size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        sb.append(")");
        if (dataset.getParams() instanceof TeradataDatasetConfig) {
            TeradataDatasetConfig datasetParams = dataset.getParamsAs(TeradataDatasetConfig.class);
            switch (datasetParams.primaryIndexBehavior) {
                case AUTO: {
                    break;
                }
                case EXPLICIT_COLUMNS: {
                    if (datasetParams.primaryIndexIsUnique) {
                        sb.append(" UNIQUE PRIMARY INDEX (");
                    } else {
                        sb.append(" PRIMARY INDEX (");
                    }
                    boolean first = true;
                    for (String column : datasetParams.primaryIndexColumns) {
                        if (!first) {
                            sb.append(",");
                        }
                        first = false;
                        sb.append(this.quoteIdentifier(column));
                    }
                    sb.append(")");
                    break;
                }
                case NOPI: {
                    sb.append(" NO PRIMARY INDEX");
                }
            }
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public void dropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (this.shouldDelegatePrepareSqlWriteToJEK(dataset)) {
            this.delegatePrepareSqlWriteToJEK(dataset, Output.WriteMode.OVERWRITE, partition, messages);
        }
        String lockName = "com.dataiku.dip.teradata." + dataset.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            this.doDropAndRecreateTableOrPartition(authCtx, connData, conn, dataset, partition, dropPartitionedTableOnSchemaMismatch, messages);
        }
    }

    private void doDropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        String partitionId;
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        String string = partitionId = partition != null ? partition.id() : null;
        if (dataset.getPartitioningSchema().isPartitioned()) {
            logger.info((Object)("Preparing to write partition " + partitionId + " of " + dataset.getName()));
            if (this.tableExists(authCtx, connData, conn, config.catalog, config.schema, config.table)) {
                try {
                    SchemaReader.isManagedSchemaCompatible(dataset.getSchema(), dataset, conn, config.catalog, config.schema, config.table, connData);
                    logger.info((Object)"Table exists with compatible schema");
                }
                catch (Exception e) {
                    if (dropPartitionedTableOnSchemaMismatch) {
                        this.dropOnMismatch(conn, connData, config, dataset, e, messages);
                    }
                    throw new SQLException("Cannot write to partition " + partitionId + ", table already exists but with an incompatible schema: " + e.getMessage(), e);
                }
            } else {
                logger.info((Object)"Creating table");
                SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, false), messages);
                conn.commit();
            }
            logger.info((Object)("Deleting records for " + partitionId));
            ExpressionBuilder clause = ExpressionUtils.getPartitionFilterClause(dataset.getPartitioningSchema(), dataset, partition, connData.getDialect());
            String deleteSQL = "DELETE FROM " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " WHERE " + clause.toSQL(this);
            SQLUtils.safeExec(conn, deleteSQL, true, messages);
        } else {
            try {
                SQLUtils.safeExec(conn, "DROP TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table), messages);
                conn.commit();
            }
            catch (SQLException e) {
                logger.info((Object)("Drop table failed, table probably did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                conn.rollback();
            }
            logger.info((Object)"Creating table");
            SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, false), messages);
        }
        conn.commit();
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.STRING && maxLength > 0) {
            return "CAST(" + expr + " AS VARCHAR(" + Math.min(12000, maxLength) + "))";
        }
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS VARCHAR(100)) = '' THEN NULL ELSE REGEXP_SIMILAR(CAST(" + expr + " AS VARCHAR(100)), '^" + this.booleanTrueValuesRegex + "$', 'i') END";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST_BOOL_TO_COLUMN, "CAST", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return String.format("CAST(CASE WHEN %s THEN 1 ELSE 0 END AS BYTEINT)", ret);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TRANSLATE, "OTRANSLATE", QueryUtils.Arity.TERNARY);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.MOD, "%", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.MOD.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String op1Expr = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.MOD.priority);
                String op2Expr = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.MOD.priority);
                return op1Expr + " MOD " + op2Expr;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (args.length > 2 && args[2] != null && args[2] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[2]).value instanceof String && args[1] != null && args[1] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[1]).value instanceof String) {
                    String tzId1 = (String)((QueryAst.ConstExpr)args[1]).value;
                    String tzId2 = (String)((QueryAst.ConstExpr)args[2]).value;
                    if (TeradataTz.JAVA_TZ_TO_TERADATA_TZ.containsKey((Object)tzId1)) {
                        tzId1 = (String)TeradataTz.JAVA_TZ_TO_TERADATA_TZ.get((Object)tzId1);
                    }
                    if (TeradataTz.JAVA_TZ_TO_TERADATA_TZ.containsKey((Object)tzId2)) {
                        tzId2 = (String)TeradataTz.JAVA_TZ_TO_TERADATA_TZ.get((Object)tzId2);
                    }
                    String asTstz = "CAST(CAST(CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP) AS VARCHAR(19)) || '+00:00' AS TIMESTAMP) AT TIME ZONE '" + tzId2 + "' ";
                    String shifted = "(" + asTstz + ") + CAST(EXTRACT(TIMEZONE_HOUR FROM (" + asTstz + ") AT TIME ZONE '" + tzId1 + "') AS INTERVAL HOUR)";
                    return "(" + shifted + ")";
                }
                if (args.length > 1 && args[1] != null && args[1] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[1]).value instanceof String) {
                    String tzId = (String)((QueryAst.ConstExpr)args[1]).value;
                    if (TeradataTz.JAVA_TZ_TO_TERADATA_TZ.containsKey((Object)tzId)) {
                        tzId = (String)TeradataTz.JAVA_TZ_TO_TERADATA_TZ.get((Object)tzId);
                    }
                    String asTstz = "CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP WITH TIME ZONE)";
                    String shifted = "(" + asTstz + ") - CAST(EXTRACT(TIMEZONE_HOUR FROM (" + asTstz + ") AT TIME ZONE '" + tzId + "') AS INTERVAL HOUR)";
                    return "(" + shifted + ")";
                }
                return "CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP) AT LOCAL ";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs < 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args.length == 0) {
                    return "NULL";
                }
                Type type = this.getParamAs(args[0], Type.class);
                Integer maxLength = this.getParamAs(args[1], Integer.class);
                if (type == Type.STRING && (maxLength == null || maxLength < 0 || maxLength > TeradataSQLDialect.this.getMaxPossibleVarcharLen())) {
                    maxLength = 10;
                }
                return TeradataSQLDialect.this.cast("NULL", null, type, maxLength);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                ArrayList exprs = Lists.newArrayList();
                for (QueryAst.Expr arg : args) {
                    exprs.add(this.toSQLWithBrackets(arg));
                }
                return "(" + Joiner.on((String)" || ").join((Iterable)exprs) + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String end = "CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP)";
                String start = "CAST(" + this.toSQLNoBrackets(args[1]) + " AS TIMESTAMP)";
                String unit = this.getParamAs(args[2], String.class);
                String diffAsTimestamp = "(" + end + " - " + start + ")";
                String diffAsDate = "(CAST(" + end + " AS DATE) - CAST(" + start + " AS DATE))";
                switch (unit) {
                    case "YEAR": 
                    case "MONTH": {
                        String daytimeDiff = "(CAST(TO_CHAR(" + end + ", 'DDHH24MISS') AS FLOAT) - CAST(TO_CHAR(" + start + ", 'DDHH24MISS') AS FLOAT))";
                        String diff = "CAST(CAST((" + diffAsTimestamp + " MONTH(4)) AS INTEGER)  + " + daytimeDiff + " / 100000000.0 AS INTEGER)";
                        return unit.equals("YEAR") ? "(" + diff + ") / 12" : diff;
                    }
                    case "WEEK": 
                    case "DAY": {
                        String timeDiff = "(CAST(TO_CHAR(" + end + ", 'HH24MISS') AS FLOAT) - CAST(TO_CHAR(" + start + ", 'HH24MISS') AS FLOAT))";
                        String diff = "CAST(" + diffAsDate + " + " + timeDiff + " / 1000000.0 AS INTEGER)";
                        return unit.equals("WEEK") ? "(" + diff + ") / 7" : diff;
                    }
                    case "HOUR": {
                        return "(EXTRACT(DAY FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)) * 24 + EXTRACT(HOUR FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)))";
                    }
                    case "MINUTE": {
                        return "(EXTRACT(DAY FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)) * 1440 + EXTRACT(HOUR FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)) * 60 + EXTRACT(MINUTE FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)))";
                    }
                    case "SECOND": {
                        return "(EXTRACT(DAY FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)) * 86400 + EXTRACT(HOUR FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)) * 3600 + EXTRACT(MINUTE FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)) * 60 + EXTRACT(SECOND FROM (" + diffAsTimestamp + " DAY(4) TO SECOND)))";
                    }
                }
                throw new IllegalArgumentException("Cannot compute date difference for unit: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NOT, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.NOT.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String arg1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.NOT.priority);
                return "NOT " + arg1;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <> " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String oneIsNull = null;
                if (!aIsConst && !bIsConst) {
                    oneIsNull = a2 + " IS NULL AND " + b2 + " IS NOT NULL OR " + a2 + " IS NOT NULL AND " + b2 + " IS NULL";
                } else if (!aIsConst) {
                    oneIsNull = a2 + " IS NULL";
                } else if (!bIsConst) {
                    oneIsNull = b2 + " IS NULL";
                }
                if (oneIsNull != null) {
                    ret = ret + " OR " + oneIsNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " > " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                Type aType = args[0].outputType != null ? args[0].outputType.dssType : null;
                Type bType = args[1].outputType != null ? args[1].outputType.dssType : null;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " < " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " >= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.EQ, "=", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " = " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String bothNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNull = a2 + " IS NULL AND " + b2 + " IS NULL";
                }
                if (bothNull != null) {
                    ret = ret + " OR " + bothNull;
                }
                return ret;
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, true, true){

            @Override
            QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
                return new QueryAst.InlineExpr("REGEXP_REPLACE(" + this.toSQLNoBrackets(expr) + ", '([%_\\\\])', '\\\\\\1')");
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, true, true){

            @Override
            QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
                return new QueryAst.InlineExpr("REGEXP_REPLACE(" + this.toSQLNoBrackets(expr) + ", '([%_\\\\])', '\\\\\\1')");
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, true, true){

            @Override
            QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
                return new QueryAst.InlineExpr("REGEXP_REPLACE(" + this.toSQLNoBrackets(expr) + ", '([%_\\\\])', '\\\\\\1')");
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISTRUE, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                return x + " <> 0 AND " + x2 + " IS NOT NULL";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISFALSE, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                return x + " = 0 AND " + x2 + " IS NOT NULL";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SET_CASE_SENSITIVITY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (this.getParamAs(args[1], Boolean.class).booleanValue()) {
                    return "(" + this.toSQLNoBrackets(args[0]) + " (CASESPECIFIC))";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_cont(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_SIMILAR(" + input + ", '.*'||" + regex + "||'.*') > 0";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    String converted;
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    DateTimeZone timezone = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
                    int offset = timezone.getStandardOffset(0L) / 1000 / 60;
                    if (requestedType == Type.DATEONLY) {
                        String sqlFormat = TeradataSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "CAST(" + input + " AS DATE FORMAT '" + sqlFormat + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        String sqlFormat = TeradataSQLDialect.this.toDateFormat(jodaFormat, true);
                        return "CAST(" + input + " AS TIMESTAMP FORMAT '" + sqlFormat + "')";
                    }
                    if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
                        converted = "CAST(" + input + " AS TIMESTAMP)";
                    } else {
                        String sqlFormat = TeradataSQLDialect.this.toDateFormat(jodaFormat, true);
                        converted = "CAST(" + input + " AS TIMESTAMP FORMAT '" + sqlFormat + "')";
                    }
                    if (offset == 0) {
                        return converted;
                    }
                    int offsetMI = offset % 60;
                    int offsetHH = offset / 60;
                    String tz = (offsetHH < 0 ? "-" : "+") + (Math.abs(offsetHH) < 10 ? "0" : "") + String.valueOf(Math.abs(offsetHH)) + ":" + (Math.abs(offsetMI) < 10 ? "0" : "") + String.valueOf(Math.abs(offsetMI));
                    return "CAST((TO_CHAR(" + converted + ", 'YYYY-MM-DD HH24:MI:SS') || '" + tz + "') AS TIMESTAMP WITH TIME ZONE) AT TIME ZONE 'GMT'";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    Object sqlFormat = TeradataSQLDialect.this.toDateFormat(jodaFormat, false);
                    boolean hasMonthOrDayName = false;
                    for (DKUDateUtils.FormatPatternPart part : DKUDateUtils.parsePattern((String)jodaFormat, (boolean)false)) {
                        if (part.numeric || part.type != DKUDateUtils.FormatPatternPartType.MONTH && part.type != DKUDateUtils.FormatPatternPartType.DAYOFWEEK) continue;
                        hasMonthOrDayName = true;
                    }
                    if (hasMonthOrDayName) {
                        sqlFormat = "FM" + (String)sqlFormat;
                    }
                    if (requestedType == Type.DATEONLY || requestedType == Type.DATETIMENOTZ) {
                        return "TO_CHAR(" + input + ", '" + (String)sqlFormat + "')";
                    }
                    if (StringUtils.isBlank((String)timezoneId) || StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return "TO_CHAR(" + input + " AT TIME ZONE 'GMT', '" + (String)sqlFormat + "')";
                    }
                    if (TeradataTz.JAVA_TZ_TO_TERADATA_TZ.containsKey((Object)timezoneId)) {
                        timezoneId = (String)TeradataTz.JAVA_TZ_TO_TERADATA_TZ.get((Object)timezoneId);
                    }
                    return "TO_CHAR(" + input + " AT TIME ZONE '" + timezoneId + "', '" + (String)sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "CAST(", " AS TIMESTAMP)"));
        this.removeOperator(QueryUtils.OperatorType.NTILE);
        this.addGenericFunction(QueryUtils.OperatorType.COSH, "COSH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SINH, "SINH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TANH, "TANH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", true));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(INSTR(", ", COALESCE(", ", '')) - 1)", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.LAST_INDEX_OF, "(INSTR(", ", COALESCE(", ", ''), -1) - 1)", false));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.DEC2HEX, "LOWER(FROM_BYTES(TO_BYTE(", "), 'base16'))"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE"));
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.IN, "IN", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                QueryAst.Expr left = args[0];
                QueryAst.Expr right = args[1];
                if (right instanceof QueryAst.ListExpr) {
                    QueryAst.ListExpr listExpr = (QueryAst.ListExpr)right;
                    boolean switchToOR = false;
                    for (QueryAst.Expr value2 : listExpr.getItems()) {
                        char c2;
                        String s;
                        if (value2 instanceof QueryAst.ConstExpr || value2 instanceof QueryAst.InlineExpr && ((s = ((QueryAst.InlineExpr)value2).expr).isEmpty() || s.toLowerCase().startsWith("date") || s.toLowerCase().startsWith("timestamp") || (c2 = s.charAt(0)) == '\'' || Character.isDigit(c2) || c2 == '.' || c2 == '-' || c2 == '+')) continue;
                        switchToOR = true;
                        break;
                    }
                    if (switchToOR) {
                        List<QueryAst.Expr> conditions = listExpr.getItems().stream().map(value -> new QueryAst.OperatorExpr(QueryUtils.OperatorType.EQ, left, (QueryAst.Expr)value)).collect(Collectors.toList());
                        QueryAst.OperatorExpr orExpr = new QueryAst.OperatorExpr(QueryUtils.OperatorType.OR, conditions.toArray(new QueryAst.Expr[0]));
                        return this.toSQLWithBrackets(orExpr);
                    }
                }
                return super.apply(args);
            }
        });
    }

    @Override
    protected String makeSimpleReplace(QueryUtils.AbstractOperator op, QueryAst.Expr[] args) {
        return String.format("OREPLACE(%1$s, %2$s, %3$s)", op.toSQLNoBrackets(args[0]), op.toSQLNoBrackets(args[1]), op.toSQLNoBrackets(args[2]));
    }

    @Override
    protected String makeReplaceWhereEmpty(QueryUtils.AbstractOperator op, ExpressionBuilder.ExpressionBuilderFactory ebf, QueryAst.Expr[] args) {
        return op.toSQLNoBrackets(ebf.caseWhen((Object[])new Object[]{ebf.expr((QueryAst.Expr)args[0]).isnull(), ebf.cst(null), ebf.expr((QueryAst.Expr)args[0]).regexpReplace((Object)ebf.cst((Object)".{0}"), (Object)args[2])}).concat((Object[])new Object[]{args[2]}).expr);
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return true;
    }

    @Override
    public String quoteDate(String str) {
        return "TIMESTAMP " + this.quoteString(str);
    }

    @Override
    public String quoteDateOnly(String str) {
        return "DATE " + this.quoteString(str);
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "TIMESTAMP " + this.quoteString(str);
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, true, false);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false, true);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false, false);
    }

    private String temporalPartExpression(String inputDateExpression, DatePart part, boolean tzAware, boolean isDateOnly) {
        Object inputDate = tzAware ? "(" + inputDateExpression + ") AT TIME ZONE 'GMT'" : inputDateExpression;
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + (String)inputDate + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + (String)inputDate + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + (String)inputDate + ")";
            }
            case SECOND_OF_MINUTE: {
                return "FLOOR(EXTRACT(SECOND FROM " + (String)inputDate + "))";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR((EXTRACT(SECOND FROM " + (String)inputDate + ") * 1000) MOD 1000)";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + (String)inputDate + ")";
            }
            case WEEK_OF_YEAR: {
                Object asDateOnly = isDateOnly ? inputDate : "CAST(" + (String)inputDate + " AS DATE)";
                return "WEEKNUMBER_OF_YEAR(" + (String)asDateOnly + ", 'ISO')";
            }
            case QUARTER_OF_YEAR: {
                return "(1 + ((EXTRACT(MONTH FROM " + (String)inputDate + ") - 1) / 3))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + (String)inputDate + ")";
            }
            case DAY_OF_WEEK: {
                Object asDateOnly = isDateOnly ? inputDate : "CAST(" + (String)inputDate + " AS DATE)";
                return "(1 + ((td_day_of_week(" + (String)asDateOnly + ") + 5) MOD 7))";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(to_char(" + (String)inputDate + ", 'PE') as bigint)";
            }
            case MILLIS_FROM_EPOCH: {
                return "(" + this.datePartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH) + " * cast(1000 as bigint) + cast(" + this.datePartExpression(inputDateExpression, DatePart.MILLISECOND_OF_SECOND) + " as bigint))";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Teradata", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false, "timestamp with time zone");
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, true, "date");
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false, "timestamp");
    }

    private String temporalTrunc(String inputDateExpression, DateRounding rounding, boolean isDateOnly, String outputSqlType) {
        Object inputDate = isDateOnly ? inputDateExpression : "(" + inputDateExpression + ") AT TIME ZONE 'GMT'";
        switch (rounding) {
            case DAY: {
                return "cast(to_char(" + (String)inputDate + ", 'YYYYMMDD') as " + outputSqlType + " format 'YYYYMMDD')";
            }
            case HOUR: {
                return "cast(to_char(" + (String)inputDate + ", 'YYYYMMDDHH24') as " + outputSqlType + " format 'YYYYMMDDHH')";
            }
            case MINUTE: {
                return "cast(to_char(" + (String)inputDate + ", 'YYYYMMDDHH24MI') as " + outputSqlType + " format 'YYYYMMDDHHMI')";
            }
            case SECOND: {
                return "cast(to_char(" + (String)inputDate + ", 'YYYYMMDDHH24MISS') as " + outputSqlType + " format 'YYYYMMDDHHMISS')";
            }
            case MONTH: {
                return "cast(to_char(" + (String)inputDate + ", 'YYYYMM') as " + outputSqlType + " format 'YYYYMM')";
            }
            case YEAR: {
                return "cast(to_char(" + (String)inputDate + ", 'YYYY') as " + outputSqlType + " format 'YYYY')";
            }
            case WEEK: {
                return "td_monday(" + (String)inputDate + ")";
            }
            case QUARTER: {
                return "td_quarter(" + (String)inputDate + ")";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String useUTCTimezone() {
        return "SET TIME ZONE 'GMT'";
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATE: {
                long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid datetime with tz: " + dssStrVal);
                }
                this.ensureThreadLocalsAreHere();
                timestamp = ((DateTimeZone)this.localTz.get()).convertLocalToUTC(timestamp, false);
                ps2.setObject(colIdx, new Timestamp(timestamp));
                break;
            }
            case DATETIMENOTZ: {
                long timestamp = this.typeDatetimeNoTz.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid datetime no tz: " + dssStrVal);
                }
                this.ensureThreadLocalsAreHere();
                timestamp = ((DateTimeZone)this.localTz.get()).convertLocalToUTC(timestamp, false);
                ps2.setObject(colIdx, new Timestamp(timestamp));
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 32000;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        query = query.trim();
        if (Pattern.compile("sample [0-9]").matcher(query.toLowerCase().replaceAll("[^A-z0-9-_\\.]", " ")).find()) {
            return query;
        }
        if (Pattern.compile("^select\\s+top\\s+[0-9]").matcher(query.toLowerCase().replaceAll("[^A-z0-9-_\\.]", " ")).find()) {
            return query;
        }
        if (query.toLowerCase().startsWith("select")) {
            return "select top " + size + " " + query.substring("select".length());
        }
        return query;
    }

    @Override
    public SQLDialect.LimitMethod getLimitMethod() {
        return SQLDialect.LimitMethod.TOP;
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE VOLATILE MULTISET TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") ON COMMIT PRESERVE ROWS";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE VOLATILE MULTISET TABLE " + this.getQuotedTableFullName(table) + " AS (" + selectExpr + ") WITH DATA ON COMMIT PRESERVE ROWS"};
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 91: {
                if (dssType == Type.DATE) {
                    String dateStr = rs2.getString(colIdx);
                    if (dateStr == null) {
                        return null;
                    }
                    try {
                        DateTimeZone tz = assumedTz != null ? assumedTz : DateTimeZone.UTC;
                        long dt = ((DateTimeFormatter)dateParserCache.get((Object)tz.getID())).parseMillis(dateStr);
                        return DKUtils.isoFormatReadableByDateFormat((long)dt);
                    }
                    catch (RuntimeException | ExecutionException e) {
                        return null;
                    }
                }
                return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
            }
            case 93: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    if (timestampNoTzAsDate) {
                        Timestamp ts = rs2.getTimestamp(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : (Calendar)this.localCalendar.get());
                        if (ts == null) {
                            return null;
                        }
                        ts = new Timestamp(ts.getTime());
                        return DKUtils.isoFormatReadableByDateFormatFromTimestampWithCorrectToString((Timestamp)ts);
                    }
                    Timestamp ts = rs2.getTimestamp(colIdx, (Calendar)this.utcCalendar.get());
                    if (ts == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormatFromTimestampWithCorrectToString((Timestamp)ts);
                }
                if (dssType == Type.DATETIMENOTZ) {
                    return rs2.getString(colIdx);
                }
                return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return sqlTypeName.equalsIgnoreCase("timestamp");
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.NONE;
    }

    @Override
    public boolean needsToHaveTrailingSemicolonsRemoved() {
        return false;
    }

    @Override
    public String getCreateIndexStatement(String indexName, SQLUtils.SQLTable table, String quotedFieldsList) {
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " (" + quotedFieldsList + ") ON " + this.getQuotedTableFullName(table);
    }

    @Override
    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> keyColumns, InfoMessage.InfoMessages messages) {
        RowSizeLimiter limiter = new RowSizeLimiter("Teradata", DatasetCodes.WARN_DATASET_TERADATA_SCHEMA_TOO_LARGE, 64000, 2, true);
        limiter.setDefaultLengthForSchemaColumn(schema, keyColumns, messages);
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public boolean canStddevAsAnalyticalFunctions() {
        return false;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE) {
            if (forParsing) {
                return "Z";
            }
            return part.numeric ? "TZH:TZM" : "TZR";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK) {
            if (part.numeric) {
                return forParsing ? "E" : "D";
            }
            if (part.shortened) {
                return forParsing ? "EEE" : "Dy";
            }
            return forParsing ? "EEEE" : "Day";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.MONTH) {
            if (part.numeric) {
                return "MM";
            }
            if (part.shortened) {
                return forParsing ? "MMM" : "Mon";
            }
            return forParsing ? "MMMM" : "Month";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.HOUR) {
            return forParsing ? "HH" : "HH24";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.HOUROFHALFDAY) {
            return "HH";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.HALFDAY) {
            return forParsing ? "T" : "AM";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.MILLISECOND) {
            return forParsing ? "S(F)" : "FFF";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            if (forParsing) {
                Pattern nonAdmissible = Pattern.compile("[^ ,.:/'hms-]");
                if (nonAdmissible.matcher(part.text).find()) {
                    throw new IllegalArgumentException("teradata format can only contain ' ,.:/'hms-' between elements");
                }
                return part.text.replace(' ', 'B');
            }
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
            if (toEscape.matcher(part.text).matches()) {
                return "\"" + part.text.replace("\"", "\\\\\"") + "\"";
            }
            return part.text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            throw new IllegalArgumentException("Clock-hour is not supported by teradata");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEK) {
            if (forParsing) {
                throw new IllegalArgumentException("ISO week parsing not supported by teradata");
            }
            return "IW";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR && forParsing) {
            throw new IllegalArgumentException("ISO week parsing not supported by teradata");
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
            return forParsing ? SQLCapability.nok("Cannot parse week/year pairs") : SQLCapability.ok();
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Cannot handle clock hour");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            return forParsing && Pattern.compile("[^ ,.:/'hms-]").matcher(part.text).find() ? SQLCapability.nok("Can only handle ' ,.:/'hms-' as text in parsing formats") : SQLCapability.ok();
        }
        if (forParsing && part.text.length() == 1 && (part.type == DKUDateUtils.FormatPatternPartType.YEAR || part.type == DKUDateUtils.FormatPatternPartType.MONTH || part.type == DKUDateUtils.FormatPatternPartType.DAY || part.type == DKUDateUtils.FormatPatternPartType.HOUR || part.type == DKUDateUtils.FormatPatternPartType.MINUTE || part.type == DKUDateUtils.FormatPatternPartType.SECOND)) {
            return SQLCapability.nok("Cannot handle single-char format elements");
        }
        return SQLCapability.ok();
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        if (DKUDateUtils.isISO8601FormatString((String)jodaFormat)) {
            return SQLCapability.ok();
        }
        return super.canFormatDate(jodaFormat, forParsing);
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        return abilities;
    }

    @Override
    public String getId() {
        return "Teradata";
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT DatabaseName, TableName FROM DBC.TablesV WHERE TableKind = 'V' AND TableName LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "DatabaseName", "");
    }

    @Override
    public SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        if (seed != null) {
            return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            return SQLDialect.RandomSampleClauseLocation.FROM;
        }
        return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        StringBuilder sb = new StringBuilder();
        sb.append("SAMPLE ");
        switch (sample.samplingMethod) {
            case RANDOM_FIXED_NB_EXACT: 
            case RANDOM_FIXED_NB: {
                sb.append(sample.rows);
                break;
            }
            case RANDOM_FIXED_RATIO: {
                if (sample.ratio == 1.0) {
                    return "";
                }
                sb.append(sample.ratio);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(sample.samplingMethod) + " sampling is not available for Teradata");
            }
        }
        return sb.toString();
    }

    @Override
    public String getLogClause(double base, String argument) {
        return this.getLogClauseForSingleArgumentLog(base, argument);
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, true, false, false);
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromUpdateSelectWriter(this, true, true);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableMaterializedTemporaryTableWriter(this, false){

            @Override
            protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
                return String.format("CREATE TABLE %s AS (SELECT * FROM %s) WITH NO DATA", tempFullName, targetFullName);
            }

            @Override
            protected String getTruncateTableCommand(String table) {
                return String.format("DELETE %s ALL", table);
            }
        };
    }
}

