/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.sql.bigquery.WriteStreamNotFoundException;
import com.dataiku.dip.sql.bigquery.Writer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.google.api.core.ApiFuture;
import com.dataiku.dss.shadelib.com.google.api.core.ApiFutureCallback;
import com.dataiku.dss.shadelib.com.google.api.core.ApiFutures;
import com.dataiku.dss.shadelib.com.google.api.gax.rpc.NotFoundException;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.Exceptions;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.TableName;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.TableSchema;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.WriteStream;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.MoreExecutors;
import com.dataiku.dss.shadelib.com.google.protobuf.Descriptors;
import com.dataiku.dss.shadelib.org.threeten.bp.ZoneId;
import com.dataiku.dss.shadelib.org.threeten.bp.ZoneOffset;
import com.dataiku.dss.shadelib.org.threeten.bp.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.threeten.bp.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.threeten.bp.format.TextStyle;
import com.dataiku.dss.shadelib.org.threeten.bp.temporal.ChronoField;
import com.dataiku.dss.shadelib.org.threeten.bp.temporal.TemporalAccessor;
import com.dataiku.dss.shadelib.org.threeten.bp.temporal.TemporalField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class BasicWriter
implements Writer<JSONArrayWorker> {
    private static final DateTimeFormatter timestampFormatter = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ofPattern((String)"yyyy[/][-]MM[/][-]dd")).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendValue((TemporalField)ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue((TemporalField)ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue((TemporalField)ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendValue((TemporalField)ChronoField.MILLI_OF_SECOND, 3).optionalEnd().optionalStart().appendFraction((TemporalField)ChronoField.MICRO_OF_SECOND, 3, 6, true).optionalEnd().optionalStart().appendFraction((TemporalField)ChronoField.NANO_OF_SECOND, 6, 9, true).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendOffset("+HH:MM", "+00:00").optionalEnd().optionalStart().appendOffset("+HHMM", "+0000").optionalEnd().optionalStart().appendOffset("+HH", "+00").optionalEnd().optionalStart().appendZoneText(TextStyle.SHORT).optionalEnd().optionalStart().appendLiteral('Z').optionalEnd().toFormatter().withZone((ZoneId)ZoneOffset.UTC);
    private final BigQueryWriteClient client;
    private final TableName tableName;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.client.native");

    BasicWriter(BigQueryWriteClient client, TableName tableName) {
        Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName cannot be null");
        this.client = client;
        this.tableName = tableName;
    }

    @Override
    public JSONArrayWorker createJSONArrayWorker() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        WriteStream stream = WriteStream.newBuilder().setType(WriteStream.Type.PENDING).build();
        CreateWriteStreamRequest createStreamRequest = CreateWriteStreamRequest.newBuilder().setParent(this.tableName.toString()).setWriteStream(stream).build();
        return new JSONArrayWorker(createStreamRequest);
    }

    @Override
    public void commit(JSONArrayWorker worker) throws IOException {
        ArrayList<JSONArrayWorker> workers = new ArrayList<JSONArrayWorker>();
        workers.add(worker);
        this.commit((Iterable<JSONArrayWorker>)workers);
    }

    @Override
    public void commit(Iterable<JSONArrayWorker> workers) throws IOException {
        Iterable streamNames = StreamSupport.stream(workers.spliterator(), false).map(w -> w.streamWriter.getStreamName()).collect(Collectors.toList());
        BatchCommitWriteStreamsRequest commitRequest = BatchCommitWriteStreamsRequest.newBuilder().setParent(this.tableName.toString()).addAllWriteStreams(streamNames).build();
        BatchCommitWriteStreamsResponse commitResponse = this.client.batchCommitWriteStreams(commitRequest);
        if (!commitResponse.hasCommitTime()) {
            commitResponse.getStreamErrorsList().forEach(err -> logger.errorV("Commit stream error: %s", new Object[]{err.getErrorMessage()}));
            throw new IOException("Failed to commit write streams");
        }
    }

    public class JSONArrayWorker
    implements Writer.JSONArrayWorker {
        private final JsonStreamWriter streamWriter;
        private final List<TableFieldSchema> timestampFields;
        private final Phaser inflightRequestCount = new Phaser(1);
        @GuardedBy(value="lock")
        private IOException error;
        private final Object lock = new Object();
        private boolean streamStarted = false;

        private JSONArrayWorker(CreateWriteStreamRequest createStreamRequest) throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
            WriteStream stream;
            try {
                stream = BasicWriter.this.client.createWriteStream(createStreamRequest);
            }
            catch (Throwable t) {
                throw this.convertThrowableToIOException(t);
            }
            TableSchema tableSchema = stream.getTableSchema();
            this.validateTableSchema(tableSchema);
            this.streamWriter = JsonStreamWriter.newBuilder((String)stream.getName(), (TableSchema)tableSchema, (BigQueryWriteClient)BasicWriter.this.client).build();
            this.timestampFields = tableSchema.getFieldsList().stream().filter(tfs -> tfs.getType() == TableFieldSchema.Type.TIMESTAMP).collect(Collectors.toList());
        }

        @Override
        public void append(JSONArray data, long offset) throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
            this.fixUpTimestampFormat(data);
            if (this.streamStarted) {
                this.checkNoError();
                this.inflightRequestCount.register();
                ApiFuture future = this.streamWriter.append(data, offset);
                ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new AppendCompleteCallback(this), (Executor)MoreExecutors.directExecutor());
            } else {
                try {
                    this.streamWriter.append(data, offset).get();
                }
                catch (ExecutionException e) {
                    throw this.convertThrowableToIOException(e.getCause());
                }
                this.streamStarted = true;
            }
        }

        private void fixUpTimestampFormat(JSONArray data) {
            if (this.timestampFields.isEmpty()) {
                return;
            }
            for (int i = 0; i < data.length(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                for (TableFieldSchema field : this.timestampFields) {
                    String fieldName = field.getName();
                    String value = jsonObject.optString(fieldName, null);
                    if (value == null) continue;
                    TemporalAccessor parsedTime = timestampFormatter.parse((CharSequence)value);
                    jsonObject.put(fieldName, (Object)DateTimeFormatter.ISO_INSTANT.format(parsedTime));
                }
            }
        }

        @Override
        public void finalizeStream() throws IOException {
            this.closeStreamWriter();
            this.checkNoError();
            BasicWriter.this.client.finalizeWriteStream(this.streamWriter.getStreamName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNoError() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.error != null) {
                    throw this.error;
                }
            }
        }

        @Override
        public void close() {
            this.closeStreamWriter();
        }

        private void closeStreamWriter() {
            this.inflightRequestCount.arriveAndAwaitAdvance();
            this.streamWriter.close();
        }

        private IOException convertThrowableToIOException(Throwable throwable) {
            if (throwable instanceof NotFoundException) {
                logger.warn((Object)"Got NotFoundException from Google trying to create a write stream or append to it.");
                return new WriteStreamNotFoundException(throwable);
            }
            return this.convertAppendThrowableToIOException(throwable);
        }

        private IOException convertAppendThrowableToIOException(Throwable throwable) {
            Exceptions.StorageException storageException = Exceptions.toStorageException((Throwable)throwable);
            return new IOException((Throwable)(storageException != null ? storageException : throwable));
        }

        private void validateTableSchema(TableSchema schema) {
            String invalidFieldNames = schema.getFieldsList().stream().map(TableFieldSchema::getName).filter(fn -> !this.fieldNameIsValid((String)fn)).map(fn -> "'" + fn + "'").collect(Collectors.joining(", "));
            if (!invalidFieldNames.isEmpty()) {
                throw ErrorContext.iaef((String)"A column name can contain letters (a-z, A-Z), numbers (0-9), or underscores (_), and it must start with a letter or underscore. Columns which do not comply: %s. Consider renaming them or using the automatic fast-write feature.", (Object)invalidFieldNames, (Object[])new Object[0]);
            }
        }

        private boolean fieldNameIsValid(String fieldName) {
            if (StringUtils.isEmpty((String)fieldName)) {
                return false;
            }
            for (int i = 0; i < fieldName.length(); ++i) {
                char c2 = fieldName.charAt(i);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || c2 == '_' || '0' <= c2 && c2 <= '9' && i != 0) continue;
                return false;
            }
            return true;
        }
    }

    private static class AppendCompleteCallback
    implements ApiFutureCallback<AppendRowsResponse> {
        private final JSONArrayWorker parent;

        public AppendCompleteCallback(JSONArrayWorker parent) {
            this.parent = parent;
        }

        public void onSuccess(AppendRowsResponse response) {
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Throwable throwable) {
            Object object = this.parent.lock;
            synchronized (object) {
                if (this.parent.error == null) {
                    this.parent.error = this.parent.convertAppendThrowableToIOException(throwable);
                }
            }
            this.complete();
        }

        private void complete() {
            this.parent.inflightRequestCount.arriveAndDeregister();
        }
    }
}

