/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.bigquery.builtin.QueryParameter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.bigquery.AvroRowReader;
import com.dataiku.dip.sql.bigquery.AvroRowReaderWorker;
import com.dataiku.dip.sql.bigquery.BasicWriter;
import com.dataiku.dip.sql.bigquery.BigQueryAbortedOperationException;
import com.dataiku.dip.sql.bigquery.BigQueryRpcClient;
import com.dataiku.dip.sql.bigquery.CreateTableInfo;
import com.dataiku.dip.sql.bigquery.CreateTemporaryTableInfo;
import com.dataiku.dip.sql.bigquery.EncryptionConfiguration;
import com.dataiku.dip.sql.bigquery.QueryResult;
import com.dataiku.dip.sql.bigquery.RetryingWriter;
import com.dataiku.dip.sql.bigquery.TimeoutSettings;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.api.gax.core.CredentialsProvider;
import com.dataiku.dss.shadelib.com.google.api.gax.core.FixedCredentialsProvider;
import com.dataiku.dss.shadelib.com.google.api.gax.paging.Page;
import com.dataiku.dss.shadelib.com.google.api.gax.rpc.TransportChannelProvider;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.ProjectList;
import com.dataiku.dss.shadelib.com.google.auth.Credentials;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelib.com.google.cloud.TransportOptions;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQuery;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryError;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryException;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryOptions;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Clustering;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Dataset;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.DatasetId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.DatasetInfo;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.InsertAllRequest;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.InsertAllResponse;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Job;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobConfiguration;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobInfo;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.QueryJobConfiguration;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.QueryParameterValue;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.RangePartitioning;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Schema;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.StandardTableDefinition;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Table;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableDefinition;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableInfo;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableResult;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TimePartitioning;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BaseBigQueryReadClient;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BaseBigQueryReadSettings;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.DataFormat;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.ProjectName;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.ReadSession;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.TableName;
import com.dataiku.dss.shadelib.com.google.cloud.http.HttpTransportOptions;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dataiku.dss.shadelib.io.grpc.HttpConnectProxiedSocketAddress;
import com.dataiku.dss.shadelib.io.grpc.ProxiedSocketAddress;
import com.dataiku.dss.shadelib.io.grpc.ProxyDetector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class BigQueryNativeClient
implements AutoCloseable {
    private static final int CREATE_TEMPORARY_TABLE_MAX_ATTEMPTS = 100;
    private final String projectId;
    private final BigQuery bigQueryClient;
    private final BigQueryRpcClient bigQueryRpc;
    private final BaseBigQueryReadClient bigQueryReadClient;
    private final BigQueryWriteClient bigQueryWriteClient;
    private final Map<String, String> jobLabels;
    @Nullable
    private final EncryptionConfiguration encryptionConfiguration;
    @Nullable
    private final DatasetId temporaryTablesDatasetId;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.client.native");

    public BigQueryNativeClient(String projectId, GoogleCredentials credentials, @Nullable EncryptionConfiguration encryptionConfiguration, ProxySettings proxySettings, TimeoutSettings timeOutSettings, String userAgent, @Nullable Map<String, String> jobLabels, String privateServiceConnectEndpoint, @Nullable TableLocation temporaryTablesLocation) throws IOException {
        BigQueryNativeClient.checkArgumentNotBlank(projectId, "projectId");
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        this.projectId = projectId;
        this.encryptionConfiguration = encryptionConfiguration;
        BigQueryOptions options = BigQueryNativeClient.buildBigQueryOptions(projectId, credentials, proxySettings, timeOutSettings, userAgent, privateServiceConnectEndpoint);
        this.bigQueryClient = (BigQuery)options.getService();
        this.bigQueryRpc = new BigQueryRpcClient(options);
        FixedCredentialsProvider credentialsProvider = FixedCredentialsProvider.create((Credentials)credentials);
        this.bigQueryReadClient = BigQueryNativeClient.createBigQueryReadClient((CredentialsProvider)credentialsProvider, proxySettings);
        this.bigQueryWriteClient = BigQueryNativeClient.createBigQueryWriteClient((CredentialsProvider)credentialsProvider, proxySettings);
        this.jobLabels = jobLabels != null && !jobLabels.isEmpty() ? jobLabels : null;
        this.temporaryTablesDatasetId = temporaryTablesLocation != null ? DatasetId.of((String)temporaryTablesLocation.projectId, (String)temporaryTablesLocation.datasetId) : null;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Iterable<ProjectList.Projects> listProjects() {
        return this.listProjects(1024L);
    }

    public Iterable<ProjectList.Projects> listProjects(Long maxResults) {
        Page<ProjectList.Projects> projects = this.bigQueryRpc.listProjects(maxResults);
        if (projects == null) {
            return Collections.emptyList();
        }
        return projects.iterateAll();
    }

    public void addDescriptionsToColumns(SQLDialect dialect, TableId tableId, List<SchemaColumn> columns, InfoMessage.InfoMessages messages) {
        Table previousTable = this.bigQueryClient.getTable(tableId, new BigQuery.TableOption[0]);
        TableDefinition previousDefinition = previousTable.getDefinition();
        FieldList previousFields = previousDefinition.getSchema().getFields();
        HashMap<String, String> commentsMap = new HashMap<String, String>();
        for (SchemaColumn sc : columns) {
            commentsMap.put(sc.getName().toLowerCase(), sc.comment);
        }
        List newFields = previousFields.stream().map(field -> {
            if (commentsMap.containsKey(field.getName().toLowerCase())) {
                return field.toBuilder().setDescription(dialect.truncateDescription((String)commentsMap.get(field.getName().toLowerCase()), field.getName(), false, messages)).build();
            }
            return field;
        }).collect(Collectors.toList());
        TableDefinition newDefinition = previousDefinition.toBuilder().setSchema(Schema.of(newFields)).build();
        Table tableInfo = previousTable.toBuilder().setDefinition(newDefinition).build();
        this.bigQueryClient.update((TableInfo)tableInfo, new BigQuery.TableOption[0]);
    }

    public boolean hasDataset(String datasetId) {
        return this.bigQueryClient.getDataset(datasetId, new BigQuery.DatasetOption[0]) != null;
    }

    public boolean hasDataset(DatasetId datasetId) {
        return this.bigQueryClient.getDataset(datasetId, new BigQuery.DatasetOption[0]) != null;
    }

    public Dataset createDataset(String datasetName) throws BigQueryException {
        Preconditions.checkNotNull((Object)datasetName, (Object)"datasetName");
        return this.createDataset(DatasetInfo.newBuilder((String)datasetName).build());
    }

    public Dataset createDataset(DatasetInfo datasetInfo) throws BigQueryException {
        Preconditions.checkNotNull((Object)datasetInfo, (Object)"datasetInfo");
        return this.bigQueryClient.create(datasetInfo, new BigQuery.DatasetOption[0]);
    }

    public List<Dataset> listDatasets() throws BigQueryException {
        return this.listDatasets(null);
    }

    public List<Dataset> listDatasets(String projectId) throws BigQueryException {
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        Page datasets = this.bigQueryClient.listDatasets(this.resolve(projectId), new BigQuery.DatasetListOption[0]);
        if (datasets != null) {
            for (Dataset dataset : datasets.iterateAll()) {
                result.add(dataset);
            }
        }
        return result;
    }

    public Dataset getDataset(String datasetId) {
        BigQueryNativeClient.checkArgumentNotBlank(datasetId, "datasetId");
        return this.bigQueryClient.getDataset(datasetId, new BigQuery.DatasetOption[0]);
    }

    public boolean deleteDataset(String datasetName) {
        BigQueryNativeClient.checkArgumentNotBlank(datasetName, "datasetName");
        return this.deleteDataset(DatasetId.of((String)this.projectId, (String)datasetName));
    }

    public boolean deleteDataset(DatasetId datasetId) {
        Preconditions.checkNotNull((Object)datasetId, (Object)"datasetId");
        return this.bigQueryClient.delete(datasetId, new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
    }

    public List<Table> listTables(DatasetId datasetId) {
        Preconditions.checkNotNull((Object)datasetId, (Object)"datasetId cannot be null");
        ArrayList<Table> result = new ArrayList<Table>();
        Page tables = this.bigQueryClient.listTables(this.resolve(datasetId), new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)1024L)});
        if (tables != null) {
            for (Table table : tables.iterateAll()) {
                result.add(table);
            }
        }
        return result;
    }

    public boolean hasTable(TableId tableId) throws BigQueryException {
        return this.getTable(tableId) != null;
    }

    public Table getTable(TableId tableId) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId");
        return this.bigQueryClient.getTable(this.resolve(tableId), new BigQuery.TableOption[0]);
    }

    public void createTable(String datasetName, String tableName, Schema schema) {
        Preconditions.checkNotNull((Object)datasetName, (Object)"datasetName cannot be null");
        TableId tableId = TableId.of((String)datasetName, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)schema);
        TableInfo.Builder tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition);
        if (this.encryptionConfiguration != null) {
            tableInfo.setEncryptionConfiguration(this.buildEncryptionConfiguration(this.encryptionConfiguration));
        }
        this.bigQueryClient.create(tableInfo.build(), new BigQuery.TableOption[0]);
    }

    public Table createTable(DatasetId datasetId, CreateTableInfo createTableInfo) throws BigQueryException {
        Preconditions.checkNotNull((Object)datasetId, (Object)"datasetId");
        DatasetId resolvedDatasetId = this.resolve(datasetId);
        TableId tableId = TableId.of((String)resolvedDatasetId.getProject(), (String)resolvedDatasetId.getDataset(), (String)createTableInfo.tableId);
        StandardTableDefinition.Builder tableDefinition = StandardTableDefinition.newBuilder();
        tableDefinition.setSchema(createTableInfo.schema.toSchema());
        if (createTableInfo.partitioning != null) {
            logger.info((Object)"Detected usage of partitioning");
            switch (createTableInfo.partitioning.partitionType) {
                case DATE: {
                    tableDefinition.setTimePartitioning(TimePartitioning.newBuilder((TimePartitioning.Type)TimePartitioning.Type.DAY).setField(createTableInfo.partitioning.field).build());
                    break;
                }
                case RANGE: {
                    tableDefinition.setRangePartitioning(RangePartitioning.newBuilder().setField(createTableInfo.partitioning.field).setRange(RangePartitioning.Range.newBuilder().setEnd(Long.valueOf(createTableInfo.partitioning.range.end)).setStart(Long.valueOf(createTableInfo.partitioning.range.start)).setInterval(Long.valueOf(createTableInfo.partitioning.range.interval)).build()).build());
                }
            }
            List<String> clusteringFields = createTableInfo.partitioning.clusteringFields;
            if (clusteringFields != null && !clusteringFields.isEmpty()) {
                tableDefinition.setClustering(Clustering.newBuilder().setFields(createTableInfo.partitioning.clusteringFields).build());
            }
        }
        TableInfo.Builder tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition.build());
        tableInfo.setFriendlyName(createTableInfo.friendlyName);
        tableInfo.setDescription(createTableInfo.description);
        tableInfo.setExpirationTime(createTableInfo.expirationTime);
        if (createTableInfo.partitioning != null) {
            tableInfo.setRequirePartitionFilter(Boolean.valueOf(createTableInfo.partitioning.requirePartitionFilter));
        }
        if (this.encryptionConfiguration != null) {
            tableInfo.setEncryptionConfiguration(this.buildEncryptionConfiguration(this.encryptionConfiguration));
        }
        return this.createTable(tableInfo.build());
    }

    public Table createTable(TableInfo tableInfo) {
        return this.bigQueryClient.create(tableInfo, new BigQuery.TableOption[0]);
    }

    public Table createTemporaryTable(DatasetId datasetId, CreateTemporaryTableInfo temporaryTableInfo) {
        Preconditions.checkNotNull((Object)datasetId, (Object)"dataset cannot be null");
        Preconditions.checkNotNull((Object)temporaryTableInfo, (Object)"temporaryTableInfo cannot be null.");
        Preconditions.checkNotNull((Object)temporaryTableInfo.schema, (Object)"temporaryTableInfo.schema cannot be null.");
        Preconditions.checkArgument((temporaryTableInfo.prefix == null || temporaryTableInfo.prefix.length() <= 992 ? 1 : 0) != 0, (Object)"temporaryTableInfo.prefix cannot be more than 992 characters long.");
        CreateTableInfo tableInfo = new CreateTableInfo();
        tableInfo.description = "Temporary table created by Dataiku DSS. Can be safely deleted after a few days.";
        tableInfo.schema = temporaryTableInfo.schema;
        tableInfo.expirationTime = BigQueryNativeClient.getExpirationTime(temporaryTableInfo.expirationTime);
        String prefix = StringUtils.isBlank((CharSequence)temporaryTableInfo.prefix) ? "__tmp_DSS_" : temporaryTableInfo.prefix;
        for (int attempt = 1; attempt <= 100; ++attempt) {
            tableInfo.tableId = prefix + UUID.randomUUID().toString().replace("-", "");
            try {
                return this.createTable(datasetId, tableInfo);
            }
            catch (BigQueryException e) {
                if (e.getCode() == 409 && attempt != 100) continue;
                throw e;
            }
        }
        throw new BigQueryException(409, String.format("Giving up trying to create a temporary table after %d attempts.", 100));
    }

    public TableResult getTableData(TableId tableId, BigQuery.TableDataListOption ... options) throws BigQueryException {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId cannot be null");
        return this.bigQueryClient.listTableData(this.resolve(tableId), options);
    }

    public boolean deleteTable(TableId tableId) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId cannot be null");
        return this.bigQueryClient.delete(this.resolve(tableId));
    }

    public InsertAllResponse insertIntoTable(TableId tableId, List<? extends Map<String, String>> rows) {
        ArrayList<InsertAllRequest.RowToInsert> content = new ArrayList<InsertAllRequest.RowToInsert>();
        for (Map<String, String> map : rows) {
            content.add(InsertAllRequest.RowToInsert.of(map));
        }
        InsertAllRequest insertAllRequest = InsertAllRequest.newBuilder((TableId)this.resolve(tableId)).setRows(content).build();
        return this.bigQueryClient.insertAll(insertAllRequest);
    }

    private Job executeSelectQueryAsync(@Nullable DatasetId queryDataSet, String query, TableId destinationTable, List<QueryParameter> parameters, boolean dryRun, Long pageSize) throws BigQueryException {
        QueryJobConfiguration queryConfig = this.getQueryJobConfiguration(queryDataSet, query, destinationTable, parameters, dryRun, pageSize);
        return this.bigQueryClient.create(JobInfo.of((JobConfiguration)queryConfig), new BigQuery.JobOption[0]);
    }

    public QueryResult executeQuery(@Nullable DatasetId queryDataSet, String query, List<QueryParameter> parameters, boolean dryRun, Long pageSize) {
        return this.executeQuery(queryDataSet, query, parameters, dryRun, pageSize, null);
    }

    public QueryResult executeQuery(@Nullable DatasetId queryDataSet, String query, List<QueryParameter> parameters, boolean dryRun, Long pageSize, @Nullable AtomicBoolean abortFlag) {
        try {
            return this.executeQueryInternal(query, parameters, dryRun, pageSize, abortFlag, queryDataSet, null);
        }
        catch (BigQueryException e) {
            BigQueryError error = e.getError();
            if (abortFlag != null && abortFlag.get()) {
                logger.info((Object)"Unable to retrieve results, but operation execution has been aborted.");
                throw new BigQueryAbortedOperationException("BigQuery query execution aborted");
            }
            if (error != null && "responseTooLarge".equals(error.getReason())) {
                if (this.temporaryTablesDatasetId != null && StringUtils.isNotBlank((CharSequence)this.temporaryTablesDatasetId.getProject()) && StringUtils.isNotBlank((CharSequence)this.temporaryTablesDatasetId.getDataset())) {
                    TableId destinationTable = TableId.of((String)this.temporaryTablesDatasetId.getProject(), (String)this.temporaryTablesDatasetId.getDataset(), (String)("dss-large-response-" + String.valueOf(UUID.randomUUID())));
                    logger.info((Object)("Unable to retrieve results because response is too large. Will try again with a destination table: " + String.valueOf(destinationTable)));
                    logger.infoV("Creating temporary table %s to store query results of query: %s", new Object[]{destinationTable, query});
                    this.createDestinationTableForLargeResults(destinationTable);
                    return this.executeQueryInternal(query, parameters, dryRun, pageSize, abortFlag, queryDataSet, destinationTable);
                }
                logger.infoV((Throwable)e, "Unable to retrieve results because response is too large but there is no default ProjectId/DatasetId. Fill in the ProjectId/DatasetId for new managed datasets for this BigQuery connection.", new Object[0]);
            }
            throw e;
        }
    }

    public Job getJob(String jobName) throws BigQueryException {
        Preconditions.checkNotNull((Object)jobName, (Object)"jobName cannot be null");
        return this.bigQueryClient.getJob(jobName, new BigQuery.JobOption[0]);
    }

    public boolean readTableRows(AvroRowReader avroRowReader, TableId tableId) {
        Preconditions.checkNotNull((Object)avroRowReader, (Object)"avroRowReader cannot be null");
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId cannot be null");
        TableName tableName = TableName.of((String)tableId.getProject(), (String)tableId.getDataset(), (String)tableId.getTable());
        ReadSession.Builder sessionBuilder = ReadSession.newBuilder().setTable(tableName.toString()).setDataFormat(DataFormat.AVRO);
        ProjectName projectName = ProjectName.of((String)tableId.getProject());
        CreateReadSessionRequest createReadSessionRequest = CreateReadSessionRequest.newBuilder().setParent(projectName.toString()).setReadSession(sessionBuilder).setMaxStreamCount(1).build();
        ReadSession session = this.bigQueryReadClient.createReadSession(createReadSessionRequest);
        avroRowReader.setSchema(session.getAvroSchema());
        int streamsCount = session.getStreamsCount();
        if (streamsCount == 0) {
            return false;
        }
        AvroRowReaderWorker avroRowReaderWorker = avroRowReader.createWorkers(streamsCount).iterator().next();
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("avro-row-reader-worker-%d").build());
        threadExecutor.submit(() -> {
            ReadRowsRequest readRowsRequest = ReadRowsRequest.newBuilder().setReadStream(session.getStreams(0).getName()).build();
            try {
                for (ReadRowsResponse response : this.bigQueryReadClient.readRowsCallable().call((Object)readRowsRequest)) {
                    Preconditions.checkState((boolean)response.hasAvroRows());
                    boolean keepReading = avroRowReaderWorker.processRows(response.getAvroRows());
                    if (keepReading) continue;
                    logger.debug((Object)"processRows() required to stop by the worker.");
                    break;
                }
                avroRowReaderWorker.complete();
            }
            catch (InterruptedException e) {
                logger.error((Object)"Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.fatal((Object)e);
                try {
                    avroRowReaderWorker.fail(e);
                }
                catch (InterruptedException e2) {
                    logger.error((Object)"Interrupted while notifying failure", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
            }
        });
        return true;
    }

    public BasicWriter createWriter(TableId tableId) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId cannot be null");
        TableName tableName = TableName.of((String)tableId.getProject(), (String)tableId.getDataset(), (String)tableId.getTable());
        return new BasicWriter(this.bigQueryWriteClient, tableName);
    }

    public RetryingWriter createRetryingWriter(TableId tableId) {
        return new RetryingWriter(this.createWriter(tableId));
    }

    private QueryResult executeQueryInternal(String query, List<QueryParameter> parameters, boolean dryRun, Long pageSize, @Nullable AtomicBoolean abortFlag, @Nullable DatasetId defaultDataSet, @Nullable TableId destinationTable) {
        QueryJobConfiguration queryConfig = this.getQueryJobConfiguration(defaultDataSet, query, destinationTable, parameters, dryRun, pageSize);
        if (BigQueryRpcClient.isFastQuerySupported(queryConfig)) {
            logger.info((Object)"Using jobs().query API to execute query in a fast way");
            return this.bigQueryRpc.executeQuery(this.projectId, queryConfig, pageSize, abortFlag);
        }
        logger.info((Object)"Using jobs().create API to execute query");
        Job job = this.executeSelectQueryAsync(defaultDataSet, query, destinationTable, parameters, dryRun, pageSize);
        if (dryRun) {
            return new QueryResult(this.bigQueryClient, job.getJobId(), null, false, job);
        }
        return this.bigQueryRpc.waitForAndReturnResults(job, pageSize, abortFlag);
    }

    private void createDestinationTableForLargeResults(TableId destinationTable) {
        TableInfo.Builder tableInfo = TableInfo.newBuilder((TableId)destinationTable, (TableDefinition)StandardTableDefinition.newBuilder().build());
        if (this.encryptionConfiguration != null) {
            tableInfo.setEncryptionConfiguration(this.buildEncryptionConfiguration(this.encryptionConfiguration));
        }
        long tableExpirationInMinutes = DKUApp.getParams().getIntParamOrElse("dku.sql.bigquery.temporaryTable.minutesToLive", 1440);
        tableInfo.setExpirationTime(Long.valueOf(Instant.now().plus(Duration.ofMinutes(tableExpirationInMinutes)).toEpochMilli()));
        tableInfo.setDescription("Temporary table created by Dataiku DSS to store query results when response is too large");
        this.createTable(tableInfo.build());
    }

    private QueryJobConfiguration getQueryJobConfiguration(DatasetId queryDataSet, String query, TableId destinationTable, List<QueryParameter> parameters, boolean dryRun, Long pageSize) {
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)query);
        if (queryDataSet != null) {
            builder.setDefaultDataset(this.resolve(queryDataSet));
        }
        if (destinationTable != null) {
            builder.setDestinationTable(this.resolve(destinationTable));
        }
        if (parameters != null) {
            for (QueryParameter parameter : parameters) {
                builder.addPositionalParameter(QueryParameterValue.newBuilder().setValue(parameter.value).setType(parameter.type).build());
            }
        }
        if (this.encryptionConfiguration != null && !Pattern.compile("^\\s*(CREATE|ALTER|DROP|INSERT|DELETE|TRUNCATE|UPDATE|MERGE)").matcher(query).find()) {
            builder.setDestinationEncryptionConfiguration(this.buildEncryptionConfiguration(this.encryptionConfiguration));
        }
        return builder.setDryRun(Boolean.valueOf(dryRun)).setMaxResults(pageSize).setLabels(this.jobLabels).build();
    }

    private String resolve(String projectId) {
        return StringUtils.isBlank((CharSequence)projectId) ? this.projectId : projectId;
    }

    public DatasetId resolve(DatasetId datasetId) {
        return BigQueryNativeClient.resolve(datasetId, this.projectId);
    }

    public TableId resolve(TableId tableId) {
        return this.resolve(tableId, tableId.getDataset());
    }

    public TableId resolve(TableId tableId, String defaultDatasetId) {
        return BigQueryNativeClient.resolve(tableId, this.projectId, defaultDatasetId);
    }

    public static DatasetId resolve(DatasetId datasetId, String defaultProjectId) {
        String actualProjectId = StringUtils.isNotBlank((CharSequence)datasetId.getProject()) ? datasetId.getProject() : defaultProjectId;
        return DatasetId.of((String)actualProjectId, (String)datasetId.getDataset());
    }

    public static TableId resolve(TableId tableId, String defaultProjectId, String defaultDatasetId) {
        String actualProjectId = StringUtils.isNotBlank((CharSequence)tableId.getProject()) ? tableId.getProject() : defaultProjectId;
        String actualDatasetId = StringUtils.isNotBlank((CharSequence)tableId.getDataset()) ? tableId.getDataset() : defaultDatasetId;
        return TableId.of((String)actualProjectId, (String)actualDatasetId, (String)tableId.getTable());
    }

    private static void checkArgumentNotBlank(String paramValue, String paramName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)paramValue), (Object)(paramName + " cannot be null or empty."));
    }

    private static long getExpirationTime(long expirationTime) {
        long now = System.currentTimeMillis();
        if (expirationTime == 0L) {
            return now + 86400000L;
        }
        if (expirationTime < now) {
            throw new IllegalArgumentException("temporaryTableInfo.schema cannot be set to a date in the past: " + expirationTime);
        }
        return expirationTime;
    }

    private static TransportOptions buildHttpTransportOptions(ProxySettings proxySettings, TimeoutSettings timeOutSettings) {
        HttpTransportOptions.Builder builder = HttpTransportOptions.newBuilder();
        builder.setHttpTransportFactory(() -> ProxyUtils.getNetHttpTransport((ProxySettings)proxySettings));
        if (timeOutSettings != null) {
            if (timeOutSettings.connectionTimeoutInMs >= 0) {
                builder.setConnectTimeout(timeOutSettings.connectionTimeoutInMs);
            }
            if (timeOutSettings.readTimeoutInMs >= 0) {
                builder.setReadTimeout(timeOutSettings.readTimeoutInMs);
            }
        }
        return builder.build();
    }

    private static BigQueryOptions buildBigQueryOptions(String projectId, GoogleCredentials credentials, ProxySettings proxySettings, TimeoutSettings timeOutSettings, String userAgent, String privateServiceConnectEndpoint) {
        BigQueryOptions.Builder options = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(projectId)).setCredentials((Credentials)credentials)).setTransportOptions(BigQueryNativeClient.buildHttpTransportOptions(proxySettings, timeOutSettings));
        if (StringUtils.isNotBlank((CharSequence)privateServiceConnectEndpoint)) {
            options.setHost(privateServiceConnectEndpoint);
        }
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            options.setHeaderProvider(() -> ImmutableMap.of((Object)"User-Agent", (Object)userAgent));
        }
        return options.build();
    }

    private static BaseBigQueryReadClient createBigQueryReadClient(CredentialsProvider credentialsProvider, ProxySettings proxySettings) throws IOException {
        BaseBigQueryReadSettings.Builder settings = (BaseBigQueryReadSettings.Builder)BaseBigQueryReadSettings.newBuilder().setCredentialsProvider(credentialsProvider);
        if (proxySettings.hasProxy()) {
            settings.setTransportChannelProvider((TransportChannelProvider)BaseBigQueryReadSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(channel -> channel.proxyDetector((ProxyDetector)new ProxyDetectorImpl(proxySettings))).build());
        }
        return BaseBigQueryReadClient.create((BaseBigQueryReadSettings)settings.build());
    }

    private static BigQueryWriteClient createBigQueryWriteClient(CredentialsProvider credentialsProvider, ProxySettings proxySettings) throws IOException {
        BigQueryWriteSettings.Builder settings = (BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(credentialsProvider);
        if (proxySettings.hasProxy()) {
            settings.setTransportChannelProvider((TransportChannelProvider)BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(channel -> channel.proxyDetector((ProxyDetector)new ProxyDetectorImpl(proxySettings))).build());
        }
        return BigQueryWriteClient.create((BigQueryWriteSettings)settings.build());
    }

    @Override
    public void close() {
        this.bigQueryWriteClient.close();
        this.bigQueryReadClient.close();
    }

    private com.dataiku.dss.shadelib.com.google.cloud.bigquery.EncryptionConfiguration buildEncryptionConfiguration(EncryptionConfiguration config) {
        return com.dataiku.dss.shadelib.com.google.cloud.bigquery.EncryptionConfiguration.newBuilder().setKmsKeyName(config.kmsKeyName).build();
    }

    public static class TableLocation {
        public final String projectId;
        public final String datasetId;

        public TableLocation(String projectId, String datasetId) {
            this.projectId = projectId;
            this.datasetId = datasetId;
        }
    }

    private static class ProxyDetectorImpl
    implements ProxyDetector {
        private final ProxySettings proxySettings;

        public ProxyDetectorImpl(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
        }

        public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) {
            HttpConnectProxiedSocketAddress.Builder proxiedSocketAddress = HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress((SocketAddress)new InetSocketAddress(this.proxySettings.host, this.proxySettings.port)).setTargetAddress((InetSocketAddress)socketAddress);
            if (this.proxySettings.hasAuthentication()) {
                proxiedSocketAddress.setUsername(this.proxySettings.username).setPassword(this.proxySettings.password);
            }
            return proxiedSocketAddress.build();
        }
    }
}

